/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sap.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreDomain;
import com.yqbsoft.laser.service.sap.domian.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.sap.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapExWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapInWhConfirmRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapMaterialMovePostingRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapQueryWhRequest;
import com.yqbsoft.laser.service.sap.facade.request.JbsSapSTORequest;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapInExWhConfirmResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapMaterialMovePostingResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapQueryWhResponse;
import com.yqbsoft.laser.service.sap.facade.response.JbsSapSTOResponse;
import com.yqbsoft.laser.service.sap.model.HtmlJsonReBean;
import com.yqbsoft.laser.service.sap.service.JbsSapWarehouseService;
import com.yqbsoft.laser.service.sap.utils.JbsUtils;
import com.yqbsoft.laser.service.sap.utils.ParamsUtils;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbsSapWarehouseServiceImpl
extends BaseServiceImpl
implements JbsSapWarehouseService {
    public static final String SYS_CODE = "jbsSap.JbsSapWarehouseServiceImpl";

    @Override
    public String sendSTOBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/os_mpf_if_sc_006";
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapSTOResponse execute = null;
        JbsSapSTORequest jbsSapSTORequest = new JbsSapSTORequest();
        try {
            jbsSapSTORequest.setApiMethod("if_sc_006");
            BeanUtils.copyAllPropertys((Object)jbsSapSTORequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapSTORequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"sendSTOBill is error");
            this.logger.error(SYS_CODE, (Object)JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
            e.printStackTrace();
            return JbsUtils.getErrorMap("sendSTOBill Exception", whOpstoreDomain.getOpstoreCode());
        }
    }

    @Override
    public HtmlJsonReBean receiveInDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.error(SYS_CODE, (Object)("receiveInDeliveryBill.dataStr>>>>>>>>>" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || ListUtil.isEmpty((Collection)((ArrayList)((HashMap)object.get((Object)"data")).get("list")))) {
            this.logger.error(SYS_CODE, (Object)("data or list\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data or list\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList receiveList = (ArrayList)((HashMap)object.get((Object)"data")).get("list");
        this.logger.error("jbsSap.JbsSapWarehouseServiceImplreceiveInDeliveryBill.list", (Object)("------------" + receiveList));
        ArrayList<WhOpstoreDomain> whOpstoreDomains = new ArrayList<WhOpstoreDomain>();
        for (HashMap dataMap : receiveList) {
            List itemList;
            WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
            whOpstoreDomain.setOpstoreOcode(dataMap.get("VBELN") + "");
            whOpstoreDomain.setStoType(dataMap.get("LFART") + "");
            whOpstoreDomain.setWarehouseCode(dataMap.get("VSTEL") + "");
            whOpstoreDomain.setMemberBcode(dataMap.get("KUNNR") + "");
            whOpstoreDomain.setMemberBname(dataMap.get("PODAT") + "");
            whOpstoreDomain.setMemberCcode(dataMap.get("LIFNR") + "");
            whOpstoreDomain.setOpstoreOcode(dataMap.get("NAME1") + "");
            whOpstoreDomain.setTenantCode("2019071800001392");
            whOpstoreDomain.setMemberCode("20000210392004");
            whOpstoreDomain.setMemberName("\u5e73\u53f0");
            String items = dataMap.get("item") + "";
            if (StringUtils.isNotBlank((String)items) && ListUtil.isNotEmpty((Collection)(itemList = (List)dataMap.get("item")))) {
                ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
                for (Map map : itemList) {
                    WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                    whOpstoreGoodsDomain.setGoodsEocode(map.get("MATNR") + "");
                    whOpstoreGoodsDomain.setGoodsName(map.get("ARKTX") + "");
                    whOpstoreGoodsDomain.setWarehouseCode(map.get("WERKS") + "");
                    whOpstoreGoodsDomain.setWarehouseName(map.get("LGORT") + "");
                    whOpstoreGoodsDomain.setGoodsNum(ParamsUtils.getBigDecimal(map.get("LFIMG")));
                    whOpstoreGoodsDomain.setPartsnameNumunit(map.get("VRKME") + "");
                    whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                    whOpstoreGoodsDomain.setMemberCode("20000210392004");
                    whOpstoreGoodsDomain.setMemberName("\u5e73\u53f0");
                    whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
                }
                whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
            }
            whOpstoreDomains.add(whOpstoreDomain);
        }
        String errorStr = "";
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomains) {
            try {
                HashMap<String, WhOpstoreDomain> sendMap = new HashMap<String, WhOpstoreDomain>();
                whOpstoreDomain.setSendType("0");
                sendMap.put("whOpstoreDomain", whOpstoreDomain);
                this.logger.error(SYS_CODE, (Object)("data or list\u53c2\u6570\u4e3a\u7a7a" + JsonUtil.buildNormalBinder().toJson(sendMap)));
                this.getInternalRouter().inInvoke("jbsPos.warehouse.inWhNoticeBill", sendMap);
            }
            catch (Exception e) {
                errorStr = errorStr + whOpstoreDomain.getOpstoreOcode() + ";";
                this.logger.error(SYS_CODE, (Object)("data or list\u53c2\u6570\u4e3a\u7a7a" + dataStr));
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((String)errorStr)) {
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorStr);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String InDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/oa_mpf_if_sc_002";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapInWhConfirmRequest jbsSapInWhConfirmRequest = new JbsSapInWhConfirmRequest();
            jbsSapInWhConfirmRequest.setApiMethod("if_sc_002");
            BeanUtils.copyAllPropertys((Object)jbsSapInWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapInWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\u300b\u300b\u300b\u300b" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public HtmlJsonReBean receiveExDeliveryBill(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"dataStr is null");
            throw new Exception("param is null");
        }
        this.logger.error(SYS_CODE, (Object)("receiveInDeliveryBill.dataStr>>>>>>>>>" + dataStr));
        JSONObject object = JSONObject.json2object((String)dataStr);
        if (EmptyUtil.isEmpty((Object)object) || StringUtils.isBlank((String)object.getString("data")) || ListUtil.isEmpty((Collection)((ArrayList)((HashMap)object.get((Object)"data")).get("list")))) {
            this.logger.error(SYS_CODE, (Object)("data or list\u53c2\u6570\u4e3a\u7a7a" + dataStr));
            throw new Exception("data or list\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList receiveList = (ArrayList)((HashMap)object.get((Object)"data")).get("list");
        this.logger.error("jbsSap.JbsSapWarehouseServiceImplreceiveExDeliveryBill.list", (Object)("------------" + receiveList));
        ArrayList<WhOpstoreDomain> whOpstoreDomains = new ArrayList<WhOpstoreDomain>();
        for (HashMap dataMap : receiveList) {
            List itemList;
            WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
            whOpstoreDomain.setOpstoreOcode(dataMap.get("VBELN") + "");
            whOpstoreDomain.setStoType(dataMap.get("LFART") + "");
            whOpstoreDomain.setWarehouseCode(dataMap.get("VSTEL") + "");
            whOpstoreDomain.setMemberBcode(dataMap.get("KUNNR") + "");
            whOpstoreDomain.setSendType("0");
            whOpstoreDomain.setMemberBname(dataMap.get("PODAT") + "");
            whOpstoreDomain.setMemberCcode(dataMap.get("LIFNR") + "");
            whOpstoreDomain.setOpstoreOcode(dataMap.get("NAME1") + "");
            whOpstoreDomain.setTenantCode("2019071800001392");
            whOpstoreDomain.setMemberCode("20000210392004");
            whOpstoreDomain.setMemberName("\u5e73\u53f0");
            String items = dataMap.get("item") + "";
            if (StringUtils.isNotBlank((String)items) && ListUtil.isNotEmpty((Collection)(itemList = (List)dataMap.get("item")))) {
                ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
                for (Map map : itemList) {
                    WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                    whOpstoreGoodsDomain.setGoodsEocode(map.get("MATNR") + "");
                    whOpstoreGoodsDomain.setGoodsName(map.get("ARKTX") + "");
                    whOpstoreGoodsDomain.setWarehouseCode(map.get("WERKS") + "");
                    whOpstoreGoodsDomain.setWarehouseName(map.get("LGORT") + "");
                    whOpstoreGoodsDomain.setGoodsNum(ParamsUtils.getBigDecimal(map.get("LFIMG")));
                    whOpstoreGoodsDomain.setPartsnameNumunit(map.get("VRKME") + "");
                    whOpstoreGoodsDomain.setTenantCode("2019071800001392");
                    whOpstoreGoodsDomain.setMemberCode("20000210392004");
                    whOpstoreGoodsDomain.setMemberName("\u5e73\u53f0");
                    whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
                }
                whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
            }
            whOpstoreDomains.add(whOpstoreDomain);
        }
        String errorStr = "";
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomains) {
            try {
                HashMap<String, WhOpstoreDomain> sendMap = new HashMap<String, WhOpstoreDomain>();
                sendMap.put("whOpstoreDomain", whOpstoreDomain);
                this.logger.error(SYS_CODE, (Object)("data or list\u53c2\u6570\u4e3a\u7a7a" + JsonUtil.buildNormalBinder().toJson(sendMap)));
                this.getInternalRouter().inInvoke("jbsPos.warehouse.exWhNoticeBill", sendMap);
            }
            catch (Exception e) {
                errorStr = errorStr + whOpstoreDomain.getOpstoreOcode() + ";";
                this.logger.error(SYS_CODE, (Object)("data or list\u53c2\u6570\u4e3a\u7a7a" + dataStr));
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((String)errorStr)) {
            throw new Exception("\u90e8\u5206\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + errorStr);
        }
        return new HtmlJsonReBean();
    }

    @Override
    public String ExDeliveryConfirmBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/oa_mpf_if_sc_004";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapInExWhConfirmResponse execute = null;
            JbsSapExWhConfirmRequest jbsSapExWhConfirmRequest = new JbsSapExWhConfirmRequest();
            jbsSapExWhConfirmRequest.setApiMethod("if_sc_004");
            BeanUtils.copyAllPropertys((Object)jbsSapExWhConfirmRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapExWhConfirmRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\u300b\u300b\u300b\u300b" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }

    @Override
    public String queryInventoryInfo(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/os_mpf_if_sc_008";
        JbsSapQueryWhResponse execute = null;
        HttpFormfacade httpFormfacade = new HttpFormfacade(url);
        JbsSapQueryWhRequest jbsSapQueryWhRequest = new JbsSapQueryWhRequest();
        jbsSapQueryWhRequest.setApiMethod("if_sc_008");
        jbsSapQueryWhRequest.setMaterial((List)paramsMap.get("material"));
        jbsSapQueryWhRequest.setPlant((List)paramsMap.get("plant"));
        jbsSapQueryWhRequest.setSloc((Map)paramsMap.get("sloc"));
        jbsSapQueryWhRequest.setBatch((List)paramsMap.get("batch"));
        jbsSapQueryWhRequest.setPeriod((Map)paramsMap.get("period"));
        execute = httpFormfacade.execute(jbsSapQueryWhRequest);
        if (!execute.getSuccess().booleanValue()) {
            return JbsUtils.getErrorMap("\u8c03\u7528\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
    }

    @Override
    public String MaterialMovePosting(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        try {
            String url = "http://devpo.jbsswift.cn:50000/RESTAdapter/os_mpf_if_sc_005";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsSapMaterialMovePostingResponse execute = null;
            JbsSapMaterialMovePostingRequest jbsSapMaterialMovePostingRequest = new JbsSapMaterialMovePostingRequest();
            jbsSapMaterialMovePostingRequest.setApiMethod("if_sc_005");
            BeanUtils.copyAllPropertys((Object)jbsSapMaterialMovePostingRequest, (Object)whOpstoreDomain);
            execute = httpFormfacade.execute(jbsSapMaterialMovePostingRequest);
            if (!execute.isSuccess()) {
                return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\u300b\u300b\u300b\u300b" + e));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        }
    }
}

