/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatjs.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.ext.channel.wechatjs.util.WeChatPayConfig;
import com.yqbsoft.laser.service.ext.channel.wechatjs.util.WeChatPayNotify;
import com.yqbsoft.laser.service.ext.channel.wechatjs.util.WeChatPaySubmit;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        String httpUrl = WeChatPayConfig.url;
        Map exmap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(channelRequest.getCmChannelClear().getExtension(), String.class, String.class);
        String verCode = "";
        if (null != exmap) {
            String spbill_create_ip;
            String openId = (String)exmap.get("openId");
            if (StringUtils.isNotBlank((String)openId)) {
                channelRequest.getRequestData().put("openid", openId);
            }
            if (StringUtils.isNotBlank((String)(spbill_create_ip = (String)exmap.get("client_ip")))) {
                channelRequest.getRequestData().put("spbill_create_ip", spbill_create_ip);
            }
            verCode = (String)exmap.get("verCode");
        }
        this.makeSubmch(channelRequest.getConfigMap(), channelRequest.getRequestData());
        if (StringUtils.isNotBlank((String)verCode)) {
            httpUrl = WeChatPayConfig.activeurl;
            channelRequest.getRequestData().put("auth_code", verCode);
            channelRequest.getRequestData().remove("notify_url");
            channelRequest.getRequestData().remove("openid");
            channelRequest.getRequestData().remove("sub_openid");
            channelRequest.getRequestData().remove("trade_type");
            channelRequest.setDebitFlag(true);
        }
        String api_key = (String)channelRequest.getRequestData().get(WeChatPayConfig.pay_key);
        Map<String, String> params = WeChatPaySubmit.buildRequestPara(channelRequest.getRequestData());
        String resXml = "";
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\uff1a" + params));
        try {
            resXml = WebUtils.doPost((String)httpUrl, (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(params).getBytes("utf-8"), (int)5000, (int)5000);
        }
        catch (IOException e) {
            this.logger.error("ChannelSignServiceImpl.sign.e", (Throwable)e);
        }
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\uff1a" + resXml));
        Map resMap = XmlUtil.getMapFromXML((String)resXml);
        HashMap<String, String> res = new HashMap<String, String>();
        if (((String)resMap.get("return_code")).equals("SUCCESS") && ((String)resMap.get("result_code")).equals("SUCCESS")) {
            if (StringUtils.isBlank((String)verCode)) {
                res.put("appId", (String)resMap.get("appid"));
                res.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
                res.put("nonceStr", UUID.randomUUID().toString().replace("-", ""));
                res.put("package", "prepay_id=".concat((String)resMap.get("prepay_id")));
                res.put("signType", "MD5");
                res.put(WeChatPayConfig.pay_key, api_key);
                String sign = WeChatPaySubmit.buildRequestMysign(res);
                res.put("paySign", sign);
            } else {
                channelRequest.setDebitResult("SUCCESS");
                channelRequest.setBankSeqno((String)resMap.get("transaction_id"));
                this.processDate(resMap, channelRequest);
            }
        } else if (StringUtils.isNotBlank((String)verCode)) {
            res.put("subMsg", (String)resMap.get("err_code_des"));
            res.put("subCode", (String)resMap.get("err_code"));
            channelRequest.setBankRescode((String)resMap.get("err_code"));
            channelRequest.setBankResmsg((String)resMap.get("err_code_des"));
            channelRequest.setDebitResult((String)resMap.get("err_code"));
        }
        channelRequest.setRequestData(res);
    }

    private void makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        if (configMap != null && configMap.containsKey("sub_appid")) {
            requestMap.put("sub_appid", configMap.get("sub_appid"));
            requestMap.put("sub_openid", requestMap.remove("openid"));
        }
        if (configMap != null && configMap.containsKey("sub_mch_id")) {
            requestMap.put("sub_mch_id", configMap.get("sub_mch_id"));
        }
    }

    private void processDate(Map<String, String> resMap, ChannelRequest channelRequest) {
        Date channelAcceptDate = null;
        String timeEnd = resMap.get("time_end");
        if (StringUtils.isNotBlank((String)timeEnd)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                channelAcceptDate = sdf.parse(timeEnd);
            }
            catch (ParseException e) {
                channelAcceptDate = new Date();
                this.logger.error("ChannelSignServiceImpl.processDate", (Object)("\u6e20\u9053\u53d7\u7406\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a" + channelRequest.getCmChannelClear().getChannelClearSeqno()));
            }
        }
        channelRequest.setChannelAcceptDate(channelAcceptDate);
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", "wxd83aab5d20209f66");
        map.put("mch_id", "1483587072");
        map.put("body", "\u6b63\u6c90");
        map.put("total_fee", "1");
        map.put("nonce_str", "181a12634384c03a57d28aaf357b411");
        map.put("out_trade_no", "242a32e7343ff3f9911c9af26d53ef5");
        map.put("pay_key", "27E48D0AD7BCBAB772EF308D0B20ABC1");
        map.put("notify_url", "http://www.baidu.com");
        map.put("trade_type", "JSAPI");
        map.put("sub_mch_id", "1485377462");
        Map<String, String> params = WeChatPaySubmit.buildRequestPara(map);
        String resXml = "";
        try {
            resXml = WebUtils.doPost((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(params).getBytes("utf-8"), (int)5000, (int)5000);
            System.out.println(resXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        Map res = bankRequest.getRequestData();
        if (bankRequest.isSing()) {
            res = XmlUtil.getMapFromXML((String)((String)bankRequest.getRequestData().get("resStream")));
            res.put(WeChatPayConfig.pay_key, bankRequest.getConfigMap().get(WeChatPayConfig.pay_key));
            if (!WeChatPayNotify.verify(res)) {
                throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.verify", "");
            }
        }
        bankRequest.setRequestData(res);
        return this.buildApiCallParam(bankRequest);
    }
}

