/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataOutChuanHangQueryService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.EncryptUtil;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OcsOcserviceConfReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OcsOcserviceReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCall;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCallDetail;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCallGoods;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderCallSend;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderPush;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderPushGoods;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderPushPayment;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrderPushSend;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.TmProappEnv;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.producer.EvenProducerInterceptor;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.producer.HashPartitioner;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.data.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.data.service.DateBaseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.StringSerializer;

public class DataOutChuanHangQueryServiceImpl
extends DateBaseService
implements DataOutChuanHangQueryService {
    private static final String SYS_CODE = "DataCHCallDataCenterServiceImpl";
    private static String ui_startdate = "startDate";
    private static String ui_enddate = "endDate";
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    protected Map<String, Object> checkMapStr(String queryJsonMapStr, String method) {
        this.logger.error("DataCHCallDataCenterServiceImpl.checkMapStr." + method, (Object)queryJsonMapStr);
        queryJsonMapStr = this.verifyPlus(queryJsonMapStr);
        this.logger.error("DataCHCallDataCenterServiceImpl.checkMapStr." + method, (Object)queryJsonMapStr);
        Map map = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(queryJsonMapStr, String.class, Object.class);
        if (MapUtil.isEmpty((Map)map)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.checkMapStr." + method + ".param is null");
            throw new ApiException("DataCHCallDataCenterServiceImpl." + method, "\u53c2\u6570\u5f02\u5e38");
        }
        return map;
    }

    public String queryOcContractCall(String queryJsonMapStr) {
        Map<String, Object> map = this.checkMapStr(queryJsonMapStr, "queryOcContractCall");
        this.logger.error("DataCHCallDataCenterServiceImpl.queryOcContractCall.queryOrderPage", (Object)JsonUtil.buildNormalBinder().toJson(map));
        DataOutChuanHangQueryServiceImpl.makePage(map);
        map.put("childFlag", true);
        map.put("order", true);
        boolean fuzzy = null == map.get("fuzzy") || Boolean.valueOf(map.get("fuzzy").toString()) != false;
        map.put("fuzzy", fuzzy);
        QueryResult<OcContractReDomain> ocContractReDomainQueryResult = this.queryOrderPage(map);
        if (ocContractReDomainQueryResult == null || ListUtil.isEmpty((Collection)ocContractReDomainQueryResult.getList())) {
            throw new ApiException("ocPage null");
        }
        ArrayList<OrderCall> orderCallList = new ArrayList<OrderCall>();
        for (OcContractReDomain ocContractReDomain : ocContractReDomainQueryResult.getList()) {
            OrderCall orderCall = this.createOrderCall(ocContractReDomain);
            if (ListUtil.isNotEmpty((Collection)ocContractReDomain.getGoodsList())) {
                ArrayList<OrderCallGoods> orderCallGoods = new ArrayList<OrderCallGoods>();
                for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                    OrderCallGoods callGoods = new OrderCallGoods();
                    callGoods.setGoodsName(ocContractGoodsDomain.getGoodsName());
                    callGoods.setSkuName(ocContractGoodsDomain.getSkuName());
                    callGoods.setGoodsNum(ocContractGoodsDomain.getGoodsNum());
                    callGoods.setContractGoodsMoney(ocContractGoodsDomain.getContractGoodsMoney());
                    callGoods.setGoodsPricesetRefrice(ocContractGoodsDomain.getPricesetRefrice());
                    if ("3".equals(ocContractGoodsDomain.getPricesetType())) {
                        callGoods.setPricesetNprice(ocContractGoodsDomain.getPricesetBaseprice());
                    } else {
                        callGoods.setPricesetNprice(ocContractGoodsDomain.getPricesetNprice());
                    }
                    orderCallGoods.add(callGoods);
                }
                orderCall.setOrderCallGoodsList(orderCallGoods);
            }
            orderCallList.add(orderCall);
        }
        QueryResult orderCallQueryResult = new QueryResult();
        orderCallQueryResult.setList(orderCallList);
        orderCallQueryResult.setTotal(ocContractReDomainQueryResult.getTotal());
        return JsonUtil.buildNormalBinder().toJson((Object)orderCallQueryResult);
    }

    private OrderCall createOrderCall(OcContractReDomain ocContractReDomain) {
        String ocserviceCode;
        QueryResult<OcsOcserviceConfReDomain> confResult;
        OrderCall orderCall = new OrderCall();
        QueryResult<OcsOcserviceReDomain> ocsQueryResult = this.queryOcservicePage(ocContractReDomain.getMemberCcode(), ocContractReDomain.getTenantCode());
        if (ocsQueryResult != null && ListUtil.isNotEmpty((Collection)ocsQueryResult.getList()) && (confResult = this.queryOcserviceConfPage(ocserviceCode = ((OcsOcserviceReDomain)ocsQueryResult.getList().get(0)).getOcserviceCode(), ocContractReDomain.getTenantCode())) != null && ListUtil.isNotEmpty((Collection)confResult.getList())) {
            orderCall.setCustomerPhone(((OcsOcserviceConfReDomain)confResult.getList().get(0)).getOcserviceConfValue());
        }
        orderCall.setContractBbillcode(ocContractReDomain.getContractBbillcode());
        orderCall.setContractBillcode(ocContractReDomain.getContractBillcode());
        if (ListUtil.isNotEmpty((Collection)ocContractReDomain.getGoodsList())) {
            orderCall.setGoodsName(((OcContractGoodsDomain)ocContractReDomain.getGoodsList().get(0)).getGoodsName());
        }
        orderCall.setContractInmoney(ocContractReDomain.getDataBmoney());
        orderCall.setDataBmoney(ocContractReDomain.getPricesetRefrice());
        orderCall.setGoodsNum(ocContractReDomain.getGoodsNum());
        orderCall.setGoodsReceiptMem(ocContractReDomain.getGoodsReceiptMem());
        orderCall.setGoodsReceiptPhone(ocContractReDomain.getGoodsReceiptPhone());
        orderCall.setMemberBname(ocContractReDomain.getMemberBname());
        orderCall.setGmtCreate(ocContractReDomain.getGmtCreate());
        orderCall.setContractType(ocContractReDomain.getContractType());
        orderCall.setDataState(ocContractReDomain.getDataState());
        QueryResult<OcContractSettlDomain> settlDomainQueryResult = this.queryContractSettlPage(ocContractReDomain.getContractBillcode(), ocContractReDomain.getTenantCode());
        if (ListUtil.isNotEmpty((Collection)settlDomainQueryResult.getList())) {
            OcContractSettlDomain ocContractSettlDomain = (OcContractSettlDomain)settlDomainQueryResult.getList().get(0);
            orderCall.setGmtCreateMemo(ocContractSettlDomain.getGmtCreate());
            orderCall.setMemberName(ocContractSettlDomain.getMemberName());
            orderCall.setContractSettlOpem(ocContractSettlDomain.getContractSettlOpemo());
        }
        return orderCall;
    }

    private QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    private QueryResult<OcsOcserviceReDomain> queryOcservicePage(String memberCode, String tenantCode) {
        if (StringUtils.isEmpty((String)memberCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryOcservicePage.null");
            return null;
        }
        String apiCode = "ocs.ocservice.queryOcservicePage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcsOcserviceReDomain.class);
    }

    private QueryResult<OcsOcserviceConfReDomain> queryOcserviceConfPage(String ocserviceCode, String tenantCode) {
        if (StringUtils.isEmpty((String)ocserviceCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryOcservicePage.null");
            return null;
        }
        String apiCode = "ocs.ocservice.queryOcserviceConfPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ocserviceCode", ocserviceCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcsOcserviceConfReDomain.class);
    }

    public String getOcContractDetailCa(String queryJsonMapStr) {
        Map<String, Object> map = this.checkMapStr(queryJsonMapStr, "getOcContractDetailCa");
        this.logger.error("DataCHCallDataCenterServiceImpl.getOcContractDetailCa", (Object)JsonUtil.buildNormalBinder().toJson(map));
        String contractBillcode = map.get("contractBillcode").toString();
        String tenantCode = map.get("tenantCode").toString();
        if (StringUtils.isEmpty((String)contractBillcode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("DataCHCallDataCenterServiceImpl.getOcContractDetailCa", "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain contract = this.getContract(contractBillcode, tenantCode);
        OrderCallDetail orderCallDetail = this.createOrderCallDetail(contract);
        this.createOrderCallSend(orderCallDetail, contract);
        return JsonUtil.buildNormalBinder().toJson((Object)orderCallDetail);
    }

    private void createOrderCallSend(OrderCallDetail orderCallDetail, OcContractReDomain contract) {
        QueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainQueryResult = this.querySgSendgoodsPage(contract.getContractBillcode(), contract.getTenantCode());
        if (sgSendgoodsReDomainQueryResult != null && ListUtil.isNotEmpty((Collection)sgSendgoodsReDomainQueryResult.getList())) {
            ArrayList<OrderCallSend> orderCallSendList = new ArrayList<OrderCallSend>();
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainQueryResult.getList()) {
                OrderCallSend orderCallSend = new OrderCallSend();
                orderCallSend.setSendgoodsCode(sgSendgoodsReDomain.getSendgoodsCode());
                orderCallSend.setContractBillcode(sgSendgoodsReDomain.getContractBillcode());
                orderCallSend.setContractBbillcode(sgSendgoodsReDomain.getContractBbillcode());
                orderCallSend.setMemberCname(sgSendgoodsReDomain.getMemberCname());
                orderCallSend.setGoodsReceiptMem(sgSendgoodsReDomain.getGoodsReceiptMem());
                orderCallSend.setGoodsReceiptArrdess(sgSendgoodsReDomain.getGoodsReceiptArrdess());
                orderCallSend.setGoodsReceiptPhone(sgSendgoodsReDomain.getGoodsReceiptPhone());
                orderCallSend.setMemberBname(sgSendgoodsReDomain.getMemberBname());
                orderCallSend.setGmtCreate(sgSendgoodsReDomain.getGmtCreate());
                orderCallSend.setPackageName(sgSendgoodsReDomain.getPackageName());
                orderCallSend.setPackageBillno(sgSendgoodsReDomain.getPackageBillno());
                orderCallSendList.add(orderCallSend);
            }
            orderCallDetail.setOrderCallSendList(orderCallSendList);
        }
    }

    private OrderCallDetail createOrderCallDetail(OcContractReDomain contract) {
        OrderCallDetail orderCallDetail = new OrderCallDetail();
        orderCallDetail.setPricesetRefrice(contract.getPricesetRefrice());
        orderCallDetail.setPricesetRefrice2(contract.getPricesetRefrice());
        orderCallDetail.setPricesetRefrice3(BigDecimal.ZERO);
        orderCallDetail.setContractInmoney(contract.getContractInmoney());
        orderCallDetail.setDataBmoney(contract.getDataBmoney());
        orderCallDetail.setGoodsPmoney(contract.getGoodsPmoney());
        orderCallDetail.setContractRemark(contract.getContractRemark());
        List ocContractSettlList = contract.getOcContractSettlList();
        if (ListUtil.isNotEmpty((Collection)ocContractSettlList)) {
            for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                if (!"CAS".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                orderCallDetail.setContractSettlBlance(ocContractSettlDomain.getContractSettlBlance());
                if (ocContractSettlDomain.getContractSettlOpemo().contains("wechat")) {
                    orderCallDetail.setPrice(ocContractSettlDomain.getContractSettlPmoney());
                    orderCallDetail.setContractSettlOpemo("wechat");
                }
                if (!ocContractSettlDomain.getContractSettlOpemo().contains("alipay")) continue;
                orderCallDetail.setPrice(ocContractSettlDomain.getContractSettlPmoney());
                orderCallDetail.setContractSettlOpemo("alipay");
            }
        }
        if (StringUtils.isBlank((String)orderCallDetail.getContractSettlOpemo()) && contract.getDataBmoney().compareTo(BigDecimal.ZERO) == 0 && contract.getPricesetRefrice().compareTo(BigDecimal.ZERO) > 0) {
            orderCallDetail.setContractSettlOpemo("ORMEMO");
        }
        if (StringUtils.isBlank((String)orderCallDetail.getContractSettlOpemo()) && ListUtil.isEmpty((Collection)ocContractSettlList) && !contract.getContractBillcode().equals(contract.getContractBbillcode()) && contract.getDataBmoney().compareTo(BigDecimal.ZERO) > 0) {
            orderCallDetail.setContractSettlOpemo("wechat");
            orderCallDetail.setPrice(contract.getDataBmoney());
        }
        orderCallDetail.setContractPmode(contract.getContractPmode());
        orderCallDetail.setGoodsLogmoney(contract.getGoodsLogmoney());
        QueryResult<SgSendgoodsReDomain> sendgoodsPage = this.querySgSendgoodsPage(contract.getContractBillcode(), contract.getTenantCode());
        if (sendgoodsPage != null && ListUtil.isNotEmpty((Collection)sendgoodsPage.getList()) && sendgoodsPage.getList().size() != 0) {
            orderCallDetail.setPackageNum(sendgoodsPage.getList().size());
        } else {
            orderCallDetail.setPackageNum(0);
        }
        orderCallDetail.setGoodsReceiptMem(contract.getGoodsReceiptMem());
        orderCallDetail.setGoodsReceiptPhone(contract.getGoodsReceiptPhone());
        orderCallDetail.setGoodsReceiptArrdess(contract.getGoodsReceiptArrdess());
        if (ListUtil.isNotEmpty((Collection)contract.getGoodsList())) {
            ArrayList<OrderCallGoods> orderCallGoods = new ArrayList<OrderCallGoods>();
            for (OcContractGoodsDomain ocContractGoodsDomain : contract.getGoodsList()) {
                OrderCallGoods callGoods = new OrderCallGoods();
                callGoods.setGoodsName(ocContractGoodsDomain.getGoodsName());
                callGoods.setSkuName(ocContractGoodsDomain.getSkuName());
                callGoods.setGoodsNum(ocContractGoodsDomain.getGoodsNum());
                callGoods.setContractGoodsMoney(ocContractGoodsDomain.getContractGoodsMoney());
                callGoods.setGoodsPricesetRefrice(ocContractGoodsDomain.getPricesetRefrice());
                if ("3".equals(ocContractGoodsDomain.getPricesetType())) {
                    callGoods.setPricesetNprice(ocContractGoodsDomain.getPricesetBaseprice());
                } else {
                    callGoods.setPricesetNprice(ocContractGoodsDomain.getPricesetNprice());
                }
                orderCallGoods.add(callGoods);
            }
            orderCallDetail.setOrderCallGoodsList(orderCallGoods);
        }
        return orderCallDetail;
    }

    private QueryResult<OcContractSettlDomain> queryContractSettlPage(String contractBillcode, String tenantCode) {
        String apiCode = "oc.contract.queryContractSettlPage";
        HashMap<String, Object> ocMap = new HashMap<String, Object>();
        ocMap.put("contractSettlBlance", "ORMEMO");
        ocMap.put("contractBillcode", contractBillcode);
        ocMap.put("tenantCode", tenantCode);
        ocMap.put("order", true);
        ocMap.put("fuzzy", false);
        ocMap.put("page", 1);
        ocMap.put("rows", 1);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(ocMap));
        return this.sendReSupObject(apiCode, param, OcContractSettlDomain.class);
    }

    private QueryResult<SgSendgoodsReDomain> querySgSendgoodsPage(String contractBillcode, String tenantCode) {
        String apiCode = "sg.sendgoods.querySgSendgoodsPageReDomain";
        HashMap<String, String> ocMap = new HashMap<String, String>();
        ocMap.put("contractBillcode", contractBillcode);
        ocMap.put("tenantCode", tenantCode);
        ocMap.put("goodsFlag", "true");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(ocMap));
        return this.sendReSupObject(apiCode, param, SgSendgoodsReDomain.class);
    }

    protected String getSendgoods(Map<String, Object> map) {
        return this.internalInvoke("sg.sendgoods.querySgSendgoodsPageReDomain", map);
    }

    private OcContractReDomain getContract(String contractBillcode, String tenantCode) {
        String apiCode = "oc.contract.getContractByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return (OcContractReDomain)this.getForObject(apiCode, OcContractReDomain.class, param);
    }

    public static void makePage(Map<String, Object> map) {
        String page;
        if (null != map && !map.isEmpty() && null != (page = (String)map.get(ui_page))) {
            String rows;
            if (StringUtils.isBlank((String)page)) {
                page = "1";
            }
            if (StringUtils.isBlank((String)(rows = (String)map.get(ui_rows))) || "0".equals(rows)) {
                rows = "10";
            }
            map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
            map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            map.put(ui_rows, Long.valueOf(rows).intValue());
            map.put(ui_page, Long.valueOf(page).intValue());
        }
    }

    public String getSgSendgoodsCall(String queryJsonMapStr) {
        Map<String, Object> map = this.checkMapStr(queryJsonMapStr, "getSgSendgoodsCall");
        if (StringUtils.isEmpty((String)map.get("contractBillcode").toString())) {
            throw new ApiException("DataCHCallDataCenterServiceImpl.getSgSendgoodsCall", "\u53c2\u6570\u5f02\u5e38");
        }
        String sendgoods = this.getSendgoods(map);
        return sendgoods;
    }

    private String verifyPlus(String content) {
        String secretkey = DataOutChuanHangQueryServiceImpl.getDdFlagPlus("2021062400000001", "secretkeyCHCa", "secretkeyCHCa");
        if (StringUtils.isBlank((String)secretkey)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.verifyPlus secretkey null");
            return null;
        }
        String data = null;
        try {
            data = EncryptUtil.aesDecrypt(content, secretkey);
        }
        catch (Exception e) {
            this.logger.error("DataCHCallDataCenterServiceImpl.verifyPlus.e", (Throwable)e);
            return null;
        }
        return data;
    }

    protected static String getDdFlagPlus(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (tenantCode.lastIndexOf("\"") > 0) {
            tenantCode = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        }
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public String queryOcContractData(String s) {
        return null;
    }

    private Properties getProp() {
        Properties props = new Properties();
        String bootstrapServers = DataOutChuanHangQueryServiceImpl.getDdFlagPlus("2021062400000001", "bootstrapServers", "bootstrapServers");
        if (StringUtils.isEmpty((String)bootstrapServers)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.kafka-getProp.null");
        }
        JSONObject jsonObject = JSONUtil.parseObj((String)bootstrapServers);
        Map jsonToMap = (Map)jsonObject.toBean(Map.class);
        this.logger.error("DataCHCallDataCenterServiceImpl.getOcContractDetailData.getProp", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToMap));
        props.put("bootstrap.servers", jsonToMap.get("bootstrap.servers"));
        props.put("acks", jsonToMap.get("acks"));
        props.put("retries", Integer.valueOf(jsonToMap.get("retries").toString()));
        props.put("batch.size", Integer.valueOf(jsonToMap.get("batch.size").toString()));
        props.put("linger.ms", Integer.valueOf(jsonToMap.get("linger.ms").toString()));
        props.put("buffer.memory", Integer.valueOf(jsonToMap.get("buffer.memory").toString()));
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("partitioner.class", HashPartitioner.class.getName());
        props.put("interceptor.classes", EvenProducerInterceptor.class.getName());
        return props;
    }

    public String getOcContractDetailData(String s) {
        Map map = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(s, String.class, Object.class);
        if (MapUtil.isEmpty((Map)map)) {
            throw new ApiException("DataCHCallDataCenterServiceImpl.getOcContractDetailData.\u53c2\u6570\u5f02\u5e38");
        }
        String contractBillcode = map.get("contractBillcode").toString();
        String dataState = map.get("dataState").toString();
        String oldDataState = map.get("oldDataState").toString();
        this.logger.error("DataCHCallDataCenterServiceImpl.getOcContractDetailData.ch.points.order.state." + contractBillcode, (Object)JsonUtil.buildNormalBinder().toJson((Object)map));
        return null;
    }

    public String getSgSendgoodsData(String s) {
        return null;
    }

    public String createOrderForData(OcContractReDomain ocContractDomain) {
        this.logger.error("DataCHCallDataCenterServiceImpl.createOrderForData.ocContractReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (ocContractDomain == null) {
            return "false";
        }
        OrderPush orderPush = this.createOrderPush(ocContractDomain);
        OrderPushPayment orderPushPayment = this.createOrderPushPayment(ocContractDomain);
        List<OrderPushSend> OrderPushSendList = this.createOrderPushSendList(ocContractDomain);
        orderPush.setOrderPushSendList(OrderPushSendList);
        orderPush.setOrderPushPayment(orderPushPayment);
        String orderPushStr = JsonUtil.buildNormalBinder().toJson((Object)orderPush);
        this.logger.error("DataCHCallDataCenterServiceImpl.createOrderForData.order", (Object)(this.getTopic() + "##" + this.getProps() + "##" + orderPushStr));
        this.sendMessage(this.getTopic(), orderPush.getContractBillcode(), orderPushStr, this.getProps());
        return "success";
    }

    public void sendMessage(String topic, String key, String message, Properties props) {
        try {
            KafkaProducer producer = new KafkaProducer(props);
            ProducerRecord record = new ProducerRecord(topic, (Object)key, (Object)message);
            producer.send(record, new Callback(){

                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    if (exception == null) {
                        DataOutChuanHangQueryServiceImpl.this.logger.info(DataOutChuanHangQueryServiceImpl.SYS_CODE, (Object)("\u53d1\u9001\u6210\u529f\uff1a" + metadata.topic() + metadata.partition() + metadata.offset()));
                    } else {
                        DataOutChuanHangQueryServiceImpl.this.logger.info(DataOutChuanHangQueryServiceImpl.SYS_CODE, (Object)("\u53d1\u9001\u5931\u8d25\uff1a" + exception.getMessage()));
                    }
                }
            });
            producer.flush();
            producer.close();
            this.logger.info(SYS_CODE, (Object)"$$$");
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"KafkaProducer\u521d\u59cb\u5316\u6216\u53d1\u9001\u5f02\u5e38", (Throwable)e);
        }
    }

    private OrderPush createOrderPush(OcContractReDomain ocContractReDomain) {
        QueryResult<TmProappEnv> proappEnvQueryResult;
        OrderPush orderPush = new OrderPush();
        orderPush.setContractBbillcode(ocContractReDomain.getContractBbillcode());
        orderPush.setContractBillcode(ocContractReDomain.getContractBillcode());
        orderPush.setContractNbillcode(ocContractReDomain.getContractNbillcode());
        orderPush.setContractInmoney(ocContractReDomain.getDataBmoney());
        orderPush.setDataBmoney(ocContractReDomain.getPricesetRefrice());
        orderPush.setGoodsNum(ocContractReDomain.getGoodsNum());
        orderPush.setGoodsReceiptMem(ocContractReDomain.getGoodsReceiptMem());
        orderPush.setGoodsReceiptPhone(ocContractReDomain.getGoodsReceiptPhone());
        orderPush.setGoodsReceiptArrdess(ocContractReDomain.getGoodsReceiptArrdess());
        orderPush.setMemberBname(ocContractReDomain.getMemberBname());
        orderPush.setGmtCreate(ocContractReDomain.getGmtCreate());
        if (ocContractReDomain.getContractType().equals("00")) {
            orderPush.setContractType("\u5b9e\u7269\u8ba2\u5355");
        } else if (ocContractReDomain.getContractType().equals("41")) {
            orderPush.setContractType("\u865a\u62df\u8ba2\u5355");
        }
        switch (ocContractReDomain.getDataState()) {
            case 1: {
                orderPush.setDataState("\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                orderPush.setDataState("\u5f85\u53d1\u8d27");
                break;
            }
            case 8: {
                orderPush.setDataState("\u90e8\u5206\u53d1\u8d27");
                break;
            }
            case 3: {
                orderPush.setDataState("\u5df2\u53d1\u8d27");
                break;
            }
            case 4: {
                orderPush.setDataState("\u5df2\u6536\u8d27");
                break;
            }
            case 5: {
                orderPush.setDataState("\u4ea4\u6613\u6210\u529f");
                break;
            }
            case -1: {
                orderPush.setDataState("\u5df2\u53d6\u6d88");
            }
        }
        QueryResult<OcContractSettlDomain> settlDomainQueryResult = this.queryContractSettlPage(ocContractReDomain.getContractBillcode(), ocContractReDomain.getTenantCode());
        if (ListUtil.isNotEmpty((Collection)settlDomainQueryResult.getList())) {
            OcContractSettlDomain ocContractSettlDomain = (OcContractSettlDomain)settlDomainQueryResult.getList().get(0);
            orderPush.setGmtCreateMemo(ocContractSettlDomain.getGmtCreate());
            orderPush.setMemberName(ocContractSettlDomain.getMemberName());
            orderPush.setContractSettlOpem(ocContractSettlDomain.getContractSettlOpemo());
        }
        orderPush.setMemberMname(ocContractReDomain.getMemberCname());
        QueryResult<UmUserinfoReDomainBean> userinfoQueryResult = this.queryUserinfoPage(ocContractReDomain.getMemberCcode(), ocContractReDomain.getTenantCode());
        if (userinfoQueryResult != null && ListUtil.isNotEmpty((Collection)userinfoQueryResult.getList())) {
            orderPush.setMemberMphone(((UmUserinfoReDomainBean)userinfoQueryResult.getList().get(0)).getUserinfoPhone());
        }
        orderPush.setContractObillcode(ocContractReDomain.getContractObillcode());
        QueryResult<CmChannelClear> channelClearQueryResult = this.queryChannelClearPage(ocContractReDomain.getContractBbillcode(), ocContractReDomain.getTenantCode());
        if (channelClearQueryResult != null && ListUtil.isNotEmpty((Collection)channelClearQueryResult.getList())) {
            orderPush.setOrderBankseq(((CmChannelClear)channelClearQueryResult.getList().get(0)).getOrderBankseq());
            orderPush.setChannelClearSeqno(((CmChannelClear)channelClearQueryResult.getList().get(0)).getChannelClearSeqno());
        }
        if ((proappEnvQueryResult = this.queryProappEnvPage(ocContractReDomain.getAppmanageIcode(), ocContractReDomain.getTenantCode())) != null && ListUtil.isNotEmpty((Collection)proappEnvQueryResult.getList())) {
            orderPush.setProappEnvType(((TmProappEnv)proappEnvQueryResult.getList().get(0)).getProappEnvName());
        }
        ArrayList<OrderPushGoods> orderPushGoodsList = new ArrayList<OrderPushGoods>();
        List goodsList = ocContractReDomain.getGoodsList();
        this.logger.info("goodsList" + goodsList);
        if (ListUtil.isNotEmpty((Collection)goodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                OrderPushGoods orderPushGoods = new OrderPushGoods();
                orderPushGoods.setGoodsName(ocContractGoodsDomain.getGoodsName());
                orderPushGoods.setSkuName(ocContractGoodsDomain.getSkuName());
                orderPushGoods.setPricesetMakeprice(ocContractGoodsDomain.getPricesetMakeprice());
                orderPushGoods.setPricesetAsprice(ocContractGoodsDomain.getPricesetAsprice());
                orderPushGoods.setGoodsNum(ocContractGoodsDomain.getGoodsNum());
                orderPushGoods.setContractGoodsMoney(ocContractGoodsDomain.getContractGoodsMoney());
                orderPushGoods.setPricesetRefrice(ocContractGoodsDomain.getPricesetRefrice());
                if ("3".equals(ocContractGoodsDomain.getPricesetType())) {
                    orderPushGoods.setPricesetNprice(ocContractGoodsDomain.getPricesetBaseprice());
                } else {
                    orderPushGoods.setPricesetNprice(ocContractGoodsDomain.getPricesetNprice());
                }
                orderPushGoodsList.add(orderPushGoods);
            }
        }
        return orderPush;
    }

    private QueryResult<UmUserinfoReDomainBean> queryUserinfoPage(String userinfoCode, String tenantCode) {
        if (StringUtils.isEmpty((String)userinfoCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryUserinfoPage.null");
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomainBean.class);
    }

    private QueryResult<CmChannelClear> queryChannelClearPage(String businessOrderno, String tenantCode) {
        if (StringUtils.isEmpty((String)businessOrderno) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryChannelClearPage.null");
            return null;
        }
        String apiCode = "cm.channelClear.querychannelClearPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessOrderno", businessOrderno);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, CmChannelClear.class);
    }

    private QueryResult<TmProappEnv> queryProappEnvPage(String proappCode, String tenantCode) {
        if (StringUtils.isEmpty((String)proappCode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.queryProappEnvPage.null");
            return null;
        }
        String apiCode = "tm.proapp.queryProappEnvPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proappCode", proappCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, TmProappEnv.class);
    }

    private OrderPushPayment createOrderPushPayment(OcContractReDomain contract) {
        OrderPushPayment orderPushPayment = new OrderPushPayment();
        orderPushPayment.setPricesetRefrice(contract.getPricesetRefrice());
        orderPushPayment.setPricesetRefrice2(contract.getPricesetRefrice());
        orderPushPayment.setPricesetRefrice3(BigDecimal.ZERO);
        orderPushPayment.setContractInmoney(contract.getContractInmoney());
        orderPushPayment.setDataBmoney(contract.getDataBmoney());
        orderPushPayment.setGoodsPmoney(contract.getGoodsPmoney());
        orderPushPayment.setBuyerMemo(contract.getContractRemark());
        orderPushPayment.setGoodsLogmoney(contract.getGoodsLogmoney());
        List ocContractSettlList = contract.getOcContractSettlList();
        if (ListUtil.isNotEmpty((Collection)ocContractSettlList)) {
            for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                if (!"CAS".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                if (ocContractSettlDomain.getContractSettlOpemo().contains("wechat")) {
                    orderPushPayment.setPrice(ocContractSettlDomain.getContractSettlPmoney());
                    orderPushPayment.setContractSettlOpemo("wechat");
                }
                if (!ocContractSettlDomain.getContractSettlOpemo().contains("alipay")) continue;
                orderPushPayment.setPrice(ocContractSettlDomain.getContractSettlPmoney());
                orderPushPayment.setContractSettlOpemo("alipay");
            }
        }
        if (StringUtils.isBlank((String)orderPushPayment.getContractSettlOpemo()) && contract.getDataBmoney().compareTo(BigDecimal.ZERO) == 0 && contract.getPricesetRefrice().compareTo(BigDecimal.ZERO) > 0) {
            orderPushPayment.setContractSettlOpemo("ORMEMO");
        }
        if (StringUtils.isBlank((String)orderPushPayment.getContractSettlOpemo()) && ListUtil.isEmpty((Collection)ocContractSettlList) && !contract.getContractBillcode().equals(contract.getContractBbillcode()) && contract.getDataBmoney().compareTo(BigDecimal.ZERO) > 0) {
            orderPushPayment.setContractSettlOpemo("wechat");
            orderPushPayment.setPrice(contract.getDataBmoney());
        }
        return orderPushPayment;
    }

    private List<OrderPushSend> createOrderPushSendList(OcContractReDomain contract) {
        ArrayList<OrderPushSend> orderPushSendList = new ArrayList<OrderPushSend>();
        QueryResult<SgSendgoodsReDomain> sgSendgoodsReDomainQueryResult = this.querySgSendgoodsPage(contract.getContractBillcode(), contract.getTenantCode());
        if (sgSendgoodsReDomainQueryResult != null && ListUtil.isNotEmpty((Collection)sgSendgoodsReDomainQueryResult.getList())) {
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainQueryResult.getList()) {
                this.logger.error("$$ sgSendgoodsReDomain", (Object)sgSendgoodsReDomain);
                OrderPushSend orderPushSend = new OrderPushSend();
                orderPushSend.setSendgoodsCode(sgSendgoodsReDomain.getSendgoodsCode());
                orderPushSend.setContractBillcode(sgSendgoodsReDomain.getContractBillcode());
                orderPushSend.setContractBbillcode(sgSendgoodsReDomain.getContractBbillcode());
                orderPushSend.setMemberCname(sgSendgoodsReDomain.getMemberCname());
                orderPushSend.setGoodsReceiptMem(sgSendgoodsReDomain.getGoodsReceiptMem());
                orderPushSend.setGoodsReceiptArrdess(sgSendgoodsReDomain.getGoodsReceiptArrdess());
                orderPushSend.setGoodsReceiptPhone(sgSendgoodsReDomain.getGoodsReceiptPhone());
                orderPushSend.setMemberBname(sgSendgoodsReDomain.getMemberBname());
                orderPushSend.setGmtCreate(sgSendgoodsReDomain.getGmtCreate());
                orderPushSend.setPackageName(sgSendgoodsReDomain.getPackageName());
                orderPushSend.setPackageBillno(sgSendgoodsReDomain.getPackageBillno());
                orderPushSend.setPackageMode("\u5feb\u9012");
                ArrayList<OrderPushGoods> orderPushSendGoodsList = new ArrayList<OrderPushGoods>();
                List sgSendgoodsGoodsDomainList = sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList();
                if (ListUtil.isNotEmpty((Collection)sgSendgoodsGoodsDomainList)) {
                    for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsGoodsDomainList) {
                        OrderPushGoods orderPushGoods = new OrderPushGoods();
                        orderPushGoods.setGoodsName(sgSendgoodsGoodsDomain.getGoodsName());
                        orderPushGoods.setSkuName(sgSendgoodsGoodsDomain.getSkuName());
                        orderPushGoods.setPricesetMakeprice(sgSendgoodsGoodsDomain.getPricesetMakeprice());
                        orderPushGoods.setPricesetAsprice(sgSendgoodsGoodsDomain.getPricesetAsprice());
                        orderPushGoods.setGoodsNum(sgSendgoodsGoodsDomain.getGoodsNum());
                        orderPushGoods.setContractGoodsMoney(sgSendgoodsGoodsDomain.getContractGoodsMoney());
                        orderPushGoods.setPricesetRefrice(sgSendgoodsGoodsDomain.getPricesetRefrice());
                        orderPushSendGoodsList.add(orderPushGoods);
                    }
                } else {
                    this.logger.error("DataCHCallDataCenterServiceImpl.sgSendgoodsGoodsDomainList.null");
                }
                orderPushSend.setOrderPushGoodsList(orderPushSendGoodsList);
                orderPushSendList.add(orderPushSend);
            }
        }
        return orderPushSendList;
    }

    private Properties getProps() {
        Properties props = new Properties();
        String bootstrapServers = DataOutChuanHangQueryServiceImpl.getDdFlagPlus("2021062400000001", "bootstrapServers", "bootstrapServers");
        if (StringUtils.isEmpty((String)bootstrapServers)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.kafka-getProps.null");
        }
        JSONObject jsonObject = JSONUtil.parseObj((String)bootstrapServers);
        Map jsonToMap = (Map)jsonObject.toBean(Map.class);
        this.logger.error("DataCHCallDataCenterServiceImpl.getOcContractDetailData.getProps", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToMap));
        props.put("bootstrap.servers", jsonToMap.get("bootstrap.servers"));
        props.put("acks", jsonToMap.get("acks"));
        props.put("retries", Integer.valueOf(jsonToMap.get("retries").toString()));
        props.put("batch.size", Integer.valueOf(jsonToMap.get("batch.size").toString()));
        props.put("linger.ms", Integer.valueOf(jsonToMap.get("linger.ms").toString()));
        props.put("buffer.memory", Integer.valueOf(jsonToMap.get("buffer.memory").toString()));
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("partitioner.class", HashPartitioner.class.getName());
        return props;
    }

    private String getTopic() {
        String bootstrapServers = DataOutChuanHangQueryServiceImpl.getDdFlagPlus("2021062400000001", "bootstrapServers", "bootstrapServers");
        if (StringUtils.isEmpty((String)bootstrapServers)) {
            this.logger.error("DataCHCallDataCenterServiceImpl.kafka-getProps.null");
        }
        JSONObject jsonObject = JSONUtil.parseObj((String)bootstrapServers);
        Map jsonToMap = (Map)jsonObject.toBean(Map.class);
        this.logger.error("DataCHCallDataCenterServiceImpl.getOcContractDetailData.getProps", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToMap));
        return jsonToMap.get("topic").toString();
    }
}

