/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.ContractConstants;
import com.yqbsoft.laser.service.contract.dao.OcCflowPprocessMapper;
import com.yqbsoft.laser.service.contract.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcContractMapper;
import com.yqbsoft.laser.service.contract.dao.OcContractSettlMapper;
import com.yqbsoft.laser.service.contract.dao.OcPackageMapper;
import com.yqbsoft.laser.service.contract.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcRefundMapper;
import com.yqbsoft.laser.service.contract.domain.ContractGoodsBean;
import com.yqbsoft.laser.service.contract.domain.ContractSumDomain;
import com.yqbsoft.laser.service.contract.domain.GoodsRefundNumBean;
import com.yqbsoft.laser.service.contract.domain.GoodsSendNumBean;
import com.yqbsoft.laser.service.contract.domain.GoodsSumDomain;
import com.yqbsoft.laser.service.contract.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.contract.domain.OcCflowPprocessDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractCtrlCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractCtrlDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractPmGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractproDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.contract.domain.OcReorderDomain;
import com.yqbsoft.laser.service.contract.domain.PackageExpressDomain;
import com.yqbsoft.laser.service.contract.domain.PingAnReport;
import com.yqbsoft.laser.service.contract.domain.RsSkuDomain;
import com.yqbsoft.laser.service.contract.domain.SgSendgoodsGoods;
import com.yqbsoft.laser.service.contract.domain.TmProappEnv;
import com.yqbsoft.laser.service.contract.domain.TypeBean;
import com.yqbsoft.laser.service.contract.domain.WhGoodsno;
import com.yqbsoft.laser.service.contract.domain.WhGoodsnoConf;
import com.yqbsoft.laser.service.contract.engine.ContractDomainPutThread;
import com.yqbsoft.laser.service.contract.engine.ContractPollThread;
import com.yqbsoft.laser.service.contract.engine.ContractService;
import com.yqbsoft.laser.service.contract.enumc.ContractPropertyEnum;
import com.yqbsoft.laser.service.contract.enumc.PackageModeEnum;
import com.yqbsoft.laser.service.contract.model.OcBrokenLine;
import com.yqbsoft.laser.service.contract.model.OcCflowPprocess;
import com.yqbsoft.laser.service.contract.model.OcConsumeBigData;
import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcContractCtrl;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.model.OcContractSettl;
import com.yqbsoft.laser.service.contract.model.OcContractpro;
import com.yqbsoft.laser.service.contract.model.OcPackage;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcRefundGoods;
import com.yqbsoft.laser.service.contract.model.OcRefundSettl;
import com.yqbsoft.laser.service.contract.model.ReportOcContractGoods;
import com.yqbsoft.laser.service.contract.model.RsSku;
import com.yqbsoft.laser.service.contract.service.OcContractCtrlService;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractPmGoodsService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcContractproService;
import com.yqbsoft.laser.service.contract.service.OcRefundEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundSettlService;
import com.yqbsoft.laser.service.contract.service.OcSendDataBaseService;
import com.yqbsoft.laser.service.domain.client.other.domain.SkuStockDomain;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class OcContractServiceImpl
extends BaseServiceImpl
implements OcContractService {
    public static final String SYS_CODE = "oc.CONTRACT.OcContractServiceImpl";
    private static ContractService contractService;
    private static Object lock;
    private OcContractMapper ocContractMapper;
    private OcContractGoodsMapper ocContractGoodsMapper;
    private OcPackageMapper ocPackageMapper;
    private OcContractSettlMapper ocContractSettlMapper;
    private OcContractCtrlService ocContractCtrlService;
    private OcSendDataBaseService ocSendDataBaseService;
    OcContractproService ocContractproService;
    private OcContractPmGoodsService ocContractPmGoodsService;
    private OcRefundMapper ocRefundMapper;
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    private OcCflowPprocessMapper ocCflowPprocessMapper;
    private OcRefundSettlService ocRefundSettlService;
    private OcContractEngineService ocContractEngineService;
    private OcRefundEngineService ocRefundEngineService;

    public OcRefundSettlService getOcRefundSettlService() {
        if (this.ocRefundSettlService == null) {
            this.ocRefundSettlService = (OcRefundSettlService)SpringApplicationContextUtil.getBean((String)"ocRefundSettlService", OcRefundSettlService.class);
        }
        return this.ocRefundSettlService;
    }

    public void setOcRefundSettlService(OcRefundSettlService ocRefundSettlService) {
        this.ocRefundSettlService = ocRefundSettlService;
    }

    public void setOcContractproService(OcContractproService ocContractproService) {
        this.ocContractproService = ocContractproService;
    }

    public OcCflowPprocessMapper getOcCflowPprocessMapper() {
        return this.ocCflowPprocessMapper;
    }

    public void setOcCflowPprocessMapper(OcCflowPprocessMapper ocCflowPprocessMapper) {
        this.ocCflowPprocessMapper = ocCflowPprocessMapper;
    }

    public OcContractPmGoodsService getOcContractPmGoodsService() {
        return this.ocContractPmGoodsService;
    }

    public void setOcContractPmGoodsService(OcContractPmGoodsService ocContractPmGoodsService) {
        this.ocContractPmGoodsService = ocContractPmGoodsService;
    }

    public OcSendDataBaseService getOcSendDataBaseService() {
        if (null == this.ocSendDataBaseService) {
            this.ocSendDataBaseService = (OcSendDataBaseService)SpringApplicationContextUtil.getBean((String)"ocSendDataBaseService");
        }
        return this.ocSendDataBaseService;
    }

    public OcContractCtrlService getOcContractCtrlService() {
        return this.ocContractCtrlService;
    }

    public void setOcContractCtrlService(OcContractCtrlService ocContractCtrlService) {
        this.ocContractCtrlService = ocContractCtrlService;
    }

    public OcRefundMapper getOcRefundMapper() {
        return this.ocRefundMapper;
    }

    public void setOcRefundMapper(OcRefundMapper ocRefundMapper) {
        this.ocRefundMapper = ocRefundMapper;
    }

    public OcRefundGoodsMapper getOcRefundGoodsMapper() {
        return this.ocRefundGoodsMapper;
    }

    public void setOcRefundGoodsMapper(OcRefundGoodsMapper ocRefundGoodsMapper) {
        this.ocRefundGoodsMapper = ocRefundGoodsMapper;
    }

    public void setOcContractSettlMapper(OcContractSettlMapper ocContractSettlMapper) {
        this.ocContractSettlMapper = ocContractSettlMapper;
    }

    public void setOcContractMapper(OcContractMapper ocContractMapper) {
        this.ocContractMapper = ocContractMapper;
    }

    public void setOcContractGoodsMapper(OcContractGoodsMapper ocContractGoodsMapper) {
        this.ocContractGoodsMapper = ocContractGoodsMapper;
    }

    public void setOcPackageMapper(OcPackageMapper ocPackageMapper) {
        this.ocPackageMapper = ocPackageMapper;
    }

    public OcContractEngineService getOcContractEngineService() {
        if (this.ocContractEngineService == null) {
            this.ocContractEngineService = (OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService", OcContractEngineService.class);
        }
        return this.ocContractEngineService;
    }

    public OcRefundEngineService getOcRefundEngineService() {
        if (this.ocRefundEngineService == null) {
            this.ocRefundEngineService = (OcRefundEngineService)SpringApplicationContextUtil.getBean((String)"ocRefundEngineService", OcRefundEngineService.class);
        }
        return this.ocRefundEngineService;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractDefault(OcContract ocContract) {
        if (null == ocContract) {
            return;
        }
        if (null == ocContract.getDataState()) {
            ocContract.setDataState(0);
        }
        Date nowdate = new Date();
        ocContract.setGmtCreate(nowdate);
        ocContract.setGmtModified(nowdate);
        if (StringUtils.isBlank((String)ocContract.getContractBillcode())) {
            ocContract.setContractBillcode(this.getNo(null, OcContract.class.getSimpleName(), "contractCode", ocContract.getTenantCode()));
        }
        if (StringUtils.isBlank((String)ocContract.getContractBbillcode())) {
            ocContract.setContractBbillcode(ocContract.getContractBillcode());
        }
        if (StringUtils.isBlank((String)ocContract.getContractTypepro())) {
            ocContract.setContractTypepro("00");
        }
        if (StringUtils.isNotBlank((String)ocContract.getAppmanageIcode())) {
            ocContract.setCashback(this.makeInv(ocContract));
        }
        TypeBean typeBean = this.getOcSetting(ocContract.getContractType(), ocContract.getTenantCode());
        if (null == ocContract.getContractInvstate()) {
            ocContract.setContractInvstate(this.checkInv(typeBean, ocContract.getContractTypepro()));
            if (null == ocContract.getCashback() || ocContract.getCashback().compareTo(BigDecimal.ZERO) == 0) {
                ocContract.setContractInvstate(3);
            }
        }
        if (null != typeBean) {
            if (StringUtils.isBlank((String)ocContract.getContractBlance())) {
                ocContract.setContractBlance(typeBean.getBlance());
            }
            if (StringUtils.isBlank((String)ocContract.getContractPmode())) {
                ocContract.setContractPmode(typeBean.getPmode());
            }
        }
    }

    private BigDecimal makeInv(OcContract ocContract) {
        if (null == ocContract) {
            return new BigDecimal("0");
        }
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(ocContract.getAppmanageIcode() + "-" + ocContract.getTenantCode()), TmProappEnv.class);
        if (null == tmProappEnv) {
            return ocContract.getDataBmoney();
        }
        String confJson = tmProappEnv.getProappEnvOpenconf();
        if (StringUtils.isBlank((String)confJson)) {
            return ocContract.getDataBmoney();
        }
        Map confMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(confJson, String.class, String.class);
        if (null == confMap || confMap.isEmpty()) {
            return ocContract.getDataBmoney();
        }
        String inv = (String)confMap.get("inv");
        if (StringUtils.isBlank((String)inv)) {
            return ocContract.getDataBmoney();
        }
        if ("opay".equals(inv)) {
            return ocContract.getPricesetRefrice();
        }
        if ("mpay".equals(inv)) {
            return ocContract.getContractMoney();
        }
        return ocContract.getDataBmoney();
    }

    private int checkOa(OcContract ocContract, TypeBean typeBean, List<OcContractGoodsDomain> goodsList) {
        Map map;
        if (null == ocContract || null == typeBean) {
            return 0;
        }
        String contractType = ocContract.getContractType();
        String contractTypepro = ocContract.getContractTypepro();
        String tenantCode = ocContract.getTenantCode();
        if (StringUtils.isBlank((String)contractType) || StringUtils.isBlank((String)contractTypepro) || StringUtils.isBlank((String)tenantCode)) {
            return 0;
        }
        if (StringUtils.isBlank((String)typeBean.getOaflag()) || "0".equals(typeBean.getOaflag())) {
            return 0;
        }
        String conf = typeBean.getOaconf();
        if (StringUtils.isNotBlank((String)conf) && null != (map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(conf, String.class, String.class)) && !map.isEmpty()) {
            for (String key : map.keySet()) {
                Object obj = "memberCcode".equals(key) ? BeanUtils.forceGetProperty((Object)goodsList.get(0), (String)key) : BeanUtils.forceGetProperty((Object)ocContract, (String)key);
                if (null == obj || StringUtils.isBlank((String)obj.toString())) {
                    return 0;
                }
                if (obj.toString().indexOf((String)map.get(key)) >= 0) continue;
                return 0;
            }
            return 1;
        }
        return 1;
    }

    private int checkEc(OcContract ocContract, List<OcContractGoodsDomain> goodsList) {
        Map map;
        if (null == ocContract) {
            return 0;
        }
        String contractType = ocContract.getContractType();
        String contractTypepro = ocContract.getContractTypepro();
        String tenantCode = ocContract.getTenantCode();
        if (StringUtils.isBlank((String)contractType) || StringUtils.isBlank((String)contractTypepro) || StringUtils.isBlank((String)tenantCode)) {
            return 0;
        }
        TypeBean typeBean = this.getOcSetting(contractType, tenantCode);
        if (null == typeBean) {
            return 0;
        }
        if (StringUtils.isBlank((String)typeBean.getEcflag()) || "0".equals(typeBean.getEcflag())) {
            return 0;
        }
        String conf = typeBean.getEcconf();
        if (StringUtils.isNotBlank((String)conf) && null != (map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(conf, String.class, String.class)) && !map.isEmpty()) {
            for (String key : map.keySet()) {
                Object obj = "memberCcode".equals(key) ? BeanUtils.forceGetProperty((Object)goodsList.get(0), (String)key) : BeanUtils.forceGetProperty((Object)ocContract, (String)key);
                if (null == obj || StringUtils.isBlank((String)obj.toString())) {
                    return 0;
                }
                if (obj.toString().indexOf((String)map.get(key)) >= 0) continue;
                return 0;
            }
            return 1;
        }
        return 1;
    }

    private int checkInv(TypeBean typeBean, String contractTypepro) {
        if (StringUtils.isBlank((String)contractTypepro) || null == typeBean) {
            return 0;
        }
        if (StringUtils.isBlank((String)typeBean.getInvp()) || "0".equals(typeBean.getInvp())) {
            return 0;
        }
        if (StringUtils.isNotBlank((String)typeBean.getNinvpro()) && typeBean.getNinvpro().equals(contractTypepro)) {
            return 3;
        }
        return 1;
    }

    private TypeBean getOcSetting(String contractType, String tenantCode) {
        String memo;
        TypeBean typeBean = null;
        OcCflowReDomain ocCflowReDomain = (OcCflowReDomain)DisUtil.getMapJson((String)"ocProtCflow", (String)(contractType + "-" + tenantCode), OcCflowReDomain.class);
        if (null == ocCflowReDomain) {
            ocCflowReDomain = (OcCflowReDomain)DisUtil.getMapJson((String)"ocProtCflow", (String)(contractType + "-" + "00000000"), OcCflowReDomain.class);
        }
        if (null != ocCflowReDomain && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    private int getContractMaxCode() {
        int code = 0;
        try {
            return this.ocContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractUpdataDefault(OcContract ocContract) {
        if (null == ocContract) {
            return;
        }
        ocContract.setGmtModified(this.getSysDate());
    }

    private void saveContractModel(OcContract ocContract) throws ApiException {
        if (null == ocContract) {
            return;
        }
        try {
            this.ocContractMapper.insert(ocContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractModel.ex", (Throwable)e);
        }
    }

    private OcContract getContractModelById(Integer contractId) {
        if (null == contractId) {
            return null;
        }
        try {
            return this.ocContractMapper.selectByPrimaryKey(contractId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractModelById", (Throwable)e);
            return null;
        }
    }

    public OcContract getContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractModelByCode", (Throwable)e);
            return null;
        }
    }

    public void updatePteContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updatePteByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePteContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePteContractModelByCode.num", map.toString());
        }
    }

    public void delContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractModelByCode.num");
        }
    }

    private void deleteContractModel(Integer contractId) throws ApiException {
        if (null == contractId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.deleteByPrimaryKey(contractId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractModel.num");
        }
    }

    private void updateContractModelPayByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updatePayByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelPayByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelPayByCode.num");
        }
    }

    private void updateContractModelBlanceByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateBlanceByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelBlanceByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelBlanceByCode.num");
        }
    }

    private void updateDateByCodeModel(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.ocContractMapper.updateDateByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateDateByCodeModel" + map.toString(), (Throwable)e);
        }
    }

    private void updateContractModelFchannel(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractFchannel(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelFchannel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelFchannel.num");
        }
    }

    private void updateContractModel(OcContract ocContract) throws ApiException {
        if (null == ocContract) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateByPrimaryKeySelective(ocContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModel.i");
        }
    }

    private void updateSumByCodeModel(ContractSumDomain contractSumDomain) throws ApiException {
        if (null == contractSumDomain) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateSumByCode(contractSumDomain);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSumByCodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSumByCodeModel.i");
        }
    }

    private void updateStateContractModel(Integer contractId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractId", contractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.null", ((Object)map).toString());
        }
    }

    private void updateStateContractModelByNb(String tenantCode, String contractNbillcode, Integer dataState, Integer oldDataState, Map<String, Object> rmap) throws ApiException {
        if (StringUtils.isBlank((String)contractNbillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractNbillcode", contractNbillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != rmap && !rmap.isEmpty()) {
            map.putAll(rmap);
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByNbCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByNb.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByNb.null");
        }
    }

    public OcContract getModelByNbCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractMapper.getByNbCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getModelByNbCode", (Throwable)e);
            return null;
        }
    }

    private void updateSendContractModel(String tenantCode, String contractBillcode, BigDecimal contractSendnum, BigDecimal contractSendweight) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            return;
        }
        if (null == contractSendnum) {
            contractSendnum = BigDecimal.ZERO;
        }
        if (null == contractSendweight) {
            contractSendweight = BigDecimal.ZERO;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractSendnum", contractSendnum);
        map.put("contractSendweight", contractSendweight);
        int i = 0;
        try {
            i = this.ocContractMapper.updateSendStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractModel.null");
        }
    }

    private void updateSendContractGoodsModel(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, BigDecimal contractGoodsSendnum, BigDecimal contractGoodsSendweight) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractGoodsCode) || null == dataState) {
            return;
        }
        if (null == contractGoodsSendnum) {
            contractGoodsSendnum = BigDecimal.ZERO;
        }
        if (null == contractGoodsSendweight) {
            contractGoodsSendweight = BigDecimal.ZERO;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("contractGoodsSendnum", contractGoodsSendnum);
        map.put("contractGoodsSendweight", contractGoodsSendweight);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateSendByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractGoodsModel.null");
        }
    }

    private void updateInvstateContractModel(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateInvstateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateInvstateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateInvstateContractModel.null");
        }
    }

    private void updateShowstateContractModel(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateShowstateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.null");
        }
    }

    private void updateEcflagstateContractModel(String tenantCode, String contractBillcode, String contractEcurl, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractEcurl", contractEcurl);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateEcflagstateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.null");
        }
    }

    private void updateStateContractModelByCode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> rmap) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != rmap && !rmap.isEmpty()) {
            map.putAll(rmap);
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByCode.null", "params=" + map);
        }
    }

    @Override
    public void updateStateByCodeQr(String contractBillcode, String tenantCode, String memberGcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == tenantCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("memberGcode", memberGcode);
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByCodeQr(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByCode.null", "params=" + map);
        }
    }

    @Override
    public void updateContractByMemberGcode(String contractBillcode, String tenantCode, String memberGcode, String memberGname) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == tenantCode) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractByMemberGcode", (Object)"isnull");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("memberGcode", memberGcode);
        map.put("memberGname", memberGname);
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByCodeMemberGcode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractByMemberGcode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractByMemberGcode.null", "params=" + map);
        }
    }

    @Override
    public void updatecontractMemberGnameState(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updatecontractMemberGnameState", (Object)"isnull");
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updatecontractMemberGnameState(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatecontractMemberGnameState", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatecontractMemberGnameState", "params=" + map);
        }
    }

    @Override
    public int countContractByStatus(Map<String, Object> map) throws ApiException {
        return this.ocContractMapper.count(map);
    }

    private void updateModelLockByCode(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.ocContractMapper.updateLockByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateModelLockByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateModelLockByCode.null", "params=" + map);
        }
    }

    private OcContract makeContract(OcContractDomain ocContractDomain, OcContract ocContract) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null == ocContract) {
            ocContract = new OcContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContract, (Object)ocContractDomain);
            return ocContract;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContract", (Throwable)e);
            return null;
        }
    }

    private OcContract makeContract(OcContractReDomain ocContractReDomain, OcContract ocContract) {
        if (null == ocContractReDomain) {
            return null;
        }
        if (null == ocContract) {
            ocContract = new OcContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContract, (Object)ocContractReDomain);
            return ocContract;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContract", (Throwable)e);
            return null;
        }
    }

    private OcContractReDomain makeOcContractDomain(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractReDomain ocContractDomain = new OcContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractDomain, (Object)ocContract);
            return ocContractDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContract> queryContractModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    private List<OcContract> queryContractModelNewPage(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.queryNew(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    private int countContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContract", (Throwable)e);
        }
        return i;
    }

    private int countContractNew(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.countNew(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContractNew", (Throwable)e);
        }
        return i;
    }

    private int countContractBySearchParam(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.countBySearchParam(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContract", (Throwable)e);
        }
        return i;
    }

    private String checkContractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getTenantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (!"2".equals(ocContractGoodsDomain.getContractGoodsGtype()) && StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsCode())) {
            msg = msg + "\u539f\u59cb\u5355\u636e\u53f7\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractGoodsDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        if (null == ocContractGoods.getDataState()) {
            ocContractGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractGoods.getContractGoodsType()) {
            ocContractGoods.setContractGoodsType(0);
        }
        if (null == ocContractGoods.getGmtCreate()) {
            ocContractGoods.setGmtCreate(date);
        }
        ocContractGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractGoods.getContractGoodsCode())) {
            ocContractGoods.setContractGoodsCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)ocContractGoods.getContractGoodsGtype())) {
            ocContractGoods.setContractGoodsGtype("0");
        }
        if (null == ocContractGoods.getGoodsCamount()) {
            ocContractGoods.setGoodsCamount(ocContractGoods.getGoodsNum());
            ocContractGoods.setGoodsCweight(ocContractGoods.getGoodsWeight());
        }
        if (null == ocContractGoods.getContractGoodsPrice()) {
            ocContractGoods.setContractGoodsPrice(ocContractGoods.getPricesetNprice());
        }
        this.makeGoods(ocContractGoods);
    }

    public void makeNvrPrice(OcContractGoods ocContractGoods) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", ocContractGoods.getTenantCode());
        paramMap.put("skuNo", ocContractGoods.getMemberContactPhone());
        paramMap.put("channelCode", ocContractGoods.getChannelCode());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        String skuJson = this.internalInvoke("rs.sku.querySkuOnePage", sendMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
        List rsSkuDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsSku.class);
        if (null == rsSkuDomainList || ListUtil.isEmpty((Collection)rsSkuDomainList)) {
            try {
                throw new Exception("nvr\u5546\u54c1\u4fe1\u606f\u6709\u8bef\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RsSku skuReDomain = (RsSku)rsSkuDomainList.get(0);
        if (ocContractGoods.getContractGoodsRefweight().intValue() > 0 && skuReDomain.getPricesetNprice().intValue() > 0 && skuReDomain.getPricesetNprice().subtract(new BigDecimal(ocContractGoods.getPricesetType())).intValue() == 0) {
            BigDecimal Nvrprice = ocContractGoods.getContractGoodsRefweight().multiply(skuReDomain.getPricesetNprice());
            ocContractGoods.setPricesetNprice(ocContractGoods.getPricesetNprice().add(Nvrprice));
        }
    }

    public void makeGoods(OcContractGoods contractGoodsDomain) {
        if (null == contractGoodsDomain) {
            return;
        }
        if (null != contractGoodsDomain.getContractGoodsMoney()) {
            return;
        }
        if (null == contractGoodsDomain.getGoodsNum()) {
            contractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == contractGoodsDomain.getPricesetNprice()) {
            contractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        BigDecimal inmoney = BigDecimal.ZERO;
        if ("3".equals(contractGoodsDomain.getContractGoodsGtype())) {
            BigDecimal subtract;
            if (null != contractGoodsDomain.getGoodsAhnum() && -1 == BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsAhnum())) {
                if (1 == contractGoodsDomain.getGoodsNum().compareTo(contractGoodsDomain.getGoodsAhnum())) {
                    subtract = contractGoodsDomain.getGoodsNum().subtract(contractGoodsDomain.getGoodsAhnum());
                    BigDecimal multiply = subtract.multiply(contractGoodsDomain.getPricesetNprice());
                    inmoney = multiply.add(contractGoodsDomain.getPricesetMakeprice());
                } else {
                    inmoney = contractGoodsDomain.getPricesetMakeprice();
                }
            } else if (0 == contractGoodsDomain.getGoodsNum().compareTo(new BigDecimal(-1))) {
                inmoney = contractGoodsDomain.getPricesetMakeprice().multiply(new BigDecimal(-1));
            } else if (0 == contractGoodsDomain.getGoodsNum().compareTo(contractGoodsDomain.getGoodsHangnum())) {
                inmoney = contractGoodsDomain.getPricesetNprice();
            } else {
                subtract = contractGoodsDomain.getGoodsNum().subtract(contractGoodsDomain.getGoodsHangnum());
                inmoney = contractGoodsDomain.getPricesetNprice().multiply(subtract);
            }
        } else {
            inmoney = contractGoodsDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
        }
        contractGoodsDomain.setContractGoodsInmoney(inmoney);
        if (null == contractGoodsDomain.getPricesetRefrice()) {
            contractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        BigDecimal refmoney = BigDecimal.ZERO;
        refmoney = "3".equals(contractGoodsDomain.getContractGoodsGtype()) ? contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum()) : contractGoodsDomain.getPricesetRefrice().multiply(contractGoodsDomain.getGoodsNum());
        contractGoodsDomain.setContractGoodsPefinmoney(refmoney);
        contractGoodsDomain.setContractGoodsPefmoney(refmoney);
        BigDecimal discountAmount = BigDecimal.ZERO;
        if ("3".equals(contractGoodsDomain.getContractGoodsGtype())) {
            BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
            if (null != contractGoodsDomain.getGoodsNum() && BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsNum()) != 0) {
                contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
            }
            contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        } else {
            BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
            if (null != contractGoodsDomain.getGoodsNum() && BigDecimal.ZERO.compareTo(contractGoodsDomain.getGoodsNum()) != 0) {
                contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum(), 2, 4));
            }
            contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
        }
        contractGoodsDomain.setContractGoodsAppraise(0);
        if (null == contractGoodsDomain.getRefundFlag()) {
            contractGoodsDomain.setRefundFlag(0);
        }
    }

    private int getContractGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocContractGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractGoodsUpdataDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        ocContractGoods.setGmtModified(this.getSysDate());
    }

    private void saveContractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        try {
            this.ocContractGoodsMapper.insert(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveContractGoodsBatchModel(List<OcContractGoods> ocContractGoodsList) throws ApiException {
        if (null == ocContractGoodsList || ocContractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocContractGoodsMapper.insertBatch(ocContractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractGoods getContractGoodsModelById(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.selectByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcContractGoods getContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractGoodsModelByCode.num");
        }
    }

    private void deleteContractGoodsModel(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.deleteByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractGoodsModel.num");
        }
    }

    private void updateContractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        try {
            this.ocContractGoodsMapper.updateByPrimaryKeySelective(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateContractGoodsTypeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateTypeByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsTypeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsTypeModel.i", map.toString());
        }
    }

    private void updateStateContractGoodsModel(Integer contractGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.null");
        }
    }

    private OcContractGoods makeContractGoods(OcContractGoodsDomain ocContractGoodsDomain, OcContractGoods ocContractGoods) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        if (null == ocContractGoods) {
            ocContractGoods = new OcContractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)ocContractGoodsDomain);
            return ocContractGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContractGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcContractGoods> queryContractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private List<ReportOcContractGoods> queryReport(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsMapper.queryReport(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> queryContractModelSum(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.querySum(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractModelSum", (Throwable)e);
            return null;
        }
    }

    private OcContractGoods queryPricesetSum(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsMapper.queryPricesetSum(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryPricesetSum", (Throwable)e);
            return null;
        }
    }

    private List<OcContractGoodsDomain> makeContractGoodsDomainList(List<OcContractGoods> ocContractGoodsList) {
        if (null == ocContractGoodsList || ocContractGoodsList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> ocContractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoods ocContractGoods : ocContractGoodsList) {
            ocContractGoodsDomainList.add(this.makeContractGoodsDomain(ocContractGoods));
        }
        return ocContractGoodsDomainList;
    }

    private OcContractGoodsDomain makeContractGoodsDomain(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return null;
        }
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)ocContractGoods);
            return ocContractGoodsDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContractGoodsDomain", (Throwable)e);
            return null;
        }
    }

    private List<String> queryBuyerMemberCodesPage(Map<String, Object> params) {
        try {
            return this.ocContractMapper.getBuyerMerberCodes(params);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryBuyerMemberCodesPage", (Throwable)e);
            return null;
        }
    }

    private int countContractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContractGoods", (Throwable)e);
        }
        return i;
    }

    private int countReport(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.countReport(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContractGoods", (Throwable)e);
        }
        return i;
    }

    private int countBuyerMerber(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.countBuyerMerber(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countBuyerMerber", (Throwable)e);
        }
        return i;
    }

    private int countAllUserOcConsumeBigData(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.countAllUserOcConsumeBigData(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countBuyerMerber", (Throwable)e);
        }
        return i;
    }

    private void updateContractGoodsModelRefByCode(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateRefByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCode.i", map.toString());
        }
    }

    private void updateContractGoodsModelRefNwByCode(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateRefByCodeNw(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefNwByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefNwByCode.i", map.toString());
        }
    }

    private void updateContractGoodsModelRefByCodeFlag(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateRefByCodeFlag(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCode.i", map.toString());
        }
    }

    private void updateContractGoodsModelRefByCodeRe(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateRefByCodeRe(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCodeRe.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCodeRe.i", map.toString());
        }
    }

    private void updateContractGoodsModelRefres(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateRefres(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefres.ex", e + "|||" + map);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefres.i", i + "||||" + map);
        }
    }

    private String checkPackage(OcPackageDomain ocPackageDomain) {
        if (null == ocPackageDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPackageDefault(OcPackage ocPackage) {
        if (null == ocPackage) {
            return;
        }
        if (null == ocPackage.getDataState()) {
            ocPackage.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocPackage.getGmtCreate()) {
            ocPackage.setGmtCreate(date);
        }
        ocPackage.setGmtModified(date);
        if (StringUtils.isBlank((String)ocPackage.getPackageCode())) {
            ocPackage.setPackageCode(this.createUUIDString());
        }
    }

    private int getPackageMaxCode() {
        int code = 0;
        try {
            return this.ocPackageMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPackageUpdataDefault(OcPackage ocPackage) {
        if (null == ocPackage) {
            return;
        }
        ocPackage.setGmtModified(this.getSysDate());
    }

    private void savePackageModel(OcPackage ocPackage) throws ApiException {
        if (null == ocPackage) {
            return;
        }
        try {
            this.ocPackageMapper.insert(ocPackage);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackageModel.ex", (Throwable)e);
        }
    }

    private OcPackage getPackageModelById(Integer packageId) {
        if (null == packageId) {
            return null;
        }
        try {
            return this.ocPackageMapper.selectByPrimaryKey(packageId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageModelById", (Throwable)e);
            return null;
        }
    }

    public OcPackage getPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocPackageMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocPackageMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delPackageModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delPackageModelByCode.num");
        }
    }

    private void deletePackageModel(Integer packageId) throws ApiException {
        if (null == packageId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocPackageMapper.deleteByPrimaryKey(packageId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deletePackageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deletePackageModel.num");
        }
    }

    private void updatePackageModel(OcPackage ocPackage) throws ApiException {
        if (null == ocPackage) {
            return;
        }
        try {
            this.ocPackageMapper.updateByPrimaryKeySelective(ocPackage);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageModel.ex", (Throwable)e);
        }
    }

    private void updatePackageSumByCodeModel(GoodsSumDomain goodsSumDomain) throws ApiException {
        if (null == goodsSumDomain) {
            return;
        }
        try {
            this.ocPackageMapper.updatePackageSumByCode(goodsSumDomain);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageSumByCodeModel.ex", (Throwable)e);
        }
    }

    private void updateStatePackageModel(Integer packageId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == packageId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageId", packageId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocPackageMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStatePackageModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStatePackageModel.null");
        }
    }

    private OcPackage makePackage(OcPackageDomain ocPackageDomain, OcPackage ocPackage) {
        if (null == ocPackageDomain) {
            return null;
        }
        if (null == ocPackage) {
            ocPackage = new OcPackage();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocPackage, (Object)ocPackageDomain);
            return ocPackage;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makePackage", (Throwable)e);
            return null;
        }
    }

    private List<OcPackageDomain> makePackageDomainList(List<OcPackage> ocPackageList) {
        if (null == ocPackageList || ocPackageList.isEmpty()) {
            return null;
        }
        ArrayList<OcPackageDomain> list = new ArrayList<OcPackageDomain>();
        for (OcPackage ocPackage : ocPackageList) {
            list.add(this.makePackageDomain(ocPackage));
        }
        return list;
    }

    private OcPackageDomain makePackageDomain(OcPackage ocPackage) {
        if (null == ocPackage) {
            return null;
        }
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocPackage);
            this.makeContractGoodsList(ocPackageDomain);
            return ocPackageDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makePackageDomain", (Throwable)e);
            return null;
        }
    }

    private void makeContractGoodsList(OcPackageDomain ocPackageDomain) {
        if (null == ocPackageDomain) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", ocPackageDomain.getContractBillcode());
        parammap.put("packageCode", ocPackageDomain.getPackageCode());
        parammap.put("tenantCode", ocPackageDomain.getTenantCode());
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(parammap);
        if (null == ocContractGoodsList) {
            return;
        }
        ocPackageDomain.setContractGoodsList(this.makeContractGoodsDomainList(ocContractGoodsList));
    }

    private List<OcPackage> queryPackageModelPage(Map<String, Object> parammap) {
        try {
            return this.ocPackageMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryPackageModel", (Throwable)e);
            return null;
        }
    }

    private int countPackage(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocPackageMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countPackage", (Throwable)e);
        }
        return i;
    }

    private void updateExpressStateByCodeModel(PackageExpressDomain packageExpressDomain) {
        int i = 0;
        try {
            i = this.ocPackageMapper.updateExpressStateByCode(packageExpressDomain);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateExpressStateByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateExpressStateByCodeModel.null");
        }
    }

    private String checkContractSettl(OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractSettlDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractSettlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractSettlDefault(OcContractSettl ocContractSettl) {
        if (null == ocContractSettl) {
            return;
        }
        if (null == ocContractSettl.getDataState()) {
            ocContractSettl.setDataState(0);
        }
        if (null == ocContractSettl.getGmtCreate()) {
            ocContractSettl.setGmtCreate(this.getSysDate());
        }
        ocContractSettl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractSettl.getContractSettlBillcode())) {
            ocContractSettl.setContractSettlBillcode(this.createUUIDString());
        }
    }

    private int getContractSettlMaxCode() {
        int code = 0;
        try {
            return this.ocContractSettlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractSettlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractSettlUpdataDefault(OcContractSettl ocContractSettl) {
        if (null == ocContractSettl) {
            return;
        }
        ocContractSettl.setGmtModified(this.getSysDate());
    }

    private void saveContractSettlModel(OcContractSettl ocContractSettl) throws ApiException {
        if (null == ocContractSettl) {
            return;
        }
        try {
            this.ocContractSettlMapper.insert(ocContractSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettlModel.ex", (Throwable)e);
        }
    }

    private void saveContractSettlModelBatch(List<OcContractSettl> ocContractSettlList) throws ApiException {
        if (null == ocContractSettlList || ocContractSettlList.isEmpty()) {
            return;
        }
        try {
            this.ocContractSettlMapper.insertBatch(ocContractSettlList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettlModelBatch.ex", (Throwable)e);
        }
    }

    private OcContractSettl getContractSettlModelById(Integer contractSettlId) {
        if (null == contractSettlId) {
            return null;
        }
        try {
            return this.ocContractSettlMapper.selectByPrimaryKey(contractSettlId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractSettlModelById", (Throwable)e);
            return null;
        }
    }

    public OcContractSettl getContractSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractSettlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractSettlModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractSettlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractSettlModelByCode.num");
        }
    }

    private void deleteContractSettlModel(Integer contractSettlId) throws ApiException {
        if (null == contractSettlId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettlMapper.deleteByPrimaryKey(contractSettlId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractSettlModel.num");
        }
    }

    private void updateContractSettlModel(OcContractSettl ocContractSettl) throws ApiException {
        if (null == ocContractSettl) {
            return;
        }
        try {
            this.ocContractSettlMapper.updateByPrimaryKeySelective(ocContractSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSettlModel.ex", (Throwable)e);
        }
    }

    private void updateStateContractSettlModel(Integer contractSettlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractSettlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSettlId", contractSettlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractSettlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractSettlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractSettlModel.null");
        }
    }

    private OcContractSettl makeContractSettl(OcContractSettlDomain ocContractSettlDomain, OcContractSettl ocContractSettl) {
        if (null == ocContractSettlDomain) {
            return null;
        }
        if (null == ocContractSettl) {
            ocContractSettl = new OcContractSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettl, (Object)ocContractSettlDomain);
            return ocContractSettl;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContractSettl", (Throwable)e);
            return null;
        }
    }

    private List<OcContractproDomain> makeOcContractproDomainList(List<OcContractpro> ocContractproList) {
        if (null == ocContractproList || ocContractproList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractproDomain> list = new ArrayList<OcContractproDomain>();
        for (OcContractpro ocContractpro : ocContractproList) {
            list.add(this.makeOcContractproDomain(ocContractpro));
        }
        return list;
    }

    private OcContractproDomain makeOcContractproDomain(OcContractpro OcContractpro2) {
        if (null == OcContractpro2) {
            return null;
        }
        OcContractproDomain ocContractproDomain = new OcContractproDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractproDomain, (Object)OcContractpro2);
            return ocContractproDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractproDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractSettlDomain> makeOcContractSettlDomainList(List<OcContractSettl> ocContractSettlList) {
        if (null == ocContractSettlList || ocContractSettlList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractSettlDomain> list = new ArrayList<OcContractSettlDomain>();
        for (OcContractSettl ocContractSettl : ocContractSettlList) {
            list.add(this.makeOcContractSettlDomain(ocContractSettl));
        }
        return list;
    }

    private OcContractSettlDomain makeOcContractSettlDomain(OcContractSettl ocContractSettl) {
        if (null == ocContractSettl) {
            return null;
        }
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettlDomain, (Object)ocContractSettl);
            return ocContractSettlDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractSettlDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractSettl> queryContractSettlModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractSettlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractSettlModel", (Throwable)e);
            return null;
        }
    }

    private int countContractSettl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractSettlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContractSettl", (Throwable)e);
        }
        return i;
    }

    private List<OcContractGoodsDomain> makeOcContractGoodsDomainList(List<OcContractGoods> ocContractGoods) {
        if (ocContractGoods == null || ocContractGoods.isEmpty()) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
        try {
            for (OcContractGoods goods : ocContractGoods) {
                OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
                BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)goods);
                goodsList.add(goodsDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractGoodsDomainList.ex", (Throwable)e);
        }
        return goodsList;
    }

    @Override
    public String sendsaveContract(OcContractDomain ocContractDomain) throws ApiException {
        this.saveOrder(ocContractDomain);
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ocContractDomainList.add(ocContractDomain);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return ocContractDomain.getContractBillcode();
    }

    @Override
    public String sendBatchSaveContract(List<OcContractDomain> ocContractDomainList) throws ApiException {
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.sendBatchSaveContract.null", "");
        }
        String contractBbillcode = this.saveBatchContract(ocContractDomainList);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return contractBbillcode;
    }

    @Override
    public String saveBatchContract(List<OcContractDomain> ocContractDomainList) throws ApiException {
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveBatchContract.null", "");
        }
        String contractBbillcode = "";
        if (ocContractDomainList.size() > 1) {
            contractBbillcode = this.getNo(null, OcContract.class.getSimpleName(), "contractBbillcode", ocContractDomainList.get(0).getTenantCode());
        }
        for (OcContractDomain ocContractDomain : ocContractDomainList) {
            ocContractDomain.setContractBbillcode(contractBbillcode);
            this.saveOrder(ocContractDomain);
            if (!StringUtils.isBlank((String)contractBbillcode)) continue;
            contractBbillcode = ocContractDomain.getContractBbillcode();
        }
        return contractBbillcode;
    }

    @Override
    public String saveContract(OcContractDomain ocContractDomain) throws ApiException {
        OcContract ocContract = this.saveOrder(ocContractDomain);
        return ocContract.getContractBillcode();
    }

    private OcPackageDomain createpackgeByGoods(OcContractDomain ocContractDomain, OcContractGoodsDomain ocContractGoodsDomain) {
        if (ocContractDomain == null || null == ocContractGoodsDomain) {
            return null;
        }
        OcPackageDomain ocPackage = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackage, (Object)ocContractDomain);
            BeanUtils.copyAllPropertys((Object)ocPackage, (Object)ocContractGoodsDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ocPackage.setGoodsNum(ocContractGoodsDomain.getGoodsNum());
        ocPackage.setGoodsWeight(ocContractGoodsDomain.getGoodsWeight());
        ocPackage.setGoodsMoney(ocContractGoodsDomain.getContractGoodsInmoney());
        ocPackage.setGoodsPmoney(ocContractGoodsDomain.getContractGoodsMoney());
        ocPackage.setPricesetRefrice(ocContractGoodsDomain.getContractGoodsPefinmoney());
        return ocPackage;
    }

    private OcPackageDomain getPackgeGroupby(String str, OcContractDomain ocContractDomain, OcContractGoodsDomain ocContractGoodsDomain, Map<String, OcPackageDomain> packgeMap, List<OcPackageDomain> ocPackgeList) {
        if (null == ocContractGoodsDomain || null == packgeMap || null == ocPackgeList || null == ocContractDomain) {
            return null;
        }
        String mapKey = "";
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] param = str.split("\\|");
            Object obj = null;
            for (String s : param) {
                obj = BeanUtils.forceGetProperty((Object)ocContractGoodsDomain, (String)s);
                if (null == obj) continue;
                parammap.put(s, obj);
                if (StringUtils.isNotBlank((String)mapKey)) {
                    mapKey = mapKey + "-";
                }
                mapKey = mapKey + obj;
            }
        } else {
            parammap.put("memberCode", ocContractGoodsDomain.getMemberCode());
            if (StringUtils.isNotBlank((String)mapKey)) {
                mapKey = mapKey + "-";
            }
            mapKey = mapKey + ocContractGoodsDomain.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getContractBillcode();
        parammap.put("contractBillcode", ocContractDomain.getContractBillcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getMemberBcode();
        parammap.put("memberBcode", ocContractDomain.getMemberBcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getChannelCode();
        parammap.put("channelCode", ocContractDomain.getChannelCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getTenantCode();
        parammap.put("tenantCode", ocContractDomain.getTenantCode());
        OcPackageDomain ocPackageDomain = null;
        ocPackageDomain = packgeMap.get(mapKey);
        if (null == ocContractGoodsDomain.getGoodsCamount()) {
            ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getGoodsCweight()) {
            ocContractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
            ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
            ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
            ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
        }
        if (null == ocPackageDomain) {
            ocPackageDomain = this.createpackgeByGoods(ocContractDomain, ocContractGoodsDomain);
            ocPackgeList.add(ocPackageDomain);
            packgeMap.put(mapKey, ocPackageDomain);
        } else {
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            ocPackageDomain.setGoodsNum(ocPackageDomain.getGoodsNum().add(ocContractGoodsDomain.getGoodsNum()));
            ocPackageDomain.setGoodsWeight(ocPackageDomain.getGoodsWeight().add(ocContractGoodsDomain.getGoodsWeight()));
            ocPackageDomain.setGoodsMoney(ocPackageDomain.getGoodsMoney().add(ocContractGoodsDomain.getContractGoodsInmoney()));
            ocPackageDomain.setGoodsPmoney(ocPackageDomain.getGoodsPmoney().add(ocContractGoodsDomain.getContractGoodsMoney()));
            ocPackageDomain.setPricesetRefrice(ocPackageDomain.getPricesetRefrice().add(ocContractGoodsDomain.getContractGoodsPefinmoney()));
        }
        return ocPackageDomain;
    }

    public void makePack(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain || ListUtil.isNotEmpty(ocContractDomain.getPackageList()) || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return;
        }
        HashMap<String, OcPackageDomain> packgeMap = new HashMap<String, OcPackageDomain>();
        String tenantCode = ocContractDomain.getTenantCode();
        String shoppingpackgeStr = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-shopping-shoppingpackgekey"));
        if (StringUtils.isBlank((String)shoppingpackgeStr)) {
            shoppingpackgeStr = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-shopping-shoppingpackgekey");
        }
        ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
        ocContractDomain.setPackageList(packageList);
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getContractGoodsGtype()) && "0".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
            if (null == ocContractGoodsDomain.getGoodsNum()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
                ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            this.getPackgeGroupby(shoppingpackgeStr, ocContractDomain, ocContractGoodsDomain, packgeMap, packageList);
        }
    }

    private OcContract saveOrder(OcContractDomain ocContractDomain) {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContract.checkContract", msg);
        }
        ocContractDomain.setContractId(null);
        OcContract ocContract = this.makeContract(ocContractDomain, null);
        this.setContractDefault(ocContract);
        this.setPaydate(ocContract, ocContractDomain);
        this.logger.error("saveOrder." + ocContract.getContractBillcode(), (Object)ocContract.getContractPaydate());
        this.makePack(ocContractDomain);
        ocContract.setContractEcflag(this.checkEc(ocContract, ocContractDomain.getPackageList().get(0).getContractGoodsList()));
        this.saveContractModel(ocContract);
        this.savePackageList(ocContractDomain.getPackageList(), ocContract);
        this.saveOcContractSettl(ocContractDomain.getOcContractSettlList(), ocContract);
        this.saveOcContractpro(ocContractDomain.getOcContractproDomainList(), ocContract);
        String contractCtrlSeqno = this.saveOcContractCtrl(ocContract);
        ocContractDomain.setContractCtrlSeqno(contractCtrlSeqno);
        ocContractDomain.setContractBillcode(ocContract.getContractBillcode());
        ocContractDomain.setContractBbillcode(ocContract.getContractBbillcode());
        ocContractDomain.setContractTypepro(ocContract.getContractTypepro());
        return ocContract;
    }

    private void setPaydate(OcContract ocContract, OcContractDomain ocContractDomain) {
        int paytime = 0;
        Date nowdate = new Date();
        String tkey = ocContract.getTenantCode();
        String mainkey = "-oc";
        String key = "";
        String key1 = "-paydate";
        String checkTime = "";
        if (StringUtils.isBlank((String)checkTime)) {
            key = "-" + ocContract.getContractType();
            checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tkey + key + key1));
        }
        if (StringUtils.isBlank((String)checkTime)) {
            key = mainkey;
            checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tkey + key + key1));
            if (StringUtils.isBlank((String)checkTime)) {
                key = "00000000" + key + key1;
                checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)key);
            }
        }
        if (StringUtils.isBlank((String)checkTime)) {
            checkTime = "720";
        }
        Date paydate = null;
        if ("-1".equals(checkTime)) {
            paydate = DateUtils.getDateToString((String)(DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
        } else {
            int paydd = Integer.valueOf(checkTime);
            if (0 < paytime && paytime < paydd) {
                paydd = paytime;
            }
            paydate = DateUtils.addMinutes((Date)nowdate, (int)paydd);
        }
        if ("24".equals(ocContractDomain.getContractType()) || "26".equals(ocContractDomain.getContractType())) {
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                if (!ListUtil.isNotEmpty(ocPackageDomain.getContractGoodsList())) continue;
                for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                    int paydd = Integer.valueOf(ocContractGoodsDomain.getGoodsProperty4());
                    if (0 < paytime && paytime < paydd) {
                        paydd = paytime;
                    }
                    paydate = DateUtils.addMinutes((Date)nowdate, (int)paydd);
                }
            }
        }
        ocContract.setContractPaydate(paydate);
    }

    private void saveOcContractpro(List<OcContractproDomain> ocContractproDomainList, OcContract ocContract) {
        if (null == ocContract || null == ocContractproDomainList || ocContractproDomainList.isEmpty()) {
            return;
        }
        for (OcContractproDomain ocContractproDomain : ocContractproDomainList) {
            ocContractproDomain.setContractproId(null);
            ocContractproDomain.setContractBbillcode(ocContract.getContractBbillcode());
            ocContractproDomain.setContractBillcode(ocContract.getContractBillcode());
            ocContractproDomain.setContractNbbillcode(ocContract.getContractNbbillcode());
            ocContractproDomain.setContractNbillcode(ocContract.getContractNbillcode());
            ocContractproDomain.setTenantCode(ocContract.getTenantCode());
            ocContractproDomain.setAppmanageIcode(ocContract.getAppmanageIcode());
        }
        this.ocContractproService.savecontractproBatch(ocContractproDomainList);
    }

    private void saveOcContractSettl(List<OcContractSettlDomain> ocContractSettlDomainList, OcContract ocContract) {
        this.logger.error("oc.CONTRACT.OcContractServiceImpl.saveOcContractSettl.ocContract", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContract));
        this.logger.error("oc.CONTRACT.OcContractServiceImpl.saveOcContractSettl.ocContractSettlDomainList", (Object)JsonUtil.buildNormalBinder().toJson(ocContractSettlDomainList));
        if (null == ocContract || null == ocContractSettlDomainList || ocContractSettlDomainList.isEmpty()) {
            return;
        }
        ArrayList<OcContractSettl> ocContractSettlList = new ArrayList<OcContractSettl>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            ocContractSettlDomain.setContractBillcode(ocContract.getContractBillcode());
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberBcode())) {
                ocContractSettlDomain.setMemberBcode(ocContract.getMemberBcode());
                ocContractSettlDomain.setMemberBname(ocContract.getMemberBname());
            }
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberCcode())) {
                ocContractSettlDomain.setMemberCcode(ocContract.getMemberCcode());
                ocContractSettlDomain.setMemberCname(ocContract.getMemberCname());
            }
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberCode())) {
                ocContractSettlDomain.setMemberCode(ocContract.getMemberCode());
                ocContractSettlDomain.setMemberName(ocContract.getMemberName());
            }
            ocContractSettlDomain.setTenantCode(ocContract.getTenantCode());
            OcContractSettl ocContractSettl = this.createContractsettl(ocContractSettlDomain);
            ocContractSettlList.add(ocContractSettl);
        }
        this.saveContractSettlModelBatch(ocContractSettlList);
    }

    private String saveOcContractCtrl(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractCtrlDomain ocContractCtrlDomain = this.createOcContractCtrlDomain(ocContract);
        if (null == ocContractCtrlDomain) {
            return null;
        }
        return this.ocContractCtrlService.saveContractCtrl(ocContractCtrlDomain);
    }

    private OcContractCtrlDomain createOcContractCtrlDomain(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractCtrlDomain ocContractCtrlDomain = new OcContractCtrlDomain();
        ocContractCtrlDomain.setTenantCode(ocContract.getTenantCode());
        ocContractCtrlDomain.setContractBbillcode(ocContract.getContractBbillcode());
        ocContractCtrlDomain.setContractBillcode(ocContract.getContractBillcode());
        return ocContractCtrlDomain;
    }

    private void savePackageList(List<OcPackageDomain> packageList, OcContract ocContract) {
        if (packageList == null || packageList.isEmpty() || null == ocContract) {
            return;
        }
        String contractBillcode = ocContract.getContractBillcode();
        String tenantCode = ocContract.getTenantCode();
        for (OcPackageDomain ocPackageDomain : packageList) {
            BigDecimal goodsMoney = ocPackageDomain.getGoodsMoney();
            BigDecimal goodsPmoney = ocPackageDomain.getGoodsPmoney();
            String goodsPmbillno = ocPackageDomain.getGoodsPmbillno();
            BigDecimal goodsWeight = ocPackageDomain.getGoodsWeight();
            BigDecimal goodsNum = ocPackageDomain.getGoodsNum();
            String areaCode = ocPackageDomain.getAreaCode();
            String areaName = ocPackageDomain.getAreaName();
            String warehouseName = ocPackageDomain.getWarehouseName();
            String warehouseCode = ocPackageDomain.getWarehouseCode();
            String contractPumode = ocPackageDomain.getContractPumode();
            try {
                BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocContract);
            }
            catch (Exception e) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackageList.e", (Throwable)e);
            }
            if (StringUtils.isNotBlank((String)contractPumode)) {
                ocPackageDomain.setContractPumode(contractPumode);
            }
            ocPackageDomain.setContractBillcode(contractBillcode);
            ocPackageDomain.setTenantCode(tenantCode);
            ocPackageDomain.setGoodsMoney(goodsMoney);
            ocPackageDomain.setGoodsPmoney(goodsPmoney);
            ocPackageDomain.setGoodsPmbillno(goodsPmbillno);
            ocPackageDomain.setGoodsWeight(goodsWeight);
            ocPackageDomain.setGoodsNum(goodsNum);
            ocPackageDomain.setAreaCode(areaCode);
            ocPackageDomain.setAreaName(areaName);
            ocPackageDomain.setWarehouseCode(warehouseCode);
            ocPackageDomain.setWarehouseName(warehouseName);
            ocPackageDomain.setMemberBcode(ocContract.getMemberBcode());
            ocPackageDomain.setMemberBname(ocContract.getMemberBname());
            ocPackageDomain.setMemberCode(ocContract.getMemberCode());
            ocPackageDomain.setMemberName(ocContract.getMemberName());
            this.savePackageBycon(ocPackageDomain, ocContract);
        }
    }

    @Override
    public void updateContractState(Integer contractId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractModel(contractId, dataState, oldDataState);
    }

    @Override
    public void updateContractStateExtend(Integer contractId, Integer dataState, Integer oldDataState) {
        if (contractId == null || contractId <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateExtend.contractId.null", "\u8ba2\u5355\u7f16\u53f7\u6709\u8bef");
        }
        switch (dataState) {
            case -1: {
                this.extend_can(contractId, dataState, oldDataState);
                break;
            }
            case 2: {
                this.extend_offlinePay(contractId, dataState, oldDataState);
                break;
            }
            case 4: {
                this.extend_offlinePay(contractId, dataState, oldDataState);
                break;
            }
            default: {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateExtend.dataState", "\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u72b6\u6001");
            }
        }
    }

    private void extend_can(Integer contractId, Integer dataState, Integer oldDataState) {
        OcContract ocContract = this.getContractModelById(contractId);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_can.ocContract", "\u8ba2\u5355\u4e0d\u5b58\u5728" + contractId);
        }
        if (null != oldDataState && oldDataState.intValue() != ocContract.getDataState().intValue()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_can.dataState", "\u8ba2\u5355\u72b6\u6001\u5df2\u53d8\u5316[" + oldDataState + "][" + ocContract.getDataState() + "]");
        }
        String contractBillcode = ocContract.getContractBillcode();
        String tenantCode = ocContract.getTenantCode();
        this.getOcContractEngineService().sendContractBack(contractBillcode, tenantCode, null);
    }

    private void extend_offlinePay(Integer contractId, Integer dataState, Integer oldDataState) {
        OcContract ocContract = this.getContractModelById(contractId);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_offlinePay.ocContract", "\u8ba2\u5355\u4e0d\u5b58\u5728" + contractId);
        }
        if (null != oldDataState && oldDataState.intValue() != ocContract.getDataState().intValue()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_offlinePay.dataState", "\u8ba2\u5355\u72b6\u6001\u5df2\u53d8\u5316[" + oldDataState + "][" + ocContract.getDataState() + "]");
        }
        String contractBillcode = ocContract.getContractBillcode();
        String tenantCode = ocContract.getTenantCode();
        this.getOcContractEngineService().sendContractNext(contractBillcode, tenantCode, null);
    }

    @Override
    public void updateContract(OcContractDomain ocContractDomain) throws ApiException {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.checkContract", msg);
        }
        OcContract oldOcContract = null;
        if (ocContractDomain.getContractId() != null) {
            oldOcContract = this.getContractModelById(ocContractDomain.getContractId());
        } else if (StringUtils.isNotBlankLoop((String[])new String[]{ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode()})) {
            oldOcContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode()}));
        }
        if (null == oldOcContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContract ocContract = this.makeContract(ocContractDomain, oldOcContract);
        this.setContractUpdataDefault(ocContract);
        this.makePack(ocContractDomain);
        ocContract.setContractEcflag(this.checkEc(ocContract, ocContractDomain.getPackageList().get(0).getContractGoodsList()));
        this.updateContractModel(ocContract);
        this.deleteContractAll(oldOcContract.getContractBillcode(), oldOcContract.getTenantCode());
        this.savePackageList(ocContractDomain.getPackageList(), ocContract);
        this.saveOcContractSettl(ocContractDomain.getOcContractSettlList(), ocContract);
        this.saveOcContractpro(ocContractDomain.getOcContractproDomainList(), ocContract);
    }

    private void deleteContractAll(String contractBillcode, String tenantCode) {
        QueryResult<OcContractpro> qprolist;
        List<OcContractSettl> settllist;
        List<OcContractGoods> glist;
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        List<OcPackage> plist = this.queryPackageModelPage(parammap);
        if (ListUtil.isNotEmpty(plist)) {
            for (OcPackage ocPackage : plist) {
                this.deletePackageModel(ocPackage.getPackageId());
            }
        }
        if (ListUtil.isNotEmpty(glist = this.queryContractGoodsModelPage(parammap))) {
            for (OcContractGoods ocContractGoods : glist) {
                this.deleteContractGoodsModel(ocContractGoods.getContractGoodsId());
            }
        }
        if (ListUtil.isNotEmpty(settllist = this.queryContractSettlModelPage(parammap))) {
            for (OcContractSettl ocContractSettl : settllist) {
                this.deleteContractSettlModel(ocContractSettl.getContractSettlId());
            }
        }
        if (null != (qprolist = this.ocContractproService.querycontractproPage(parammap)) && ListUtil.isNotEmpty((Collection)qprolist.getList())) {
            for (OcContractpro ocContractpro : qprolist.getList()) {
                this.ocContractproService.deletecontractpro(ocContractpro.getContractproId());
            }
        }
    }

    @Override
    public OcContractReDomain getContract(Integer contractId) {
        OcContract ocContract = this.getContractModelById(contractId);
        OcContractReDomain ocContractDomain = this.makeReDomain(ocContract);
        return ocContractDomain;
    }

    @Override
    public void deleteContract(Integer contractId) throws ApiException {
        this.deleteContractModel(contractId);
    }

    @Override
    public QueryResult<OcContract> queryContractPage(Map<String, Object> map) {
        int count = this.countContract(map);
        List<Object> ocContractList = new ArrayList();
        if (count > 0) {
            ocContractList = this.queryContractModelPage(map);
            if (map.get("childFlag") != null && ocContractList != null && !ocContractList.isEmpty()) {
                map.clear();
                for (OcContract ocContract : ocContractList) {
                    map.put("contractBillcode", ocContract.getContractBillcode());
                    map.put("tenantCode", ocContract.getTenantCode());
                    map.put("mode", PackageModeEnum.AUTO.getCode());
                    ocContract.setPackageList(this.setPackageList(map));
                }
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    private List<OcPackage> setPackageList(Map<String, Object> map) {
        QueryResult<OcPackage> rueryResult = this.queryPackagePage(map);
        if (null == rueryResult) {
            return null;
        }
        return rueryResult.getList();
    }

    private List<OcPackageDomain> queryPackageDomainList(String contractBillcode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("mode", PackageModeEnum.AUTO.getCode());
        List<OcPackage> packageList = this.queryPackageModelPage(map);
        if (ListUtil.isEmpty(packageList)) {
            return null;
        }
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        for (OcPackage ocPackage : packageList) {
            OcPackageDomain domain = new OcPackageDomain();
            try {
                BeanUtils.copyAllPropertys((Object)domain, (Object)ocPackage);
                packageDomainList.add(domain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryPackageDomainList.foreach.ex", (Throwable)e);
            }
        }
        return packageDomainList;
    }

    private List<OcContractGoodsDomain> queryContractGoodsDomainListNew(Map<String, Object> parammap) {
        List<OcContractGoods> goodsList = this.queryContractGoodsModelPage(parammap);
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> goodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoods ocContractGoods : goodsList) {
            OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)ocContractGoods);
                goodsDomainList.add(goodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsDomainListNew.foreach.ex", (Throwable)e);
            }
        }
        return goodsDomainList;
    }

    private List<OcContractGoodsDomain> queryContractGoodsDomainList(String contractBillcode, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        List<OcContractGoods> goodsList = this.queryContractGoodsModelPage(parammap);
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> goodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoods ocContractGoods : goodsList) {
            OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)ocContractGoods);
                goodsDomainList.add(goodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsDomainList.foreach.ex", (Throwable)e);
            }
        }
        return goodsDomainList;
    }

    private List<OcContractSettlDomain> queryContractSettlDomainList(String contractBillcode, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        List<OcContractSettl> ocContractSettls = this.queryContractSettlModelPage(parammap);
        if (ListUtil.isEmpty(ocContractSettls)) {
            return null;
        }
        ArrayList<OcContractSettlDomain> ocContractSettlDomains = new ArrayList<OcContractSettlDomain>();
        for (OcContractSettl ocContractSettl : ocContractSettls) {
            OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocContractSettlDomain, (Object)ocContractSettl);
                ocContractSettlDomains.add(ocContractSettlDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsDomainList.foreach.ex", (Throwable)e);
            }
        }
        return ocContractSettlDomains;
    }

    private List<OcContractReDomain> queryContractReDomainModelPage(Map<String, Object> map) {
        List<OcContract> contractList = this.ocContractMapper.query(map);
        return this.childFlag(map, contractList);
    }

    private List<OcContractReDomain> queryContractReDomainBySearchParam(Map<String, Object> map) {
        List<OcContract> contractList = this.ocContractMapper.queryBySearchParam(map);
        return this.childFlag(map, contractList);
    }

    private List<OcContractReDomain> childFlag(Map<String, Object> map, List<OcContract> contractList) {
        if (contractList == null || contractList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractReDomain> contractReDomainList = new ArrayList<OcContractReDomain>();
        boolean childFlag = null != map && map.get("childFlag") != null;
        boolean goodsProFlag = null == map.get("goodsProFlag") ? false : Boolean.valueOf(map.get("goodsProFlag").toString());
        boolean packFlag = null == map.get("packFlag") ? false : Boolean.valueOf(map.get("packFlag").toString());
        boolean settleFlag = null == map.get("settleFlag") ? false : Boolean.valueOf(map.get("settleFlag").toString());
        for (OcContract ocContract : contractList) {
            OcContractReDomain contractReDomain = this.makeOcContractDomain(ocContract);
            if (packFlag) {
                contractReDomain.setPackageList(this.queryPackageDomainList(ocContract.getContractBillcode(), ocContract.getTenantCode()));
            }
            if (childFlag) {
                contractReDomain.setGoodsList(this.queryContractGoodsDomainList(ocContract.getContractBillcode(), ocContract.getTenantCode()));
            }
            if (settleFlag) {
                contractReDomain.setOcContractSettlList(this.queryContractSettlDomainList(ocContract.getContractBillcode(), ocContract.getTenantCode()));
            }
            if (goodsProFlag) {
                contractReDomain.setOcContractproDomainList(this.queryContractProDomain(ocContract));
            }
            contractReDomainList.add(contractReDomain);
        }
        return contractReDomainList;
    }

    private List<OcContractReDomain> childFlagNew(Map<String, Object> map, List<OcContract> contractList) {
        if (contractList == null || contractList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractReDomain> contractReDomainList = new ArrayList<OcContractReDomain>();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("order", true);
        parammap.put("fuzzy", true);
        for (OcContract ocContract : contractList) {
            OcContractReDomain contractReDomain = this.makeOcContractDomain(ocContract);
            contractReDomain.setPackageList(this.queryPackageDomainList(ocContract.getContractBillcode(), ocContract.getTenantCode()));
            if (null != map && map.get("warehouseName") != null) {
                parammap.put("warehouseName", map.get("warehouseName"));
            }
            if (null != map && map.get("warehouseNameTrue") != null) {
                parammap.put("warehouseNameTrue", map.get("warehouseNameTrue"));
            }
            if (null != map && map.get("contractGoodsRemark") != null) {
                parammap.put("contractGoodsRemark", map.get("contractGoodsRemark"));
            }
            if (null != map && map.get("goodsNo") != null) {
                parammap.put("goodsNo", map.get("goodsNo"));
            }
            if (null != map && map.get("goodsName") != null) {
                parammap.put("goodsName", map.get("goodsName"));
            }
            if (null != map && map.get("orderStrStr") != null) {
                parammap.put("orderStr", map.get("orderStrStr"));
            }
            if (null != map && map.get("classtreeCode") != null) {
                parammap.put("classtreeCode", map.get("classtreeCode"));
            }
            if (null != map && map.get("dataStateNewStr") != null) {
                parammap.put("dataState", map.get("dataStateNewStr"));
            }
            parammap.put("contractBillcode", ocContract.getContractBillcode());
            parammap.put("tenantCode", ocContract.getTenantCode());
            contractReDomain.setGoodsList(this.queryContractGoodsDomainListNew(parammap));
            contractReDomainList.add(contractReDomain);
        }
        return contractReDomainList;
    }

    private List<OcContractproDomain> queryContractProDomain(OcContract ocContract) {
        List<OcContractpro> ocContractproList = this.ocContractproService.querycontractproByOrderCode(ocContract.getTenantCode(), ocContract.getContractBillcode());
        if (ListUtil.isEmpty(ocContractproList)) {
            return null;
        }
        ArrayList<OcContractproDomain> ocContractproDomainList = new ArrayList<OcContractproDomain>();
        for (OcContractpro ocContractpro : ocContractproList) {
            OcContractproDomain ocContractproDomain = new OcContractproDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocContractproDomain, (Object)ocContractpro);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocContractproDomainList.add(ocContractproDomain);
        }
        return ocContractproDomainList;
    }

    @Override
    public QueryResult<OcContractReDomain> queryContractPageReDomain(Map<String, Object> map) {
        int count = this.countContract(map);
        List<Object> ocContractList = new ArrayList();
        if (count > 0) {
            ocContractList = this.queryContractReDomainModelPage(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    @Override
    public QueryResult<OcContractReDomain> queryContractReDomainModelNewPage(Map<String, Object> map) {
        String warehouseNameTrue = null == map || null == map.get("warehouseNameTrue") ? "" : (String)map.get("warehouseNameTrue");
        Boolean flag = Boolean.valueOf(warehouseNameTrue);
        if (flag.booleanValue()) {
            map.put("warehouseNameTrue", flag);
        }
        int count = this.countContractNew(map);
        List<Object> ocContractList = new ArrayList();
        if (count > 0) {
            ocContractList = this.queryContractReDomainModel(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    private List<OcContractReDomain> queryContractReDomainModel(Map<String, Object> map) {
        List<OcContract> contractList = this.queryContractModelNewPage(map);
        return this.childFlagNew(map, contractList);
    }

    @Override
    public QueryResult<OcContractReDomain> queryContract(Map<String, Object> map) {
        if (map.get("tenantCode") == null) {
            this.logger.error("queryContract is null", map);
            return null;
        }
        int count = this.countContract(map);
        List<OcContractReDomain> ocContractList = this.queryContractModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    private List<OcContractReDomain> queryContractModel(Map<String, Object> map) {
        try {
            return this.ocContractMapper.queryl(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<OcContractReDomain> queryContractPageBySearchParam(Map<String, Object> map) {
        int count = this.countContractBySearchParam(map);
        List<Object> ocContractList = new ArrayList();
        if (count > 0) {
            ocContractList = this.queryContractReDomainBySearchParam(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    @Override
    public OcContractReDomain getContractByCode(Map<String, Object> map) {
        OcContract ocContract = this.getContractModelByCode(map);
        OcContractReDomain ocContractDomain = this.makeReDomain(ocContract);
        return ocContractDomain;
    }

    @Override
    public OcCflowPprocessDomain getContractTimeByCode(Map<String, Object> map) {
        this.logger.error("map----=", map);
        this.logger.error("-------------========");
        if (null == map) {
            return null;
        }
        try {
            OcCflowPprocess ocCflowPprocess = this.ocCflowPprocessMapper.selectContractime(map);
            OcCflowPprocessDomain ocCflowPprocessDomain = new OcCflowPprocessDomain();
            BeanUtils.copyAllPropertys((Object)ocCflowPprocessDomain, (Object)ocCflowPprocess);
            return ocCflowPprocessDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.selectContractime", (Throwable)e);
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.selectContractime.ex", (Throwable)e);
        }
    }

    @Override
    public OcContract getContractOneByCode(Map<String, Object> map) {
        return this.getContractModelByCode(map);
    }

    @Override
    public OcContract getContractModelByCodes(Map<String, Object> map) {
        return this.getContractModelByCode(map);
    }

    private OcContractReDomain makeReDomain(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractReDomain ocContractDomain = this.makeOcContractDomain(ocContract);
        if (null == ocContractDomain) {
            return null;
        }
        TypeBean typeBean = this.getOcSetting(ocContract.getContractType(), ocContract.getTenantCode());
        if (null != typeBean) {
            ocContractDomain.setIntpay(typeBean.getIntpay());
            ocContractDomain.setPmpay(typeBean.getPmpay());
            ocContractDomain.setBlance(typeBean.getBlance());
            ocContractDomain.setPmode(typeBean.getPmode());
            ocContractDomain.setFreight(typeBean.getFreight());
            ocContractDomain.setCoppay(typeBean.getCoppay());
            ocContractDomain.setUrpay(typeBean.getUrpay());
            int i = this.checkInv(typeBean, ocContract.getContractTypepro());
            if (0 == i) {
                ocContractDomain.setInvp("0");
            } else {
                ocContractDomain.setInvp("1");
            }
            ocContractDomain.setRef(typeBean.getRef());
            ocContractDomain.setReg(typeBean.getReg());
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", ocContract.getContractBillcode());
        parammap.put("tenantCode", ocContract.getTenantCode());
        List<OcPackage> ocPackageList = this.queryPackageModelPage(parammap);
        if (null == ocPackageList || ocPackageList.isEmpty()) {
            return ocContractDomain;
        }
        List<OcPackageDomain> packageList = this.makePackageDomainList(ocPackageList);
        ocContractDomain.setPackageList(packageList);
        List<OcContractSettl> ocContractSettlList = this.queryContractSettlModelPage(parammap);
        ocContractDomain.setOcContractSettlList(this.makeOcContractSettlDomainList(ocContractSettlList));
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
        for (OcPackageDomain ocPackageDomain : packageList) {
            goodsList.addAll(ocPackageDomain.getContractGoodsList());
        }
        if (ListUtil.isEmpty(goodsList)) {
            parammap.put("contractBillcode", ocContract.getContractBillcode());
            ocContractDomain.setGoodsList(this.makeOcContractGoodsDomainList(this.queryContractGoodsModelPage(parammap)));
        } else {
            ocContractDomain.setGoodsList(goodsList);
        }
        ocContractDomain.setOaflag(this.checkOa(ocContract, typeBean, ocContractDomain.getGoodsList()) + "");
        List<OcContractpro> proList = this.ocContractproService.querycontractproByOrderCode(ocContract.getTenantCode(), ocContract.getContractBillcode());
        ocContractDomain.setOcContractproDomainList(this.makeOcContractproDomainList(proList));
        return ocContractDomain;
    }

    @Override
    public void delContractByCode(Map<String, Object> map) throws ApiException {
        this.delContractModelByCode(map);
    }

    @Override
    public void saveContractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        if (null == ocContractGoodsDomain || StringUtils.isBlank((String)ocContractGoodsDomain.getContractBillcode()) || StringUtils.isBlank((String)ocContractGoodsDomain.getPackageCode())) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoods.null");
        }
        OcContract ocContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractGoodsDomain.getContractBillcode(), ocContractGoodsDomain.getTenantCode()}));
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoods.ocContract", ocContractGoodsDomain.getContractBillcode());
        }
        OcPackage ocPackage = this.getPackageModelByCode(this.getQueryMapParam("packageCode,tenantCode", new Object[]{ocContractGoodsDomain.getPackageCode(), ocContractGoodsDomain.getTenantCode()}));
        if (null == ocPackage) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoods.ocPackage", ocContractGoodsDomain.getPackageCode());
        }
        OcContractGoods ocContractGoods = this.createContractgoods(ocContractGoodsDomain);
        this.makeSum(ocContract, ocPackage, ocContractGoods);
        this.updateContractModel(ocContract);
        this.updatePackageModel(ocPackage);
        this.saveContractGoodsModel(ocContractGoods);
    }

    private void makeSum(OcContract contractDomain, OcPackage ocPackage, OcContractGoods ocContractGoodsDomain) {
        if (null == contractDomain || null == ocPackage || null == ocContractGoodsDomain) {
            return;
        }
        BigDecimal goodsMoney = ocPackage.getGoodsInmoney();
        BigDecimal goodsInmoney = ocPackage.getGoodsMoney();
        BigDecimal goodsPef = ocPackage.getPricesetRefrice();
        BigDecimal packageGoodsWeight = ocPackage.getGoodsWeight();
        BigDecimal packageGoodsNum = ocPackage.getGoodsNum();
        BigDecimal packagemoney = ocPackage.getGoodsPacgemoney();
        ocContractGoodsDomain.setMemberBcode(contractDomain.getMemberBcode());
        ocContractGoodsDomain.setMemberBname(contractDomain.getMemberBname());
        if (null == ocContractGoodsDomain.getContractGoodsBoxamt()) {
            ocContractGoodsDomain.setContractGoodsBoxamt(BigDecimal.ZERO);
        }
        packagemoney = packagemoney.add(ocContractGoodsDomain.getContractGoodsBoxamt());
        if (null == ocContractGoodsDomain.getGoodsNum()) {
            ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        packageGoodsNum = packageGoodsNum.add(ocContractGoodsDomain.getGoodsNum());
        if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
            ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
        }
        goodsInmoney = goodsInmoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
        if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
            ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
        }
        goodsMoney = goodsMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
        if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
            ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
        }
        goodsPef = goodsPef.add(ocContractGoodsDomain.getContractGoodsPefinmoney());
        if (null == ocContractGoodsDomain.getGoodsWeight()) {
            ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        packageGoodsWeight = packageGoodsWeight.add(ocContractGoodsDomain.getGoodsWeight());
        ocPackage.setGoodsWeight(packageGoodsWeight);
        ocPackage.setGoodsNum(packageGoodsNum);
        ocPackage.setGoodsPacgemoney(packagemoney);
        ocPackage.setGoodsMoney(goodsInmoney);
        ocPackage.setPricesetRefrice(goodsPef);
        ocPackage.setGoodsPmoney(goodsMoney);
        ocPackage.setGoodsInmoney(goodsMoney);
        contractDomain.setContractPaymoney(contractDomain.getContractPaymoney().add(ocContractGoodsDomain.getContractGoodsBoxamt()));
        contractDomain.setPricesetRefrice(contractDomain.getPricesetRefrice().add(ocContractGoodsDomain.getContractGoodsPefinmoney()));
        contractDomain.setGoodsNum(contractDomain.getGoodsNum().add(ocContractGoodsDomain.getGoodsNum()));
        contractDomain.setGoodsWeight(contractDomain.getGoodsWeight().add(ocContractGoodsDomain.getGoodsWeight()));
        contractDomain.setContractInmoney(contractDomain.getContractInmoney().add(ocContractGoodsDomain.getContractGoodsInmoney()));
        contractDomain.setGoodsMoney(contractDomain.getGoodsMoney().add(ocContractGoodsDomain.getContractGoodsMoney()));
        contractDomain.setContractMoney(contractDomain.getContractMoney().add(ocContractGoodsDomain.getContractGoodsMoney()));
        contractDomain.setDataBnum(contractDomain.getGoodsNum());
        contractDomain.setDataBweight(contractDomain.getGoodsWeight());
        contractDomain.setDataBmoney(contractDomain.getDataBmoney().add(ocContractGoodsDomain.getContractGoodsMoney()));
    }

    private OcContractGoods createContractgoods(OcContractGoodsDomain ocContractGoodsDomain) {
        String msg = this.checkContractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoods.checkContractGoods", msg);
        }
        OcContractGoods ocContractGoods = this.makeContractGoods(ocContractGoodsDomain, null);
        this.setContractGoodsDefault(ocContractGoods);
        return ocContractGoods;
    }

    @Override
    public void updateContractGoodsState(Integer contractGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractGoodsModel(contractGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateContractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        String msg = this.checkContractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoods.checkContractGoods", msg);
        }
        OcContractGoods oldOcContractGoods = this.getContractGoodsModelById(ocContractGoodsDomain.getContractGoodsId());
        if (null == oldOcContractGoods) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractGoods ocContractGoods = this.makeContractGoods(ocContractGoodsDomain, oldOcContractGoods);
        this.setContractGoodsUpdataDefault(ocContractGoods);
        this.updateContractGoodsModel(ocContractGoods);
    }

    @Override
    public OcContractGoods getContractGoods(Integer contractGoodsId) {
        return this.getContractGoodsModelById(contractGoodsId);
    }

    @Override
    public void deleteContractGoods(Integer contractGoodsId) throws ApiException {
        this.deleteContractGoodsModel(contractGoodsId);
    }

    @Override
    public QueryResult<OcContractGoods> queryContractGoodsPage(Map<String, Object> map) {
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractGoodsList);
        return queryResult;
    }

    @Override
    public QueryResult<ReportOcContractGoods> queryReportPage(Map<String, Object> map) {
        List<ReportOcContractGoods> ocContractGoodsList = this.queryReport(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReport(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractGoodsList);
        return queryResult;
    }

    @Override
    public Map<String, Object> queryContractSum(Map<String, Object> map) {
        return this.queryContractModelSum(map);
    }

    @Override
    public OcContractGoods getContractGoodsByCode(Map<String, Object> map) {
        return this.getContractGoodsModelByCode(map);
    }

    @Override
    public OcContractGoods getContractGoodsPricesetSum(Map<String, Object> map) {
        return this.queryPricesetSum(map);
    }

    @Override
    public void delContractGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delContractGoodsModelByCode(map);
    }

    @Override
    public void savePackage(OcPackageDomain ocPackageDomain) throws ApiException {
        this.savePackageBycon(ocPackageDomain, null);
    }

    private void savePackageBycon(OcPackageDomain ocPackageDomain, OcContract ocContract) {
        String msg = this.checkPackage(ocPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackage.checkPackage", msg);
        }
        OcPackage ocPackage = this.makePackage(ocPackageDomain, null);
        this.setPackageDefault(ocPackage);
        this.savePackageModel(ocPackage);
        this.saveContractGoodsList(ocPackageDomain.getContractGoodsList(), ocPackage, ocContract);
    }

    private void saveContractGoodsList(List<OcContractGoodsDomain> contractGoodsList, OcPackage ocPackage, OcContract ocContract) {
        if (contractGoodsList == null || contractGoodsList.isEmpty() || null == ocPackage) {
            return;
        }
        List<String> classTrees = Arrays.asList("2020101600000033", "2020101600000101", "2020101600000053", "2020101600000002");
        ArrayList<OcContractGoods> ocContractGoodsList = new ArrayList<OcContractGoods>();
        ArrayList<OcContractPmGoodsDomain> ocContractPmGoodsDomainList = new ArrayList<OcContractPmGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
            if ("2020050600004084".equals(ocContractGoodsDomain.getTenantCode())) {
                if (classTrees.contains(ocContractGoodsDomain.getClasstreeCode())) {
                    ocContractGoodsDomain.setGoodsPro("1");
                } else {
                    ocContractGoodsDomain.setGoodsPro("0");
                }
                if ("2020101600000033".equals(ocContractGoodsDomain.getClasstreeCode())) {
                    ocContractGoodsDomain.setGoodsPro("3");
                }
            }
            ocContractGoodsDomain.setPackageCode(ocPackage.getPackageCode());
            ocContractGoodsDomain.setContractBillcode(ocPackage.getContractBillcode());
            ocContractGoodsDomain.setTenantCode(ocPackage.getTenantCode());
            ocContractGoodsDomain.setMemberBcode(ocPackage.getMemberBcode());
            ocContractGoodsDomain.setMemberBname(ocPackage.getMemberBname());
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsGtype())) {
                ocContractGoodsDomain.setContractGoodsGtype("0");
            }
            if (null == ocContractGoodsDomain.getContractGoodsType()) {
                ocContractGoodsDomain.setContractGoodsType(0);
            }
            if (null != ocContract) {
                if (StringUtils.isBlank((String)ocContractGoodsDomain.getMemberCcode()) && StringUtils.isNotBlank((String)ocContract.getMemberCcode())) {
                    ocContractGoodsDomain.setMemberCcode(ocContract.getMemberCcode());
                    ocContractGoodsDomain.setMemberCname(ocContract.getMemberCname());
                }
                ocContractGoodsDomain.setMemberCode(ocContract.getMemberCode());
                ocContractGoodsDomain.setMemberName(ocContract.getMemberName());
            }
            OcContractGoods ocContractGoods = this.createContractgoods(ocContractGoodsDomain);
            if (ListUtil.isNotEmpty(ocContractGoodsDomain.getOcContractPmGoodsDomainList())) {
                for (OcContractPmGoodsDomain ocContractPmGoodsDomain : ocContractGoodsDomain.getOcContractPmGoodsDomainList()) {
                    ocContractPmGoodsDomain.setContractBillcode(ocContractGoods.getContractBillcode());
                    ocContractPmGoodsDomain.setContractGoodsCode(ocContractGoods.getContractGoodsCode());
                    ocContractPmGoodsDomainList.add(ocContractPmGoodsDomain);
                }
            }
            ocContractGoodsList.add(ocContractGoods);
        }
        this.saveContractGoodsBatchModel(ocContractGoodsList);
        this.ocContractPmGoodsService.saveContractPmGoodsBatch(ocContractPmGoodsDomainList);
    }

    @Override
    public void updatePackageState(Integer packageId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePackageModel(packageId, dataState, oldDataState);
    }

    @Override
    public void updatePackage(OcPackageDomain ocPackageDomain) throws ApiException {
        String msg = this.checkPackage(ocPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackage.checkPackage", msg);
        }
        OcPackage oldOcPackage = this.getPackageModelById(ocPackageDomain.getPackageId());
        if (null == oldOcPackage) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackage.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcPackage ocPackage = this.makePackage(ocPackageDomain, oldOcPackage);
        this.setPackageUpdataDefault(ocPackage);
        this.updatePackageModel(ocPackage);
    }

    @Override
    public OcPackage getPackage(Integer packageId) {
        return this.getPackageModelById(packageId);
    }

    @Override
    public void deletePackage(Integer packageId) throws ApiException {
        this.deletePackageModel(packageId);
    }

    @Override
    public QueryResult<OcPackage> queryPackagePage(Map<String, Object> map) {
        List<OcPackage> ocPackageList = this.queryPackageModelPage(map);
        if (ocPackageList != null && !ocPackageList.isEmpty()) {
            for (OcPackage ocPackage : ocPackageList) {
                map.put("packageCode", ocPackage.getPackageCode());
                ocPackage.setContractGoodsList(this.queryContractGoodsModelPage(map));
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPackage(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocPackageList);
        map.clear();
        return queryResult;
    }

    @Override
    public OcPackage getPackageByCode(Map<String, Object> map) {
        return this.getPackageModelByCode(map);
    }

    @Override
    public void delPackageByCode(Map<String, Object> map) throws ApiException {
        this.delPackageModelByCode(map);
    }

    @Override
    public void updateContractStateByCode(Map<String, Object> map) throws ApiException {
        String contractBillcode = map.get("contractBillcode").toString();
        Integer dataState = (Integer)map.get("dataState");
        Integer oldDataState = (Integer)map.get("oldDataState");
        OcContract contract = this.getContractModelByCode(map);
        this.updateStateContractModel(contract.getContractId(), dataState, oldDataState);
        if (ContractPropertyEnum.VIRTUAL.getCode().equals(contract.getContractProperty())) {
            this.updateExtContractPackage(contract.getTenantCode(), contractBillcode, null, null);
        }
    }

    @Override
    public QueryResult<OcContract> getOcContractByGoods(Map<String, Object> map) throws ApiException {
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(map);
        ArrayList<OcContract> contractList = new ArrayList<OcContract>();
        for (OcContractGoods goods : ocContractGoodsList) {
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            pmap.put("contractBillcode", goods.getContractBillcode());
            pmap.put("tenantCode", goods.getTenantCode());
            OcContract contract = this.getContractModelByCode(pmap);
            if (contract == null) continue;
            contract.setOcContractGoods(goods);
            contractList.add(contract);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(contractList);
        return queryResult;
    }

    @Override
    public void sendContractMsg(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendContractMsg", (Object)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        OcContract ocContract = this.getContractModelByCode(this.getQueryParamMap("tenantCode,contractBillcode", new Object[]{tenantCode, contractBillcode}));
        if (ocContract == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendContractMsg", (Object)"\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        List<OcContractGoods> goodslist = this.queryContractGoodsModelPage(this.getQueryParamMap("tenantCode,contractBillcode", new Object[]{tenantCode, contractBillcode}));
        this.sendMns(ocContract, goodslist);
    }

    public void sendMns(OcContract ocContract, List<OcContractGoods> goodslist) {
        if (ListUtil.isEmpty(goodslist)) {
            return;
        }
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        mnsMap.put("mnslistSubject", "");
        mnsMap.put("mnslistSource", "0");
        if (ContractConstants.NEW_ORDER.equals(ocContract.getDataState())) {
            mnsMap.put("mnslistBusType", "o1");
        } else if (ContractConstants.PAY_FINISH_ORDER.equals(ocContract.getDataState())) {
            mnsMap.put("mnslistBusType", "o2");
        } else {
            return;
        }
        HashMap<String, String> contentMap = new HashMap<String, String>();
        ArrayList<Map<String, String>> receiverList = new ArrayList<Map<String, String>>();
        this.makeReceiver(ocContract.getTenantCode(), ocContract.getMemberCode(), receiverList);
        if (!ocContract.getMemberCode().equals(ocContract.getMemberCcode())) {
            this.makeReceiver(ocContract.getTenantCode(), ocContract.getMemberCcode(), receiverList);
        }
        contentMap.put("memberName", ocContract.getMemberBname());
        contentMap.put("goodsRemark", goodslist.get(0).getGoodsRemark());
        contentMap.put("orderAmount", String.valueOf(ocContract.getContractMoney().setScale(2, 5)));
        contentMap.put("contractBillcode", ocContract.getContractBillcode());
        mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, receiverList));
        mnsMap.put("tenantCode", ocContract.getTenantCode());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        this.inAsyncInvoke("mns.mns.saveSendMnslist", paramMap);
    }

    private void makeReceiver(String tenantCode, String memberCode, List<Map<String, String>> receiverList) {
        if (StringUtils.isNotBlank((String)memberCode)) {
            HashMap<String, String> map = new HashMap<String, String>();
            Map<String, Object> member = this.getMember(tenantCode, memberCode);
            String phone = (String)member.get("merberPhone");
            if (StringUtils.isBlank((String)phone)) {
                phone = (String)member.get("merberTel");
            }
            if (StringUtils.isBlank((String)phone)) {
                return;
            }
            map.put("telphone", phone);
            map.put("name", (String)member.get("merberCompname"));
            receiverList.add(map);
        }
    }

    private Map<String, Object> getMember(String tenantCode, String memberCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryParamMap("tenantCode,merberCode", new Object[]{tenantCode, memberCode})));
        String result = this.internalInvoke("mm.merber.getMerberByCode", paramMap);
        Map resultMap = null;
        try {
            resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultMap;
    }

    private String getMnslistExp(Map<String, String> contentMap, List<Map<String, String>> receiverList) {
        HashMap<String, String> expMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(contentMap);
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        expMap.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        expMap.put("theme", "");
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }

    @Override
    public String updateContractAndRefund(String tenantCode, String contractBillcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContract contract = this.getContractModelByCode(map);
        if (contract == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractAndRefund.null", "\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.updateStateContractModel(contract.getContractId(), -1, contract.getDataState());
        return contract.getContractBillcode();
    }

    @Override
    public void updateContractGoodsAndRefund(String tenantCode, String contractGoodsCode, BigDecimal contractGoodsRefnum, BigDecimal contractGoodsRefweight, int dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("contractGoodsRefnum", contractGoodsRefnum);
        map.put("contractGoodsRefweight", contractGoodsRefweight);
        this.updateContractGoodsModelRefByCode(map);
    }

    @Override
    public void updateBatchContractGoodsAndRefund(List<GoodsRefundNumBean> goodsRefundNumBeanList) {
        if (ListUtil.isEmpty(goodsRefundNumBeanList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GoodsRefundNumBean goodsRefundNumBean : goodsRefundNumBeanList) {
            map.put("tenantCode", goodsRefundNumBean.getTenantCode());
            map.put("dataState", goodsRefundNumBean.getDataState());
            map.put("contractGoodsCode", goodsRefundNumBean.getContractGoodsCode());
            map.put("contractGoodsRefnum", goodsRefundNumBean.getContractGoodsRefnum());
            map.put("contractGoodsRefweight", goodsRefundNumBean.getContractGoodsRefweight());
            this.updateContractGoodsModelRefByCode(map);
        }
    }

    @Override
    public void updateBatchContractGoodsAndRefundNw(List<GoodsRefundNumBean> goodsRefundNumBeanList) {
        if (ListUtil.isEmpty(goodsRefundNumBeanList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GoodsRefundNumBean goodsRefundNumBean : goodsRefundNumBeanList) {
            map.put("tenantCode", goodsRefundNumBean.getTenantCode());
            map.put("dataState", goodsRefundNumBean.getDataState());
            map.put("contractGoodsCode", goodsRefundNumBean.getContractGoodsCode());
            map.put("contractGoodsRefnum", goodsRefundNumBean.getContractGoodsRefnum());
            map.put("contractGoodsRefweight", goodsRefundNumBean.getContractGoodsRefweight());
            this.updateContractGoodsModelRefNwByCode(map);
        }
    }

    @Override
    public void updateBatchContractGoodsAndRefundFlag(List<GoodsRefundNumBean> goodsRefundNumBeanList) {
        if (ListUtil.isEmpty(goodsRefundNumBeanList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GoodsRefundNumBean goodsRefundNumBean : goodsRefundNumBeanList) {
            map.put("tenantCode", goodsRefundNumBean.getTenantCode());
            map.put("dataState", goodsRefundNumBean.getDataState());
            map.put("contractGoodsCode", goodsRefundNumBean.getContractGoodsCode());
            map.put("contractGoodsRefnum", goodsRefundNumBean.getContractGoodsRefnum());
            map.put("contractGoodsRefweight", goodsRefundNumBean.getContractGoodsRefweight());
            this.updateContractGoodsModelRefByCodeFlag(map);
        }
    }

    @Override
    public void updateBatchContractGoodsAndRefundRe(List<GoodsRefundNumBean> goodsRefundNumBeanList) {
        if (ListUtil.isEmpty(goodsRefundNumBeanList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GoodsRefundNumBean goodsRefundNumBean : goodsRefundNumBeanList) {
            map.put("tenantCode", goodsRefundNumBean.getTenantCode());
            map.put("contractGoodsCode", goodsRefundNumBean.getContractGoodsCode());
            map.put("contractGoodsRefnum", goodsRefundNumBean.getContractGoodsRefnum());
            map.put("contractGoodsRefweight", goodsRefundNumBean.getContractGoodsRefweight());
            this.updateContractGoodsModelRefByCodeRe(map);
        }
    }

    @Override
    public void updateContractGoodsRefundres(String tenantCode, String contractGoodsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        this.updateContractGoodsModelRefres(map);
    }

    @Override
    public void updateRefundPass(String refundCode, String tenantCode) {
    }

    @Override
    public void updateCashSettl(String tenantCode, String contractBillcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        this.updateCashSettlModel(map);
    }

    private void updateCashSettlModel(Map<String, Object> map) {
        try {
            int i = this.ocContractMapper.updateCashSettl(map);
            if (i <= 0) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateCashSettlModel", "\u66f4\u65b0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateCashSettlModel", (Throwable)e);
        }
    }

    @Override
    public void updateContractSubMoney(Integer contractId, String modifyMoney, String remark) {
        if (StringUtils.isEmpty((String)modifyMoney)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractMoneyApply", "\u4ef7\u683c\u4e3a\u7a7a\uff01");
        }
        OcContract contract = this.getContractModelById(contractId);
        if (contract == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractMoneyApply", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        BigDecimal updateMoney = new BigDecimal(modifyMoney);
        contract.setContractMoney(contract.getContractMoney().add(updateMoney));
        contract.setDataBmoney(contract.getDataBmoney().add(updateMoney));
        contract.setGmtModified(this.getSysDate());
        BigDecimal goodsPmoney = contract.getGoodsPmoney();
        if (null == goodsPmoney) {
            goodsPmoney = BigDecimal.ZERO;
        }
        goodsPmoney = goodsPmoney.subtract(updateMoney);
        contract.setGoodsPmoney(goodsPmoney);
        contract.setMemo(remark);
        this.updateContractMoneyPass(contract, updateMoney);
    }

    @Override
    public String updateContractSubMoneyByContractBillcode(String contractBillcode, String modifyMoney, String remark, String tenantCode) {
        if (StringUtils.isEmpty((String)modifyMoney)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSubMoneyByContractBillcode", "\u4ef7\u683c\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContract contract = this.getContractModelByCode(map);
        if (contract == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSubMoneyByContractBillcode", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01" + map);
        }
        BigDecimal updateMoney = new BigDecimal(modifyMoney);
        contract.setContractMoney(contract.getContractMoney().add(updateMoney));
        contract.setDataBmoney(contract.getDataBmoney().add(updateMoney));
        contract.setGmtModified(this.getSysDate());
        BigDecimal goodsPmoney = contract.getGoodsPmoney();
        if (null == goodsPmoney) {
            goodsPmoney = BigDecimal.ZERO;
        }
        goodsPmoney = goodsPmoney.subtract(updateMoney);
        contract.setGoodsPmoney(goodsPmoney);
        contract.setMemo(remark);
        this.updateContractMoneyPass(contract, updateMoney);
        return "success";
    }

    private void updateContractMoneyPass(OcContract contract, BigDecimal updateMoney) {
        if (contract == null) {
            return;
        }
        BigDecimal basePrice = BigDecimal.ZERO;
        BigDecimal amount = null;
        List<OcContractGoods> contractGoodsList = this.queryContractGoodsModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contract.getContractBillcode(), contract.getTenantCode()}));
        BigDecimal smoney = updateMoney;
        BigDecimal money = contract.getContractInmoney();
        BigDecimal nmoney = BigDecimal.ZERO;
        BigDecimal nsmoney = null;
        if (ListUtil.isNotEmpty(contractGoodsList)) {
            for (int i = 0; i < contractGoodsList.size(); ++i) {
                OcContractGoods ocContractGoods = contractGoodsList.get(i);
                nmoney = ocContractGoods.getContractGoodsInmoney();
                if (i == contractGoodsList.size() - 1) {
                    nsmoney = smoney;
                    smoney = BigDecimal.ZERO;
                } else {
                    nsmoney = nmoney.divide(money, 2, 5).multiply(updateMoney);
                    smoney = smoney.subtract(nsmoney);
                }
                ocContractGoods.setContractGoodsMoney(ocContractGoods.getContractGoodsMoney().add(nsmoney));
                ocContractGoods.setContractGoodsPrice(ocContractGoods.getContractGoodsMoney().divide(ocContractGoods.getGoodsNum(), 2, 5));
                this.updateContractGoodsModel(ocContractGoods);
                if (ocContractGoods.getPricesetBaseprice() == null) continue;
                basePrice = basePrice.add(ocContractGoods.getPricesetBaseprice());
            }
        }
        if (contract.getCashback() != null) {
            if (basePrice != BigDecimal.ZERO && basePrice.compareTo(contract.getContractMoney()) < 0) {
                amount = this.calBackAmount(this.getQueryMapParam("orderAmount,pricesetBaseprice", new Object[]{contract.getContractMoney(), basePrice}), contract.getTenantCode());
            }
            if (amount != null) {
                contract.setCashback(amount);
            }
        }
        this.updateContractModel(contract);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("businessOrderno", contract.getContractBillcode());
        paramMap.put("ptradeSeqno", contract.getPtradeSeqno());
        paramMap.put("tenantCode", contract.getTenantCode());
        paramMap.put("money", contract.getContractMoney());
        paramMap.put("transferAmount", amount);
    }

    @Override
    public void loadContractMsg() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractTypepro", "0");
        map.put("dataState", "0");
        map.put("endPayDate", DateUtil.addMinutes((Date)this.getSysDate(), (int)-1));
        List<OcContract> list = this.queryContractModelPage(map);
        for (OcContract oc : list) {
            map.clear();
            map.put("contractBillcode", oc.getContractBillcode());
            map.put("tenantCode", oc.getTenantCode());
            List<OcContractGoods> goodslist = this.queryContractGoodsModelPage(map);
            if (goodslist == null || goodslist.size() == 0) continue;
            ArrayList<OcContractGoodsDomain> goodsdomainlist = new ArrayList<OcContractGoodsDomain>();
            for (OcContractGoods goods : goodslist) {
                OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)goods);
                }
                catch (Exception e) {
                    this.logger.error("cancle", (Object)e.getMessage());
                }
                goodsdomainlist.add(goodsDomain);
            }
            HashMap<String, Integer> pmap = new HashMap<String, Integer>();
            pmap.put("contractId", oc.getContractId());
            pmap.put("dataState", -1);
            pmap.put("oldDataState", 0);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(pmap));
            paramMap.put("goodsList", JsonUtil.buildNormalBinder().toJson(goodsdomainlist));
            paramMap.put("ctype", 3);
            paramMap.put("tenantCode", oc.getTenantCode());
            paramMap.put("contractBillcode", oc.getContractBillcode());
            this.inAsyncInvoke("oc.contract.updateContractStateByCode", paramMap);
        }
    }

    private void processExtContractPackage(OcContract ocContract) {
        if (ContractPropertyEnum.VIRTUAL.getCode().equals(ocContract.getContractProperty())) {
            this.virtualContractPackage(ocContract);
        }
    }

    private void virtualContractPackage(OcContract ocContract) {
        if (ocContract == null) {
            return;
        }
        Integer num = ocContract.getGoodsNum().intValue();
        if (num <= 0) {
            return;
        }
        ConcurrentHashMap<String, String> vmap = new ConcurrentHashMap<String, String>();
        String prefix = DateUtil.getDateStr((String)"yyyyMMdd");
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        for (int i = 0; i < num; ++i) {
            OcPackageDomain packageDomain = new OcPackageDomain();
            try {
                BeanUtils.copyAllPropertys((Object)packageDomain, (Object)ocContract);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.virtualContractPakege", (Object)"\u5c5e\u6027\u590d\u5236\u5931\u8d25");
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.virtualContractPackage", "\u5c5e\u6027\u590d\u5236\u5931\u8d25");
            }
            packageDomain.setPackageMode(PackageModeEnum.AUTO.getCode());
            String code = this.generateRandom(vmap, ocContract.getContractBillcode());
            String packageBillno = prefix + code;
            packageDomain.setPackageBillno(packageBillno);
            Date vaildDate = DateUtil.getDateToString((String)DateUtil.getAfterDate((Date)this.getSysDate(), (int)7, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
            packageDomain.setGmtVaild(vaildDate);
            packageDomainList.add(packageDomain);
        }
        this.savePackageList(packageDomainList, ocContract);
    }

    private String generateRandom(Map<String, String> vmap, String tenantCode) {
        int rand;
        String code = "";
        do {
            Random r = new Random();
            rand = r.nextInt(99999999);
        } while (vmap.containsKey(code = String.format("%08d", rand)));
        List<OcPackage> list = this.queryPackageModelPage(this.getQueryParamMap("tenantCode,packageBillno", new Object[]{tenantCode, code}));
        if (!ListUtil.isEmpty(list)) {
            return this.generateRandom(vmap, tenantCode);
        }
        vmap.put(code, code);
        return code;
    }

    @Override
    public void updateExtContractPackage(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        OcContract ocContract = this.getContractModelByCode(this.getQueryParamMap("tenantCode,contractBillcode", new Object[]{tenantCode, contractBillcode}));
        if (ocContract == null) {
            return;
        }
        this.processExtContractPackage(ocContract);
        if (dataState == null || oldDataState == null) {
            return;
        }
        this.updateContractState(ocContract.getContractId(), dataState, oldDataState);
    }

    @Override
    public void saveContractSendGoods(Map<String, Object> map) {
        if (map == null || StringUtils.isBlank((String)((String)map.get("contractBillcode")))) {
            return;
        }
        int dataState = 8;
        ArrayList<String> skuCodes = new ArrayList<String>();
        ArrayList<BigDecimal> goodsNums = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> pricesetMakeprice = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> pricesetBaseprice = new ArrayList<BigDecimal>();
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("contractBillcode", map.get("contractBillcode"));
        pmap.put("tenantCode", map.get("tenantCode"));
        OcContract oc = this.getContractModelByCode(pmap);
        QueryResult<OcPackage> rs = this.queryPackagePage(pmap);
        if (rs != null && rs.getList() != null) {
            for (OcPackage pack : rs.getList()) {
                for (OcContractGoods goods : pack.getContractGoodsList()) {
                    goodsNums.add(goods.getGoodsCamount());
                    skuCodes.add(goods.getGoodsCode());
                    pricesetMakeprice.add(goods.getPricesetMakeprice());
                    pricesetBaseprice.add(goods.getPricesetBaseprice());
                }
                pack.setPackageMode((String)map.get("packageMode"));
                pack.setPackageBillno((String)map.get("packageBillno"));
                pack.setPackageName((String)map.get("packageName"));
                this.updatePackageModel(pack);
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("skuCodes", skuCodes);
        paramMap.put("goodsNums", goodsNums);
        paramMap.put("storeGoodsBtype", "102");
        paramMap.put("merberCode", oc.getMemberBcode());
        paramMap.put("merberName", oc.getMemberBname());
        paramMap.put("channelCodeOUT", "TS");
        paramMap.put("channelNameOUT", "\u603b\u4ed3");
        paramMap.put("channelCodeIN", oc.getChannelCode());
        paramMap.put("channelNameIN", oc.getChannelName());
        paramMap.put("merberBcode", oc.getMemberCode());
        paramMap.put("merberBname", oc.getMemberName());
        paramMap.put("pricesetMakeprice", pricesetMakeprice);
        paramMap.put("pricesetBaseprice", pricesetBaseprice);
        paramMap.put("tenantCode", oc.getTenantCode());
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        this.internalInvoke("rs.resourceGoods.updateSkuStockRecord", pmap);
        this.updateContractState(oc.getContractId(), dataState, oc.getDataState());
    }

    @Override
    public void updateContractStateToSuccess(String contractBillcode, String tenantCode) {
        if (StringUtils.isEmpty((String)contractBillcode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractStateToSuccess", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContract contract = this.getContractModelByCode(map);
        if (contract == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractStateToSuccess", (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            return;
        }
        this.updateStateContractModel(contract.getContractId(), 3, contract.getDataState());
    }

    @Override
    public void updateContractStateForGroupbuy(String contractNbillcode, String tenantCode, String type) {
        if (StringUtils.isEmpty((String)contractNbillcode) || StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)type)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateForGroupbuy.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<OcContract> contractList = this.queryContractModelPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{contractNbillcode, tenantCode}));
        if (ListUtil.isEmpty(contractList)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateForGroupbuy.ex", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        List<OcContractGoods> contractGoodsList = this.queryContractGoodsModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractList.get(0).getContractBillcode(), tenantCode}));
        if (ListUtil.isEmpty(contractGoodsList)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateForGroupbuy.ex", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if ("success".equals(type)) {
            SkuStockDomain skuStockDomain = new SkuStockDomain();
            skuStockDomain.setTenantCode(tenantCode);
            skuStockDomain.setSkuCode(contractGoodsList.get(0).getGoodsCode());
            skuStockDomain.setGoodsNum(new BigDecimal(contractList.size()));
            skuStockDomain.setDataOpbillstate(contractGoodsList.get(0).getDataOpbillstate());
            skuStockDomain.setType("4");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("skuList", JsonUtil.buildNormalBinder().toJson(Arrays.asList(skuStockDomain)));
            this.internalInvoke("rs.sku.updateSkuStock", param);
        }
        if ("fail".equals(type)) {
            for (OcContract ocContract : contractList) {
                this.updateStateContractModel(ocContract.getContractId(), 9, ocContract.getDataState());
            }
        }
    }

    private BigDecimal calBackAmount(Map<String, Object> paramMap, String tenantCode) {
        String script = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + "exchange-backAmountScript"));
        if (StringUtils.isBlank((String)script)) {
            return null;
        }
        Object amount = ScriptUtil.evel((String)script, paramMap);
        if (amount == null) {
            this.logger.error("OrderMngCon.calBackAmount.error", (Object)script);
            return null;
        }
        BigDecimal backAmount = null;
        try {
            backAmount = new BigDecimal(amount.toString());
        }
        catch (Exception e) {
            this.logger.error("OrderMngCon.calBackAmount.error", (Throwable)e);
        }
        return backAmount;
    }

    @Override
    public void updatePackageUse(OcPackageDomain ocPackageDomain) {
        if (ocPackageDomain == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageUse.ex", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        this.updatePackage(ocPackageDomain);
        this.updatePackageState(ocPackageDomain.getPackageId(), 1, 0);
        this.updateVcontractStateByPackage(ocPackageDomain.getContractBillcode(), ocPackageDomain.getTenantCode());
    }

    @Override
    public QueryResult<String> getBuyerMemberCodes(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.getBuyerMemberCodes", "args is null");
        }
        List<String> memberCodes = this.queryBuyerMemberCodesPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBuyerMerber(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(memberCodes);
        return queryResult;
    }

    private void updateVcontractStateByPackage(String contractBillcode, String tenantCode) {
        List<OcPackage> packageList = this.queryPackageModelPage(this.getQueryMapParam("contractBillcode,packageMode,tenantCode,dataState", new Object[]{contractBillcode, "AUTO", tenantCode, 0}));
        if (ListUtil.isEmpty(packageList)) {
            OcContract contract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
            this.updateContractState(contract.getContractId(), 7, contract.getDataState());
        }
    }

    @Override
    public String saveContractSettl(OcContractSettlDomain ocContractSettlDomain) throws ApiException {
        OcContractSettl ocContractSettl = this.createContractsettl(ocContractSettlDomain);
        this.saveContractSettlModel(ocContractSettl);
        return ocContractSettl.getContractSettlBillcode();
    }

    private OcContractSettl createContractsettl(OcContractSettlDomain ocContractSettlDomain) {
        String msg = this.checkContractSettl(ocContractSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettl.checkContractSettl", msg);
        }
        OcContractSettl ocContractSettl = this.makeContractSettl(ocContractSettlDomain, null);
        this.setContractSettlDefault(ocContractSettl);
        return ocContractSettl;
    }

    @Override
    public void updateContractSettlState(Integer contractSettlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractSettlModel(contractSettlId, dataState, oldDataState);
    }

    @Override
    public void updateContractSettl(OcContractSettlDomain ocContractSettlDomain) throws ApiException {
        String msg = this.checkContractSettl(ocContractSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSettl.checkContractSettl", msg);
        }
        OcContractSettl oldOcContractSettl = this.getContractSettlModelById(ocContractSettlDomain.getContractSettlId());
        if (null == oldOcContractSettl) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSettl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractSettl ocContractSettl = this.makeContractSettl(ocContractSettlDomain, oldOcContractSettl);
        this.setContractSettlUpdataDefault(ocContractSettl);
        this.updateContractSettlModel(ocContractSettl);
    }

    @Override
    public OcContractSettl getContractSettl(Integer contractSettlId) {
        return this.getContractSettlModelById(contractSettlId);
    }

    @Override
    public void deleteContractSettl(Integer contractSettlId) throws ApiException {
        this.deleteContractSettlModel(contractSettlId);
    }

    @Override
    public QueryResult<OcContractSettl> queryContractSettlPage(Map<String, Object> map) {
        List<OcContractSettl> ocContractSettlList = this.queryContractSettlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractSettl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractSettlList);
        return queryResult;
    }

    @Override
    public OcContractSettl getContractSettlByCode(Map<String, Object> map) {
        return this.getContractSettlModelByCode(map);
    }

    @Override
    public void delContractSettlByCode(Map<String, Object> map) throws ApiException {
        this.delContractSettlModelByCode(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContractService getContractService() {
        Object object = lock;
        synchronized (object) {
            if (null == contractService) {
                contractService = new ContractService((OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService"));
                for (int i = 0; i < 100; ++i) {
                    contractService.addPollPool(new ContractPollThread(contractService));
                }
            }
            return contractService;
        }
    }

    @Override
    public void updateContractFlowState(OcContractCtrlCflowDomain ocContractCtrlCflowDomain) throws ApiException {
        if (null == ocContractCtrlCflowDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractCtrlCflowDomain.getTenantCode());
        map.put("contractCtrlSeqno", ocContractCtrlCflowDomain.getContractCtrlSeqno());
        OcContractCtrl ocContractCtrl = this.ocContractCtrlService.getContractCtrlByCode(map);
        if (null == ocContractCtrl) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractFlowState.null", "\u6570\u636e\u4e3a\u7a7a" + ocContractCtrlCflowDomain.getTenantCode() + " " + ocContractCtrlCflowDomain.getContractCtrlSeqno());
        }
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        if (null != ocContractCtrlCflowDomain.getContractPaygmoney()) {
            rmap.put("contractPaygmoney", ocContractCtrlCflowDomain.getContractPaygmoney());
        }
        if (null != ocContractCtrlCflowDomain.getContractDepositdate()) {
            rmap.put("contractDepositdate", ocContractCtrlCflowDomain.getContractDepositdate());
        }
        if (null != ocContractCtrlCflowDomain.getContractValidate()) {
            rmap.put("contractValidate", ocContractCtrlCflowDomain.getContractValidate());
        }
        if (null != ocContractCtrlCflowDomain.getContractInvoicedate()) {
            rmap.put("contractInvoicedate", ocContractCtrlCflowDomain.getContractInvoicedate());
        }
        if (null != ocContractCtrlCflowDomain.getPtradeSeqno()) {
            rmap.put("ptradeSeqno", ocContractCtrlCflowDomain.getPtradeSeqno());
        }
        if (null != ocContractCtrlCflowDomain.getContractPaydate()) {
            rmap.put("contractPaydate", ocContractCtrlCflowDomain.getContractPaydate());
        }
        this.updateStateContractModelByCode(ocContractCtrl.getTenantCode(), ocContractCtrl.getContractBillcode(), ocContractCtrlCflowDomain.getDataState(), ocContractCtrlCflowDomain.getOldDataState(), rmap);
        this.ocContractCtrlService.updateContractCtrlCflow(ocContractCtrlCflowDomain);
        DisUtil.set((String)("ocContract-state-" + ocContractCtrl.getContractBillcode() + ocContractCtrl.getTenantCode()), (String)String.valueOf(ocContractCtrlCflowDomain.getDataState()), (int)10);
    }

    @Override
    public void updateContractPay(String contractBillcode, String tenantCode, BigDecimal contractPaygmoney) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractPaygmoney", contractPaygmoney);
        this.updateContractModelPayByCode(map);
    }

    @Override
    public OcReorderDomain updatePackageExpress(PackageExpressDomain packageExpressDomain) {
        if (null == packageExpressDomain) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageExpress.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)packageExpressDomain.getPackageCode())) {
            packageExpressDomain.setOldDataState(0);
        }
        this.updateExpressStateByCodeModel(packageExpressDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageCode", packageExpressDomain.getPackageCode());
        map.put("tenantCode", packageExpressDomain.getTenantCode());
        OcPackage ocPackage = this.getPackageModelByCode(map);
        if (null != ocPackage) {
            // empty if block
        }
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        ocReorderDomain.setOrderState("2");
        return ocReorderDomain;
    }

    @Override
    public void updateContractPtradeSeqno(Map<String, String> map) {
        if (MapUtil.isEmpty(map) || map.get("contractBillcode") == null || map.get("ptradeSeqno") == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractPtradeSeqno.params", "\u53c2\u6570\u6709\u8bef");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.putAll(map);
        this.updatePteContractModelByCode(parammap);
    }

    @Override
    public void updateContractAppraise(String contractBillcode, String tenantCode, Integer appraise) {
        if (StringUtils.hasBlank((String[])new String[]{contractBillcode, tenantCode}) || appraise == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractAppraise.map.null", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        OcContract ocContract = this.getContractModelByCode(parammap);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractAppraise.null", ((Object)parammap).toString());
        }
        OcContract newOcContract = new OcContract();
        newOcContract.setContractId(ocContract.getContractId());
        newOcContract.setContractAppraise(appraise);
        this.updateContractModel(newOcContract);
    }

    @Override
    public void updateContractRefund(String tenantCode, String contractBillcode, Integer contractState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.params", "\u53c2\u6570\u6709\u8bef");
        }
        if (null == contractState) {
            contractState = 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContract ocContract = this.getContractModelByCode(map);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.null", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefund paran", (Object)(ocContract.getDataState() + " == " + contractState + " == " + contractBillcode));
        if (ocContract.getDataState() - contractState != 0) {
            return;
        }
        List<OcContractGoods> list = this.queryContractGoodsModelPage(map);
        if (null == list || list.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.goodsnull", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        boolean flag = true;
        for (OcContractGoods ocContractGoods : list) {
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if ("1".equals(ocContractGoods.getContractGoodsGtype()) || ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum()).intValue() <= 0) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefund \u8fdb\u5165\u8282\u70b9");
            this.getOcContractEngineService().sendContractBack(contractBillcode, tenantCode, null);
        }
    }

    public String sendSgSendgoodsCheckGoods(OcContract ocContract, List<OcContractGoods> list) {
        this.logger.error("oc.CONTRACT.OcContractServiceImplsendSgSendgoodsCheckGoods \u8fdb\u5165");
        HashMap<String, Object> ocRMap = new HashMap<String, Object>();
        ocRMap.put("tenantCode", ocContract.getTenantCode());
        ocRMap.put("contractBillcode", ocContract.getContractBillcode());
        ocRMap.put("dataState", 0);
        int num = this.ocRefundMapper.count(ocRMap);
        if (num > 0) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendSgSendgoodsCheckGoods.pmap", ocRMap);
            return "error";
        }
        HashMap<String, String> sgMap = new HashMap<String, String>();
        sgMap.put("tenantCode", ocContract.getTenantCode());
        sgMap.put("contractBillcode", ocContract.getContractBillcode());
        HashMap<String, String> sgparam = new HashMap<String, String>();
        sgparam.put("map", JsonUtil.buildNormalBinder().toJson(sgMap));
        String json = (String)this.getInternalRouter().inInvoke("sg.sendgoods.querySendgoodsGoodsPage", sgparam);
        SupQueryResult jsonResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List sgSendgoodsGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonResult.getList()), SgSendgoodsGoods.class);
        if (ListUtil.isEmpty((Collection)sgSendgoodsGoodsList)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendSgSendgoodsCheckGoods:queryParamMap", sgparam);
            return "error";
        }
        HashMap<String, BigDecimal> goodsMap = new HashMap<String, BigDecimal>();
        for (SgSendgoodsGoods sgSendgoodsGoodsDomain : sgSendgoodsGoodsList) {
            if (goodsMap.containsKey(sgSendgoodsGoodsDomain.getContractGoodsCode())) {
                BigDecimal goodsNum = ((BigDecimal)goodsMap.get(sgSendgoodsGoodsDomain.getContractGoodsCode())).add(sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount());
                goodsMap.put(sgSendgoodsGoodsDomain.getContractGoodsCode(), goodsNum);
                continue;
            }
            goodsMap.put(sgSendgoodsGoodsDomain.getContractGoodsCode(), sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount());
        }
        Boolean flag = true;
        for (OcContractGoods ocContractGoodsDomain : list) {
            if (goodsMap.get(ocContractGoodsDomain.getContractGoodsCode()) == null) {
                goodsMap.put(ocContractGoodsDomain.getContractGoodsCode(), BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getContractGoodsRefnum() == null) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getGoodsCamount().subtract(ocContractGoodsDomain.getContractGoodsRefnum()).compareTo((BigDecimal)goodsMap.get(ocContractGoodsDomain.getContractGoodsCode())) == 0) continue;
            flag = false;
        }
        if (flag.booleanValue()) {
            HashMap<String, Object> mapStr = new HashMap<String, Object>();
            mapStr.put("dataStateStr1", "sendgoods");
            this.getOcContractEngineService().sendContractNext(ocContract.getContractBillcode(), ocContract.getTenantCode(), mapStr);
        }
        return "success";
    }

    @Override
    public void updateContractRefundNw(String tenantCode, String contractBillcode, Integer contractState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefundNw.params", "\u53c2\u6570\u6709\u8bef");
        }
        if (null == contractState) {
            contractState = 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContract ocContract = this.getContractModelByCode(map);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefundNw.null", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefundNw paran", (Object)(ocContract.getDataState() + " == " + contractState + " == " + contractBillcode));
        List<OcContractGoods> list = this.queryContractGoodsModelPage(map);
        if (null == list || list.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefundNw.goodsnull", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        boolean flag = true;
        for (OcContractGoods ocContractGoods : list) {
            BigDecimal refundNum = BigDecimal.ZERO;
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoods.getContractGoodsRefweight()) {
                ocContractGoods.setContractGoodsRefweight(BigDecimal.ZERO);
            }
            if ("1".equals(ocContractGoods.getContractGoodsGtype())) continue;
            List<OcRefundGoods> ocRefundGoodsList = this.ocRefundGoodsMapper.query(this.getQueryMapParam("contractGoodsCode,tenantCode", new Object[]{ocContractGoods.getContractGoodsCode(), tenantCode}));
            if (ListUtil.isNotEmpty(ocRefundGoodsList)) {
                for (OcRefundGoods ocRefundGoods : ocRefundGoodsList) {
                    OcRefund byCode = this.ocRefundMapper.getByCode(this.getQueryMapParam("refundCode,tenantCode", new Object[]{ocRefundGoods.getRefundCode(), tenantCode}));
                    if (byCode.getDataState() != 8) continue;
                    refundNum = refundNum.add(ocRefundGoods.getRefundGoodsNum());
                }
            }
            this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefundNw ocContractGoods", (Object)(ocContractGoods.getContractGoodsRefnum() + "," + ocContractGoods.getContractGoodsRefweight()));
            this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefundNw refundNum", (Object)(ocContractGoods.getGoodsCamount() + "," + refundNum));
            if (ocContractGoods.getGoodsCamount().subtract(refundNum).intValue() <= 0) continue;
            flag = false;
            break;
        }
        if ("45".equals(ocContract.getContractType())) {
            flag = true;
        }
        if (flag) {
            this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefundNw \u8fdb\u5165\u8282\u70b9");
            this.getOcContractEngineService().sendContractBack(contractBillcode, tenantCode, null);
        }
        if (8 == ocContract.getDataState()) {
            this.sendSgSendgoodsCheckGoods(ocContract, list);
        }
    }

    @Override
    public void updateContractRefundCyy(String tenantCode, String contractBillcode, Integer contractState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.params", "\u53c2\u6570\u6709\u8bef");
        }
        if (null == contractState) {
            contractState = 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContract ocContract = this.getContractModelByCode(map);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.null", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefund paran", (Object)(ocContract.getDataState() + " == " + contractState + " == " + contractBillcode));
        List<OcContractGoods> list = this.queryContractGoodsModelPage(map);
        if (null == list || list.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.goodsnull", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        boolean flag = true;
        for (OcContractGoods ocContractGoods : list) {
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if ("1".equals(ocContractGoods.getContractGoodsGtype()) || ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum()).intValue() <= 0) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.logger.error("oc.CONTRACT.OcContractServiceImplupdateContractRefund \u8fdb\u5165\u8282\u70b9");
            this.getOcContractEngineService().sendContractBack(contractBillcode, tenantCode, null);
        }
    }

    @Override
    public String saveContractSettlBatch(List<OcContractSettlDomain> ocContractSettlDomainList) throws ApiException {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettlBatch.null", "");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String str = "";
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            if ("CAS".equals(ocContractSettlDomain.getContractSettlBlance())) {
                map.put("contractBillcode", ocContractSettlDomain.getContractBillcode());
                map.put("tenantCode", ocContractSettlDomain.getTenantCode());
                str = ocContractSettlDomain.getContractSettlOpemo();
                if (StringUtils.isNotBlank((String)str)) {
                    if (str.indexOf("(") > 0) {
                        map.put("fchannelCode", str.substring(0, str.indexOf("(")));
                        map.put("faccountName", str.substring(str.indexOf("(") + 1, str.length() - 1));
                    } else {
                        map.put("fchannelCode", ocContractSettlDomain.getContractSettlOpemo());
                        map.put("faccountName", ocContractSettlDomain.getContractSettlOpemo());
                    }
                }
            }
            if (null != ocContractSettlDomain.getContractSettlId()) {
                this.updateContractSettl(ocContractSettlDomain);
                continue;
            }
            this.saveContractSettl(ocContractSettlDomain);
        }
        if (MapUtil.isNotEmpty(map)) {
            this.updateContractModelFchannel(map);
        }
        return "";
    }

    @Override
    public List<OcContractSettl> queryContractSettlByContractCode(String tenantCode, String contractBillcode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        return this.queryContractSettlModelPage(parammap);
    }

    @Override
    public void updateContractBlance(String contractBillcode, String tenantCode, String contractBlance) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        map.put("contractBlance", contractBlance);
        this.updateContractModelBlanceByCode(map);
    }

    @Override
    public void updateContractInvstate(String contractBillcode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateInvstateContractModel(tenantCode, contractBillcode, dataState, oldDataState);
    }

    @Override
    public void updateContractShowstate(String contractBillcode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateShowstateContractModel(tenantCode, contractBillcode, dataState, oldDataState);
    }

    @Override
    public void updateContractEcflagstate(String contractBillcode, String tenantCode, String contractEcurl, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateEcflagstateContractModel(tenantCode, contractBillcode, contractEcurl, dataState, oldDataState);
    }

    private Integer getEcflagStateByCode(String contractBillcode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        int res = 0;
        try {
            res = this.ocContractMapper.getEcflagStateByCode(map);
        }
        catch (Exception ex) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getEcflagStateByCode" + map);
            return -1;
        }
        return res;
    }

    @Override
    public Integer getStateByContractBillcode(String contractBillcode, String tenantCode) throws ApiException {
        return this.getEcflagStateByCode(contractBillcode, tenantCode);
    }

    @Override
    public Map<String, Object> syncOrderService(String orderStr) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.logger.error("syncOrderService ==== ", (Object)orderStr);
        return resultMap;
    }

    @Override
    public String updateSendNum(List<GoodsSendNumBean> goodsSendNumBeanList) {
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return "error";
        }
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeanList) {
            this.updateSendContractModel(goodsSendNumBean.getTenantCode(), goodsSendNumBean.getContractBillcode(), goodsSendNumBean.getContractGoodsSendnum(), goodsSendNumBean.getContractGoodsSendweight());
            this.updateSendContractGoodsModel(goodsSendNumBean.getTenantCode(), goodsSendNumBean.getContractGoodsCode(), 1, null, goodsSendNumBean.getContractGoodsSendnum(), goodsSendNumBean.getContractGoodsSendweight());
        }
        return "success";
    }

    @Override
    public List<OcContractGoods> queryCorderGoodsByBillcode(Map<String, Object> map) throws ApiException {
        List<OcContractGoods> ocContractGoods = this.ocContractGoodsMapper.queryCorderGoodsByBillcode(map);
        if (ocContractGoods.size() == 0) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryCorderGoodsByBillcode===" + map);
            return null;
        }
        return ocContractGoods;
    }

    @Override
    public String getOrderFreight(String tenantCode, String sku, String area) throws ApiException {
        String str = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sku", sku);
        map.put("area", area);
        map.put("tenantCode", tenantCode);
        try {
            str = (String)this.getInternalRouter().inInvoke(" omns.jd.getFreight", map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getOrderFreight", (Object)((Object)map).toString());
        }
        return str;
    }

    @Override
    public String getBalance(String payType) throws ApiException {
        String str = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("payType", payType);
        try {
            str = (String)this.getInternalRouter().inInvoke("omns.jd.getBalance", map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getBalance", (Object)((Object)map).toString());
        }
        return str;
    }

    @Override
    public QueryResult<Map<String, Object>> getBalanceDetail(Map<String, Object> map) throws ApiException {
        QueryResult retList = null;
        if (null == map) {
            return null;
        }
        String str = "";
        try {
            str = (String)this.getInternalRouter().inInvoke("omns.jd.getBalanceDetail", map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getBalanceDetail", (Object)map.toString());
        }
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        Map dataStateMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(str, String.class, Object.class);
        if (null == dataStateMap) {
            return null;
        }
        String successs = (String)dataStateMap.get("success");
        if (StringUtils.isNotBlank((String)successs) && successs.equals("true")) {
            String reJson = (String)dataStateMap.get("ReJson");
            if (null == reJson) {
                return null;
            }
            Map map1 = (Map)JsonUtil.buildNormalBinder().getJsonToMap(reJson, String.class, Object.class);
            if (null == map1) {
                return null;
            }
            int total = (Integer)map1.get("total");
            String data = (String)map1.get("data");
            if (StringUtils.isBlank((String)data)) {
                return null;
            }
            List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(data, Map.class);
            if (null == mapList) {
                return null;
            }
            retList = new QueryResult();
            retList.setTotal((long)total);
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(total);
            retList.setPageTools((SupPageTools)pageTools);
            retList.setList(mapList);
            retList.setRows(mapList);
        }
        return retList;
    }

    @Override
    public void updateContracStateByNb(String contractNbillcode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        this.updateStateContractModelByNb(tenantCode, contractNbillcode, dataState, oldDataState, map);
    }

    @Override
    public OcContract getByNbCode(String contractNbillcode, String channelCode, String tenantCode) {
        return this.getModelByNbCode(this.getQueryMapParam("contractNbillcode,channelCode,tenantCode", new Object[]{contractNbillcode, channelCode, tenantCode}));
    }

    @Override
    public OcContractReDomain getDomainByNbCode(String contractNbillcode, String channelCode, String tenantCode) {
        OcContract ocContract = this.getModelByNbCode(this.getQueryMapParam("contractNbillcode,channelCode,tenantCode", new Object[]{contractNbillcode, channelCode, tenantCode}));
        if (null == ocContract) {
            return null;
        }
        OcContractReDomain contractReDomain = this.makeOcContractDomain(ocContract);
        contractReDomain.setGoodsList(this.queryContractGoodsDomainList(ocContract.getContractBillcode(), ocContract.getTenantCode()));
        return contractReDomain;
    }

    private List<OcConsumeBigData> queryAllUserOcConsumeBigDataModel(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.queryAllUserOcConsumeBigData(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryAllUserOcConsumeBigDataModel", (Throwable)e);
            return null;
        }
    }

    private List<OcConsumeBigData> queryAllOcConsumeBigDataByDayModel(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.queryAllOcConsumeBigDataByDay(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryAllOcConsumeBigDataByDayModel", (Throwable)e);
            return null;
        }
    }

    private List<OcConsumeBigData> queryAllOcConsumeBigDataForSellerModel(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.queryAllOcConsumeBigDataForSeller(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryAllOcConsumeBigDataForSellerModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<OcConsumeBigData> queryAllUserOcConsumeBigDataPage(Map<String, Object> map) throws ApiException {
        int count = null == this.queryAllUserOcConsumeBigDataModel(map) ? 0 : this.queryAllUserOcConsumeBigDataModel(map).size();
        PageTools pageTools = new PageTools();
        this.changePageTools(pageTools, map);
        List<OcConsumeBigData> ocConsumeBigDataList = this.queryAllUserOcConsumeBigDataModel(map);
        QueryResult queryResult = new QueryResult();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocConsumeBigDataList);
        return queryResult;
    }

    @Override
    public List<OcConsumeBigData> queryAllOcConsumeBigDataByDay(Map<String, Object> map) throws ApiException {
        return this.queryAllOcConsumeBigDataByDayModel(map);
    }

    @Override
    public QueryResult<OcConsumeBigData> queryAllOcConsumeBigDataForSellerPage(Map<String, Object> map) throws ApiException {
        int count = null == this.queryAllOcConsumeBigDataForSellerModel(map) ? 0 : this.queryAllOcConsumeBigDataForSellerModel(map).size();
        PageTools pageTools = new PageTools();
        this.changePageTools(pageTools, map);
        List<OcConsumeBigData> ocConsumeBigDataList = this.queryAllOcConsumeBigDataForSellerModel(map);
        this.countAllUserOcConsumeBigData(map);
        QueryResult queryResult = new QueryResult();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocConsumeBigDataList);
        return queryResult;
    }

    private void changePageTools(PageTools pageTools, Map<String, Object> map) {
        if (null != map.get("rows") && null != map.get("page")) {
            int startNum = Integer.valueOf(map.get("page").toString());
            int endNum = Integer.valueOf(map.get("rows").toString());
            map.put("startNum", (startNum - 1) * endNum);
            map.put("endNum", endNum);
            pageTools.setPageNo(startNum);
            pageTools.setPageSize(endNum);
        }
    }

    @Override
    public void saveExContractGoods(List<OcContractGoodsDomain> ocContractGoodsDomainList) throws ApiException {
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            return;
        }
        Integer contractState = ocContractGoodsDomainList.get(0).getContractState();
        if (null != contractState) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractBillcode", ocContractGoodsDomainList.get(0).getContractBillcode());
            map.put("tenantCode", ocContractGoodsDomainList.get(0).getTenantCode());
            OcContract contract = this.getContractModelByCode(map);
            if (null == contract) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveExContractGoods.null");
            }
            this.updateStateContractModel(contract.getContractId(), contractState, contractState);
            this.updateContractStateByCode(map);
        }
        HashMap<String, String> contractGoodsMap = new HashMap<String, String>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getContractGoodsOldcode())) {
                contractGoodsMap.put(ocContractGoodsDomain.getContractGoodsOldcode(), ocContractGoodsDomain.getTenantCode());
            }
            if ("-1".equals(ocContractGoodsDomain.getContractGoodsGtype())) continue;
            this.saveContractGoods(ocContractGoodsDomain);
        }
        if (MapUtil.isNotEmpty(contractGoodsMap)) {
            for (String key : contractGoodsMap.keySet()) {
                this.updateContractGoodsTypeModel(this.getQueryMapParam("contractGoodsType,contractGoodsCode,tenantCode,oldContractGoodsType", new Object[]{1, key, contractGoodsMap.get(key), 0}));
            }
        }
    }

    public String foreignQueryContractPageReDomain(Map<String, Object> vop_mapTobean) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        Object pageNo = vop_mapTobean.get("pageNo");
        Object pageSize = vop_mapTobean.get("pageSize");
        Object startDate = vop_mapTobean.get("startDate");
        Object endDate = vop_mapTobean.get("endDate");
        if (startDate != null) {
            parameter.put("startDate", startDate);
        }
        if (endDate != null) {
            parameter.put("endDate", endDate);
        }
        if (pageNo == null || pageSize == null) {
            vop_mapTobean.put("msg", "\u5206\u9875\u53c2\u6570\u672a\u586b\u5199");
            return JsonUtil.buildNormalBinder().toJson(vop_mapTobean);
        }
        parameter.put("childFlag", true);
        parameter.put("startRow", (Integer.parseInt(pageNo.toString()) - 1) * Integer.parseInt(pageSize.toString()));
        parameter.put("rows", Integer.parseInt(pageSize.toString()));
        parameter.put("tenantCode", vop_mapTobean.get("tenantCode"));
        return JsonUtil.buildNormalBinder().toJson(this.queryContractPageReDomain(parameter));
    }

    @Override
    public void updateContractGoodsStateStr(String contractBillcode, String skuNo, Integer dataState, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsState.null", contractBillcode + "-" + skuNo + "-" + tenantCode);
        }
        List<OcContractGoods> ocContractGoods = this.updateContractGoodsStateStr(contractBillcode, skuNo, tenantCode);
        for (OcContractGoods ocContractGood : ocContractGoods) {
            this.updateContractGoodsState(ocContractGood.getContractGoodsId(), dataState, ocContractGood.getDataState());
        }
    }

    @Override
    public String updateBatchContractAndRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateBatchContractAndRefund.ocRefundDomain.null", (Object)"ocRefundDomain is null");
            return "error";
        }
        OcContract ocContract = this.getContractModelByCode(this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode()}));
        if (null == ocContract) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateBatchContractAndRefund.getContractModelByCode.ocContract.null", (Object)(ocRefundDomain.getContractBillcode() + ":" + ocRefundDomain.getTenantCode()));
            return "error";
        }
        BigDecimal contractSendnum = ocContract.getContractSendnum();
        BigDecimal contractSendweight = ocContract.getContractSendweight();
        List<OcRefundGoodsDomain> ocRefundGoodsDomainList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(this.getQueryParamMap("contractBillcode,skuNo,tenantCode", new Object[]{ocRefundDomain.getContractBillcode(), ocRefundGoodsDomain.getSkuNo(), ocRefundDomain.getTenantCode()}));
            if (ListUtil.isEmpty(ocContractGoodsList)) continue;
            OcContractGoods ocContractGoods = ocContractGoodsList.get(0);
            BigDecimal contractGoodsSendnum = ocContractGoods.getContractGoodsSendnum();
            BigDecimal contractGoodsSendweight = ocContractGoods.getContractGoodsSendweight();
            contractSendnum = contractSendnum.subtract(ocContractGoods.getContractGoodsRefnum());
            contractSendweight = contractSendweight.subtract(ocContractGoods.getContractGoodsRefweight());
            contractGoodsSendnum = contractGoodsSendnum.subtract(ocContractGoods.getContractGoodsRefnum());
            contractGoodsSendweight = contractGoodsSendweight.subtract(ocContractGoods.getContractGoodsRefweight());
            this.updateContractSendGoodsNumAndWeight(ocContractGoods.getContractGoodsId(), contractGoodsSendnum, contractGoodsSendweight);
        }
        if (contractSendnum.compareTo(BigDecimal.ZERO) == 0 && contractSendweight.compareTo(BigDecimal.ZERO) == 0) {
            this.updateContractState(ocContract.getContractId(), -1, ocContract.getDataState());
            this.updateContractSendNumAndWeight(ocContract.getContractId(), contractSendnum, contractSendweight, ContractConstants.REFUND_GOODS_AGREE_STATE);
        } else {
            this.updateContractSendNumAndWeight(ocContract.getContractId(), contractSendnum, contractSendweight, ContractConstants.REFUND_GOODS_AGREE_STATE);
        }
        return "success";
    }

    @Override
    public String updateStateContractGoodsNumAndWeight(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateStateBatchContractGoodsNumAndWeight.ocRefundDomain.null", (Object)"ocRefundDomain is null");
            return "error";
        }
        Integer contratGoodsState = ContractConstants.REFUND_GOODS_APPALY_STATE;
        if (ocRefundDomain.getDataState() == ContractConstants.REFUND_GOODS_APPALY_STATE) {
            contratGoodsState = ContractConstants.REFUND_GOODS_APPALY_STATE;
        }
        if (ocRefundDomain.getDataState() == ContractConstants.REFUND_GOODS_CANCEL_STATE) {
            contratGoodsState = ContractConstants.REFUND_GOODS_CANCEL_STATE;
        }
        if (ocRefundDomain.getDataState() == ContractConstants.REFUND_GOODS_REJECT_STATE) {
            contratGoodsState = ContractConstants.REFUND_GOODS_REJECT_STATE;
        }
        if (ocRefundDomain.getDataState() == ContractConstants.REFUND_GOODS_AGREE_STATE) {
            contratGoodsState = ContractConstants.REFUND_GOODS_AGREE_STATE;
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(this.getQueryParamMap("contractBillcode,skuNo,tenantCode", new Object[]{ocRefundDomain.getContractBillcode(), ocRefundGoodsDomain.getSkuNo(), ocRefundDomain.getTenantCode()}));
            if (ListUtil.isEmpty(ocContractGoodsList)) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateStateBatchContractGoodsNumAndWeight.ocContractGoodsList", (Object)(ocRefundDomain.getContractBillcode() + "-" + ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundDomain.getTenantCode()));
                return "error";
            }
            OcContractGoods ocContractGoods = ocContractGoodsList.get(0);
            if (contratGoodsState == ContractConstants.REFUND_GOODS_APPALY_STATE) {
                this.updateStateContractGoodsRefundNumAndWeight(ocContractGoods.getContractGoodsId(), ocRefundGoodsDomain.getGoodsNum(), ocRefundGoodsDomain.getGoodsWeight(), contratGoodsState);
                continue;
            }
            if (contratGoodsState == ContractConstants.REFUND_GOODS_CANCEL_STATE || contratGoodsState == ContractConstants.REFUND_GOODS_REJECT_STATE) {
                BigDecimal goodsNum = ocRefundGoodsDomain.getGoodsNum();
                BigDecimal goodsWeight = ocRefundGoodsDomain.getGoodsWeight();
                goodsNum = goodsNum.subtract(goodsNum).subtract(goodsNum);
                goodsWeight = goodsWeight.subtract(goodsWeight).subtract(goodsWeight);
                this.updateStateContractGoodsRefundNumAndWeight(ocContractGoods.getContractGoodsId(), goodsNum, goodsWeight, contratGoodsState);
                continue;
            }
            if (contratGoodsState != ContractConstants.REFUND_GOODS_AGREE_STATE) continue;
            this.updateStateContractGoods(ocContractGoods.getContractGoodsId(), contratGoodsState, 1);
            BigDecimal reFundNum = BigDecimal.ZERO;
            List<OcContractGoods> ocContractGoodss = this.queryContractGoodsModelPage(this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode()}));
            for (OcContractGoods contractGoods : ocContractGoodss) {
                if (contractGoods.getDataState() != ContractConstants.REFUND_GOODS_AGREE_STATE || contractGoods.getRefundFlag() != 1) continue;
                reFundNum = reFundNum.add(contractGoods.getContractGoodsRefnum());
            }
            OcContract ocContract = this.getContractModelByCode(this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode()}));
            if (ocContract.getGoodsNum() == null) {
                ocContract.setGoodsNum(BigDecimal.ZERO);
            }
            if (reFundNum.compareTo(ocContract.getGoodsNum()) != 0) continue;
            this.updateContractState(ocContract.getContractId(), -1, ocContract.getDataState());
        }
        return "success";
    }

    @Override
    public String updateContractGoodsStateApplyOcRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateApplyOcRefund.ocRefundDomain.null", (Object)"ocRefundDomain is null");
            return "error";
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            if (StringUtils.isNotBlank((String)ocRefundGoodsDomain.getRefundGoodsOldcode())) continue;
            OcContractGoods ocContractGoods = this.getContractGoodsModelByCode(this.getQueryParamMap("contractGoodsCode,tenantCode", new Object[]{ocRefundGoodsDomain.getContractGoodsCode(), ocRefundDomain.getTenantCode()}));
            if (null == ocContractGoods) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateApplyOcRefund.ocContractGoods", (Object)(ocRefundGoodsDomain.getContractGoodsCode() + "-" + ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundDomain.getTenantCode()));
                return "error";
            }
            this.updateStateContractGoodsRefundNumAndWeight(ocContractGoods.getContractGoodsId(), ocRefundGoodsDomain.getRefundGoodsNum(), ocRefundGoodsDomain.getRefundGoodsWeight(), 0);
        }
        return "success";
    }

    @Override
    public String updateContractGoodsStateAgreeOcRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateAgreeOcRefund.ocRefundDomain.null", (Object)"ocRefundDomain is null");
            return "error";
        }
        BigDecimal reFundNum = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            if (StringUtils.isNotBlank((String)ocRefundGoodsDomain.getRefundGoodsOldcode())) continue;
            OcContractGoods ocContractGoods = this.getContractGoodsModelByCode(this.getQueryParamMap("contractGoodsCode,tenantCode", new Object[]{ocRefundGoodsDomain.getContractGoodsCode(), ocRefundDomain.getTenantCode()}));
            if (null == ocContractGoods) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateAgreeOcRefund.ocContractGoods", (Object)(ocRefundGoodsDomain.getContractGoodsCode() + "-" + ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundDomain.getTenantCode()));
                return "error";
            }
            if (null == ocContractGoods.getContractGoodsRefnum() || null == ocContractGoods.getGoodsNum()) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateAgreeOcRefund.RefnumOrGoodsNum", (Object)(ocContractGoods.getContractGoodsId() + "-" + ocContractGoods.getContractGoodsRefnum() + "-" + ocContractGoods.getGoodsNum()));
                return "error";
            }
            if (ocContractGoods.getContractGoodsRefnum().compareTo(ocContractGoods.getGoodsNum()) == 0) {
                this.updateStateContractGoods(ocContractGoods.getContractGoodsId(), ContractConstants.REFUND_GOODS_INVALID_STATE, ContractConstants.REFUND_GOODS_YES_FLAG);
                continue;
            }
            this.updateStateContractGoods(ocContractGoods.getContractGoodsId(), ContractConstants.REFUND_GOODS_VALID_STATE, ContractConstants.REFUND_GOODS_YES_FLAG);
        }
        List<OcContractGoods> ocContractGoodss = this.queryContractGoodsModelPage(this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode()}));
        for (OcContractGoods contractGoods : ocContractGoodss) {
            if (contractGoods.getRefundFlag() != 1) continue;
            reFundNum = reFundNum.add(contractGoods.getContractGoodsRefnum());
        }
        OcContract ocContract = this.getContractModelByCode(this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{ocRefundDomain.getContractBillcode(), ocRefundDomain.getTenantCode()}));
        if (ocContract.getGoodsNum() == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateAgreeOcRefund.GoodsNum!!!", (Object)(ocContract.getContractBillcode() + "-" + ocContract.getGoodsNum()));
            return "error";
        }
        if (reFundNum.compareTo(ocContract.getGoodsNum()) == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", ContractConstants.OCCTRACT_STATE_CANCEL);
            this.getOcContractEngineService().sendContractBack(ocContract.getContractBillcode(), ocContract.getTenantCode(), map);
        }
        return "success";
    }

    @Override
    public String updateContractGoodsStateRejectOcRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateRejectOcRefund.ocRefundDomain.null", (Object)"ocRefundDomain is null");
            return "error";
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            if (StringUtils.isNotBlank((String)ocRefundGoodsDomain.getRefundGoodsOldcode())) continue;
            OcContractGoods ocContractGoods = this.getContractGoodsModelByCode(this.getQueryParamMap("contractGoodsCode,tenantCode", new Object[]{ocRefundGoodsDomain.getContractGoodsCode(), ocRefundDomain.getTenantCode()}));
            if (null == ocContractGoods) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateRejectOcRefund.ocContractGoods", (Object)(ocRefundGoodsDomain.getContractGoodsCode() + "-" + ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundDomain.getTenantCode()));
                return "error";
            }
            BigDecimal goodsNum = ocRefundGoodsDomain.getRefundGoodsNum();
            BigDecimal goodsWeight = ocRefundGoodsDomain.getRefundGoodsWeight();
            goodsNum = goodsNum.subtract(goodsNum).subtract(goodsNum);
            goodsWeight = goodsWeight.subtract(goodsWeight).subtract(goodsWeight);
            this.updateStateContractGoodsRefundNumAndWeight(ocContractGoods.getContractGoodsId(), goodsNum, goodsWeight, ocContractGoods.getDataState());
        }
        return "success";
    }

    @Override
    public String updateContractGoodsStateCancelOcRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateCancelOcRefund.ocRefundDomain.null", (Object)"ocRefundDomain is null");
            return "error";
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            if (StringUtils.isNotBlank((String)ocRefundGoodsDomain.getRefundGoodsOldcode())) continue;
            OcContractGoods ocContractGoods = this.getContractGoodsModelByCode(this.getQueryParamMap("contractGoodsCode,tenantCode", new Object[]{ocRefundGoodsDomain.getContractGoodsCode(), ocRefundDomain.getTenantCode()}));
            if (null == ocContractGoods) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsStateCancelOcRefund.ocContractGoods", (Object)(ocRefundGoodsDomain.getContractGoodsCode() + "-" + ocRefundGoodsDomain.getSkuNo() + "-" + ocRefundDomain.getTenantCode()));
                return "error";
            }
            BigDecimal goodsNum = ocRefundGoodsDomain.getRefundGoodsNum();
            BigDecimal goodsWeight = ocRefundGoodsDomain.getRefundGoodsWeight();
            goodsNum = goodsNum.subtract(goodsNum).subtract(goodsNum);
            goodsWeight = goodsWeight.subtract(goodsWeight).subtract(goodsWeight);
            this.updateStateContractGoodsRefundNumAndWeight(ocContractGoods.getContractGoodsId(), goodsNum, goodsWeight, 0);
        }
        return "success";
    }

    private void updateStateContractGoods(Integer contractGoodsId, Integer dataState, Integer refundFlag) {
        if (null == contractGoodsId) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("refundFlag", refundFlag);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateStateContractGoods(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.null");
        }
    }

    private void updateStateContractGoodsRefundNumAndWeight(Integer contractGoodsId, BigDecimal contractGoodsRefnum, BigDecimal contractGoodsRefweight, Integer dataState) {
        if (null == contractGoodsId) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("contractGoodsRefnum", contractGoodsRefnum);
        map.put("contractGoodsRefweight", contractGoodsRefweight);
        map.put("dataState", dataState);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateContractgoodsNumAndWeight(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.null", ((Object)map).toString());
        }
    }

    private void updateContractSendNumAndWeight(Integer contractId, BigDecimal contractSendnum, BigDecimal contractSendweight, Integer dataState) throws ApiException {
        if (null == contractId) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractId", contractId);
        map.put("contractSendnum", contractSendnum);
        map.put("contractSendweight", contractSendweight);
        map.put("dataState", dataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateSendNumAndWeightByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.null");
        }
    }

    private void updateContractSendGoodsNumAndWeight(Integer contractGoodsId, BigDecimal contractGoodsSendnum, BigDecimal contractGoodsSendweight) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("contractGoodsSendnum", contractGoodsSendnum);
        map.put("contractGoodsSendweight", contractGoodsSendweight);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateContractgoodsSendNumAndWeight(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.null");
        }
    }

    public List<OcContractGoods> updateContractGoodsStateStr(String contractBillcode, String skuNo, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("skuNo", skuNo);
        map.put("tenantCode", tenantCode);
        List<OcContractGoods> ocContractGoods = this.queryContractGoodsModelPage(map);
        return ocContractGoods;
    }

    private void updateContractgoodsInfo(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateContractgoodsInfo(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractgoodsInfo.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractgoodsInfo.null", map.toString());
        }
    }

    private void updateContractgoodsDate(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateContractgoodsDate(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractgoodsDate.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractgoodsDate.null", map.toString());
        }
    }

    private void updateContractgoodsTopNum(String contractGoodsCode, String tenantCode, BigDecimal goodsTopnum, BigDecimal goodsTopweight) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("tenantCode", tenantCode);
        map.put("goodsTopnum", goodsTopnum);
        map.put("goodsTopweight", goodsTopweight);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateContractgoodsTopNum(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractgoodsTopNum.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractgoodsTopNum.null", ((Object)map).toString());
        }
    }

    @Override
    public String updateTopNumNew(List<GoodsSendNumBean> goodsSendNumBeanList) {
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return "error";
        }
        String tenantCode = "";
        HashMap<String, String> mainMap = new HashMap<String, String>();
        HashMap<String, OcContractSettlDomain> settMap = new HashMap<String, OcContractSettlDomain>();
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        OcContractGoods ocContractGoods = null;
        String contractBillcode = "";
        tenantCode = this.getShipmentNum(goodsSendNumBeanList, tenantCode, mainMap, settMap, ocContractGoods, contractBillcode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (MapUtil.isNotEmpty(mainMap)) {
            for (String key : mainMap.keySet()) {
                mapStr.put("contractBillcode", key);
                mapStr.put("tenantCode", tenantCode);
                List<OcContractGoods> ocContractGoodsStr = this.queryContractGoodsModelPage(mapStr);
                if (ListUtil.isEmpty(ocContractGoodsStr)) {
                    this.logger.error("oc.CONTRACT.OcContractServiceImplcloseProductNewOrder.ocContractGoodsStr", (Object)((Object)mapStr).toString());
                    continue;
                }
                mapStr.put("dataOpbillstate", 2);
                List<OcContractGoods> ocContractGoodsNewStr = this.queryContractGoodsModelPage(mapStr);
                if (ListUtil.isEmpty(ocContractGoodsNewStr) || ocContractGoodsStr.size() != ocContractGoodsNewStr.size()) {
                    this.updateContractMoneyNew((String)mainMap.get(key), tenantCode, null);
                }
                map.put("contractBillcode", key);
                map.put("tenantCode", tenantCode);
                OcContract ocContract = this.getContractModelByCodes(map);
                if (null != ocContract && ocContract.getDataState() != 4) {
                    this.updateStateContractModelByCode(tenantCode, key, 4, null, null);
                }
                if (ocContractGoodsStr.size() != ocContractGoodsNewStr.size()) continue;
                this.updateTopNum(goodsSendNumBeanList);
                this.getOcContractEngineService().sendContractNext(key, tenantCode, null);
            }
        }
        return "success";
    }

    private void updateContractMoneyNew(String contractBillcode, String tenantCode, OcContractSettlDomain vasocContractSettlDomain) {
        List<OcContractGoods> goodlist = this.queryContractGoodsModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (ListUtil.isEmpty(goodlist)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractMoneyNew", (Object)("contractBillcode" + contractBillcode + "," + "tenantCode" + tenantCode));
            return;
        }
        OcContract ocContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (null == ocContract) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractMoneyNewStr", (Object)("contractBillcode" + contractBillcode + "," + "tenantCode" + tenantCode));
            return;
        }
        this.getContractSumDomain(contractBillcode, tenantCode, goodlist, ocContract);
    }

    private ContractSumDomain getContractSumDomain(String contractBillcode, String tenantCode, List<OcContractGoods> goodlist, OcContract ocContract) {
        HashMap<String, GoodsSumDomain> sumMap = new HashMap<String, GoodsSumDomain>();
        ContractSumDomain contractSumDomain = new ContractSumDomain();
        contractSumDomain.setContractBillcode(contractBillcode);
        contractSumDomain.setTenantCode(tenantCode);
        for (OcContractGoods ocContractGoods : goodlist) {
            if (-1 == ocContractGoods.getDataState() || ocContractGoods.getContractGoodsGtype().equals("1")) continue;
            GoodsSumDomain goodsSumDomain = (GoodsSumDomain)sumMap.get(ocContractGoods.getPackageCode());
            if (null == goodsSumDomain) {
                goodsSumDomain = new GoodsSumDomain();
                goodsSumDomain.setContractBillcode(contractBillcode);
                goodsSumDomain.setTenantCode(tenantCode);
                goodsSumDomain.setPackageCode(ocContractGoods.getPackageCode());
                sumMap.put(ocContractGoods.getPackageCode(), goodsSumDomain);
            }
            if ("3".equals(ocContractGoods.getContractGoodsGtype())) {
                BigDecimal subtract;
                if (null == ocContractGoods.getGoodsAhnum()) {
                    ocContractGoods.setGoodsAhnum(BigDecimal.ZERO);
                }
                if (0 == new BigDecimal(-1).compareTo(ocContractGoods.getGoodsNum())) {
                    goodsSumDomain.setContractGoodsInmoney(goodsSumDomain.getContractGoodsInmoney().subtract(ocContractGoods.getPricesetMakeprice()));
                    contractSumDomain.setContractInmoney(contractSumDomain.getContractInmoney().subtract(ocContractGoods.getPricesetMakeprice()));
                    continue;
                }
                if (0 == ocContractGoods.getGoodsNum().compareTo(ocContractGoods.getGoodsHangnum())) {
                    if (null == ocContractGoods.getPricesetNprice()) continue;
                    goodsSumDomain.setContractGoodsInmoney(goodsSumDomain.getContractGoodsInmoney().add(ocContractGoods.getPricesetNprice()));
                    contractSumDomain.setContractInmoney(contractSumDomain.getContractInmoney().add(ocContractGoods.getPricesetNprice()));
                    continue;
                }
                if (0 != BigDecimal.ZERO.compareTo(ocContractGoods.getGoodsAhnum()) && 0 == BigDecimal.ZERO.compareTo(ocContractGoods.getGoodsHangnum())) {
                    if (-1 == ocContractGoods.getGoodsNum().compareTo(ocContractGoods.getGoodsAhnum()) || 0 == ocContractGoods.getGoodsNum().compareTo(ocContractGoods.getGoodsAhnum())) {
                        goodsSumDomain.setContractGoodsInmoney(goodsSumDomain.getContractGoodsInmoney().add(ocContractGoods.getPricesetMakeprice()));
                        contractSumDomain.setContractInmoney(contractSumDomain.getContractInmoney().add(ocContractGoods.getPricesetMakeprice()));
                        continue;
                    }
                    subtract = ocContractGoods.getGoodsNum().subtract(ocContractGoods.getGoodsAhnum());
                    BigDecimal multiply = subtract.multiply(ocContractGoods.getPricesetNprice());
                    goodsSumDomain.setContractGoodsInmoney(goodsSumDomain.getContractGoodsInmoney().add(ocContractGoods.getPricesetNprice()).add(multiply));
                    contractSumDomain.setContractInmoney(contractSumDomain.getContractInmoney().add(ocContractGoods.getPricesetNprice()).add(multiply));
                    continue;
                }
                subtract = ocContractGoods.getGoodsNum().subtract(ocContractGoods.getGoodsHangnum());
                goodsSumDomain.setContractGoodsInmoney(goodsSumDomain.getContractGoodsInmoney().add(subtract.multiply(ocContractGoods.getPricesetNprice())));
                contractSumDomain.setContractInmoney(contractSumDomain.getContractInmoney().add(subtract.multiply(ocContractGoods.getPricesetNprice())));
                continue;
            }
            contractSumDomain.setGoodsWeight(contractSumDomain.getGoodsWeight().add(ocContractGoods.getGoodsWeight()));
            goodsSumDomain.setGoodsWeight(goodsSumDomain.getGoodsWeight().add(ocContractGoods.getGoodsWeight()));
            contractSumDomain.setGoodsNum(contractSumDomain.getGoodsNum().add(ocContractGoods.getGoodsWeight()));
            if (null != ocContractGoods.getGoodsTopnum() && ocContractGoods.getGoodsTopnum().compareTo(BigDecimal.ZERO) > 0) {
                ocContractGoods.setContractGoodsInmoney(ocContractGoods.getGoodsTopnum().multiply(ocContractGoods.getPricesetNprice()));
            } else {
                ocContractGoods.setContractGoodsInmoney(ocContractGoods.getGoodsNum().multiply(ocContractGoods.getPricesetNprice()));
            }
            goodsSumDomain.setGoodsNum(goodsSumDomain.getGoodsNum().add(ocContractGoods.getGoodsNum()));
            contractSumDomain.setGoodsNum(contractSumDomain.getGoodsNum().add(ocContractGoods.getGoodsNum()));
            goodsSumDomain.setContractGoodsMoney(goodsSumDomain.getContractGoodsMoney().add(ocContractGoods.getContractGoodsInmoney()));
            contractSumDomain.setGoodsMoney(contractSumDomain.getGoodsMoney().add(ocContractGoods.getContractGoodsInmoney()));
            contractSumDomain.setContractMoney(contractSumDomain.getContractMoney().add(ocContractGoods.getContractGoodsInmoney()));
            goodsSumDomain.setContractGoodsPefinmoney(goodsSumDomain.getContractGoodsPefinmoney().add(ocContractGoods.getContractGoodsPefinmoney()));
            contractSumDomain.setPricesetRefrice(contractSumDomain.getPricesetRefrice().add(ocContractGoods.getContractGoodsPefinmoney()));
            goodsSumDomain.setContractGoodsInmoney(goodsSumDomain.getContractGoodsInmoney().add(ocContractGoods.getContractGoodsInmoney()));
            contractSumDomain.setContractInmoney(contractSumDomain.getContractInmoney().add(ocContractGoods.getContractGoodsInmoney()));
        }
        contractSumDomain.setContractMoney(contractSumDomain.getContractMoney().add(ocContract.getGoodsLogmoney()));
        contractSumDomain.setDataBmoney(contractSumDomain.getContractMoney().add(ocContract.getGoodsLogmoney()).add(contractSumDomain.getPricesetRefrice()).add(ocContract.getContractPaymoney()).setScale(2, 4));
        contractSumDomain.setGoodsPmoney(contractSumDomain.getContractInmoney().subtract(contractSumDomain.getContractMoney()));
        this.updateSumByCodeModel(contractSumDomain);
        for (String key : sumMap.keySet()) {
            this.updatePackageSumByCodeModel((GoodsSumDomain)sumMap.get(key));
        }
        return contractSumDomain;
    }

    private String getTopNum(List<GoodsSendNumBean> goodsSendNumBeanList, String tenantCode, Map<String, String> mainMap, Map<String, OcContractSettlDomain> settMap, OcContractGoods ocContractGoods, String contractBillcode) {
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeanList) {
            BigDecimal contractGoodsSendnumStr;
            BigDecimal goodsMoeny = goodsSendNumBean.getGoodsMoeny();
            if (StringUtils.isBlank((String)contractBillcode)) {
                contractBillcode = goodsSendNumBean.getContractBillcode();
            }
            if (StringUtils.isNotBlank((String)contractBillcode)) {
                ocContractGoods = this.getContractGoodsModelByCode(this.getQueryMapParam("contractGoodsCode,tenantCode", new Object[]{goodsSendNumBean.getContractGoodsCode(), tenantCode}));
                contractBillcode = ocContractGoods.getContractBillcode();
            }
            if (null == (contractGoodsSendnumStr = goodsSendNumBean.getContractGoodsSendnum())) {
                goodsSendNumBean.setContractGoodsSendnum(BigDecimal.ZERO);
            }
            this.updateContractgoodsTopNum(goodsSendNumBean.getContractGoodsCode(), goodsSendNumBean.getTenantCode(), goodsSendNumBean.getContractGoodsSendnum(), goodsSendNumBean.getContractGoodsSendweight());
            mainMap.put("contractBillcode", contractBillcode);
            if (null != settMap.get(contractBillcode)) {
                OcContractSettlDomain ocContractSettlDomainStr = settMap.get(contractBillcode);
                if (null == goodsMoeny) {
                    goodsMoeny = BigDecimal.ZERO;
                }
                ocContractSettlDomainStr.setContractSettlPmoney(goodsMoeny);
                ocContractSettlDomainStr.setContractSettlGmoney(goodsMoeny);
                settMap.put(contractBillcode, ocContractSettlDomainStr);
            }
            if (null == settMap.get(contractBillcode)) {
                OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
                ocContractSettlDomain.setContractBillcode(goodsSendNumBean.getContractBillcode());
                ocContractSettlDomain.setMemberBcode(ocContractGoods.getMemberBcode());
                ocContractSettlDomain.setMemberBname(ocContractGoods.getMemberBname());
                ocContractSettlDomain.setMemberCode(ocContractGoods.getMemberCode());
                ocContractSettlDomain.setMemberName(ocContractGoods.getMemberName());
                ocContractSettlDomain.setMemberCcode(ocContractGoods.getMemberCcode());
                ocContractSettlDomain.setMemberCname(ocContractGoods.getMemberCname());
                ocContractSettlDomain.setContractSettlType("0");
                ocContractSettlDomain.setContractSettlBlance("BVD");
                ocContractSettlDomain.setContractPmode("0");
                ocContractSettlDomain.setContractSettlOpno("B01");
                ocContractSettlDomain.setContractSettlPmoney(goodsMoeny);
                ocContractSettlDomain.setContractSettlGmoney(goodsMoeny);
                ocContractSettlDomain.setTenantCode(ocContractGoods.getTenantCode());
                ocContractSettlDomain.setAppmanageIcode(ocContractGoods.getAppmanageIcode());
                settMap.put(contractBillcode, ocContractSettlDomain);
            }
            tenantCode = goodsSendNumBean.getTenantCode();
        }
        return tenantCode;
    }

    private String getShipmentNum(List<GoodsSendNumBean> goodsSendNumBeanList, String tenantCode, Map<String, String> mainMap, Map<String, OcContractSettlDomain> settMap, OcContractGoods ocContractGoods, String contractBillcode) {
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeanList) {
            if (StringUtils.isBlank((String)contractBillcode)) {
                contractBillcode = goodsSendNumBean.getContractBillcode();
            }
            if (StringUtils.isNotBlank((String)contractBillcode)) {
                ocContractGoods = this.getContractGoodsModelByCode(this.getQueryMapParam("contractGoodsCode,tenantCode", new Object[]{goodsSendNumBean.getContractGoodsCode(), tenantCode}));
                contractBillcode = ocContractGoods.getContractBillcode();
            }
            BigDecimal sum = BigDecimal.ZERO;
            BigDecimal contractGoodsSendnumStr = goodsSendNumBean.getContractGoodsSendnum();
            BigDecimal goodsCamount = ocContractGoods.getGoodsCamount();
            BigDecimal contractGoodsRefnum = ocContractGoods.getContractGoodsRefnum();
            if (null == contractGoodsRefnum) {
                contractGoodsRefnum = BigDecimal.ZERO;
            }
            sum = contractGoodsSendnumStr.add(contractGoodsRefnum);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractGoodsCode", goodsSendNumBean.getContractGoodsCode());
            map.put("tenantCode", goodsSendNumBean.getTenantCode());
            map.put("goodsTopnum", goodsSendNumBean.getContractGoodsSendnum());
            map.put("goodsTopweight", goodsSendNumBean.getContractGoodsSendweight());
            if (sum.compareTo(goodsCamount) == 0) {
                map.put("dataOpbillstate", 2);
            }
            this.updateContractgoodsDate(map);
            goodsSendNumBean.setContractGoodsSendweight(BigDecimal.ZERO);
            goodsSendNumBean.setContractGoodsSendnum(BigDecimal.ZERO);
            mainMap.put(contractBillcode, contractBillcode);
            tenantCode = goodsSendNumBean.getTenantCode();
        }
        return tenantCode;
    }

    @Override
    public Map<String, String> updateTopNum(List<GoodsSendNumBean> goodsSendNumBeanList) {
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return null;
        }
        String tenantCode = "";
        HashMap<String, String> mainMap = new HashMap<String, String>();
        HashMap<String, OcContractSettlDomain> settMap = new HashMap<String, OcContractSettlDomain>();
        OcContractGoods ocContractGoods = null;
        String contractBillcode = "";
        tenantCode = this.getTopNum(goodsSendNumBeanList, tenantCode, mainMap, settMap, ocContractGoods, contractBillcode);
        if (MapUtil.isNotEmpty(mainMap)) {
            for (String key : mainMap.keySet()) {
                this.updateContractMoney((String)mainMap.get(key), tenantCode, (OcContractSettlDomain)settMap.get(mainMap.get(key)));
            }
        }
        return mainMap;
    }

    @Override
    public String updateBatchGoodsInfo(List<Map<String, Object>> mapList) {
        if (ListUtil.isEmpty(mapList)) {
            return "error";
        }
        String contractBillcode = "";
        String tenantCode = "";
        HashMap<String, String> mainMap = new HashMap<String, String>();
        for (Map<String, Object> map : mapList) {
            contractBillcode = (String)map.get("contractBillcode");
            if (StringUtils.isBlank((String)contractBillcode)) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateBatchGoodsInfo.contractBillcode");
            }
            tenantCode = (String)map.get("tenantCode");
            if (null != map.get("goodsCamount") && new BigDecimal(String.valueOf(map.get("goodsCamount"))).compareTo(BigDecimal.ZERO) > 0) {
                mainMap.put("contractBillcode", contractBillcode);
            } else if (null != map.get("dataState")) {
                mainMap.put("contractBillcode", contractBillcode);
            }
            this.updateContractgoodsInfo(map);
        }
        if (MapUtil.isNotEmpty(mainMap)) {
            for (String key : mainMap.keySet()) {
                this.updateContractMoney((String)mainMap.get(key), tenantCode, null);
            }
        }
        return "success";
    }

    private void updateContractMoney(String contractBillcode, String tenantCode, OcContractSettlDomain vasocContractSettlDomain) {
        List<OcContractGoods> goodlist = this.queryContractGoodsModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (ListUtil.isEmpty(goodlist)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractMoneyStr", (Object)("contractBillcode" + contractBillcode + "," + "tenantCode" + tenantCode));
            return;
        }
        OcContract ocContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (null == ocContract) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractMoney", (Object)("contractBillcode" + contractBillcode + "," + "tenantCode" + tenantCode));
            return;
        }
        ContractSumDomain contractSumDomain = this.getContractSumDomain(contractBillcode, tenantCode, goodlist, ocContract);
        if (null != vasocContractSettlDomain) {
            BigDecimal money;
            BigDecimal fee;
            BigDecimal feeSum = BigDecimal.ZERO;
            BigDecimal SumAmount = BigDecimal.ZERO;
            BigDecimal feeSumStr = BigDecimal.ZERO;
            BigDecimal vdSum = BigDecimal.ZERO;
            BigDecimal vdSumStr = BigDecimal.ZERO;
            BigDecimal orderAmount = BigDecimal.ZERO;
            List<OcContractSettl> settlList = this.queryContractSettlByContractCode(tenantCode, contractBillcode);
            for (OcContractSettl ocContractSettl : settlList) {
                if ("02".equals(ocContractSettl.getContractSettlOpno()) && "FEE".equals(ocContractSettl.getContractSettlBlance())) {
                    feeSum = ocContractSettl.getContractSettlPmoney();
                }
                if (!"01".equals(ocContractSettl.getContractSettlOpno()) || !"VD".equals(ocContractSettl.getContractSettlBlance())) continue;
                vdSum = ocContractSettl.getContractSettlPmoney();
            }
            SumAmount = feeSum.add(vdSum);
            orderAmount = contractSumDomain.getDataBmoney();
            if (null != SumAmount && SumAmount.compareTo(BigDecimal.ZERO) > 0 && feeSum.compareTo(BigDecimal.ZERO) > 0) {
                feeSumStr = orderAmount.divide(SumAmount, 3, 4).multiply(feeSum).setScale(2, 5);
            }
            if (null != SumAmount && SumAmount.compareTo(BigDecimal.ZERO) > 0 && vdSum.compareTo(BigDecimal.ZERO) > 0) {
                vdSumStr = orderAmount.subtract(feeSumStr).setScale(2, 5);
            }
            if ((fee = feeSumStr.subtract(feeSum)).compareTo(BigDecimal.ZERO) < 0) {
                OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
                ocContractSettlDomain.setContractBillcode(ocContract.getContractBillcode());
                ocContractSettlDomain.setMemberBcode(ocContract.getMemberBcode());
                ocContractSettlDomain.setMemberBname(ocContract.getMemberBname());
                ocContractSettlDomain.setMemberCode(ocContract.getMemberCode());
                ocContractSettlDomain.setMemberName(ocContract.getMemberName());
                ocContractSettlDomain.setMemberCcode(ocContract.getMemberCcode());
                ocContractSettlDomain.setMemberCname(ocContract.getMemberCname());
                ocContractSettlDomain.setContractSettlType("0");
                ocContractSettlDomain.setContractSettlBlance("BFEE");
                ocContractSettlDomain.setContractPmode("0");
                ocContractSettlDomain.setContractSettlPmoney(BigDecimal.ZERO.subtract(fee));
                ocContractSettlDomain.setContractSettlGmoney(BigDecimal.ZERO.subtract(fee));
                ocContractSettlDomain.setContractSettlOpno("B02");
                ocContractSettlDomain.setTenantCode(ocContract.getTenantCode());
                ocContractSettlDomain.setAppmanageIcode(ocContract.getAppmanageIcode());
                this.saveContractSettl(ocContractSettlDomain);
            }
            if ((money = vdSumStr.subtract(vdSum)).compareTo(BigDecimal.ZERO) < 0) {
                vasocContractSettlDomain.setContractSettlPmoney(BigDecimal.ZERO.subtract(money));
                vasocContractSettlDomain.setContractSettlGmoney(BigDecimal.ZERO.subtract(money));
                this.saveContractSettl(vasocContractSettlDomain);
            }
        }
    }

    @Override
    public String updateContractGoodsGoodsno(OcContractDomain ocContractDomain) {
        List<WhGoodsnoConf> whGoodsnoConfList = this.getWhGoodsnoConfList(ocContractDomain, null, "user", null);
        if (ListUtil.isEmpty(whGoodsnoConfList)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsGoodsno", (Object)"is null");
            return "success";
        }
        WhGoodsnoConf whGoodsnoConf = whGoodsnoConfList.get(0);
        WhGoodsno whGoodsno = this.getWhGoodsno(whGoodsnoConf);
        if (null == whGoodsno) {
            return "success";
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            map2.put("goodsProperty3", whGoodsno.getGoodsnoNo());
            map2.put("goodsProperty5", whGoodsno.getGoodsnoName());
            map2.put("contractGoodsCode", ocContractGoodsDomain.getContractGoodsCode());
            map2.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            this.updateContractgoodsInfo(map2);
        }
        return "success";
    }

    private WhGoodsno getWhGoodsno(WhGoodsnoConf whGoodsnoConf) {
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        HashMap<String, String> mapStr1 = new HashMap<String, String>();
        mapStr1.put("goodsnoCode", whGoodsnoConf.getGoodsnoCode());
        mapStr1.put("tenantCode", whGoodsnoConf.getTenantCode());
        paramMap1.put("map", JsonUtil.buildNormalBinder().toJson(mapStr1));
        String objectStr = this.internalInvoke("wh.WhGoodsno.queryGoodsnoPage", paramMap1);
        if (objectStr == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getWhGoodsnoStr", (Object)((Object)paramMap1).toString());
            return null;
        }
        SupQueryResult whGoodsnoQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(objectStr, SupQueryResult.class);
        List whGoodsnoList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)whGoodsnoQueryResult.getList()), WhGoodsno.class);
        if (null == whGoodsnoList || whGoodsnoList.isEmpty()) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.wh.WhGoodsno.queryGoodsnoPage", (Object)(((Object)paramMap1).toString() + "===object===" + objectStr));
            return null;
        }
        WhGoodsno whGoodsno = (WhGoodsno)whGoodsnoList.get(0);
        return whGoodsno;
    }

    private List<WhGoodsnoConf> getWhGoodsnoConfList(OcContractDomain ocContractDomain, OcContractGoodsDomain ocContractGoodsDomain, String type, String goodsnoCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (type.equals("user")) {
            map.put("memberCode", ocContractDomain.getMemberBcode());
            map.put("goodsnoConfType", "user");
            map.put("tenantCode", ocContractDomain.getTenantCode());
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        } else {
            map.put("goodsnoConfOp", ocContractGoodsDomain.getGoodsNo());
            map.put("goodsnoCode", goodsnoCode);
            map.put("goodsnoConfType", "goodsNo");
            map.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        }
        String object = this.internalInvoke("wh.WhGoodsno.queryGoodsnoConfPage", paramMap);
        if (object == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.wh.WhGoodsno.queryGoodsnoConfPageStr", (Object)((Object)paramMap).toString());
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(object, SupQueryResult.class);
        List whGoodsnoConfList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhGoodsnoConf.class);
        if (null == whGoodsnoConfList || whGoodsnoConfList.isEmpty()) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.wh.WhGoodsno.queryGoodsnoConfPage", (Object)(((Object)paramMap).toString() + "===object===" + object));
            return null;
        }
        return whGoodsnoConfList;
    }

    @Override
    public String updateContractBatch(List<Map<String, Object>> mapList) {
        if (ListUtil.isEmpty(mapList)) {
            return "error";
        }
        String contractBillcode = "";
        for (Map<String, Object> map : mapList) {
            contractBillcode = (String)map.get("contractBillcode");
            if (StringUtils.isBlank((String)contractBillcode)) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractBatch.updateContractBatch");
            }
            this.updateContract(map);
        }
        return "success";
    }

    @Override
    public String updateContractBatchYT(List<Map<String, Object>> mapList) {
        if (ListUtil.isEmpty(mapList)) {
            return "error";
        }
        String contractObillcode = "";
        for (Map<String, Object> map : mapList) {
            contractObillcode = (String)map.get("contractObillcode");
            if (StringUtils.isBlank((String)contractObillcode)) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractBatch.updateContractBatch");
            }
            this.updateContractYT(map);
        }
        return "success";
    }

    @Override
    public String updateContractBatchBynbbillcode(List<Map<String, Object>> mapList) {
        if (ListUtil.isEmpty(mapList)) {
            return "error";
        }
        String contractObillcode = "";
        for (Map<String, Object> map : mapList) {
            contractObillcode = (String)map.get("contractNbbillcode");
            if (StringUtils.isBlank((String)contractObillcode)) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractBatchBynbbillcode.updateContractBatch");
            }
            this.updateContractYTcontractNbbillcode(map);
        }
        return "success";
    }

    private void updateContract(Map<String, Object> rmap) throws ApiException {
        if (null == rmap || rmap.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateContract(rmap);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.null" + rmap);
        }
    }

    private void updateContractYT(Map<String, Object> rmap) throws ApiException {
        if (null == rmap || rmap.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractYT(rmap);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.null" + rmap);
        }
    }

    private void updateContractYTcontractNbbillcode(Map<String, Object> rmap) throws ApiException {
        if (null == rmap || rmap.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractYTcontractNbbillcode(rmap);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractYTcontractNbbillcode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractYTcontractNbbillcode.null" + rmap);
        }
    }

    @Override
    public String sendUpdateBatchGoodsInfo(List<ContractGoodsBean> mapList) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        for (ContractGoodsBean contractGoodsBean : mapList) {
            List<Map<String, Object>> mapList1 = contractGoodsBean.getMapList();
            this.updateBatchGoodsInfo(mapList1);
            parammap.put("contractBillcode", contractGoodsBean.getContractBillcode());
            parammap.put("tenantCode", contractGoodsBean.getTenantCode());
            parammap.put("dataStateNewStr", true);
            List<OcContractGoodsDomain> ocContractGoodsDomains = this.queryContractGoodsDomainListNew(parammap);
            if (ListUtil.isNotEmpty(ocContractGoodsDomains)) continue;
            this.getOcContractEngineService().sendContractBack(contractGoodsBean.getContractBillcode(), contractGoodsBean.getTenantCode(), null);
        }
        return "success";
    }

    @Override
    public void updateContractInv(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        this.ocContractMapper.updateContractInv(map);
    }

    @Override
    public void queryContractByLike(Map<String, Object> param) throws ApiException {
    }

    @Override
    public String contractUpload(MultipartFile multipartFile, Map<String, Object> map) {
        return null;
    }

    @Override
    public QueryResult<PingAnReport> pingAnOrderReport(Map<String, Object> map) throws ApiException {
        List<PingAnReport> anReports = this.ocContractMapper.pingAnReport(map);
        QueryResult queryResult = new QueryResult();
        String reportCount = this.ocContractMapper.pingAnReportCount(map);
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.valueOf(reportCount).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(anReports);
        queryResult.setTotal((long)Integer.valueOf(reportCount).intValue());
        return queryResult;
    }

    @Override
    public Map<String, Object> getPurchasableGoodsNum(Map<String, Object> map) throws ApiException {
        Map<String, Object> refMap;
        this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPurchasableGoodsNum.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("purchasedTotal", "0");
        if (MapUtil.isEmpty(map)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPurchasableGoodsNum.map is null");
            return resultMap;
        }
        Map<String, Object> rsMap = this.ocContractGoodsMapper.getPurchasableGoodsNum(map);
        if (MapUtil.isEmpty(rsMap)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPurchasableGoodsNum.rsMap is null");
            return resultMap;
        }
        if (rsMap.get("billCodes") != null && StringUtils.isNotBlank((String)rsMap.get("billCodes").toString()) && MapUtil.isNotEmpty(refMap = this.ocRefundMapper.getRefNumTotal(rsMap))) {
            rsMap.putAll(refMap);
        }
        this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPurchasableGoodsNum.rsMap", (Object)JsonUtil.buildNormalBinder().toJson(rsMap));
        return rsMap;
    }

    @Override
    public String sendPayWxMns(OcContractReDomain ocContractDomain) throws ApiException {
        if (ocContractDomain == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendPayWxMns.ocContractDomain is null");
            return "error";
        }
        HashMap<String, Object> mapOc = new HashMap<String, Object>();
        mapOc.put("contractBillcode", ocContractDomain.getContractBillcode());
        mapOc.put("tenantCode", ocContractDomain.getTenantCode());
        OcContractReDomain contractByCode = this.getContractByCode(mapOc);
        if (contractByCode == null || ListUtil.isEmpty(contractByCode.getOcContractSettlList())) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendPayWxMns.contractByCode is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        boolean vdFlag = false;
        String payType = "";
        for (OcContractSettlDomain contractSettl : contractByCode.getOcContractSettlList()) {
            if ("VD".equals(contractSettl.getContractSettlBlance())) {
                vdFlag = true;
                payType = StringUtils.isNotBlank((String)payType) ? "+\u57fa\u672c\u6237" : "\u57fa\u672c\u6237";
            }
            if (!"CAS".equals(contractSettl.getContractSettlBlance())) continue;
            if (StringUtils.isNotBlank((String)payType)) {
                payType = "+\u73b0\u91d1";
                continue;
            }
            payType = "\u73b0\u91d1";
        }
        if (!vdFlag) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendPayWxMns \u4e0d\u63a8\u9001");
            return "success";
        }
        StringBuilder goodsName = new StringBuilder();
        for (OcContractGoodsDomain ocContractGoodsDomain : contractByCode.getGoodsList()) {
            goodsName.append(",").append(ocContractGoodsDomain.getGoodsName());
        }
        if (goodsName.length() >= 18) {
            goodsName.setLength(18);
            goodsName.append("...");
        }
        String goodsNameStr = goodsName.substring(1);
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        String p = "";
        if ("02333".equals(contractByCode.getAppmanageIcode())) {
            p = "1";
        } else if ("032".equals(contractByCode.getAppmanageIcode())) {
            p = "0";
        } else {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendPayWxMns.\u4e0d\u662f\u5c0f\u7a0b\u5e8f\u8ba2\u5355\u4e0d\u901a\u77e5", (Object)contractByCode.getAppmanageIcode());
            return "success";
        }
        mnsMnslistDomainBean.setMnslistBustype("vd" + p + "01");
        mnsMnslistDomainBean.setMnslistBusname("\u57fa\u672c\u6237\u652f\u4ed8");
        mnsMnslistDomainBean.setMemberCode(ocContractDomain.getMemberBcode());
        mnsMnslistDomainBean.setDataTenant(ocContractDomain.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(ocContractDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("proappCode", ocContractDomain.getAppmanageIcode());
        listReceiver.put("code", ocContractDomain.getMemberBcode());
        listReceiver.put("name", ocContractDomain.getMemberBname());
        listReceiver.put("goodsNameStr", goodsNameStr);
        listReceiver.put("oederAmount", ocContractDomain.getDataBmoney().stripTrailingZeros().toPlainString());
        listReceiver.put("orderCode", ocContractDomain.getContractBillcode());
        listReceiver.put("payType", payType);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        listReceiver.put("orderTime", simpleDateFormat.format(contractByCode.getGmtCreate()));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendPayWxMns.mnsMnslistDomainBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        HashMap<String, String> paramsend = new HashMap<String, String>();
        paramsend.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        String s = this.internalInvoke("mns.ser.sendMnslist", paramsend);
        this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendPayWxMns.s", (Object)JsonUtil.buildNormalBinder().toJson((Object)s));
        return "success";
    }

    @Override
    public QueryResult<OcContract> queryOcContractByContractNbillCode(String auctionCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)auctionCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.queryOcContractByContractNbillCode.auctionCode is null");
        }
        List<OcContract> ocContractList = this.queryOcContractContractNbillCode(auctionCode, tenantCode);
        if (ListUtil.isEmpty(ocContractList)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.queryOcContractByContractNbillCode.ocContractList is null");
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(ocContractList.size());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    private List<OcContract> queryOcContractContractNbillCode(String auctionCode, String tenantCode) {
        if (StringUtils.isEmpty((String)auctionCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.MapperBefore.queryOcContractByContractNbillCode.auctionCode is null");
        }
        try {
            return this.ocContractMapper.queryContractNbillCodeOcContract(auctionCode, tenantCode);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.MapperAfter.queryContractNbillCodeOcContract" + e);
        }
    }

    @Override
    public String updateContractContractValidate(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractContractValidate", (Object)"isnull");
            return "error";
        }
        HashMap<String, Object> mapStr1 = new HashMap<String, Object>();
        Date nowdate = this.getSysDate();
        String tkey = ocContractDomain.getTenantCode();
        String mainkey = "-oc";
        String key = "";
        String key1 = "-contractValidate";
        Date paydate = this.getDate(ocContractDomain, nowdate, tkey, mainkey, key1);
        try {
            mapStr1.put("tenantCode", ocContractDomain.getTenantCode());
            mapStr1.put("contractValidate", paydate);
            mapStr1.put("contractBillcode", ocContractDomain.getContractBillcode());
            this.updateContractContractValidateModel(mapStr1);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractContractValidate", (Object)((Object)mapStr1).toString());
            return "error";
        }
        return "success";
    }

    @Override
    public String updateContractEffectivedate(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractEffectivedate", (Object)"isnull");
            return "error";
        }
        HashMap<String, Object> mapStr1 = new HashMap<String, Object>();
        Date nowdate = this.getSysDate();
        String tkey = ocContractDomain.getTenantCode();
        String mainkey = "-oc";
        String key = "";
        String key1 = "-contractEffectivedate";
        Date paydate = this.getDate(ocContractDomain, nowdate, tkey, mainkey, key1);
        try {
            mapStr1.put("tenantCode", ocContractDomain.getTenantCode());
            mapStr1.put("contractEffectivedate", paydate);
            mapStr1.put("contractBillcode", ocContractDomain.getContractBillcode());
            this.updateContractContractValidateModel(mapStr1);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractEffectivedate", (Object)((Object)mapStr1).toString());
            return "error";
        }
        return "success";
    }

    private Date getDate(OcContractDomain ocContractDomain, Date nowdate, String tkey, String mainkey, String key1) {
        String key;
        String checkTime = "";
        if (StringUtils.isNotBlank((String)ocContractDomain.getChannelCode())) {
            key = mainkey + "-" + ocContractDomain.getChannelCode();
            checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tkey + key + key1));
            if (StringUtils.isBlank((String)checkTime)) {
                key = "00000000" + key + key1;
                checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)key);
            }
        }
        if (StringUtils.isNotBlank((String)ocContractDomain.getMemberMcode())) {
            key = mainkey + "-" + ocContractDomain.getMemberMcode();
            checkTime = DisUtil.getMap((String)"DdFalgSetting-mcodekey", (String)(tkey + key + key1));
            this.logger.error(".createOrder1212", (Object)("param is null" + checkTime));
            if (StringUtils.isBlank((String)checkTime)) {
                key = "00000000" + key + key1;
                checkTime = DisUtil.getMap((String)"DdFalgSetting-mcodekey", (String)key);
            }
        }
        if (StringUtils.isBlank((String)checkTime) && StringUtils.isNotBlank((String)ocContractDomain.getGoodsClass())) {
            key = mainkey + "-" + ocContractDomain.getGoodsClass();
            checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tkey + key + key1));
            if (StringUtils.isBlank((String)checkTime)) {
                key = "00000000" + key + key1;
                checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)key);
            }
        }
        if (StringUtils.isBlank((String)checkTime)) {
            key = mainkey;
            checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tkey + key + key1));
            if (StringUtils.isBlank((String)checkTime)) {
                key = "00000000" + key + key1;
                checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)key);
            }
        }
        if (StringUtils.isBlank((String)checkTime)) {
            checkTime = "720";
        }
        Date paydate = null;
        if ("-1".equals(checkTime)) {
            paydate = DateUtils.getDateToString((String)(DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
        } else {
            int paydd = Integer.valueOf(checkTime);
            paydate = DateUtils.addMinutes((Date)nowdate, (int)paydd);
        }
        return paydate;
    }

    public void updateContractContractValidateModel(Map<String, Object> rmap) throws ApiException {
        if (null == rmap || rmap.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractContractValidateModel(rmap);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractValidateModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractValidateModel.null" + rmap);
        }
    }

    @Override
    public OcConsumeBigData queryOcContractTotal(Map<String, Object> map) throws ApiException {
        OcConsumeBigData modelOcConsumeBigData = this.getModelOcConsumeBigData(map);
        map.put("start", true);
        OcConsumeBigData modelOcConsumeBigData1 = this.getModelOcConsumeBigData(map);
        OcConsumeBigData modelOcConsumeBigDataStr = new OcConsumeBigData();
        modelOcConsumeBigDataStr.setSumMoney(modelOcConsumeBigData.getSumMoney().setScale(2, 5));
        modelOcConsumeBigDataStr.setSumCount(modelOcConsumeBigData.getSumCount());
        BigDecimal subtract = modelOcConsumeBigData.getSumMoney().subtract(modelOcConsumeBigData1.getSumMoney()).setScale(2, 5);
        Integer subtract1 = modelOcConsumeBigData.getSumCount() - modelOcConsumeBigData1.getSumCount();
        modelOcConsumeBigDataStr.setValue1(subtract.toString());
        modelOcConsumeBigDataStr.setValue2(String.valueOf(subtract1));
        return modelOcConsumeBigDataStr;
    }

    @Override
    public Map<String, Object> getCountMoneyNew(Map<String, Object> map) {
        return this.countMoneyNew(map);
    }

    private Map<String, Object> queryContractModelSumModel(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.queryContractGoodsSum(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractModelSumModel", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> countMoneyNew(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.countMoneyNew(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countMoneyNew", (Throwable)e);
            return null;
        }
    }

    public OcConsumeBigData getModelOcConsumeBigData(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractMapper.queryOcContractTotal(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getModelOcConsumeBigData", (Throwable)e);
            return null;
        }
    }

    @Override
    public OcConsumeBigData queryOcContractToCensus(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractMapper.queryOcContractToCensus(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryOcContractToCensus", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<OcContractReDomain> ocDataTotal(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        ArrayList<OcContractReDomain> ocContractReDomainList = new ArrayList<OcContractReDomain>();
        List<OcContract> ocContractList = this.ocContractMapper.query(map);
        OcContractReDomain contractReDomain = null;
        for (OcContract ocContract : ocContractList) {
            map.put("contractBillcode", ocContract.getContractBillcode());
            List<OcContractGoods> ocContractGoodsList = this.ocContractGoodsMapper.query(map);
            if (ListUtil.isEmpty(ocContractGoodsList)) continue;
            contractReDomain = this.makeOcContractDomain(ocContract);
            List<OcContractGoodsDomain> ocContractGoodsDomains = this.changeDomain(ocContractGoodsList);
            contractReDomain.setGoodsList(ocContractGoodsDomains);
            ocContractReDomainList.add(contractReDomain);
        }
        QueryResult queryResult = new QueryResult();
        queryResult.setList(ocContractReDomainList);
        queryResult.setTotal((long)ocContractReDomainList.size());
        return queryResult;
    }

    @Override
    public QueryResult<OcBrokenLine> ocMoneyTotal(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<OcBrokenLine> resultList = this.ocContractMapper.ocMoneyTotal(map);
        QueryResult queryResult = new QueryResult();
        queryResult.setList(resultList);
        queryResult.setTotal((long)resultList.size());
        return queryResult;
    }

    @Override
    public QueryResult<OcBrokenLine> contractGoodsMoneyTotal(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<OcBrokenLine> resultList = this.ocContractGoodsMapper.ocGoodsMoneyTotal(map);
        QueryResult queryResult = new QueryResult();
        queryResult.setList(resultList);
        queryResult.setTotal((long)resultList.size());
        return queryResult;
    }

    public List<OcContractGoodsDomain> changeDomain(List<OcContractGoods> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> goodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoods ocContractGoods : goodsList) {
            OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)ocContractGoods);
                goodsDomainList.add(goodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsDomainList.foreach.ex", (Throwable)e);
            }
        }
        return goodsDomainList;
    }

    @Override
    public void saveContracts(List<OcContractGoodsDomain> ocContractGoodsDomain) throws ApiException {
        if (null != ocContractGoodsDomain && ocContractGoodsDomain.size() > 0) {
            for (OcContractGoodsDomain ocContractGoodsDomain1 : ocContractGoodsDomain) {
                this.saveContractGoods(ocContractGoodsDomain1);
            }
        }
    }

    @Override
    public String updateContractSubMoneyByCodeSettl(List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            if (!StringUtils.isNotBlank((String)ocContractSettlDomain.getContractSettlBlance()) || !ocContractSettlDomain.getContractSettlBlance().equals("user")) continue;
            String contractBillcode = ocContractSettlDomain.getContractBillcode();
            String tenantCode = ocContractSettlDomain.getTenantCode();
            BigDecimal updateMoney = ocContractSettlDomain.getContractSettlPmoney();
            String remark = ocContractSettlDomain.getContractSettlOpemo();
            map.put("contractBillcode", contractBillcode);
            map.put("tenantCode", tenantCode);
            OcContract contract = this.getContractModelByCode(map);
            if (null == contract) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractSubMoneyByCodeSettl", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01" + ((Object)map).toString()));
                return "error";
            }
            contract.setContractMoney(contract.getContractMoney().add(updateMoney));
            contract.setDataBmoney(contract.getDataBmoney().add(updateMoney));
            contract.setGmtModified(this.getSysDate());
            BigDecimal goodsPmoney = contract.getGoodsPmoney();
            if (null == goodsPmoney) {
                goodsPmoney = BigDecimal.ZERO;
            }
            goodsPmoney = goodsPmoney.subtract(updateMoney);
            contract.setGoodsPmoney(goodsPmoney);
            contract.setMemo(remark);
            this.updateContractMoneyPass(contract, updateMoney);
        }
        return "success";
    }

    @Override
    public String sendUpdatecloseNotProductOrder(List<GoodsSendNumBean> goodsSendNumBeanList) {
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.closeProductOrder", (Object)JsonUtil.buildNormalBinder().toJson(goodsSendNumBeanList));
            return "error";
        }
        String tenantCode = goodsSendNumBeanList.get(0).getTenantCode();
        HashMap<String, String> mainMap = new HashMap<String, String>();
        OcContractGoods ocContractGoods = null;
        String contractBillcode = "";
        this.getTopNotNumNew(goodsSendNumBeanList, tenantCode, mainMap, ocContractGoods, contractBillcode);
        if (MapUtil.isNotEmpty(mainMap)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap mapStr = new HashMap();
            for (String key : mainMap.keySet()) {
                map.put("contractBillcode", key);
                map.put("tenantCode", tenantCode);
                List<OcContractGoods> ocContractGoodsStr = this.queryContractGoodsModelPage(map);
                if (ListUtil.isEmpty(ocContractGoodsStr)) {
                    this.logger.error("oc.CONTRACT.OcContractServiceImplcloseNotProductOrder.ocContractGoodsStr", (Object)((Object)map).toString());
                    continue;
                }
                map.put("dataOpbillstate", 2);
                List<OcContractGoods> ocContractGoodsNewStr = this.queryContractGoodsModelPage(map);
                if (ListUtil.isEmpty(ocContractGoodsNewStr)) {
                    this.logger.error("oc.CONTRACT.OcContractServiceImplcloseNotProductOrder.ocContractGoodsNewStr", (Object)((Object)map).toString());
                    continue;
                }
                if (ocContractGoodsStr.size() != ocContractGoodsNewStr.size()) continue;
                String str = this.sendUpdateContractMoney(key, tenantCode);
                if (StringUtils.isBlank((String)str) || !str.equals("success")) {
                    this.logger.error(SYS_CODE, (Object)"sendUpdateContractMoneyparm is null");
                    continue;
                }
                this.getOcContractEngineService().sendContractBack(key, tenantCode, null);
            }
        }
        return "success";
    }

    private void getTopNotNumNew(List<GoodsSendNumBean> goodsSendNumBeanList, String tenantCode, Map<String, String> mainMap, OcContractGoods ocContractGoods, String contractBillcode) {
        BigDecimal contractGoodsBoxnum = BigDecimal.ZERO;
        BigDecimal contractGoodsSendnum = BigDecimal.ZERO;
        BigDecimal goodsOrdnum = BigDecimal.ZERO;
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeanList) {
            if (StringUtils.isBlank((String)contractBillcode)) {
                contractBillcode = goodsSendNumBean.getContractBillcode();
            }
            if (StringUtils.isNotBlank((String)contractBillcode)) {
                ocContractGoods = this.getContractGoodsModelByCode(this.getQueryMapParam("contractGoodsCode,tenantCode", new Object[]{goodsSendNumBean.getContractGoodsCode(), tenantCode}));
                contractBillcode = ocContractGoods.getContractBillcode();
            }
            if ((goodsOrdnum = ocContractGoods.getGoodsOrdnum()) == null) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.getTopNotNumNew.goodsOrdnum\uff01\uff01\uff01", (Object)goodsSendNumBean.getContractGoodsCode());
                continue;
            }
            contractGoodsBoxnum = goodsSendNumBean.getContractGoodsRefnum();
            if (contractGoodsBoxnum == null) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.getTopNotNumNew.contractGoodsRefnum\uff01\uff01\uff01", (Object)"parm is null");
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractGoodsCode", goodsSendNumBean.getContractGoodsCode());
            map.put("tenantCode", goodsSendNumBean.getTenantCode());
            map.put("contractGoodsBoxnum", contractGoodsBoxnum);
            if (goodsOrdnum.compareTo(contractGoodsBoxnum) == 0) {
                map.put("dataOpbillstate", 2);
            }
            this.updateContractgoodsInfo(map);
            mainMap.put(contractBillcode, contractBillcode);
        }
    }

    @Override
    public String sendUpdatecloseProductNewOrder(List<GoodsSendNumBean> goodsSendNumBeanList) {
        this.logger.error("oc.CONTRACT.OcContractServiceImpl.closeProductOrder", (Object)JsonUtil.buildNormalBinder().toJson(goodsSendNumBeanList));
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return "error";
        }
        String tenantCode = goodsSendNumBeanList.get(0).getTenantCode();
        HashMap<String, String> mainMap = new HashMap<String, String>();
        OcContractGoods ocContractGoods = null;
        String contractBillcode = "";
        this.getTopNumNew(goodsSendNumBeanList, tenantCode, mainMap, ocContractGoods, contractBillcode);
        if (MapUtil.isNotEmpty(mainMap)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, Object> mapStr = new HashMap<String, Object>();
            for (String key : mainMap.keySet()) {
                String str;
                map.put("contractBillcode", key);
                map.put("tenantCode", tenantCode);
                List<OcContractGoods> ocContractGoodsStr = this.queryContractGoodsModelPage(map);
                if (ListUtil.isEmpty(ocContractGoodsStr)) {
                    this.logger.error("oc.CONTRACT.OcContractServiceImplcloseProductNewOrder.ocContractGoodsStr", (Object)((Object)map).toString());
                    continue;
                }
                map.put("dataOpbillstate", 2);
                List<OcContractGoods> ocContractGoodsNewStr = this.queryContractGoodsModelPage(map);
                if (ListUtil.isNotEmpty(ocContractGoodsNewStr) && ocContractGoodsStr.size() == ocContractGoodsNewStr.size()) {
                    this.updateTopNum(goodsSendNumBeanList);
                    this.getOcContractEngineService().sendContractNext(key, tenantCode, null);
                }
                map.put("dataOpbillstate", 3);
                List<OcContractGoods> ocContractGoodsNotNewStr = this.queryContractGoodsModelPage(map);
                if (!ListUtil.isNotEmpty(ocContractGoodsNotNewStr) || ocContractGoodsStr.size() != ocContractGoodsNotNewStr.size()) continue;
                mapStr.put("contractBillcode", key);
                mapStr.put("tenantCode", tenantCode);
                OcContract ocContract = this.getContractModelByCodes(mapStr);
                if (null != ocContract && ocContract.getDataState() != 4) {
                    this.updateStateContractModelByCode(tenantCode, key, 4, null, null);
                }
                if (StringUtils.isBlank((String)(str = this.sendUpdateContractMoney(key, tenantCode))) || !str.equals("success")) continue;
                this.getOcContractEngineService().sendContractNext(key, tenantCode, null);
            }
        }
        return "success";
    }

    @Override
    public void updateDateByCode(Map<String, Object> map) {
        this.updateDateByCodeModel(map);
    }

    @Override
    public void updateOrderStatus(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) {
        this.updateStateContractModelByCode(tenantCode, contractBillcode, dataState, oldDataState, null);
    }

    @Override
    public void updateOrderStatusCyy(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContractReDomain contractByCode = this.getContractByCode(map);
        if (contractByCode != null) {
            if (contractByCode.getDataState() == 2) {
                this.updateStateContractModelByCode(tenantCode, contractBillcode, dataState, oldDataState, null);
                contractByCode.setDataState(dataState);
            }
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)contractByCode));
            this.getInternalRouter().inInvoke("da.daopsumlist.sendContractGoodInfo", pmap);
        }
    }

    @Override
    public void cancelContractStatus(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        this.updateStateContractModelByCode(tenantCode, contractBillcode, -1, 1, map);
    }

    private void getTopNumNew(List<GoodsSendNumBean> goodsSendNumBeanList, String tenantCode, Map<String, String> mainMap, OcContractGoods ocContractGoods, String contractBillcode) {
        BigDecimal contractGoodsRefnum = BigDecimal.ZERO;
        BigDecimal contractGoodsSendnum = BigDecimal.ZERO;
        BigDecimal goodsCamount = BigDecimal.ZERO;
        BigDecimal goodsNumber = BigDecimal.ZERO;
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeanList) {
            contractBillcode = goodsSendNumBean.getContractBillcode();
            if (StringUtils.isNotBlank((String)contractBillcode)) {
                ocContractGoods = this.getContractGoodsModelByCode(this.getQueryMapParam("contractGoodsCode,tenantCode", new Object[]{goodsSendNumBean.getContractGoodsCode(), tenantCode}));
                contractBillcode = ocContractGoods.getContractBillcode();
                mainMap.put(contractBillcode, contractBillcode);
            }
            if ((goodsCamount = ocContractGoods.getGoodsCamount()) == null) {
                goodsCamount = ocContractGoods.getGoodsCamount();
            }
            if ((contractGoodsRefnum = goodsSendNumBean.getContractGoodsRefnum()) == null) {
                return;
            }
            if (ocContractGoods != null && (contractGoodsSendnum = ocContractGoods.getGoodsTopnum()) == null) {
                contractGoodsSendnum = BigDecimal.ZERO;
            }
            BigDecimal sum = BigDecimal.ZERO;
            BigDecimal contractGoodsRefnum1 = ocContractGoods.getContractGoodsRefnum();
            if (null == contractGoodsRefnum1) {
                contractGoodsRefnum1 = BigDecimal.ZERO;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractGoodsCode", goodsSendNumBean.getContractGoodsCode());
            map.put("tenantCode", goodsSendNumBean.getTenantCode());
            map.put("contractGoodsRefnum", contractGoodsRefnum);
            sum = contractGoodsRefnum1.add(contractGoodsRefnum);
            goodsNumber = contractGoodsSendnum.add(sum);
            if (goodsNumber == null) {
                return;
            }
            if (goodsNumber.compareTo(goodsCamount) == 0 && contractGoodsSendnum.compareTo(BigDecimal.ZERO) == 1) {
                map.put("dataOpbillstate", 2);
            }
            if (sum.compareTo(goodsCamount) == 0) {
                map.put("dataOpbillstate", 3);
            }
            this.updateContractgoodsInfo(map);
            goodsSendNumBean.setContractGoodsRefnum(null);
            goodsSendNumBean.setContractGoodsSendnum(BigDecimal.ZERO);
        }
    }

    @Override
    public Map<String, Object> queryContractGoodsSum(Map<String, Object> map) {
        return this.queryContractModelSumModel(map);
    }

    @Override
    public String sendUpdateContractMoney(String contractBillcode, String tenantCode) {
        OcContract ocContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (null == ocContract) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendUpdateContractMoney", (Object)("contractBillcode" + contractBillcode + "," + "tenantCode" + tenantCode));
            return "error";
        }
        List<OcContractSettl> settlList = this.queryContractSettlByContractCode(tenantCode, contractBillcode);
        if (ListUtil.isEmpty(settlList)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendUpdateContractMoneyStr", (Object)("contractBillcode" + contractBillcode + "," + "tenantCode" + tenantCode));
            return "error";
        }
        for (OcContractSettl ocContractSettl : settlList) {
            OcContractSettlDomain ocContractSettlDomain;
            if ("02".equals(ocContractSettl.getContractSettlOpno()) && "FEE".equals(ocContractSettl.getContractSettlBlance())) {
                ocContractSettlDomain = new OcContractSettlDomain();
                ocContractSettlDomain.setContractBillcode(ocContract.getContractBillcode());
                ocContractSettlDomain.setMemberBcode(ocContract.getMemberBcode());
                ocContractSettlDomain.setMemberBname(ocContract.getMemberBname());
                ocContractSettlDomain.setMemberCode(ocContract.getMemberCode());
                ocContractSettlDomain.setMemberName(ocContract.getMemberName());
                ocContractSettlDomain.setMemberCcode(ocContract.getMemberCcode());
                ocContractSettlDomain.setMemberCname(ocContract.getMemberCname());
                ocContractSettlDomain.setContractSettlType("0");
                ocContractSettlDomain.setContractSettlBlance("BFEE");
                ocContractSettlDomain.setContractPmode("0");
                ocContractSettlDomain.setContractSettlPmoney(ocContractSettl.getContractSettlPmoney());
                ocContractSettlDomain.setContractSettlGmoney(ocContractSettl.getContractSettlGmoney());
                ocContractSettlDomain.setContractSettlOpno("B02");
                ocContractSettlDomain.setTenantCode(ocContract.getTenantCode());
                ocContractSettlDomain.setAppmanageIcode(ocContract.getAppmanageIcode());
                this.saveContractSettl(ocContractSettlDomain);
            }
            if (!"01".equals(ocContractSettl.getContractSettlOpno()) || !"VD".equals(ocContractSettl.getContractSettlBlance())) continue;
            ocContractSettlDomain = new OcContractSettlDomain();
            ocContractSettlDomain.setContractBillcode(ocContract.getContractBillcode());
            ocContractSettlDomain.setMemberBcode(ocContract.getMemberBcode());
            ocContractSettlDomain.setMemberBname(ocContract.getMemberBname());
            ocContractSettlDomain.setMemberCode(ocContract.getMemberCode());
            ocContractSettlDomain.setMemberName(ocContract.getMemberName());
            ocContractSettlDomain.setMemberCcode(ocContract.getMemberCcode());
            ocContractSettlDomain.setMemberCname(ocContract.getMemberCname());
            ocContractSettlDomain.setContractSettlType("0");
            ocContractSettlDomain.setContractSettlBlance("BVD");
            ocContractSettlDomain.setContractPmode("0");
            ocContractSettlDomain.setContractSettlPmoney(ocContractSettl.getContractSettlPmoney());
            ocContractSettlDomain.setContractSettlGmoney(ocContractSettl.getContractSettlGmoney());
            ocContractSettlDomain.setContractSettlOpno("B01");
            ocContractSettlDomain.setTenantCode(ocContract.getTenantCode());
            ocContractSettlDomain.setAppmanageIcode(ocContract.getAppmanageIcode());
            this.saveContractSettl(ocContractSettlDomain);
        }
        return "success";
    }

    @Override
    public void updateContractContractNbillcode(String contractBillcode, String tenantCode, String contractNbillcode) throws ApiException {
        this.updateContractContractNbillcodeModel(contractBillcode, tenantCode, contractNbillcode);
    }

    private void updateContractContractNbillcodeModel(String contractBillcode, String tenantCode, String contractObillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractObillcode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractObillcode", contractObillcode);
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractContractNbillcode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractNbillcodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractNbillcodeModel.null", ((Object)map).toString());
        }
    }

    @Override
    public void updateContractContractNbillcodeCrm(String contractBillcode, String tenantCode, String contractNbillcode, String contractObillcode) throws ApiException {
        this.updateContractContractNbillcodeModelCrm(contractBillcode, tenantCode, contractNbillcode, contractObillcode);
    }

    @Override
    public void updateContractContractObillcodeYT(String contractBillcode, String tenantCode, Integer contractState, String contractObillcode) throws ApiException {
        this.updateContractContractObillcodeModelYT(contractBillcode, tenantCode, contractState, contractObillcode);
    }

    @Override
    public void updateContractContractNbbillcodeYT(String contractBillcode, String tenantCode, Integer contractState, String contractNbbillcode) throws ApiException {
        this.updateContractContractNbbillcodeModelYT(contractBillcode, tenantCode, contractState, contractNbbillcode);
    }

    private void updateContractContractNbillcodeModelCrm(String contractBillcode, String tenantCode, String contractNbillcode, String contractObillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractNbillcode) || StringUtils.isBlank((String)contractObillcode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractObillcode", contractObillcode);
        map.put("contractNbillcode", contractNbillcode);
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractContractNbillcodeCrm(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractNbillcodeModelCrm.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractNbillcodeModelCrm.null", ((Object)map).toString());
        }
    }

    private void updateContractContractObillcodeModelYT(String contractBillcode, String tenantCode, Integer contractState, String contractObillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode) || null == contractState || StringUtils.isBlank((String)contractObillcode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractObillcode", contractObillcode);
        map.put("contractState", contractState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractContractObillcodeYT(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractObillcodeYT.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractObillcodeYT.null", ((Object)map).toString());
        }
    }

    private void updateContractContractNbbillcodeModelYT(String contractBillcode, String tenantCode, Integer contractState, String contractNbbillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode) || null == contractState || StringUtils.isBlank((String)contractNbbillcode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractNbbillcode", contractNbbillcode);
        map.put("contractState", contractState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateContractContractNbbillcodeYT(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractNbbillcodeYT.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractContractNbbillcodeYT.null", ((Object)map).toString());
        }
    }

    @Override
    public String sendSaveSendgoodsRefund(String contractBillcode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendSaveSendgoodsRefund", (Object)("contractBillcode" + contractBillcode + "," + "tenantCode" + tenantCode));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.getContractByCode(map);
        ocContractReDomain.setContractState(ocContractReDomain.getDataState());
        if (null == ocContractReDomain) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendSaveSendgoodsRefundStr", (Object)("map" + ((Object)map).toString()));
            return "error";
        }
        String str = this.getOcRefundEngineService().sendSaveOrderRefund(ocContractReDomain);
        if (StringUtils.isBlank((String)str) || str.equals("error")) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendSaveSendgoodsRefundStr", (Object)("str" + str));
            return "error";
        }
        return "success";
    }

    @Override
    public void updatecontractState(Map<String, Object> map) throws ApiException {
        String contractBillcode = map.get("channelsendOpcode") + "";
        String tenantCode = map.get("tenantCode") + "";
        HashMap<String, Object> ocmap = new HashMap<String, Object>();
        ocmap.put("contractBillcode", contractBillcode);
        ocmap.put("tenantCode", tenantCode);
        OcContractReDomain contractByCode = this.getContractByCode(ocmap);
        if (null != contractByCode) {
            this.updateContractState(contractByCode.getContractId(), 7, contractByCode.getDataState());
            this.updateContract(contractByCode);
        }
    }

    @Override
    public void updateoccontractState(Map<String, Object> map) throws ApiException {
        String contractBillcode = map.get("channelsendOpcode") + "";
        String tenantCode = map.get("tenantCode") + "";
        HashMap<String, Object> ocmap = new HashMap<String, Object>();
        ocmap.put("contractBillcode", contractBillcode);
        ocmap.put("tenantCode", tenantCode);
        OcContractReDomain contractByCode = this.getContractByCode(ocmap);
        if (null != contractByCode) {
            this.updateContractState(contractByCode.getContractId(), 0, contractByCode.getDataState());
            List goodslist = this.queryContractGoodsPage(this.getQueryParamMap("tenantCode,contractBillcode", new Object[]{contractByCode.getTenantCode(), contractByCode.getContractBillcode()})).getList();
            if (ListUtil.isNotEmpty((Collection)goodslist)) {
                HashMap<String, String> sendMap = new HashMap<String, String>();
                HashMap<String, String> skuMap = new HashMap<String, String>();
                ArrayList<Integer> idShelList = new ArrayList<Integer>();
                ArrayList<Integer> idList = new ArrayList<Integer>();
                ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
                for (OcContractGoods ocContractGoods : goodslist) {
                    sendMap.put("skuCode", ocContractGoods.getSkuCode());
                    sendMap.put("tenantCode", ocContractGoods.getTenantCode());
                    skuMap.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
                    String rssku = this.internalInvoke("rs.sku.getSkuByCode", skuMap);
                    RsSkuDomain rsSkuReDomain = (RsSkuDomain)JsonUtil.buildNormalBinder().getJsonToObject(rssku, RsSkuDomain.class);
                    if (null == rsSkuReDomain) continue;
                    if ("1".equals(String.valueOf(rsSkuReDomain.getDataOpbillstate()))) {
                        idShelList.add(rsSkuReDomain.getSkuId());
                    }
                    idList.add(rsSkuReDomain.getSkuId());
                    rsSkuReDomain.setGoodsSupplynum(rsSkuReDomain.getGoodsSupplynum().add(ocContractGoods.getGoodsCamount()));
                    skuList.add(rsSkuReDomain);
                }
                if (ListUtil.isNotEmpty(skuList)) {
                    skuMap.clear();
                    skuMap.put("skuList", JsonUtil.buildNormalBinder().toJson(skuList));
                    this.internalInvoke("rs.sku.updateSkuList", skuMap);
                }
                skuMap.clear();
                skuMap.put("skuIdList", JsonUtil.buildNormalBinder().toJson(idShelList));
                this.internalInvoke("rs.resource.sendUpdateSoldOutBatchSku", skuMap);
                skuMap.clear();
                skuMap.put("skuIdList", JsonUtil.buildNormalBinder().toJson(idList));
                this.internalInvoke("rs.resource.sendUpdateShelveBatchSku", skuMap);
            }
        }
    }

    public static void main(String[] args) {
        if (new BigDecimal("1").subtract(new BigDecimal("1")).intValue() >= 0) {
            System.out.println("\u4e0d\u6267\u884c");
        }
    }

    @Override
    public QueryResult<OcContractGoods> queryContractGoodsSumPage(Map<String, Object> map) {
        List<OcContractGoods> ocContractGoodsList = this.queryCorderGoodsBySum(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractGoodsList);
        return queryResult;
    }

    @Override
    public void updateNewContractRefund(String tenantCode, String contractBillcode, Integer contractState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateNewContractRefund.params", "\u53c2\u6570\u6709\u8bef");
        }
        if (null == contractState) {
            contractState = 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContract ocContract = this.getContractModelByCode(map);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateNewContractRefund.null", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        List<OcContractGoods> list = this.queryContractGoodsModelPage(map);
        if (null == list || list.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateNewContractRefund.goodsnull", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        boolean flag = true;
        for (OcContractGoods ocContractGoods : list) {
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum()).intValue() <= 0) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.getOcContractEngineService().sendContractBack(contractBillcode, tenantCode, null);
        }
    }

    @Override
    public String updateContractSettlRmoney(String refundCode, String tenantCode, String type) {
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractSettlRmoney", (Object)"is null");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", tenantCode);
        QueryResult<OcRefundSettl> ocRefundSettlQueryResult = this.getOcRefundSettlService().queryRefundSettlPage(map);
        if (ListUtil.isNotEmpty((Collection)ocRefundSettlQueryResult.getList())) {
            for (OcRefundSettl ocRefundSettlDomain : ocRefundSettlQueryResult.getList()) {
                map.put("type", type);
                if (null == ocRefundSettlDomain.getContractSettlPmoney()) {
                    ocRefundSettlDomain.setContractSettlPmoney(BigDecimal.ZERO);
                }
                map.put("contractSettlRmoney", ocRefundSettlDomain.getContractSettlPmoney());
                map.put("contractSettlBillcode", ocRefundSettlDomain.getContractSettlBillcode());
                this.updateContractSettlRmoneyModelByCode(map);
            }
        } else {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractSettlRmoney.map", map);
            return "error";
        }
        return "success";
    }

    private List<OcContractGoods> queryCorderGoodsBySum(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsMapper.queryCorderGoodsBySum(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryCorderGoodsBySum", (Throwable)e);
            return null;
        }
    }

    @Override
    public OcConsumeBigData getAllOcConSumMoneyByDataState(Map<String, Object> parammap) {
        return this.getAllOcConSumMoney(parammap);
    }

    private OcConsumeBigData getAllOcConSumMoney(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.getAllOcConSumMoneyByDataState(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getAllOcConSumMoneyByDataState", (Throwable)e);
            return null;
        }
    }

    private void updateContractSettlRmoneyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettlMapper.updateontractSettlRmoney(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSettlRmoneyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateontractSettlRmoneyModelByCode.num" + map);
        }
    }

    @Override
    public void updateContractLockByCode(String contractBillcode, String tenantCode) throws ApiException {
        this.updateModelLockByCode(tenantCode, contractBillcode);
    }

    @Override
    public void updateContractById(OcContractDomain ocContractDomain) throws ApiException {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.checkContract", msg);
        }
        OcContract oldOcContract = null;
        if (ocContractDomain.getContractId() != null) {
            oldOcContract = this.getContractModelById(ocContractDomain.getContractId());
        } else if (StringUtils.isNotBlankLoop((String[])new String[]{ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode()})) {
            oldOcContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode()}));
        }
        if (null == oldOcContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContract ocContract = this.makeContract(ocContractDomain, oldOcContract);
        this.updateContractModel(ocContract);
    }

    @Override
    public void updateContractReById(OcContractReDomain ocContractReDomain) throws ApiException {
        String msg = this.checkContract(ocContractReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.checkContract", msg);
        }
        OcContract oldOcContract = null;
        if (ocContractReDomain.getContractId() != null) {
            oldOcContract = this.getContractModelById(ocContractReDomain.getContractId());
        } else if (StringUtils.isNotBlankLoop((String[])new String[]{ocContractReDomain.getContractBillcode(), ocContractReDomain.getTenantCode()})) {
            oldOcContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractReDomain.getContractBillcode(), ocContractReDomain.getTenantCode()}));
        }
        if (null == oldOcContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContract ocContract = this.makeContract(ocContractReDomain, oldOcContract);
        this.updateContractModel(ocContract);
    }

    static {
        lock = new Object();
    }
}

