/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcRefundMapper;
import com.yqbsoft.laser.service.contract.domain.DisChannelsendDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractproDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundCtrlCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundCtrlDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundFileDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundPmGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundSettlDomain;
import com.yqbsoft.laser.service.contract.domain.OcSendcontractDataDomain;
import com.yqbsoft.laser.service.contract.engine.RefundPollThread;
import com.yqbsoft.laser.service.contract.engine.RefundPutThread;
import com.yqbsoft.laser.service.contract.engine.RefundService;
import com.yqbsoft.laser.service.contract.enumc.RefundState;
import com.yqbsoft.laser.service.contract.enumc.RefundType;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.model.OcContractpro;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcRefundCtrl;
import com.yqbsoft.laser.service.contract.model.OcRefundFile;
import com.yqbsoft.laser.service.contract.model.OcRefundGoods;
import com.yqbsoft.laser.service.contract.model.OcRefundPmGoods;
import com.yqbsoft.laser.service.contract.model.OcRefundSettl;
import com.yqbsoft.laser.service.contract.model.OcSendcontractApi;
import com.yqbsoft.laser.service.contract.model.OcSendcontractApiconf;
import com.yqbsoft.laser.service.contract.model.OcSendcontractData;
import com.yqbsoft.laser.service.contract.model.PtePtrade;
import com.yqbsoft.laser.service.contract.model.PtradeBackBean;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcContractproService;
import com.yqbsoft.laser.service.contract.service.OcRefundCtrlService;
import com.yqbsoft.laser.service.contract.service.OcRefundFileService;
import com.yqbsoft.laser.service.contract.service.OcRefundPmGoodsService;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.contract.service.OcRefundSettlService;
import com.yqbsoft.laser.service.contract.service.OcSendDataBaseService;
import com.yqbsoft.laser.service.contract.service.OcSendcontractApiService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundServiceImpl
extends BaseServiceImpl
implements OcRefundService {
    public static final String SYS_CODE = "oc.CONTRACT.OcRefundServiceImpl";
    private static RefundService refundService;
    private static Object lock;
    private OcRefundMapper ocRefundMapper;
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    private OcRefundSettlService ocRefundSettlService;
    private OcRefundFileService ocRefundFileService;
    private OcContractService ocContractService;
    private OcSendcontractApiService ocSendcontractApiService;
    private OcSendDataBaseService ocSendDataBaseService;
    OcRefundCtrlService ocRefundCtrlService;
    private OcRefundPmGoodsService ocRefundPmGoodsService;
    OcContractproService ocContractproService;

    public OcRefundPmGoodsService getOcRefundPmGoodsService() {
        return this.ocRefundPmGoodsService;
    }

    public void setOcRefundPmGoodsService(OcRefundPmGoodsService ocRefundPmGoodsService) {
        this.ocRefundPmGoodsService = ocRefundPmGoodsService;
    }

    public static void setRefundService(RefundService refundService) {
        OcRefundServiceImpl.refundService = refundService;
    }

    public void setOcRefundCtrlService(OcRefundCtrlService ocRefundCtrlService) {
        this.ocRefundCtrlService = ocRefundCtrlService;
    }

    public OcSendDataBaseService getOcSendDataBaseService() {
        if (null == this.ocSendDataBaseService) {
            this.ocSendDataBaseService = (OcSendDataBaseService)SpringApplicationContextUtil.getBean((String)"ocSendDataBaseService");
        }
        return this.ocSendDataBaseService;
    }

    public OcContractproService getContractproService() {
        if (null == this.ocContractproService) {
            this.ocContractproService = (OcContractproService)SpringApplicationContextUtil.getBean((String)"ocContractproService");
        }
        return this.ocContractproService;
    }

    public void setOcSendcontractApiService(OcSendcontractApiService ocSendcontractApiService) {
        this.ocSendcontractApiService = ocSendcontractApiService;
    }

    public OcContractService getOcContractService() {
        return this.ocContractService;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public OcRefundFileService getOcRefundFileService() {
        return this.ocRefundFileService;
    }

    public void setOcRefundFileService(OcRefundFileService ocRefundFileService) {
        this.ocRefundFileService = ocRefundFileService;
    }

    public OcRefundSettlService getOcRefundSettlService() {
        return this.ocRefundSettlService;
    }

    public void setOcRefundSettlService(OcRefundSettlService ocRefundSettlService) {
        this.ocRefundSettlService = ocRefundSettlService;
    }

    public void setOcRefundMapper(OcRefundMapper ocRefundMapper) {
        this.ocRefundMapper = ocRefundMapper;
    }

    public void setOcRefundGoodsMapper(OcRefundGoodsMapper ocRefundGoodsMapper) {
        this.ocRefundGoodsMapper = ocRefundGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRefundMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            msg = msg + "RefundType\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundDefault(OcRefund ocRefund) {
        if (null == ocRefund) {
            return;
        }
        if (null == ocRefund.getDataState()) {
            ocRefund.setDataState(0);
        }
        if (null == ocRefund.getGmtCreate()) {
            ocRefund.setGmtCreate(this.getSysDate());
        }
        ocRefund.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefund.getRefundCode())) {
            ocRefund.setRefundCode(this.getNo(null, OcRefund.class.getSimpleName(), "refundCode", ocRefund.getTenantCode()));
        }
    }

    private int getRefundMaxCode() {
        int code = 0;
        try {
            return this.ocRefundMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundUpdataDefault(OcRefund ocRefund) {
        if (null == ocRefund) {
            return;
        }
        ocRefund.setGmtModified(this.getSysDate());
    }

    private void saveRefundModel(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund) {
            return;
        }
        try {
            this.ocRefundMapper.insert(ocRefund);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundModel.ex", (Throwable)e);
        }
    }

    private OcRefund getRefundModelById(Integer refundId) {
        if (null == refundId) {
            return null;
        }
        try {
            return this.ocRefundMapper.selectByPrimaryKey(refundId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundModelById", (Throwable)e);
            return null;
        }
    }

    public OcRefund getRefundModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRefundModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundModelByCode.num");
        }
    }

    private void deleteRefundModel(Integer refundId) throws ApiException {
        if (null == refundId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.deleteByPrimaryKey(refundId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundModel.num");
        }
    }

    private void updateRefundModel(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund) {
            return;
        }
        try {
            this.ocRefundMapper.updateByPrimaryKeySelective(ocRefund);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundModel.ex", (Throwable)e);
        }
    }

    private void updateStateRefundModel(Integer refundId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundId", refundId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        this.logger.error("oc.CONTRACT.OcRefundServiceImplupdateStateRefundModel====" + map);
        int i = 0;
        try {
            i = this.ocRefundMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundModel.null");
        }
        this.logger.error("oc.CONTRACT.OcRefundServiceImplupdateStateRefundModel!!!!!!!!!" + i);
    }

    private OcRefund makeRefund(OcRefundDomain ocRefundDomain, OcRefund ocRefund) {
        if (null == ocRefundDomain) {
            return null;
        }
        if (null == ocRefund) {
            ocRefund = new OcRefund();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefund, (Object)ocRefundDomain);
            return ocRefund;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeRefund", (Throwable)e);
            return null;
        }
    }

    private List<OcRefund> queryRefundModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.queryRefundModel", (Throwable)e);
            return null;
        }
    }

    private int countRefund(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.countRefund", (Throwable)e);
        }
        return i;
    }

    private String checkRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) {
        if (null == ocRefundGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsCode())) {
            msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundGoodsDefault(OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoods) {
            return;
        }
        if (null == ocRefundGoods.getDataState()) {
            ocRefundGoods.setDataState(0);
        }
        if (null == ocRefundGoods.getGmtCreate()) {
            ocRefundGoods.setGmtCreate(this.getSysDate());
        }
        ocRefundGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefundGoods.getRefundGoodsCode())) {
            ocRefundGoods.setRefundGoodsCode(this.createUUIDString());
        }
    }

    private int getRefundGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocRefundGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundGoodsUpdataDefault(OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoods) {
            return;
        }
        ocRefundGoods.setGmtModified(this.getSysDate());
    }

    private void saveRefundGoodsModel(OcRefundGoods ocRefundGoods) throws ApiException {
        if (null == ocRefundGoods) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.insert(ocRefundGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveBatchRefundGoodsModel(List<OcRefundGoods> ocRefundGoodsList) throws ApiException {
        if (null == ocRefundGoodsList || ocRefundGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.insertBatch(ocRefundGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveBatchRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private OcRefundGoods getRefundGoodsModelById(Integer refundGoodsId) {
        if (null == refundGoodsId) {
            return null;
        }
        try {
            return this.ocRefundGoodsMapper.selectByPrimaryKey(refundGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcRefundGoods getRefundGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRefundGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundGoodsModelByCode.num");
        }
    }

    private void deleteRefundGoodsModel(Integer refundGoodsId) throws ApiException {
        if (null == refundGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.deleteByPrimaryKey(refundGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundGoodsModel.num");
        }
    }

    private void updateRefundGoodsModel(OcRefundGoods ocRefundGoods) throws ApiException {
        if (null == ocRefundGoods) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.updateByPrimaryKeySelective(ocRefundGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateRefundGoodsModel(Integer refundGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundGoodsId", refundGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundGoodsModel.null");
        }
    }

    private OcRefundGoods makeRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain, OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoodsDomain) {
            return null;
        }
        if (null == ocRefundGoods) {
            ocRefundGoods = new OcRefundGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundGoods, (Object)ocRefundGoodsDomain);
            return ocRefundGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeRefundGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcRefundGoods> queryRefundGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.queryRefundGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countRefundGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.countRefundGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public OcSendcontractData saveRefundRe(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.saveRefundModle(ocRefundDomain);
        if (null == ocRefund) {
            return null;
        }
        return this.saveSendcontractDataRe(ocRefund, "add");
    }

    @Override
    public OcRefund saveRefundre(OcRefundDomain ocRefundDomain) throws ApiException {
        return this.saveRefundModle(ocRefundDomain);
    }

    @Override
    public String saveBatchRefund(List<OcRefundDomain> ocRefundDomainList) throws ApiException {
        if (ListUtil.isEmpty(ocRefundDomainList)) {
            return null;
        }
        String code = null;
        for (OcRefundDomain ocRefundDomain : ocRefundDomainList) {
            code = this.saveRefund(ocRefundDomain);
        }
        return code;
    }

    @Override
    public String saveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.saveRefundModle(ocRefundDomain);
        return ocRefund.getRefundCode();
    }

    private OcRefund saveRefundModle(OcRefundDomain ocRefundDomain) {
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefund.checkRefund", msg);
        }
        OcRefund ocRefund = this.makeRefund(ocRefundDomain, null);
        this.setRefundDefault(ocRefund);
        this.saveRefundModel(ocRefund);
        String refundCtrlSeqno = this.saveOcRefundCtrl(ocRefund);
        this.saveBatchRefundGoods(ocRefundDomain.getOcRefundGoodsDomainList(), ocRefund);
        if (null != ocRefundDomain.getOcRefundFileDomainList() && !ocRefundDomain.getOcRefundFileDomainList().isEmpty()) {
            this.saveBatchFile(ocRefundDomain.getOcRefundFileDomainList(), ocRefund);
        }
        if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundSettlDomainList())) {
            for (OcRefundSettlDomain ocRefundSettlDomain : ocRefundDomain.getOcRefundSettlDomainList()) {
                ocRefundSettlDomain.setRefundCode(ocRefund.getRefundCode());
            }
            this.ocRefundSettlService.saveRefundSettlBatch(ocRefundDomain.getOcRefundSettlDomainList());
        }
        ocRefundDomain.setRefundCtrlSeqno(refundCtrlSeqno);
        ocRefundDomain.setRefundCode(ocRefund.getRefundCode());
        ocRefundDomain.setRefundId(ocRefund.getRefundId());
        return ocRefund;
    }

    private String saveOcRefundCtrl(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundCtrlDomain ocRefundCtrlDomain = this.createOcRefundCtrlDomain(ocRefund);
        if (null == ocRefundCtrlDomain) {
            return null;
        }
        return this.ocRefundCtrlService.saveRefundCtrl(ocRefundCtrlDomain);
    }

    private OcRefundCtrlDomain createOcRefundCtrlDomain(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundCtrlDomain ocRefundCtrlDomain = new OcRefundCtrlDomain();
        ocRefundCtrlDomain.setRefundCode(ocRefund.getRefundCode());
        ocRefundCtrlDomain.setTenantCode(ocRefund.getTenantCode());
        ocRefundCtrlDomain.setContractBbillcode(ocRefund.getContractBbillcode());
        ocRefundCtrlDomain.setContractBillcode(ocRefund.getContractBillcode());
        return ocRefundCtrlDomain;
    }

    private void saveBatchFile(List<OcRefundFileDomain> ocRefundFileDomainList, OcRefund ocRefund) {
        if (null == ocRefundFileDomainList || ocRefundFileDomainList.isEmpty() || null == ocRefund) {
            return;
        }
        String tenantCode = ocRefund.getTenantCode();
        for (OcRefundFileDomain ocRefundFileDomain : ocRefundFileDomainList) {
            ocRefundFileDomain.setRefundCode(ocRefund.getRefundCode());
            ocRefundFileDomain.setTenantCode(tenantCode);
            ocRefundFileDomain.setContractBillcode(ocRefund.getContractBillcode());
        }
        this.ocRefundFileService.saveRefundFileBatch(ocRefundFileDomainList);
    }

    @Override
    public OcSendcontractData updateRefundState(Integer refundId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundModel(refundId, dataState, oldDataState);
        OcRefund ocRefund = this.getRefundModelById(refundId);
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    private OcSendcontractData saveSendcontractDataRe(OcRefund ocRefund, String sendcontractDataType) {
        if (null == ocRefund) {
            return null;
        }
        OcSendcontractDataDomain ocSendcontractDataDomain = new OcSendcontractDataDomain();
        ocSendcontractDataDomain.setAppmanageIcode(ocRefund.getAppmanageIcode());
        ocSendcontractDataDomain.setMemberBcode(ocRefund.getMemberBcode());
        ocSendcontractDataDomain.setMemberBname(ocRefund.getMemberBname());
        ocSendcontractDataDomain.setMemberCcode(ocRefund.getMemberCcode());
        ocSendcontractDataDomain.setMemberCname(ocRefund.getMemberCname());
        ocSendcontractDataDomain.setMemberCode(ocRefund.getMemberCode());
        ocSendcontractDataDomain.setMemberName(ocRefund.getMemberName());
        ocSendcontractDataDomain.setSendcontractDataOpcode(ocRefund.getRefundCode());
        ocSendcontractDataDomain.setSendcontractDataType(sendcontractDataType);
        ocSendcontractDataDomain.setTenantCode(ocRefund.getTenantCode());
        return this.getOcSendDataBaseService().synSendcontractDataRe(ocSendcontractDataDomain);
    }

    @Override
    public void updateRefund(OcRefundReDomain ocRefundDomain) throws ApiException {
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefund.checkRefund", msg);
        }
        OcRefund oldOcRefund = this.getRefundModelById(ocRefundDomain.getRefundId());
        if (null == oldOcRefund) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefund.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateRefundModel(ocRefundDomain.getRefundId(), oldOcRefund.getDataState(), oldOcRefund.getDataState());
        OcRefund ocRefund = this.makeRefund(ocRefundDomain, oldOcRefund);
        this.setRefundUpdataDefault(ocRefund);
        this.updateRefundModel(ocRefund);
    }

    @Override
    public OcRefundReDomain getRefund(Integer refundId) {
        return this.makeOcRefundDomain(this.getRefundModelById(refundId));
    }

    private OcRefundReDomain makeOcRefundDomainRe(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundReDomain ocRefundReDomain = new OcRefundReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundReDomain, (Object)ocRefund);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeOcRefundDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", ocRefund.getRefundCode());
        map.put("tenantCode", ocRefund.getTenantCode());
        QueryResult<OcRefundFile> qlist = this.ocRefundFileService.queryRefundFilePage(map);
        if (null != qlist) {
            ocRefundReDomain.setOcRefundFileDomainList(this.makeFileDomain(qlist.getList()));
        }
        ocRefundReDomain.setOcRefundGoodsDomainList(this.makeGoodsDomain(this.queryRefundGoodsModelPage(map)));
        ocRefundReDomain.setOcRefundSettlDomainList(this.makeSettlDomain(map));
        return ocRefundReDomain;
    }

    private List<OcRefundFileDomain> makeFileDomain(List<OcRefundFile> ocRefundFileList) {
        if (ListUtil.isEmpty(ocRefundFileList)) {
            return null;
        }
        ArrayList<OcRefundFileDomain> ocRefundFileDomainList = new ArrayList<OcRefundFileDomain>();
        for (OcRefundFile ocRefundFile : ocRefundFileList) {
            OcRefundFileDomain ocRefundFileDomain = new OcRefundFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundFileDomain, (Object)ocRefundFile);
                ocRefundFileDomainList.add(ocRefundFileDomain);
            }
            catch (Exception exception) {}
        }
        return ocRefundFileDomainList;
    }

    private List<OcRefundGoodsDomain> makeGoodsDomain(List<OcRefundGoods> ocRefundGoodsList) {
        if (ListUtil.isEmpty(ocRefundGoodsList)) {
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OcRefundGoods ocRefundGoods : ocRefundGoodsList) {
            OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocRefundGoods);
                map.put("tenantCode", ocRefundGoodsDomain.getTenantCode());
                map.put("refundGoodsCode", ocRefundGoodsDomain.getRefundGoodsCode());
                QueryResult<OcRefundPmGoods> ocRefundPmGoodsQueryResult = this.ocRefundPmGoodsService.queryRefundPmGoodsPage(map);
                if (ListUtil.isNotEmpty((Collection)ocRefundPmGoodsQueryResult.getList())) {
                    ocRefundGoodsDomain.setOcRefundPmGoodsDomainList(this.makeFundPmGoodsDomain(ocRefundPmGoodsQueryResult.getList()));
                }
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
            catch (Exception exception) {}
        }
        return ocRefundGoodsDomainList;
    }

    private List<OcRefundSettlDomain> makeSettlDomain(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        ArrayList<OcRefundSettlDomain> ocRefundSettlDomains = new ArrayList<OcRefundSettlDomain>();
        QueryResult<OcRefundSettl> ocRefundSettlQueryResult = this.ocRefundSettlService.queryRefundSettlPage(map);
        if (ListUtil.isNotEmpty((Collection)ocRefundSettlQueryResult.getList())) {
            for (OcRefundSettl ocRefundGoods : ocRefundSettlQueryResult.getList()) {
                OcRefundSettlDomain ocRefundSettlDomain = new OcRefundSettlDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundSettlDomain, (Object)ocRefundGoods);
                    ocRefundSettlDomains.add(ocRefundSettlDomain);
                }
                catch (Exception exception) {}
            }
        }
        return ocRefundSettlDomains;
    }

    private List<OcRefundPmGoodsDomain> makeFundPmGoodsDomain(List<OcRefundPmGoods> ocRefundPmGoodsDomainList) {
        if (ListUtil.isEmpty(ocRefundPmGoodsDomainList)) {
            return null;
        }
        ArrayList<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList1 = new ArrayList<OcRefundPmGoodsDomain>();
        for (OcRefundPmGoods ocRefundPmGoodsDomain1 : ocRefundPmGoodsDomainList) {
            OcRefundPmGoodsDomain ocRefundPmGoodsDomain = new OcRefundPmGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundPmGoodsDomain, (Object)ocRefundPmGoodsDomain1);
                ocRefundPmGoodsDomainList1.add(ocRefundPmGoodsDomain);
            }
            catch (Exception exception) {}
        }
        return ocRefundPmGoodsDomainList1;
    }

    private OcRefundReDomain makeOcRefundDomain(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundReDomain ocRefundReDomain = new OcRefundReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundReDomain, (Object)ocRefund);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeOcRefundDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", ocRefund.getRefundCode());
        map.put("tenantCode", ocRefund.getTenantCode());
        QueryResult<OcRefundFile> qlist = this.ocRefundFileService.queryRefundFilePage(map);
        QueryResult<OcRefundGoods> ocRefundGoodsQueryResult = this.queryRefundGoodsPage(map);
        if (null != qlist) {
            ocRefundReDomain.setOcRefundFileList(qlist.getRows());
        }
        if (null != ocRefundGoodsQueryResult) {
            ocRefundReDomain.setOcRefundGoodsList(ocRefundGoodsQueryResult.getRows());
        }
        ocRefundReDomain.setOcRefundGoodsList(this.queryRefundGoodsModelPage(map));
        return ocRefundReDomain;
    }

    private List<OcRefundReDomain> makeOcRefundReDomainList(List<OcRefund> ocRefundList, Map<String, Object> map) {
        if (ListUtil.isEmpty(ocRefundList)) {
            return null;
        }
        ArrayList<OcRefundReDomain> refundReDomainList = new ArrayList<OcRefundReDomain>();
        boolean ocContractProFlag = null == map.get("ocContractProFlag") ? false : Boolean.valueOf(map.get("ocContractProFlag").toString());
        boolean ocContractGoodsFlag = null == map.get("ocContractGoodsFlag") ? false : Boolean.valueOf(map.get("ocContractGoodsFlag").toString());
        for (OcRefund ocRefund : ocRefundList) {
            OcRefundReDomain ocRefundReDomain = this.makeOcRefundDomain(ocRefund);
            if (ocContractProFlag) {
                this.queryContractpro(ocRefundReDomain);
            }
            if (ocContractGoodsFlag) {
                this.queryContractGoods(ocRefundReDomain);
            }
            refundReDomainList.add(ocRefundReDomain);
        }
        return refundReDomainList;
    }

    void queryContractGoods(OcRefundReDomain ocRefundReDomain) {
        List<OcRefundGoods> ocRefundGoodsList = ocRefundReDomain.getOcRefundGoodsList();
        if (ListUtil.isEmpty(ocRefundGoodsList)) {
            return;
        }
        ArrayList<OcContractGoodsDomain> list = new ArrayList<OcContractGoodsDomain>();
        for (OcRefundGoods ocRefundGoods : ocRefundGoodsList) {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            if (null == ocRefundGoods.getContractGoodsCode()) continue;
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            parammap.put("contractGoodsCode", ocRefundGoods.getContractGoodsCode());
            parammap.put("tenantCode", ocRefundGoods.getTenantCode());
            OcContractGoods ocContractGoods = this.ocContractService.getContractGoodsByCode(parammap);
            try {
                BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocContractGoodsDomain.setContractGoodsRefnum(ocRefundGoods.getRefundGoodsNum());
            list.add(ocContractGoodsDomain);
        }
        ocRefundReDomain.setGoodsList(list);
    }

    void queryContractpro(OcRefundReDomain ocRefundReDomain) {
        List<OcContractpro> proList = this.getContractproService().querycontractproByOrderCode(ocRefundReDomain.getTenantCode(), ocRefundReDomain.getContractBillcode());
        ocRefundReDomain.setOcContractproDomainList(this.makeOcContractproDomainList(proList));
    }

    private List<OcContractproDomain> makeOcContractproDomainList(List<OcContractpro> ocContractproList) {
        if (null == ocContractproList || ocContractproList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractproDomain> list = new ArrayList<OcContractproDomain>();
        for (OcContractpro ocContractpro : ocContractproList) {
            list.add(this.makeOcContractproDomain(ocContractpro));
        }
        return list;
    }

    private OcContractproDomain makeOcContractproDomain(OcContractpro OcContractpro2) {
        if (null == OcContractpro2) {
            return null;
        }
        OcContractproDomain ocContractproDomain = new OcContractproDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractproDomain, (Object)OcContractpro2);
            return ocContractproDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeOcContractproDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteRefund(Integer refundId) throws ApiException {
        this.deleteRefundModel(refundId);
    }

    @Override
    public QueryResult<OcRefund> queryRefundPage(Map<String, Object> map) {
        List<OcRefund> ocRefundList = this.queryRefundModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefund(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundList);
        return queryResult;
    }

    @Override
    public QueryResult<OcRefundReDomain> queryRefundReDomainPage(Map<String, Object> map) {
        int count = this.countRefund(map);
        List<Object> ocRefundList = new ArrayList();
        if (count > 0) {
            ocRefundList = this.queryRefundReDomainModelPage(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefund(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundList);
        return queryResult;
    }

    private List<OcRefundReDomain> queryRefundReDomainModelPage(Map<String, Object> map) {
        List<OcRefund> ocRefundList = this.queryRefundModelPage(map);
        return this.makeOcRefundReDomainList(ocRefundList, map);
    }

    @Override
    public OcRefundReDomain getRefundByCode(Map<String, Object> map) {
        return this.makeOcRefundDomain(this.getRefundModelByCode(map));
    }

    @Override
    public OcRefundReDomain getRefundDomainByCode(Map<String, Object> map) {
        return this.makeOcRefundDomainRe(this.getRefundModelByCode(map));
    }

    @Override
    public void delRefundByCode(Map<String, Object> map) throws ApiException {
        this.delRefundModelByCode(map);
    }

    @Override
    public String saveRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) throws ApiException {
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain);
        this.saveRefundGoodsModel(ocRefundGoods);
        return ocRefundGoods.getRefundGoodsCode();
    }

    private void saveBatchRefundGoods(List<OcRefundGoodsDomain> ocRefundGoodsDomainList, OcRefund ocRefund) {
        if (null == ocRefundGoodsDomainList || ocRefundGoodsDomainList.isEmpty() || null == ocRefund) {
            return;
        }
        ArrayList<OcRefundGoods> ocRefundGoodsList = new ArrayList<OcRefundGoods>();
        ArrayList<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList = new ArrayList<OcRefundPmGoodsDomain>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            ocRefundGoodsDomain.setRefundCode(ocRefund.getRefundCode());
            ocRefundGoodsDomain.setContractBillcode(ocRefund.getContractBillcode());
            OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain);
            ocRefundGoodsList.add(ocRefundGoods);
            if (!ListUtil.isNotEmpty(ocRefundGoodsDomain.getOcRefundPmGoodsDomainList())) continue;
            for (OcRefundPmGoodsDomain ocRefundPmGoodsDomain : ocRefundGoodsDomain.getOcRefundPmGoodsDomainList()) {
                ocRefundPmGoodsDomain.setContractBillcode(ocRefundGoodsDomain.getContractBillcode());
                ocRefundPmGoodsDomain.setContractGoodsCode(ocRefundGoodsDomain.getContractGoodsCode());
                ocRefundPmGoodsDomain.setRefundGoodsCode(ocRefundGoods.getRefundGoodsCode());
                ocRefundPmGoodsDomain.setRefundBillcode(ocRefund.getRefundCode());
                ocRefundPmGoodsDomainList.add(ocRefundPmGoodsDomain);
            }
        }
        if (ListUtil.isNotEmpty(ocRefundPmGoodsDomainList)) {
            this.ocRefundPmGoodsService.saveRefundPmGoodsBatch(ocRefundPmGoodsDomainList);
        }
        this.saveBatchRefundGoodsModel(ocRefundGoodsList);
    }

    private OcRefundGoods makeRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) {
        String msg = this.checkRefundGoods(ocRefundGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundGoods.checkRefundGoods", msg);
        }
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain, null);
        this.setRefundGoodsDefault(ocRefundGoods);
        return ocRefundGoods;
    }

    @Override
    public void updateRefundGoodsState(Integer refundGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundGoodsModel(refundGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) throws ApiException {
        String msg = this.checkRefundGoods(ocRefundGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoods.checkRefundGoods", msg);
        }
        OcRefundGoods oldOcRefundGoods = this.getRefundGoodsModelById(ocRefundGoodsDomain.getRefundGoodsId());
        if (null == oldOcRefundGoods) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain, oldOcRefundGoods);
        this.setRefundGoodsUpdataDefault(ocRefundGoods);
        this.updateRefundGoodsModel(ocRefundGoods);
    }

    @Override
    public OcRefundGoods getRefundGoods(Integer refundGoodsId) {
        return this.getRefundGoodsModelById(refundGoodsId);
    }

    @Override
    public void deleteRefundGoods(Integer refundGoodsId) throws ApiException {
        this.deleteRefundGoodsModel(refundGoodsId);
    }

    @Override
    public QueryResult<OcRefundGoods> queryRefundGoodsPage(Map<String, Object> map) {
        List<OcRefundGoods> ocRefundGoodsList = this.queryRefundGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefundGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundGoodsList);
        return queryResult;
    }

    @Override
    public OcRefundGoods getRefundGoodsByCode(Map<String, Object> map) {
        return this.getRefundGoodsModelByCode(map);
    }

    @Override
    public void delRefundGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delRefundGoodsModelByCode(map);
    }

    @Override
    public OcSendcontractData updateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        Integer oldDatastate = ocRefund.getDataState();
        Integer datastate = 0;
        if (oldDatastate == RefundState.APPLY.getCode()) {
            datastate = RefundState.REVOKE.getCode();
        } else if (oldDatastate == RefundState.SEND.getCode()) {
            datastate = RefundState.RESGOODS.getCode();
        } else {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.refundDataState." + oldDatastate, "\u9000\u8d27\u5355\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c~");
        }
        this.updateStateRefundModel(ocRefund.getRefundId(), datastate, ocRefund.getDataState());
        this.saveContractRes(qmap);
        ocRefund.setDataState(datastate);
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    @Override
    public OcSendcontractData updateRefundRefuse(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        Integer oldDatastate = ocRefund.getDataState();
        Integer datastate = 0;
        if (oldDatastate == RefundState.APPLY.getCode()) {
            datastate = RefundState.RESAPP.getCode();
        } else if (oldDatastate == RefundState.SEND.getCode()) {
            datastate = RefundState.RESGOODS.getCode();
        } else {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.refundDataState." + oldDatastate, "\u9000\u8d27\u5355\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c~");
        }
        this.updateStateRefundModel(ocRefund.getRefundId(), datastate, ocRefund.getDataState());
        this.saveContractRes(qmap);
        ocRefund.setDataState(datastate);
        ocRefund.setMemo((String)map.get("memo"));
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    private void saveContractRes(Map<String, Object> qmap) {
        if (null == qmap || qmap.isEmpty()) {
            return;
        }
        List<OcRefundGoods> rlist = this.queryRefundGoodsModelPage(qmap);
        if (null == rlist || rlist.isEmpty()) {
            return;
        }
        for (OcRefundGoods ocRefundGoods : rlist) {
            if (null != ocRefundGoods.getGoodsCamount()) {
                ocRefundGoods.setGoodsCamount(ocRefundGoods.getGoodsCamount().multiply(new BigDecimal(-1)));
            }
            if (null != ocRefundGoods.getGoodsCweight()) {
                ocRefundGoods.setGoodsCweight(ocRefundGoods.getGoodsCweight().multiply(new BigDecimal(-1)));
            }
            this.ocContractService.updateContractGoodsAndRefund(ocRefundGoods.getTenantCode(), ocRefundGoods.getContractGoodsCode(), ocRefundGoods.getGoodsCamount(), ocRefundGoods.getGoodsCweight(), 0);
        }
    }

    @Override
    public OcSendcontractData saveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundPay.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundPay.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        this.updateStateRefundModel(ocRefund.getRefundId(), RefundState.SUC.getCode(), ocRefund.getDataState());
        ocRefund.setDataState(RefundState.SUC.getCode());
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    @Override
    public Map<String, Object> sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        return this.updateRefundPass(refundCode, tenantCode, map);
    }

    @Override
    public Map<String, Object> updateRefundPass(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728" + qmap);
        }
        String type = ocRefund.getRefundType();
        Integer oldDatastate = ocRefund.getDataState();
        if (null != map && !map.isEmpty()) {
            OcRefund newOcRefund = new OcRefund();
            newOcRefund.setRefundId(ocRefund.getRefundId());
            try {
                BeanUtils.copyAllPropertys((Object)newOcRefund, map);
            }
            catch (Exception e) {
                throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.e", (Throwable)e);
            }
            this.updateRefundModel(newOcRefund);
        }
        Integer dataState = 0;
        boolean pay = false;
        if (type.equals(RefundType.REFMONEY.getCode()) && oldDatastate == RefundState.APPLY.getCode()) {
            dataState = RefundState.PASS.getCode();
            pay = true;
        } else if (type.equals(RefundType.REFGOODS.getCode()) && oldDatastate == RefundState.ARR.getCode()) {
            pay = true;
            dataState = RefundState.PLAT.getCode();
        } else {
            dataState = oldDatastate + 1;
        }
        ocRefund.setDataState(dataState);
        this.updateStateRefundModel(ocRefund.getRefundId(), dataState, oldDatastate);
        boolean flag = true;
        if (pay) {
            this.ocContractService.updateContractRefund(tenantCode, ocRefund.getContractBillcode(), ocRefund.getContractState());
            if (null == ocRefund.getRefundMoney()) {
                flag = false;
            } else {
                int r = ocRefund.getRefundMoney().compareTo(BigDecimal.ZERO);
                if (r <= 0) {
                    flag = false;
                }
            }
        }
        ocRefund.setDataState(dataState);
        OcSendcontractData ocSendcontractData = this.saveSendcontractDataRe(ocRefund, "update");
        HashMap<String, Object> remap = new HashMap<String, Object>();
        remap.put("ocSendcontractData", ocSendcontractData);
        if (flag) {
            remap.put("ocRefund", ocRefund);
        }
        return remap;
    }

    @Override
    public String updatePay(String refundCode, String type, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        Map map = this.getQueryMapParam("refundCode,tenantCode", new Object[]{refundCode, tenantCode});
        OcRefund ocRefund = this.getRefundModelByCode(map);
        if (null == ocRefund) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updatePay.ocRefund", map.toString());
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefund.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefund.getContractBbillcode());
        ptradeBackBean.setBusinessOrder(ocRefund.getContractBillcode());
        ptradeBackBean.setBusinessOrderno(ocRefund.getContractBbillcode());
        ptradeBackBean.setPtradeSeqno(ocRefund.getPtradeSeqno());
        ptradeBackBean.setTenantCode(ocRefund.getTenantCode());
        ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney());
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refundEngine.sendSaveRefundPay");
        ptradeBackBean.setBackAmountType(type);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            return "error";
        }
        Map parMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocRefund.getContractBillcode(), tenantCode});
        OcContractReDomain contractByCode = this.ocContractService.getContractByCode(parMap);
        if (null == contractByCode) {
            return "error";
        }
        if (null == contractByCode.getRefundMoney()) {
            contractByCode.setRefundMoney(BigDecimal.ZERO);
        }
        contractByCode.setRefundMoney(contractByCode.getRefundMoney().add(ocRefund.getRefundMoney()));
        this.ocContractService.updateContract(contractByCode);
        return "success";
    }

    private String payOutDataContract(OcRefundDomain ocRefundDomain) {
        String apiCode = "data.dataInDataPingan.payOutDataContract";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    @Override
    public String updatePayAndGift(String refundCode, String type, String tenantCode) throws ApiException {
        OcRefundDomain ocRefundDomain;
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        Map map = this.getQueryMapParam("refundCode,tenantCode", new Object[]{refundCode, tenantCode});
        OcRefund ocRefund = this.getRefundModelByCode(map);
        if (null == ocRefund) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updatePay.ocRefund", map.toString());
        }
        if ("3".equals(ocRefund.getRefundUsertype())) {
            ocRefund.setRefundAudate(new Date());
            if (!"B20".equals(ocRefund.getRefundType())) {
                ocRefund.setMemo("\u4e0b\u535530\u5206\u949f\u5185\u81ea\u52a8\u5ba1\u6838");
            }
            try {
                ocRefundDomain = new OcRefundReDomain();
                BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocRefund);
                this.updateRefund((OcRefundReDomain)ocRefundDomain);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ("\u6cb3\u5317\u94a2\u94c1".equals(ocRefund.getMemberName()) || "\u6d4b\u8bd5-\u8001\u72fc\u516c\u53f8".equals(ocRefund.getMemberName())) {
            try {
                ocRefundDomain = new OcRefundDomain();
                BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocRefund);
                this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updatePayAndGift============>");
                String payOutDataContract = this.payOutDataContract(ocRefundDomain);
                this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updatePayAndGift.payOutDataContract", (Object)payOutDataContract);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return "success";
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefund.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefund.getContractBbillcode());
        ptradeBackBean.setBusinessOrder(ocRefund.getContractBillcode());
        ptradeBackBean.setBusinessOrderno(ocRefund.getContractBbillcode());
        ptradeBackBean.setPtradeSeqno(ocRefund.getPtradeSeqno());
        ptradeBackBean.setTenantCode(ocRefund.getTenantCode());
        if ("08".equals(ocRefund.getContractType())) {
            String error = this.makeRefundMoney(ocRefund, ptradeBackBean);
            if (error != null) {
                return error;
            }
        } else {
            ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney());
        }
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refundEngine.sendSaveRefundPay");
        ptradeBackBean.setBackAmountType(type);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            return "error";
        }
        Map parMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocRefund.getContractBillcode(), tenantCode});
        OcContractReDomain contractByCode = this.ocContractService.getContractByCode(parMap);
        if (null == contractByCode) {
            return "error";
        }
        if (null == contractByCode.getRefundMoney()) {
            contractByCode.setRefundMoney(BigDecimal.ZERO);
        }
        contractByCode.setRefundMoney(contractByCode.getRefundMoney().add(ocRefund.getRefundMoney()));
        this.ocContractService.updateContract(contractByCode);
        return "success";
    }

    private String makeRefundMoney(OcRefund ocRefund, PtradeBackBean ptradeBackBean) {
        BigDecimal refundMoneySum = BigDecimal.ZERO;
        HashMap<String, String> payMap = new HashMap<String, String>();
        payMap.put("tenantCode", ocRefund.getTenantCode());
        payMap.put("ptradeSeqno", ocRefund.getPtradeSeqno());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(payMap));
        String ptePtradeByCodeStr = this.internalInvoke("pte.ptrade.getPtradeByCode", paramMap);
        if (StringUtils.isBlank((String)ptePtradeByCodeStr)) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.ptePtradeByCodeStr", paramMap);
            return "error";
        }
        PtePtrade ptePtradePay = (PtePtrade)JsonUtil.buildNormalBinder().getJsonToObject(ptePtradeByCodeStr, PtePtrade.class);
        if (ptePtradePay == null) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.ptePtradePay", (Object)ptePtradeByCodeStr);
            return "error";
        }
        HashMap<String, Object> refundMap = new HashMap<String, Object>();
        refundMap.put("tenantCode", ocRefund.getTenantCode());
        refundMap.put("ptradeOldseqno", ocRefund.getPtradeSeqno());
        refundMap.put("opuserCode", ocRefund.getMemberBcode());
        refundMap.put("ptradpdeCode", "PAYMENTBACK");
        refundMap.put("dataState", 5);
        HashMap<String, String> paramMap2 = new HashMap<String, String>();
        paramMap2.put("map", JsonUtil.buildNormalBinder().toJson(refundMap));
        String ptePtradeRefundPageStr = this.internalInvoke("pte.ptrade.queryPtradePage", paramMap2);
        if (StringUtils.isBlank((String)ptePtradeRefundPageStr)) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.ptePtradeRefundPageStr", paramMap2);
            return "error";
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(ptePtradeRefundPageStr, QueryResult.class);
        if (queryResult == null) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.queryResult", (Object)ptePtradeRefundPageStr);
            return "error";
        }
        List ptePtradeRefundList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), PtePtrade.class);
        if (ListUtil.isNotEmpty((Collection)ptePtradeRefundList)) {
            for (PtePtrade ptePtrade : ptePtradeRefundList) {
                refundMoneySum = refundMoneySum.add(ptePtrade.getOrderAmount());
            }
        }
        if (refundMoneySum.compareTo(ptePtradePay.getOrderOamount()) == 0) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.refundMoneySum", (Object)refundMoneySum);
            HashMap<String, String> refundNextMap = new HashMap<String, String>();
            refundNextMap.put("tenantCode", ocRefund.getTenantCode());
            refundNextMap.put("refundCode", ocRefund.getRefundCode());
            HashMap<String, Integer> refundNextParam = new HashMap<String, Integer>();
            refundNextParam.put("payDataState", 5);
            refundNextMap.put("map", JsonUtil.buildNormalBinder().toJson(refundNextParam));
            this.internalInvoke("oc.refundEngine.sendRefundNext", refundNextMap);
            return "success";
        }
        refundMoneySum = refundMoneySum.add(ocRefund.getRefundMoney());
        BigDecimal subtract = ptePtradePay.getOrderOamount().subtract(refundMoneySum);
        this.logger.error("oc.CONTRACT.OcRefundServiceImpl.subtract", (Object)subtract);
        this.logger.error("oc.CONTRACT.OcRefundServiceImpl.refundMoneySum", (Object)refundMoneySum);
        if (subtract.compareTo(BigDecimal.ZERO) < 0) {
            ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney().add(subtract));
        } else {
            ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney());
        }
        return null;
    }

    @Override
    public String updateSendRefundPay(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return null;
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefundDomain.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefundDomain.getContractBbillcode());
        ptradeBackBean.setBusinessOrder(ocRefundDomain.getContractBillcode());
        ptradeBackBean.setBusinessOrderno(ocRefundDomain.getContractBbillcode());
        ptradeBackBean.setPtradeSeqno(ocRefundDomain.getPtradeSeqno());
        ptradeBackBean.setTenantCode(ocRefundDomain.getTenantCode());
        ptradeBackBean.setOrderAmount(ocRefundDomain.getRefundMoney());
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refundEngine.sendSaveRefundPay");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            return "error";
        }
        return "success";
    }

    @Override
    public OcSendcontractData updateRefundPay(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefund.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefund.getContractBbillcode());
        ptradeBackBean.setBusinessOrder(ocRefund.getContractBillcode());
        ptradeBackBean.setBusinessOrderno(ocRefund.getContractBbillcode());
        ptradeBackBean.setPtradeSeqno(ocRefund.getPtradeSeqno());
        ptradeBackBean.setTenantCode(ocRefund.getTenantCode());
        ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney());
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refundEngine.sendSaveRefundPay");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        this.updateStateRefundModel(ocRefund.getRefundId(), RefundState.PAY.getCode(), ocRefund.getDataState());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", ocRefund.getRefundCode());
        map.put("tenantCode", ocRefund.getTenantCode());
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPay.null", "");
        }
        ocRefund.setDataState(RefundState.PAY.getCode());
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefundService getRefundService() {
        Object object = lock;
        synchronized (object) {
            if (null == refundService) {
                refundService = new RefundService((OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"));
                refundService.addPollPool(new RefundPollThread(refundService));
            }
            return refundService;
        }
    }

    @Override
    public void loadRefundProcess() {
        this.loadDb();
    }

    @Override
    public boolean sendApiOcRefund(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund || StringUtils.isBlank((String)ocRefund.getMemberBcode()) || StringUtils.isBlank((String)ocRefund.getTenantCode())) {
            return false;
        }
        HashMap<String, Object> apiMap = new HashMap<String, Object>();
        apiMap.put("tenantCode", ocRefund.getTenantCode());
        QueryResult<OcSendcontractApi> userApi = this.ocSendcontractApiService.querySendcontractApiPage(apiMap);
        if (null == userApi || userApi.getList().size() <= 0) {
            return false;
        }
        List userApiList = userApi.getList();
        List<OcSendcontractApi> uApiList = this.structureApi(userApiList, ocRefund);
        if (null == uApiList || uApiList.isEmpty()) {
            return false;
        }
        for (OcSendcontractApi rsRessendApi : uApiList) {
            HashMap<String, OcRefund> paramMap1 = new HashMap<String, OcRefund>();
            paramMap1.put("ocRefund", ocRefund);
            String result = (String)this.getInternalRouter().inInvoke(rsRessendApi.getSendcontractApiapicode(), "1.0", "0", paramMap1);
            if (!StringUtils.isEmpty((String)result) && !"false".equals(result)) continue;
            this.logger.error("\u672a\u6210\u529f\u5904\u7406\u7684api *****" + rsRessendApi.getSendcontractApiCode() + "*****" + ocRefund.getMemberBcode());
            return false;
        }
        return false;
    }

    private void updateRefundStateByCodes(String refundCode, Integer dataState, Integer oldDataState, String tenantCode, Map<String, String> mapStr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("tenantCode", tenantCode);
        if (MapUtil.isNotEmpty(mapStr)) {
            map.putAll(mapStr);
        }
        try {
            this.ocRefundMapper.updateRefundStateByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updateRefundStateByCodes===" + map);
        }
    }

    @Override
    public void updateRefundExamine(Map<String, Object> map, String tenantCode, String refundCode) {
        this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updateRefundExamine2===" + map);
        if (StringUtils.isNotBlank((String)tenantCode) && StringUtils.isNotBlank((String)refundCode)) {
            map.put("tenantCode", tenantCode);
            map.put("refundCode", refundCode);
        }
        try {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updateRefundExamine===" + map);
            this.ocRefundMapper.updateOcRefundExamine(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updateRefundStateByCodes===" + map);
        }
    }

    @Override
    public OcSendcontractData updateRefundStateByCode(String refundCode, Integer dataState, Integer oldDataState, String tenantCode) throws ApiException {
        this.updateRefundStateByCodes(refundCode, dataState, oldDataState, tenantCode, null);
        OcRefund ocRefund = this.getRefundModelByCode(this.getQueryMapParam("refundCode,tenantCode", new Object[]{refundCode, tenantCode}));
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    private List<OcSendcontractApi> structureApi(List<OcSendcontractApi> userApiList, OcRefund ocRefund) {
        ArrayList<OcSendcontractApi> ocSendcontractApiList = new ArrayList<OcSendcontractApi>();
        for (OcSendcontractApi ocSendsendApi : userApiList) {
            List apiconfList;
            Map<String, List<String>> map;
            HashMap<String, Object> apiconfMap = new HashMap<String, Object>();
            apiconfMap.put("sendcontractApiapicode", ocSendsendApi.getSendcontractApiCode());
            apiconfMap.put("tenantCode", ocSendsendApi.getTenantCode());
            QueryResult<OcSendcontractApiconf> apiconf = this.ocSendcontractApiService.querysendcontractApiconfPage(apiconfMap);
            if (null == apiconf || apiconf.getList().size() <= 0) {
                ocSendcontractApiList.add(ocSendsendApi);
            }
            if (null == (map = this.makeScopelist(apiconfList = apiconf.getList())) || map.isEmpty()) continue;
            boolean flag = true;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)ocSendsendApi, (String)key);
                if (null == objValue) {
                    flag = false;
                    break;
                }
                if (map.get(key).contains(objValue)) continue;
                flag = false;
                break;
            }
            if (!flag || ocSendcontractApiList.contains(ocSendsendApi)) continue;
            ocSendcontractApiList.add(ocSendsendApi);
        }
        return ocSendcontractApiList;
    }

    private Map<String, List<String>> makeScopelist(List<OcSendcontractApiconf> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (OcSendcontractApiconf ocSendcontractApiconf : apiconfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(ocSendcontractApiconf.getSendcontractApiconfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(ocSendcontractApiconf.getSendcontractApiconfType(), list);
            }
            list.add(ocSendcontractApiconf.getSendcontractApiconfOp());
        }
        return map;
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", RefundState.ARR.getCode());
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcRefund> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = OcRefundServiceImpl.getRefundService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", OcRefundServiceImpl.getRefundService().getPage());
                result = this.queryRefundPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    OcRefundServiceImpl.getRefundService().addPutPool(new RefundPutThread(OcRefundServiceImpl.getRefundService(), result.getRows()));
                    if (result.getRows().size() == OcRefundServiceImpl.getRefundService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            OcRefundServiceImpl.getRefundService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public OcSendcontractData updateRefundStateByNcode(String refundNcode, String channelCode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)refundNcode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<OcRefund> list = this.queryRefundModelPage(this.getQueryMapParam("refundNcode,channelCode,tenantCode", new Object[]{refundNcode, channelCode, tenantCode}));
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        return this.updateRefundState(list.get(0).getRefundId(), dataState, oldDataState);
    }

    @Override
    public OcRefund getRefundByNcode(String refundNcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)refundNcode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<OcRefund> list = this.queryRefundModelPage(this.getQueryMapParam("refundNcode,channelCode,tenantCode", new Object[]{refundNcode, channelCode, tenantCode}));
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public String sendOcRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.sendOcRefund", (Object)"param is null");
            return "error";
        }
        OcRefundReDomain ocRefundReDomain = this.getRefundDomainByCode(this.getQueryParamMap("refundCode,tenantCode", new Object[]{ocRefundDomain.getRefundCode(), ocRefundDomain.getTenantCode()}));
        if (null == ocRefundReDomain) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.sendOcRefund", (Object)(ocRefundDomain.getRefundCode() + "-" + ocRefundDomain.getTenantCode()));
            return "error";
        }
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        if (null == ocRefundReDomain.getDataState()) {
            ocRefundReDomain.setDataState(0);
        }
        disChannelsendDomain.setChannelsendDir(ocRefundReDomain.getDataState().toString());
        disChannelsendDomain.setChannelsendType("OcRefund");
        disChannelsendDomain.setChannelCode(ocRefundReDomain.getChannelCode());
        disChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)ocRefundReDomain));
        disChannelsendDomain.setTenantCode(ocRefundReDomain.getTenantCode());
        disChannelsendDomainList.add(disChannelsendDomain);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        try {
            this.getInternalRouter().inInvoke("dis.channelsendBase.sendChannelsendBatch", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    @Override
    public void updateExtrinsicStateByRefundCode(String refundCode, String dataOpnextbillstate, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)dataOpnextbillstate) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateBysendgoodsCode.param", (Object)(refundCode + "-" + dataOpnextbillstate + "-" + tenantCode));
            return;
        }
        this.updateExtrinsicStateByCode(this.getQueryParamMap("refundCode,dataOpnextbillstate,tenantCode", new Object[]{refundCode, dataOpnextbillstate, tenantCode}));
    }

    @Override
    public Map<String, Object> queryOcRefundCount(Map<String, Object> map) throws ApiException {
        Map<String, Object> resMap = null;
        try {
            resMap = this.ocRefundMapper.countData(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.queryOcRefundCount.ex", (Throwable)e);
        }
        return resMap;
    }

    public void updateExtrinsicStateByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateByCode.null", "map is null");
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.updateExtrinsicStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateByCode.null");
        }
    }

    @Override
    public void updateRefundFlowState(OcRefundCtrlCflowDomain ocRefundCtrlCflowDomain) throws ApiException {
        if (null == ocRefundCtrlCflowDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocRefundCtrlCflowDomain.getTenantCode());
        map.put("refundCtrlSeqno", ocRefundCtrlCflowDomain.getRefundCtrlSeqno());
        OcRefundCtrl ocRefundCtrl = this.ocRefundCtrlService.getRefundCtrlByCode(map);
        if (null == ocRefundCtrl) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundFlowState.null", "\u6570\u636e\u4e3a\u7a7a" + ((Object)map).toString());
        }
        this.updateRefundStateByCodes(ocRefundCtrl.getRefundCode(), ocRefundCtrlCflowDomain.getDataState(), ocRefundCtrlCflowDomain.getOldDataState(), ocRefundCtrl.getTenantCode(), ocRefundCtrlCflowDomain.getMap());
        this.ocRefundCtrlService.updateRefundCtrlCflow(ocRefundCtrlCflowDomain);
    }

    @Override
    public void sendupdateContract(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.sendOcRefund", (Object)"param is null");
        }
        this.ocContractService.updateContractStateByCode(this.getQueryParamMap("contractBillcode,dataState,tenantCode,oldDataState", new Object[]{ocRefundDomain.getContractBillcode(), -1, ocRefundDomain.getTenantCode(), null}));
    }

    private void updateModelLockByCode(String tenantCode, String refundCode) throws ApiException {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.ocRefundMapper.updateLockByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateModelLockByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateModelLockByCode.null", "params=" + map);
        }
    }

    @Override
    public void updateRefundLockByCode(String refundCode, String tenantCode) throws ApiException {
        this.updateModelLockByCode(tenantCode, refundCode);
    }

    static {
        lock = new Object();
    }
}

