/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmRouterMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmRouterDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppmanage;
import com.yqbsoft.laser.service.esb.appmanage.model.AmRouter;
import com.yqbsoft.laser.service.esb.appmanage.service.AppapiService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppmanageService;
import com.yqbsoft.laser.service.esb.appmanage.service.RouterService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouterServiceImpl
extends BaseServiceImpl
implements RouterService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.RouterServiceImpl";
    private AmRouterMapper amRouterMapper;
    private AppmanageService appmanageService;
    private AppapiService appapiService;

    public void setAppmanageService(AppmanageService appmanageService) {
        this.appmanageService = appmanageService;
    }

    public void setAppapiService(AppapiService appapiService) {
        this.appapiService = appapiService;
    }

    public void setAmRouterMapper(AmRouterMapper amRouterMapper) {
        this.amRouterMapper = amRouterMapper;
    }

    private Date getSysDate() {
        try {
            return this.amRouterMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouterServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRouter(AmRouterDomain amRouterDomain) {
        if (null == amRouterDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setRouterDefault(AmRouter amRouter) {
        if (null == amRouter) {
            return;
        }
        if (null == amRouter.getDataState()) {
            amRouter.setDataState(0);
        }
        if (null == amRouter.getGmtCreate()) {
            amRouter.setGmtCreate(this.getSysDate());
        }
        amRouter.setGmtModified(this.getSysDate());
    }

    private void setRouterUpdataDefault(AmRouter amRouter) {
        if (null == amRouter) {
            return;
        }
        amRouter.setGmtModified(this.getSysDate());
    }

    private void saveRouterModel(AmRouter amRouter) throws ApiException {
        if (null == amRouter) {
            return;
        }
        try {
            this.amRouterMapper.insert(amRouter);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.saveFtpserverModel.ex");
        }
    }

    private AmRouter getRouterModelById(Integer routerId) {
        if (null == routerId) {
            return null;
        }
        try {
            return this.amRouterMapper.selectByPrimaryKey(routerId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouterServiceImpl.getRouterModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteRouterModel(Integer routerId) throws ApiException {
        if (null == routerId) {
            return;
        }
        int i = 0;
        try {
            i = this.amRouterMapper.deleteByPrimaryKey(routerId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.deleteRouterModel.ex");
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.deleteRouterModel.num");
        }
    }

    private void deleteRouterModelByDire(Integer routerDire) throws ApiException {
        if (null == routerDire) {
            return;
        }
        int i = 0;
        try {
            i = this.amRouterMapper.deleteByDire(routerDire);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.deleteRouterModelByDire.ex");
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.deleteRouterModelByDire.num");
        }
    }

    private void updateRouterModel(AmRouter amRouter) throws ApiException {
        if (null == amRouter) {
            return;
        }
        try {
            this.amRouterMapper.updateByPrimaryKeySelective(amRouter);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.updateRouterModel.ex");
        }
    }

    private void updateStateRouterModel(Integer routerId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == routerId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routerId", routerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amRouterMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.updateStateRouterModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.updateStateRouterModel.null");
        }
    }

    private AmRouter makeRouter(AmRouterDomain amRouterDomain, AmRouter amRouter) {
        if (null == amRouterDomain) {
            return null;
        }
        if (null == amRouter) {
            amRouter = new AmRouter();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amRouter, (Object)amRouterDomain);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouterServiceImpl.makeRouter", (Throwable)e);
        }
        return amRouter;
    }

    private List<AmRouter> queryRouterModelPage(Map<String, Object> parammap) {
        try {
            return this.amRouterMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouterServiceImpl.queryRouterModel", (Throwable)e);
            return null;
        }
    }

    private int countRouter(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amRouterMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.RouterServiceImpl.countRouter", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveRouter(AmRouterDomain amRouterDomain) throws ApiException {
        String msg = this.checkRouter(amRouterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.saveRouter.checkRouter", msg);
        }
        AmRouter amRouter = this.makeRouter(amRouterDomain, null);
        this.setRouterDefault(amRouter);
        this.saveRouterModel(amRouter);
    }

    @Override
    public void updateRouterState(Integer routerId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRouterModel(routerId, dataState, oldDataState);
    }

    @Override
    public void updateRouter(AmRouterDomain amRouterDomain) throws ApiException {
        String msg = this.checkRouter(amRouterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.updateRouter.checkRouter", msg);
        }
        AmRouter oldAmRouter = this.getRouterModelById(amRouterDomain.getRouterId());
        if (null == oldAmRouter) {
            throw new ApiException("am.ESB.APPMANAGE.RouterServiceImpl.updateRouter.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmRouter amRouter = this.makeRouter(amRouterDomain, oldAmRouter);
        this.setRouterUpdataDefault(amRouter);
        this.updateRouterModel(amRouter);
    }

    @Override
    public AmRouter getRouter(Integer routerId) {
        return this.getRouterModelById(routerId);
    }

    @Override
    public void deleteRouter(Integer routerId) throws ApiException {
        this.deleteRouterModel(routerId);
    }

    @Override
    public void deleteRouterByDire(Integer routerDire) throws ApiException {
        this.deleteRouterModelByDire(routerDire);
    }

    @Override
    public QueryResult<AmRouter> queryRouterPage(Map<String, Object> map) {
        List<AmRouter> amRouterList = this.queryRouterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRouter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amRouterList);
        return queryResult;
    }

    @Override
    public void deleteAppAndRouter(Integer appmanageId) throws ApiException {
        AmAppmanage amAppmanage = this.appmanageService.getAppmanage(appmanageId);
        this.appmanageService.deleteAppmanage(appmanageId);
        if (amAppmanage != null && amAppmanage.getRouterDire() != null) {
            Integer routerDire = amAppmanage.getRouterDire();
            this.appapiService.deleteAppapiRouterByDire(routerDire);
            this.deleteRouterByDire(routerDire);
        }
    }
}

