/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlExpressMapper;
import com.yqbsoft.laser.service.logistics.domain.WlExpressDomain;
import com.yqbsoft.laser.service.logistics.model.WlExpress;
import com.yqbsoft.laser.service.logistics.service.WlExpressService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WlExpressServiceImpl
extends BaseServiceImpl
implements WlExpressService {
    public static final String SYS_CODE = "wl.LOGISTICS.WlExpressServiceImpl";
    private WlExpressMapper wlExpressMapper;
    String key = "WlExpress-list";
    String keyDomain = "WlExpress-domain";
    String keyvalue = "WlExpress-key";

    public void setWlExpressMapper(WlExpressMapper wlExpressMapper) {
        this.wlExpressMapper = wlExpressMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlExpressMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkExpress(WlExpressDomain wlExpressDomain) {
        if (null == wlExpressDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setExpressDefault(WlExpress wlExpress) {
        if (null == wlExpress) {
            return;
        }
        if (null == wlExpress.getDataState()) {
            wlExpress.setDataState(0);
        }
        if (null == wlExpress.getGmtCreate()) {
            wlExpress.setGmtCreate(this.getSysDate());
        }
        wlExpress.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlExpress.getExpressCode())) {
            wlExpress.setExpressCode(this.createUUIDString());
        }
    }

    private int getExpressMaxCode() {
        int code = 0;
        try {
            return this.wlExpressMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.getExpressMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExpressUpdataDefault(WlExpress wlExpress) {
        if (null == wlExpress) {
            return;
        }
        wlExpress.setGmtModified(this.getSysDate());
    }

    private void saveExpressModel(WlExpress wlExpress) throws ApiException {
        if (null == wlExpress) {
            return;
        }
        try {
            this.wlExpressMapper.insert(wlExpress);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.saveExpressModel.ex", (Throwable)e);
        }
    }

    private WlExpress getExpressModelById(Integer expressId) {
        if (null == expressId) {
            return null;
        }
        try {
            return this.wlExpressMapper.selectByPrimaryKey(expressId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.getExpressModelById", (Throwable)e);
            return null;
        }
    }

    public WlExpress getExpressModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlExpressMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.getExpressModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delExpressModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExpressMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.delExpressModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.delExpressModelByCode.num");
        }
    }

    private void deleteExpressModel(Integer expressId) throws ApiException {
        if (null == expressId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExpressMapper.deleteByPrimaryKey(expressId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.deleteExpressModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.deleteExpressModel.num");
        }
    }

    private void updateExpressModel(WlExpress wlExpress) throws ApiException {
        if (null == wlExpress) {
            return;
        }
        try {
            this.wlExpressMapper.updateByPrimaryKeySelective(wlExpress);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.updateExpressModel.ex", (Throwable)e);
        }
    }

    private void updateStateExpressModel(Integer expressId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == expressId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expressId", expressId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlExpressMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.updateStateExpressModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.updateStateExpressModel.null");
        }
    }

    private WlExpress makeExpress(WlExpressDomain wlExpressDomain, WlExpress wlExpress) {
        if (null == wlExpressDomain) {
            return null;
        }
        if (null == wlExpress) {
            wlExpress = new WlExpress();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlExpress, (Object)wlExpressDomain);
            return wlExpress;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.makeExpress", (Throwable)e);
            return null;
        }
    }

    private WlExpressDomain makeExpressDomain(WlExpress wlExpress) {
        if (null == wlExpress) {
            return null;
        }
        WlExpressDomain wlExpressDomain = new WlExpressDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlExpressDomain, (Object)wlExpress);
            return wlExpressDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.makeExpress", (Throwable)e);
            return null;
        }
    }

    private List<WlExpress> queryExpressModelPage(Map<String, Object> parammap) {
        try {
            return this.wlExpressMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.queryExpressModel", (Throwable)e);
            return null;
        }
    }

    private int countExpress(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlExpressMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExpressServiceImpl.countExpress", (Throwable)e);
        }
        return i;
    }

    private void sendMsg(String dir, WlExpress wlExpress) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("channelsendType", "wlExpress");
        p.put("channelsendDir", dir);
        p.put("channelsendTxt", JsonUtil.buildNormalBinder().toJson((Object)wlExpress));
        p.put("channelsendOpcode", wlExpress.getExpressCode());
        p.put("tenantCode", wlExpress.getTenantCode());
        paramsMap.put("emChannelSendDomain", JsonUtil.buildNormalBinder().toJson(p));
        this.internalInvoke("evm.emEngineService.send", paramsMap);
    }

    @Override
    public void saveExpress(WlExpressDomain wlExpressDomain) throws ApiException {
        String msg = this.checkExpress(wlExpressDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.saveExpress.checkExpress", msg);
        }
        WlExpress wlExpress = this.makeExpress(wlExpressDomain, null);
        this.setExpressDefault(wlExpress);
        this.saveExpressModel(wlExpress);
        ArrayList<WlExpress> wlExpressList = new ArrayList<WlExpress>();
        wlExpressList.add(wlExpress);
        this.updateCache(wlExpressList);
        this.sendMsg("add", wlExpress);
    }

    @Override
    public void updateExpressState(Integer expressId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateExpressModel(expressId, dataState, oldDataState);
    }

    @Override
    public void updateExpress(WlExpressDomain wlExpressDomain) throws ApiException {
        String msg = this.checkExpress(wlExpressDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.updateExpress.checkExpress", msg);
        }
        WlExpress oldWlExpress = this.getExpressModelById(wlExpressDomain.getExpressId());
        if (null == oldWlExpress) {
            throw new ApiException("wl.LOGISTICS.WlExpressServiceImpl.updateExpress.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlExpress wlExpress = this.makeExpress(wlExpressDomain, oldWlExpress);
        this.setExpressUpdataDefault(wlExpress);
        this.updateExpressModel(wlExpress);
        this.sendMsg("edit", wlExpress);
    }

    @Override
    public WlExpress getExpress(Integer expressId) {
        return this.getExpressModelById(expressId);
    }

    @Override
    public void deleteExpress(Integer expressId) throws ApiException {
        this.deleteExpressModel(expressId);
        this.sendMsg("del", this.getExpressModelById(expressId));
    }

    @Override
    public QueryResult<WlExpress> queryExpressPage(Map<String, Object> map) {
        List<WlExpress> wlExpressList = this.queryExpressModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExpress(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlExpressList);
        return queryResult;
    }

    @Override
    public WlExpress getExpressByCode(Map<String, Object> map) {
        return this.getExpressModelByCode(map);
    }

    @Override
    public void delExpressByCode(Map<String, Object> map) throws ApiException {
        this.delExpressModelByCode(map);
    }

    @Override
    public void loadExpressCache() {
        this.logger.info("wl.LOGISTICS.WlExpressServiceImpl.loadExpressCache.start", (Object)"=======\u8c03\u5ea6start=======");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        List<WlExpress> wlExpressList = this.queryExpressModelPage(parammap);
        this.loadCache(wlExpressList);
        this.logger.info("wl.LOGISTICS.WlExpressServiceImpl.loadExpressCache.end", (Object)"=======\u8c03\u5ea6end=======");
    }

    private void loadCache(List<WlExpress> wlExpressList) {
        if (null == wlExpressList || wlExpressList.isEmpty()) {
            DisUtil.del((String)this.key);
            DisUtil.del((String)this.keyvalue);
            this.logger.info("wl.LOGISTICS.WlExpressServiceImpl.loadExpressCache.del.end", (Object)"=======\u8c03\u5ea6del-end=======");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> domainMap = new HashMap<String, String>();
        for (WlExpress wlExpress : wlExpressList) {
            String code = wlExpress.getExpressCode();
            String name = wlExpress.getExpressName();
            map.put(code, name);
            if (!StringUtils.isNotBlank((String)wlExpress.getExpressapiCode())) continue;
            domainMap.put(code + "-" + wlExpress.getTenantCode(), wlExpress.getExpressapiCode());
        }
        DisUtil.set((String)this.key, (String)JsonUtil.buildNormalBinder().toJson(wlExpressList));
        DisUtil.setMapVer((String)this.keyvalue, map);
        DisUtil.setMapVer((String)this.keyDomain, domainMap);
    }

    private void updateCache(List<WlExpress> wlExpressList) {
        HashMap<String, String> domainMap;
        if (ListUtil.isEmpty(wlExpressList)) {
            return;
        }
        ArrayList<WlExpress> wlExpressListCache = DisUtil.getListJson((String)this.key, WlExpress.class);
        if (null == wlExpressListCache) {
            wlExpressListCache = new ArrayList<WlExpress>();
        }
        wlExpressListCache.addAll(wlExpressList);
        HashMap<String, String> map = DisUtil.getMapAll((String)this.keyvalue);
        if (null == map) {
            map = new HashMap<String, String>();
        }
        if (null == (domainMap = DisUtil.getMapAll((String)this.keyDomain))) {
            domainMap = new HashMap<String, String>();
        }
        for (WlExpress wlExpress : wlExpressList) {
            String code = wlExpress.getExpressCode();
            String name = wlExpress.getExpressName();
            map.put(code, name);
            if (!StringUtils.isNotBlank((String)wlExpress.getExpressapiCode())) continue;
            domainMap.put(code + "-" + wlExpress.getTenantCode(), wlExpress.getExpressapiCode());
        }
        DisUtil.set((String)this.key, (String)JsonUtil.buildNormalBinder().toJson(wlExpressList));
        DisUtil.setMapVer((String)this.keyvalue, map);
        DisUtil.setMapVer((String)this.keyDomain, domainMap);
    }

    @Override
    public void saveExpressInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<WlExpress> wlExpressList = this.queryExpressModelPage(this.getQueryParamMap("tenantCode", new Object[]{"00000000"}));
        if (ListUtil.isEmpty(wlExpressList)) {
            return;
        }
        for (WlExpress wlExpress : wlExpressList) {
            List<WlExpress> oldWlExpressList = this.queryExpressModelPage(this.getQueryParamMap("tenantCode,expressCode", new Object[]{tenantCode, wlExpress.getExpressCode()}));
            if (ListUtil.isNotEmpty(oldWlExpressList)) continue;
            wlExpress.setExpressId(null);
            wlExpress.setTenantCode(tenantCode);
            WlExpressDomain wlExpressDomain = this.makeExpressDomain(wlExpress);
            this.saveExpress(wlExpressDomain);
        }
    }
}

