/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.risk.handler;

import com.yqbsoft.laser.service.mns.risk.MnsRiskContext;
import com.yqbsoft.laser.service.mns.risk.handler.BaseMnsRiskHandler;
import com.yqbsoft.laser.service.mns.risk.handler.MnsRiskHandler;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;

public class MnsLinearRiskHandler
extends BaseMnsRiskHandler
implements MnsRiskHandler {
    @Override
    public MnsRiskContext checkRisk(String mnsconfigBustype) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistBusType", mnsconfigBustype);
        Date nowDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String endDate = sdf.format(nowDate);
        map.put("endDate", endDate);
        String startDate = sdf.format(DateUtils.addMinutes((Date)nowDate, (int)-1));
        map.put("startDate", startDate);
        List<Map<String, Object>> list = this.mnslistService.queryNumByTenantCode(map);
        if (list == null) {
            return MnsRiskContext.success();
        }
        String mnsLinearRiskNum = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-risk-mnsLinearRiskNum");
        String mnsLinearMin = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-risk-mnsLinearMin");
        if (StringUtils.isBlank((String)mnsLinearRiskNum)) {
            return MnsRiskContext.success();
        }
        if (StringUtils.isBlank((String)mnsLinearMin)) {
            mnsLinearMin = "10";
        }
        HashMap<String, Object> riskParam = new HashMap<String, Object>();
        MnsRiskContext mnsRiskContext = new MnsRiskContext();
        mnsRiskContext.setRiskAfterParam(riskParam);
        for (Map<String, Object> groupMap : list) {
            Integer num = Integer.valueOf(groupMap.get("num").toString());
            String tenantCode = (String)groupMap.get("tenantCode");
            if (StringUtils.isBlank((String)tenantCode)) continue;
            String key = TokenUtil.genToken((Object[])new Object[]{"mns", "risk", mnsconfigBustype, tenantCode});
            if (num >= Integer.valueOf(mnsLinearRiskNum)) {
                String count = SupDisUtil.get((String)key);
                if (StringUtils.isBlank((String)count)) {
                    count = "0";
                }
                if (Integer.valueOf(count) >= Integer.valueOf(mnsLinearMin)) {
                    this.logger.warn("MnsFullRiskHandler.checkRisk", (Object)("\u79df\u6237\u3010" + tenantCode + "\u3011\u77ed\u4fe1\u98ce\u63a7\u5f00\u542f"));
                    mnsRiskContext.setRisk(true);
                    riskParam.put(tenantCode, num);
                    SupDisUtil.del((String)key);
                    continue;
                }
                String value = Integer.valueOf(count) + 1 + "";
                SupDisUtil.set((String)key, (String)value, (int)600);
                continue;
            }
            SupDisUtil.del((String)key);
        }
        return mnsRiskContext;
    }

    @Override
    public void riskAfterPolicy(String mnsconfigBustype, MnsRiskContext context) {
        this.handlerWarning(mnsconfigBustype, context);
    }
}

