/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistReDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.mns.domain.OcContractReDomain;
import com.yqbsoft.laser.service.mns.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.mns.domain.PmPromotionDiscountReDomain;
import com.yqbsoft.laser.service.mns.domain.PmPromotionReDomain;
import com.yqbsoft.laser.service.mns.domain.PmUserCouponReDomain;
import com.yqbsoft.laser.service.mns.domain.PmUserUsecouponReDomain;
import com.yqbsoft.laser.service.mns.domain.UmUserinfo;
import com.yqbsoft.laser.service.mns.model.MnsMnsblist;
import com.yqbsoft.laser.service.mns.model.MnsMnsconfig;
import com.yqbsoft.laser.service.mns.model.MnsMnslist;
import com.yqbsoft.laser.service.mns.model.MnsMnstemplate;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistPollThread;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistPutThread;
import com.yqbsoft.laser.service.mns.send.SendMnsBlistService;
import com.yqbsoft.laser.service.mns.send.SendPollThread;
import com.yqbsoft.laser.service.mns.send.SendService;
import com.yqbsoft.laser.service.mns.service.MnsSendPhoneService;
import com.yqbsoft.laser.service.mns.service.MnsService;
import com.yqbsoft.laser.service.mns.service.MnsblistService;
import com.yqbsoft.laser.service.mns.service.MnslistService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnsServiceImpl
extends BaseServiceImpl
implements MnsService {
    public static final String SYS_CODE = "mns.MNS.MnsServiceImpl";
    private static final Logger log = LoggerFactory.getLogger(MnsServiceImpl.class);
    private static SendService sendService;
    private static SendMnsBlistService sendMnsBlistService;
    private static Object lock;
    private MnslistService mnslistService;
    private MnsblistService mnsblistService;
    private MnsSendPhoneService mnsSendPhoneService;

    public void setMnslistService(MnslistService mnslistService) {
        this.mnslistService = mnslistService;
    }

    public void setMnsblistService(MnsblistService mnsblistService) {
        this.mnsblistService = mnsblistService;
    }

    public void setMnsSendPhoneService(MnsSendPhoneService mnsSendPhoneService) {
        this.mnsSendPhoneService = mnsSendPhoneService;
    }

    @Override
    public void sendMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        this.mnslistService.saveMnslist(mnsMnslistDomainBean);
        this.getSendService().putQueue(mnsMnslistDomainBean);
    }

    @Override
    public void sendMnsBlist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        final List<MnsMnsblistDomainBean> relist = this.mnslistService.saveSend(mnsMnslistDomainBean);
        if (ListUtil.isNotEmpty(relist)) {
            this.getsendMnsBlistService().addPutPool(new SendMnsBlistPutThread(this.getsendMnsBlistService(), relist));
        }
        Thread countThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String mnslistCode = ((MnsMnsblistDomainBean)relist.get(0)).getMnslistCode();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("mnslistCode", mnslistCode);
                MnsMnslist mnsMnslist = MnsServiceImpl.this.mnslistService.queryMnslist(map).get(0);
                MnsServiceImpl.this.logger.error("mns.MNS.MnsServiceImpl.sendMnsBlist", (Object)("mnsMnslist->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslist)));
                Integer mnslistId = mnsMnslist.getMnslistId();
                boolean run = true;
                int totalCount = 0;
                boolean sendCount = false;
                int failCount = 0;
                while (run) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    QueryResult<MnsMnsblist> queryResult = MnsServiceImpl.this.mnsblistService.queryMnsblistPage(map);
                    totalCount = queryResult.getList().size();
                    sendCount = false;
                    failCount = 0;
                    List list = queryResult.getList();
                    int processedCount = 0;
                    for (MnsMnsblist mnsMnsblist : list) {
                        String dataState = String.valueOf(mnsMnsblist.getDataState());
                        if ("0".equals(dataState)) continue;
                        ++processedCount;
                        if (!"-1".equals(dataState)) continue;
                        ++failCount;
                    }
                    if (processedCount != totalCount) continue;
                    run = false;
                }
                MnsServiceImpl.this.logger.error("mns.MNS.MnsServiceImpl.sendMnsBlist", (Object)("mnslistId->" + mnslistId + ",totalCount->" + totalCount + ",failCount->" + failCount));
                try {
                    if (failCount == 0) {
                        MnsServiceImpl.this.mnslistService.updateMnslistState(mnslistId, 1, 0);
                    } else if (failCount < totalCount) {
                        MnsServiceImpl.this.mnslistService.updateMnslistState(mnslistId, 2, 0);
                    } else {
                        MnsServiceImpl.this.mnslistService.updateMnslistState(mnslistId, -1, 0);
                    }
                }
                catch (Exception e) {
                    log.error("mns.MNS.MnsServiceImpl.sendMnsBlist", (Object)("mnslistId->" + mnslistId + ",\u72b6\u6001\u66f4\u65b0\u5931\u8d25 error->" + e.getMessage()));
                }
            }
        });
        countThread.start();
    }

    @Override
    public void saveSendPlus(String TemplateParam, String phoneNumbers, String businessType, String app_id, String tenantCode) throws ApiException {
        this.mnslistService.saveSendPlus(TemplateParam, phoneNumbers, businessType, app_id, tenantCode);
    }

    @Override
    public String sendOrderDomain(OcContractReDomain ocContractDomain) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.sendOrderDomain", (Object)"=====================================\u8ba2\u5355\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8c03\u7528=====================================");
        if (null == ocContractDomain) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendOrderDomain", (Object)("ocContractReDomain->" + ocContractDomain));
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("oc" + ocContractDomain.getContractType() + ocContractDomain.getDataState());
        mnsMnslistDomainBean.setMnslistBusname("\u8ba2\u5355\u53d1\u9001\u6d88\u606f");
        mnsMnslistDomainBean.setMemberCode(ocContractDomain.getMemberBcode());
        mnsMnslistDomainBean.setDataTenant(ocContractDomain.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(ocContractDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", ocContractDomain.getMemberBcode());
        listReceiver.put("name", ocContractDomain.getMemberBname());
        listReceiver.put("ocContractDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)ocContractDomain));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    private String checkPromotionReminder(Map<String, Object> map) {
        if (map == null) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionReminder", (Object)"map is null");
            return "map is null";
        }
        if (map.get("promotion") == null) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionReminder", (Object)"promotion is null");
            return "promotion is null";
        }
        if (map.get("users") == null) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionReminder", (Object)"users is null");
            return "users is null";
        }
        Object promotion = map.get("promotion");
        Object users = map.get("users");
        if (!(promotion instanceof Map)) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionReminder", (Object)"promotion must be PmPromotionDomain");
            return "promotion must be Map";
        }
        if (!(users instanceof Map)) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionReminder", (Object)"users must be Map");
            return "users must be Map";
        }
        List usersL = (List)users;
        Map promotionL = (Map)promotion;
        for (Object object : usersL) {
            if (object instanceof Map) continue;
            this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionReminder", (Object)"user must be UmUserDomain");
            return "error";
        }
        map.put("promotion", promotionL);
        map.put("users", usersL);
        return null;
    }

    @Override
    public String sendPromotionReminder(Map<String, Object> params) throws Exception {
        if (params.get("mnsblistId") != null) {
            Object value = params.get("mnsblistId");
            if (value != null) {
                if (value instanceof Integer) {
                    Integer mnsblistId = (Integer)value;
                } else {
                    Integer mnsblistId = Integer.valueOf(value.toString());
                }
            } else {
                Object mnsblistId = null;
            }
            return "success";
        }
        if (params.get("mnslistId") != null) {
            Object value = params.get("mnslistId");
            Integer mnslistId = value != null ? (value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString())) : null;
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("mnslistId", mnslistId);
            queryParams.put("dataState", -1);
            List list = this.mnsblistService.queryMnsblistPage(queryParams).getList();
            return "success";
        }
        Map promotion = (Map)params.get("promotion");
        Map users = (Map)params.get("users");
        this.logger.error("mns.MNS.MnsServiceImpl.sendOrderDomain", (Object)"=====================================\u83b7\u53d6\u6d88\u606f\u5185\u5bb9=====================================");
        this.logger.error("mns.MNS.MnsServiceImpl.promotion", (Object)("map->" + promotion));
        this.logger.error("mns.MNS.MnsServiceImpl.users", (Object)("map->" + users));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("pm002");
        mnsMnslistDomainBean.setMnslistBusname("\u8425\u9500\u6d3b\u52a8\u63a8\u9001\u4fe1\u606f");
        String tenantCode = (String)promotion.get("tenantCode");
        mnsMnslistDomainBean.setDataTenant(tenantCode);
        mnsMnslistDomainBean.setTenantCode(tenantCode);
        mnsMnslistDomainBean.setMemberName((String)promotion.get("opName"));
        ArrayList receiverList = new ArrayList();
        List dis = (List)users.get("dis");
        List target = (List)users.get("target");
        HashMap<String, String> disM = new HashMap<String, String>();
        HashMap<String, String> targetM = new HashMap<String, String>();
        disM.put("dis", JsonUtil.buildNonNullBinder().toJson((Object)dis));
        receiverList.add(disM);
        targetM.put("target", JsonUtil.buildNonNullBinder().toJson((Object)target));
        receiverList.add(targetM);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("promotion", JsonUtil.buildNonNullBinder().toJson((Object)promotion));
        receiverList.add(map1);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        mnsMnslistDomainBean.setMnslistContent((String)promotion.get("promotionCode"));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    private void reSendMnsBlist(Integer mnsblistId) throws Exception {
        MnsMnsblist mnsMnsblist = this.mnsblistService.getMnsblist(mnsblistId);
        if (mnsMnsblist == null) {
            this.logger.error("mns.MNS.MnsServiceImpl.reSendMnsBlist", (Object)"mnsMnsblist is null");
            return;
        }
        this.logger.error("mns.MNS.MnsServiceImpl.reSendMnsBlist", (Object)("mnsMnsblist->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnsblist)));
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("mnslistCode", mnsMnsblist.getMnslistCode());
        List<MnsMnslist> list = this.mnslistService.queryMnslist(queryParams);
        MnsMnslist mnsMnslist = list.get(0);
        this.logger.error("mns.MNS.MnsServiceImpl.reSendMnsBlist", (Object)("mnsMnslist->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslist)));
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        BeanUtils.copyAllPropertys((Object)mnsMnslistDomainBean, (Object)mnsMnslist);
        this.logger.error("mns.MNS.MnsServiceImpl.reSendMnsBlist", (Object)("mnsMnslistDomainBean->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean)));
        HashMap m = new HashMap();
        String mnslistExp = mnsMnslistDomainBean.getMnslistExp();
        Map mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class);
        List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
        MnsMnsconfig mnsconfig = this.findMnsMnsconfig(mnsMnslistDomainBean);
        List<Map<String, String>> mnsList = this.getmsnsList(receiverList, mnsconfig, mnsMnslistDomainBean, mnsMnsblist);
        this.mnsblistService.deleteMnsblist(mnsblistId);
        if (ListUtil.isNotEmpty(mnsList)) {
            this.mnsSendPhoneService.saveSendMsg(mnsList, mnsconfig);
        }
    }

    private List<Map<String, String>> getmsnsList(List<Map<String, String>> receiverList, MnsMnsconfig mnsconfig, MnsMnslistDomainBean mnsMnslistDomainBean, MnsMnsblist mnsMnsblist) throws Exception {
        String disJson = receiverList.get(0).get("dis");
        ArrayList dislist = disJson == null ? new ArrayList() : JsonUtil.buildNonDefaultBinder().getList(disJson, List.class, String.class);
        String targetJson = receiverList.get(1).get("target");
        ArrayList targetlist = targetJson == null ? new ArrayList() : JsonUtil.buildNonDefaultBinder().getList(targetJson, List.class, String.class);
        String promotionCode = mnsMnslistDomainBean.getMnslistContent();
        HashMap channel_company_map = new HashMap();
        HashMap company_user_map = new HashMap();
        HashMap channel_user_map = new HashMap();
        ArrayList<String> userInfoCodeSet = new ArrayList<String>();
        ArrayList<String> companyCodeSet = new ArrayList<String>();
        StringBuilder userInfoCodeBuilder = new StringBuilder();
        StringBuilder companyCodeBuilder = new StringBuilder();
        for (String userinfoCode : targetlist) {
            if (!StringUtils.isNotBlank((String)userinfoCode)) continue;
            userInfoCodeBuilder.append(userinfoCode).append(",");
        }
        if (userInfoCodeBuilder.length() > 0) {
            userInfoCodeBuilder.deleteCharAt(userInfoCodeBuilder.length() - 1);
        }
        for (String disCode : dislist) {
            if (!StringUtils.isNotBlank((String)disCode)) continue;
            companyCodeSet.add(disCode);
            companyCodeBuilder.append(disCode).append(",");
        }
        if (companyCodeBuilder.length() > 0) {
            companyCodeBuilder.deleteCharAt(companyCodeBuilder.length() - 1);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        paramMap.put("companyCode", companyCodeBuilder.toString());
        paramMap.put("userinfoCode", userInfoCodeBuilder.toString());
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.sendReSupObject("org.employee.queryEmployeePage", map, Object.class);
        List list = queryResult.getList();
        String json = JsonUtil.buildNonDefaultBinder().toJson((Object)list);
        this.logger.error("\u67e5\u8be2\u5339\u914d\u7684\u516c\u53f8\u5458\u5de5", (Object)json);
        List jsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(json, Map.class);
        for (Map stringStringMap : jsonToList) {
            String companyCode = (String)stringStringMap.get("companyCode");
            String userCode = (String)stringStringMap.get("userinfoCode");
            if (!company_user_map.containsKey(companyCode)) {
                company_user_map.put(companyCode, new ArrayList());
            }
            ((List)company_user_map.get(companyCode)).add(userCode);
            userInfoCodeSet.add(userCode);
        }
        this.logger.error("\u516c\u53f8-\u7528\u6237", (Object)JsonUtil.buildNormalBinder().toJson(company_user_map));
        HashMap<String, String> pmParamMap = new HashMap<String, String>();
        HashMap<String, String> pmMap = new HashMap<String, String>();
        StringBuilder skuCode = new StringBuilder();
        pmParamMap.put("promotionCode", promotionCode);
        pmMap.put("map", JsonUtil.buildNormalBinder().toJson(pmParamMap));
        QueryResult pmQueryResult = this.sendReSupObject("pm.PmPromotion.queryPromotionPage", pmMap, Object.class);
        List pmList = pmQueryResult.getList();
        String pmJson = JsonUtil.buildNonDefaultBinder().toJson((Object)pmList);
        List pmJsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(pmJson, Map.class);
        for (Map stringStringMap : pmJsonToList) {
            skuCode.append((String)stringStringMap.get("skuCode")).append(",");
        }
        if (skuCode.length() > 0) {
            skuCode.deleteCharAt(skuCode.length() - 1);
        }
        this.logger.error("\u8425\u9500\u5546\u54c1sku", (Object)JsonUtil.buildNormalBinder().toJson((Object)skuCode));
        HashMap<String, String> channelParamMap = new HashMap<String, String>();
        HashMap<String, String> channelMap = new HashMap<String, String>();
        StringBuilder companyCodeBuilder2 = new StringBuilder();
        StringBuilder channelCodeBuilder = new StringBuilder();
        for (String companyCode : company_user_map.keySet()) {
            if (!StringUtils.isNotBlank((String)companyCode)) continue;
            companyCodeBuilder2.append(companyCode).append(",");
        }
        if (companyCodeBuilder2.length() > 0) {
            companyCodeBuilder2.deleteCharAt(companyCodeBuilder2.length() - 1);
        }
        channelParamMap.put("memberCode", companyCodeBuilder2.toString());
        channelMap.put("map", JsonUtil.buildNormalBinder().toJson(channelParamMap));
        QueryResult channelQueryResult = this.sendReSupObject("dis.channel.queryChannelPage", channelMap, Object.class);
        List channelList = channelQueryResult.getList();
        String channelJson = JsonUtil.buildNonDefaultBinder().toJson((Object)channelList);
        List channelJsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(channelJson, Map.class);
        for (Map stringStringMap : channelJsonToList) {
            channel_company_map.put(stringStringMap.get("channelCode"), stringStringMap.get("memberCode"));
            channelCodeBuilder.append((String)stringStringMap.get("channelCode")).append(",");
        }
        if (channelCodeBuilder.length() > 0) {
            channelCodeBuilder.deleteCharAt(channelCodeBuilder.length() - 1);
        }
        this.logger.error("\u6240\u6709\u516c\u53f8\u7684\u6e20\u9053", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelCodeBuilder));
        this.logger.error("\u6e20\u9053-\u516c\u53f8", (Object)JsonUtil.buildNormalBinder().toJson(channel_company_map));
        HashSet channelCodeSet = new HashSet();
        HashMap<String, String> skuParamMap = new HashMap<String, String>();
        HashMap<String, String> skuMap = new HashMap<String, String>();
        skuParamMap.put("channelCode", channelCodeBuilder.toString());
        skuParamMap.put("skuCodes", skuCode.toString());
        skuMap.put("map", JsonUtil.buildNormalBinder().toJson(skuParamMap));
        QueryResult skuQueryResult = this.sendReSupObject("rs.sku.querySkuOnePage", skuMap, Object.class);
        List skuList = skuQueryResult.getList();
        String skuJson = JsonUtil.buildNonDefaultBinder().toJson((Object)skuList);
        List skuJsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(skuJson, Map.class);
        for (Map stringStringMap : skuJsonToList) {
            channelCodeSet.add(stringStringMap.get("channelCode"));
        }
        this.logger.error("\u53ef\u63a8\u6e20\u9053:", (Object)JsonUtil.buildNormalBinder().toJson(channelCodeSet));
        for (String channelCode : channel_company_map.keySet()) {
            if (channelCodeSet.contains(channelCode)) continue;
            channel_company_map.remove(channelCode);
        }
        for (String channelCode : channel_company_map.keySet()) {
            String companyCode = (String)channel_company_map.get(channelCode);
            if (!company_user_map.containsKey(companyCode)) continue;
            channel_user_map.put(channelCode, company_user_map.get(companyCode));
        }
        this.logger.error("\u6e20\u9053-\u7528\u6237", (Object)JsonUtil.buildNormalBinder().toJson(channel_user_map));
        MnsMnsblistReDomainBean mnsMnsblistDomainBean = new MnsMnsblistReDomainBean();
        mnsMnsblistDomainBean.setDataState(0);
        mnsMnsblistDomainBean.setMnschannelCode(mnsconfig.getMnschannelCode());
        mnsMnsblistDomainBean.setMnschannelName(mnsconfig.getMnschannelName());
        mnsMnsblistDomainBean.setAppapiCode(mnsconfig.getAppapiCode());
        mnsMnsblistDomainBean.setAppapiVersion(mnsconfig.getAppapiVersion());
        mnsMnsblistDomainBean.setMnslistContent(mnsMnsblist.getMnslistContent());
        mnsMnsblistDomainBean.setTenantCode(mnsconfig.getTenantCode());
        mnsMnsblistDomainBean.setMnslistBustype(mnsconfig.getMnsconfigBustype());
        mnsMnsblistDomainBean.setMnslistBusname(mnsconfig.getMnsconfigBusname());
        mnsMnsblistDomainBean.setMnslistSource(0);
        mnsMnsblistDomainBean.setMemberCode(mnsMnsblist.getMemberCode());
        mnsMnsblistDomainBean.setMnslistExp(mnsMnsblist.getMnslistExp());
        mnsMnsblistDomainBean.setAppmanageIcode(mnsconfig.getAppmanageIcode());
        mnsMnsblistDomainBean.setMnslistCode(mnsMnsblist.getMnslistCode());
        List<String> stoppedUserList = this.stoppedUserList();
        if (!channel_user_map.values().toString().contains(mnsMnsblist.getMemberCode())) {
            mnsMnsblistDomainBean.setMnslistState("\u6e20\u9053\u5185\u65e0\u6d3b\u52a8\u5546\u54c1");
            mnsMnsblistDomainBean.setDataState(-1);
        } else if (stoppedUserList.contains(mnsMnsblist.getMnslistCode())) {
            mnsMnsblistDomainBean.setMnslistState("\u5458\u5de5\u88ab\u505c\u7528");
            mnsMnsblistDomainBean.setDataState(-1);
        } else {
            mnsMnsblistDomainBean.setMnslistState("");
        }
        this.mnsblistService.saveMnsblist(mnsMnsblistDomainBean);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("promotion", receiverList.get(receiverList.size() - 1).get("promotion"));
        m.put("code", mnsMnsblist.getMemberCode());
        m.put("mnslistContent", mnsMnslistDomainBean.getMnslistContent());
        m.put("mnslistBustype", mnsMnslistDomainBean.getMnslistBustype());
        m.put("mnslistCode", mnsMnslistDomainBean.getMnslistCode());
        m.put("memberCode", mnsMnsblist.getMemberCode());
        m.put("mnsblistId", String.valueOf(mnsMnsblistDomainBean.getMnsblistId()));
        m.put("promotion", receiverList.get(receiverList.size() - 1).get("promotion"));
        this.makeMapKv(m);
        m.put("mnslistExp", mnsMnsblist.getMnslistExp());
        ArrayList<Map<String, String>> mnsList = new ArrayList<Map<String, String>>();
        mnsList.add(m);
        return mnsList;
    }

    private List<String> stoppedUserList() {
        ArrayList<String> res = new ArrayList<String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        paramMap.put("dataState", "-1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.sendReSupObject("org.employee.queryEmployeePage", map, Object.class);
        List list = queryResult.getList();
        String json = JsonUtil.buildNonDefaultBinder().toJson((Object)list);
        List jsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(json, Map.class);
        for (Map stringStringMap : jsonToList) {
            res.add((String)stringStringMap.get("userinfoCode"));
        }
        return res;
    }

    private MnsMnsconfig findMnsMnsconfig(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return null;
        }
        String busType = mnsMnslistDomainBean.getMnslistBustype();
        if (null == busType) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendMns", (Object)"busType is null");
            return null;
        }
        MnsMnsconfig mnsMnsconfig = null;
        if (StringUtils.isNotBlank((String)mnsMnslistDomainBean.getAppmanageIcode())) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getAppmanageIcode() + "-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getDataTenant() + "-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getDataTenant() + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-all-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendMns", (Object)("\u672a\u627e\u5230\u914d\u7f6e\u4fe1\u606fmnsMnsconfig" + busType + "-" + mnsMnslistDomainBean.getTenantCode()));
            return null;
        }
        MnsMnstemplate mnsMnstemplate = null;
        if (!"smail".equals(busType)) {
            if (StringUtils.isBlank((String)mnsMnsconfig.getDataTenant())) {
                mnsMnsconfig.setDataTenant("");
            }
            if (null == (mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getTenantCode()), MnsMnstemplate.class))) {
                mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant()), MnsMnstemplate.class);
            }
            if (null == mnsMnstemplate) {
                this.logger.error("mns.MNS.MnsServiceImpl.sendMns", (Object)("\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606fmnsMnstemplate:" + mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant() + "-" + mnsMnsconfig.getTenantCode()));
                return null;
            }
        }
        mnsMnsconfig.setMnsMnstemplate(mnsMnstemplate);
        return mnsMnsconfig;
    }

    public void makeMapKv(Map<String, String> map) {
        Map<String, Object> stringObjectMap = MnsServiceImpl.stringMapToObject(map);
        for (String s : stringObjectMap.keySet()) {
            if (!(stringObjectMap.get(s) instanceof Map)) continue;
            Map object = (Map)stringObjectMap.get(s);
            for (String string : object.keySet()) {
                map.put(string, (String)object.get(string));
            }
            map.remove(s);
        }
    }

    private static Map<String, Object> stringMapToObject(Map<String, String> marapusermap) {
        HashMap<String, Object> mapObject = new HashMap<String, Object>();
        for (String key : marapusermap.keySet()) {
            if (marapusermap.get(key).indexOf("{") >= 0) {
                mapObject.put(key, JsonUtil.buildNormalBinder().getJsonToObject(marapusermap.get(key), Map.class));
                continue;
            }
            mapObject.put(key, marapusermap.get(key));
        }
        return mapObject;
    }

    @Override
    public String sendUserDomain(UmUserinfo umUserinfo) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.sendUserDomain", (Object)"=====================================\u7528\u6237\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8c03\u7528=====================================");
        if (null == umUserinfo) {
            this.logger.error("mns.MNS.MnsServiceImpl.sendUserDomain", (Object)("umUserinfo->" + umUserinfo));
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("um" + umUserinfo.getUserinfoType() + umUserinfo.getDataState());
        mnsMnslistDomainBean.setMnslistBusname("\u7528\u6237\u53d1\u9001\u6d88\u606f");
        mnsMnslistDomainBean.setMemberCode(umUserinfo.getUserCode());
        mnsMnslistDomainBean.setDataTenant(umUserinfo.getTenantCode());
        String params = JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfo);
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(umUserinfo.getTenantCode());
        this.logger.error("mns.MNS.MnsServiceImpl.sendUserDomain", (Object)("=====================================" + mnsMnslistDomainBean.getMnslistBustype() + "====================================="));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendRefundDomain(OcRefundReDomain ocRefundDomain) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)"=====================================\u9000\u8d27\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8c03\u7528=====================================");
        if (null != ocRefundDomain) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("refundCode", ocRefundDomain.getRefundCode());
                map.put("tenantCode", ocRefundDomain.getTenantCode());
                HashMap<String, String> upMap = new HashMap<String, String>();
                upMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
                String resourceGoodsListStr = (String)this.getInternalRouter().inInvoke("oc.refund.getRefundByCode", upMap);
                OcRefundReDomain jsonToObject = (OcRefundReDomain)JsonUtil.buildNonEmptyBinder().getJsonToObject(resourceGoodsListStr, OcRefundReDomain.class);
                ocRefundDomain.setDataState(jsonToObject.getDataState());
                this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("=====================================resourceGoodsListStr->" + resourceGoodsListStr + "====================================="));
            }
            catch (Exception e) {
                this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)"=================->error");
                return "error";
            }
        } else {
            this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("ocRefundDomain->" + ocRefundDomain));
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("r" + ocRefundDomain.getContractType() + "" + ocRefundDomain.getDataState() + "");
        this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("=====================================ocRefundDomain->" + ocRefundDomain.getGmtModified() + "====================================="));
        this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("=====================================ocRefundDomain->" + ocRefundDomain + "====================================="));
        this.logger.error("mns.MNS.MnsServiceImpl.sendRefundDomain", (Object)("=====================================mnsMnslistDomainBean.setMnslistBustype()->" + mnsMnslistDomainBean.getMnslistBustype() + "====================================="));
        mnsMnslistDomainBean.setMnslistBusname("\u9000\u8d27\u53d1\u9001\u6d88\u606f");
        mnsMnslistDomainBean.setMemberCode(ocRefundDomain.getMemberCode());
        mnsMnslistDomainBean.setDataTenant(ocRefundDomain.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(ocRefundDomain.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", ocRefundDomain.getMemberBcode());
        listReceiver.put("name", ocRefundDomain.getMemberBname());
        listReceiver.put("ocRefundDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)ocRefundDomain));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.logger.error("mns.MNS.MnsServiceImpl.sendTestForJsonNotice", (Object)("============================================mnsMnslistDomainBean->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean) + "============================================"));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendOrderMnslist(String contractBillcode, String busType, String memberBcode, String tenantCode) throws ApiException {
        HashMap<String, String> contentMap;
        ArrayList receiverList;
        MnsMnslistDomainBean mnsMnslistDomainBean;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("userinfoCode", memberBcode);
        queryMap.put("tenantCode", tenantCode);
        String result = null;
        try {
            result = this.internalInvoke("um.user.getUserinfoByCode", queryMap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsServiceImplsendOrderMnslist.map", queryMap);
            return "error";
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(result, UmUserinfo.class);
        if (null != umUserinfo) {
            mnsMnslistDomainBean = new MnsMnslistDomainBean();
            mnsMnslistDomainBean.setMnslistBustype(busType);
            mnsMnslistDomainBean.setMnslistBusname("\u90ae\u7bb1\u53d1\u9001\u4fe1\u606f");
            mnsMnslistDomainBean.setMemberCode(umUserinfo.getUserinfoCode());
            mnsMnslistDomainBean.setDataTenant(tenantCode);
            receiverList = new ArrayList();
            HashMap<String, String> mape = new HashMap<String, String>();
            mape.put("email", umUserinfo.getUserinfoEmail());
            mape.put("name", umUserinfo.getUserinfoCompname());
            receiverList.add(mape);
            contentMap = new HashMap<String, String>();
            contentMap.put("email", umUserinfo.getUserinfoEmail());
            contentMap.put("userinfoCompname", umUserinfo.getUserinfoCompname());
            if (StringUtils.isNotBlank((String)contractBillcode)) {
                contentMap.put("contractBillcode", contractBillcode);
            }
        } else {
            return "error";
        }
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(contentMap));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        String params = JsonUtil.buildNonDefaultBinder().toJson(expMap);
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(tenantCode);
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendCouponDomain(String tenantCode) throws ApiException {
        String copyVal = new String(tenantCode);
        if (null != copyVal && copyVal.length() > 16) {
            tenantCode = copyVal.substring(0, 16);
        }
        String pmCouponKey = "couponEnd-" + tenantCode;
        List<PmUserCouponReDomain> pmUserCouponReDomainList = this.queryCouponDomain(copyVal);
        if (ListUtil.isNotEmpty(pmUserCouponReDomainList)) {
            for (PmUserCouponReDomain pmUserCouponDomain : pmUserCouponReDomainList) {
                this.logger.error("mns.MNS.MnsServiceImpl.sendCouponDomain", (Object)"=====================================\u4f18\u60e0\u5238\u8fc7\u671f\u901a\u77e5\u63a5\u53e3\u8c03\u7528=====================================");
                MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
                mnsMnslistDomainBean.setMnslistBustype("pm001");
                this.logger.error("mns.MNS.MnsServiceImpl.sendCouponDomain", (Object)("=====================================sendCouponDomain->" + pmUserCouponDomain.getGmtModified() + "====================================="));
                this.logger.error("mns.MNS.MnsServiceImpl.sendCouponDomain", (Object)("=====================================sendCouponDomain->" + pmUserCouponDomain + "====================================="));
                this.logger.error("mns.MNS.MnsServiceImpl.sendCouponDomain", (Object)("=====================================mnsMnslistDomainBean.setMnslistBustype()->" + mnsMnslistDomainBean.getMnslistBustype() + "====================================="));
                mnsMnslistDomainBean.setMnslistBusname("\u4f18\u60e0\u5238\u8fc7\u671f\u901a\u77e5");
                mnsMnslistDomainBean.setMemberCode(pmUserCouponDomain.getMemberCode());
                mnsMnslistDomainBean.setDataTenant(pmUserCouponDomain.getTenantCode());
                mnsMnslistDomainBean.setTenantCode(pmUserCouponDomain.getTenantCode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("imsgSuserCode", "sys");
                map.put("imsgSuserName", "sys");
                ArrayList receiverList = new ArrayList();
                HashMap<String, String> listReceiver = new HashMap<String, String>();
                listReceiver.put("code", pmUserCouponDomain.getMemberBcode());
                listReceiver.put("name", pmUserCouponDomain.getMemberBname());
                listReceiver.put("pmUserCouponDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)pmUserCouponDomain));
                receiverList.add(listReceiver);
                map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
                HashMap paramMap = new HashMap();
                map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
                mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
                this.logger.error("mns.MNS.MnsServiceImpl.sendTestForJsonNotice", (Object)("============================================mnsMnslistDomainBean->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean) + "============================================"));
                this.sendMnslist(mnsMnslistDomainBean);
            }
        }
        SupDisUtil.set((String)pmCouponKey, (String)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.logger.error("mns.MNS.MnsServiceImpl.redis.setVal.", (Object)(pmCouponKey + "=" + SupDisUtil.get((String)pmCouponKey)));
        return "success";
    }

    @Override
    public String sendPromotionDomain(String tenantCode) throws ApiException {
        String copyVal = new String(tenantCode);
        if (null != copyVal && copyVal.length() > 16) {
            tenantCode = copyVal.substring(0, 16);
        }
        String pmCouponKey = "promotionEndtime-" + tenantCode;
        List<PmPromotionReDomain> pmPromotionReDomains = this.queryPromotionDomain(copyVal);
        if (ListUtil.isNotEmpty(pmPromotionReDomains)) {
            for (PmPromotionReDomain pmPromotionDomain : pmPromotionReDomains) {
                HashMap<String, String> param1 = new HashMap<String, String>();
                param1.put("promotionCode", pmPromotionDomain.getPromotionCode());
                param1.put("pbCode", "0023");
                param1.put("tenantCode", tenantCode);
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("map", JsonUtil.buildNonDefaultBinder().toJson(param1));
                QueryResult pmUserUsecouponReDomainSupQueryResult = this.getQueryResutl("pm.PmUserUsecoupon.queryUserUsecouponPage", map1, PmUserUsecouponReDomain.class);
                this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionDomain.pm.PmUserUsecoupon.queryUserUsecouponPage.", (Object)("pmUserUsecouponReDomainSupQueryResult=" + JsonUtil.buildNormalBinder().toJson((Object)pmUserUsecouponReDomainSupQueryResult)));
                int number = pmUserUsecouponReDomainSupQueryResult.getList().size();
                HashMap<String, Object> param2 = new HashMap<String, Object>();
                param2.put("promotionCode", pmPromotionDomain.getPromotionCode());
                param2.put("tenantCode", tenantCode);
                param2.put("discEnd", -1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("map", JsonUtil.buildNonDefaultBinder().toJson(param2));
                QueryResult pmPromotionDiscountReDomainSupQueryResult = this.getQueryResutl("pm.PmPromotionDiscount.queryPromotionDiscountPage", map2, PmPromotionDiscountReDomain.class);
                this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionDomain.pm.PmPromotionDiscount.queryPromotionDiscountPage.", (Object)("pmPromotionDiscountReDomainSupQueryResult=" + JsonUtil.buildNormalBinder().toJson((Object)pmPromotionDiscountReDomainSupQueryResult)));
                int number1 = ((PmPromotionDiscountReDomain)pmPromotionDiscountReDomainSupQueryResult.getList().get(0)).getDiscStart().intValue();
                pmPromotionDomain.setNumber(number);
                pmPromotionDomain.setNumber1(number1 - number);
                this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionDomain", (Object)"=====================================\u6d3b\u52a8\u72b6\u6001\u901a\u77e5\u63a5\u53e3\u8c03\u7528=====================================");
                MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
                mnsMnslistDomainBean.setMnslistBustype("pm002");
                this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionDomain", (Object)("=====================================sendPromotionDomain->" + pmPromotionDomain.getGmtModified() + "====================================="));
                this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionDomain", (Object)("=====================================sendPromotionDomain->" + pmPromotionDomain + "====================================="));
                this.logger.error("mns.MNS.MnsServiceImpl.sendPromotionDomain", (Object)("=====================================mnsMnslistDomainBean.setMnslistBustype()->" + mnsMnslistDomainBean.getMnslistBustype() + "====================================="));
                mnsMnslistDomainBean.setMnslistBusname("\u6d3b\u52a8\u72b6\u6001\u901a\u77e5");
                mnsMnslistDomainBean.setMemberCode(pmPromotionDomain.getMemberCode());
                mnsMnslistDomainBean.setDataTenant(pmPromotionDomain.getTenantCode());
                mnsMnslistDomainBean.setTenantCode(pmPromotionDomain.getTenantCode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("imsgSuserCode", "sys");
                map.put("imsgSuserName", "sys");
                ArrayList receiverList = new ArrayList();
                HashMap<String, String> listReceiver = new HashMap<String, String>();
                listReceiver.put("code", pmPromotionDomain.getPromotionActcode());
                listReceiver.put("name", pmPromotionDomain.getPromotionActname());
                listReceiver.put("pmPromotionDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)pmPromotionDomain));
                receiverList.add(listReceiver);
                map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
                HashMap paramMap = new HashMap();
                map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
                mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
                this.logger.error("mns.MNS.MnsServiceImpl.sendTestForJsonNotice", (Object)("============================================mnsMnslistDomainBean->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean) + "============================================"));
                this.sendMnslist(mnsMnslistDomainBean);
            }
        }
        SupDisUtil.set((String)pmCouponKey, (String)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.logger.error("mns.MNS.MnsServiceImpl.redis.setVal.", (Object)(pmCouponKey + "=" + SupDisUtil.get((String)pmCouponKey)));
        return "success";
    }

    @Override
    public List<PmUserCouponReDomain> queryCouponDomain(String tenantCode) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.queryCouponDomain.start.>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        int step = 0;
        try {
            Long stime = new Long(0L);
            String copyVal = new String(tenantCode);
            if (null != copyVal && copyVal.length() > 16) {
                tenantCode = copyVal.substring(0, 16);
                stime = Long.valueOf(copyVal.substring(16));
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", tenantCode);
            param.put("dataState", 0);
            String field = tenantCode.concat("-").concat("couponExpirePushTime").concat("-").concat("couponExpirePushTime");
            String couponExpirePushTime = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            if (StringUtils.isBlank((String)couponExpirePushTime)) {
                couponExpirePushTime = "1440";
            } else {
                try {
                    Integer.valueOf(couponExpirePushTime);
                }
                catch (NumberFormatException e) {
                    couponExpirePushTime = "1440";
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar calendar = Calendar.getInstance();
            calendar.set(12, calendar.get(12) + Integer.valueOf(couponExpirePushTime));
            String startTime = df.format(calendar.getTime());
            if (null != copyVal && copyVal.length() > 16) {
                startTime = df.format(new Date(stime * 1000L));
            }
            String pmCouponKey = "couponEnd-" + tenantCode;
            String value = SupDisUtil.get((String)pmCouponKey);
            this.logger.error("mns.MNS.MnsServiceImpl.queryCouponDomain.redis.value", (Object)("value=" + value));
            step = 1;
            if (value == null) {
                param.put("couponEndQstart", startTime);
                param.put("couponEndQend", startTime);
            } else {
                param.put("couponEndQstart", startTime);
                long time = df.parse(value).getTime();
                long time1 = new Date().getTime() - time;
                long time2 = df.parse(startTime).getTime() + time1;
                Date date1 = new Date(time2);
                param.put("couponEndQend", df.format(date1));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNonDefaultBinder().toJson(param));
            this.logger.error("mns.MNS.MnsServiceImpl.queryCouponDomain.map.", (Object)("map=" + JsonUtil.buildNormalBinder().toJson(param)));
            QueryResult pmUserCouponReDomainSupQueryResult = this.getQueryResutl("pm.PmUserCoupon.queryUserCouponPage", map, PmUserCouponReDomain.class);
            this.logger.error("mns.MNS.MnsServiceImpl.queryCouponDomain.pmUserCouponReDomainSupQueryResult1.", (Object)("pmUserCouponReDomainSupQueryResult=" + JsonUtil.buildNormalBinder().toJson((Object)pmUserCouponReDomainSupQueryResult)));
            return pmUserCouponReDomainSupQueryResult.getList();
        }
        catch (Exception e) {
            switch (step) {
                case 1: {
                    this.logger.error("mns.MNS.MnsServiceImpl.queryCouponDomain.getQueryResutl.error.");
                }
            }
            this.logger.error("mns.MNS.MnsServiceImpl.queryCouponDomain.error.", (Object)("exception=" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<PmPromotionReDomain> queryPromotionDomain(String tenantCode) throws ApiException {
        this.logger.error("mns.MNS.MnsServiceImpl.queryPromotionDomain.start.>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        try {
            Long stime = new Long(0L);
            String copyVal = new String(tenantCode);
            if (null != copyVal && copyVal.length() > 16) {
                tenantCode = copyVal.substring(0, 16);
                stime = Long.valueOf(copyVal.substring(16));
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", tenantCode);
            param.put("promotionType", "1");
            param.put("pbCode", "0023");
            param.put("dataState", 1);
            String field = tenantCode.concat("-").concat("promotionChangePushTime").concat("-").concat("promotionChangePushTime");
            String promotionChangePushTime = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            if (StringUtils.isBlank((String)promotionChangePushTime)) {
                promotionChangePushTime = "60";
            } else {
                try {
                    Integer.valueOf(promotionChangePushTime);
                }
                catch (NumberFormatException e) {
                    promotionChangePushTime = "60";
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar calendar = Calendar.getInstance();
            calendar.set(12, calendar.get(12) - Integer.valueOf(promotionChangePushTime));
            String startTime = df.format(calendar.getTime());
            if (null != copyVal && copyVal.length() > 16) {
                startTime = df.format(new Date(stime * 1000L));
            }
            String pmCouponKey = "promotionEndtime-" + tenantCode;
            String value = SupDisUtil.get((String)pmCouponKey);
            this.logger.error("mns.MNS.MnsServiceImpl.queryPromotionDomain.redis.value", (Object)("value=" + value));
            if (value == null) {
                param.put("promotionBegintimeQstart", startTime);
                param.put("promotionBegintimeQend", startTime);
            } else {
                param.put("promotionBegintimeQend", startTime);
                long time = df.parse(value).getTime();
                long time1 = new Date().getTime() - time;
                long time2 = df.parse(startTime).getTime() - time1;
                Date date1 = new Date(time2);
                param.put("promotionBegintimeQstart", df.format(date1));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNonDefaultBinder().toJson(param));
            this.logger.error("mns.MNS.MnsServiceImpl.queryPromotionDomain.map.", (Object)("map=" + JsonUtil.buildNormalBinder().toJson(param)));
            QueryResult pmPromotionReDomainSupQueryResult = this.getQueryResutl("pm.PmPromotion.queryPromotionPage", map, PmPromotionReDomain.class);
            this.logger.error("mns.MNS.MnsServiceImpl.queryPromotionDomain.pmPromotionReDomainSupQueryResult.", (Object)("pmPromotionReDomainSupQueryResult=" + JsonUtil.buildNormalBinder().toJson((Object)pmPromotionReDomainSupQueryResult)));
            return pmPromotionReDomainSupQueryResult.getList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendMnsBlistService getsendMnsBlistService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendMnsBlistService) {
                sendMnsBlistService = new SendMnsBlistService((MnslistService)SpringApplicationContextUtil.getBean((String)"mnslistService"));
                for (int i = 0; i < 20; ++i) {
                    sendMnsBlistService.addPollPool(new SendMnsBlistPollThread(sendMnsBlistService));
                }
            }
            return sendMnsBlistService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((MnsService)SpringApplicationContextUtil.getBean((String)"mnsService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    static {
        lock = new Object();
    }
}

