/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultAbapObject;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.IntHashTable;
import com.sap.conn.jco.util.ObjectList;
import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;

public class BasXMLWriter {
    private HashMap<String, Integer> m_hashed_strings = new HashMap();
    private static final int START_ID_VALUE = 8;
    private int m_currentID = 8;
    private static final byte[] BXML_DECL = new byte[]{66, 88, 77, 76};
    private static final byte[] BXML_VERSION = new byte[]{48, 46, 55};
    private static final String UTF8_ENCODING = "UTF-8";
    private static byte[] BXML_ENCODING = new byte[]{117, 116, 102, 45, 56};
    private static final byte[] BXML_HEADER_VERSION = new byte[]{3, 86, 69, 82};
    private static final byte[] BXML_HEADER_ENCODING = new byte[]{3, 69, 78, 67};
    private static int HEADER_OFFSET = 0;
    private static byte[] HEADER = new byte[256];
    private static final byte[] ABAP = new byte[]{4, 97, 98, 97, 112};
    private static final byte[] NS_ASX = new byte[]{3, 97, 115, 120};
    private static final byte[] NS_ASXHINT = new byte[]{7, 97, 115, 120, 104, 105, 110, 116};
    private static final byte[] VERSION = new byte[]{7, 118, 101, 114, 115, 105, 111, 110};
    private static final byte[] ABAP_VERSION = new byte[]{3, 49, 46, 48};
    private static final byte[] VALUES = new byte[]{6, 118, 97, 108, 117, 101, 115};
    private static String URI_ABAP_XML = "http://www.sap.com/abapxml";
    private static String URI_ABAP_HINT = "http://www.sap.com/abapxml/hint";
    private static String URI_ABAP_GLOBAL_CLASSES = "http://www.sap.com/abapxml/classes/global";
    private static final byte NO_NAMESPACE_ID = 1;
    private static final byte ASX_NAMESPACE_ID = 2;
    private static final byte ASXHINT_NAMESPACE_ID = 3;
    private static final byte CLS_NAMESPACE_ID = 4;
    private static final String ITEM = "item";
    private static final String LINES = "lines";
    private static final String HREF = "href";
    private static final String ID = "id";
    private static final char[] objectReferencePrefix = new char[]{'#', 'o'};
    private int lines_id = 0;
    private int href_id = 0;
    private int id_id = 0;
    private OutputStream m_out = null;
    private String m_encoding = "UTF-8";
    private IntHashTable<Reference> references;
    private ObjectList<Reference> referenceListForHeap;
    int nextReferenceID = 1;

    private static void calculateBinaryHeader() {
        byte[] url;
        System.arraycopy(BXML_DECL, 0, HEADER, 0, BXML_DECL.length);
        HEADER_OFFSET = (byte)BXML_DECL.length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 63;
        byte length = (byte)BXML_HEADER_VERSION.length;
        System.arraycopy(BXML_HEADER_VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        length = (byte)BXML_VERSION.length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
        System.arraycopy(BXML_VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 63;
        length = (byte)BXML_HEADER_ENCODING.length;
        System.arraycopy(BXML_HEADER_ENCODING, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        length = (byte)BXML_ENCODING.length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
        System.arraycopy(BXML_ENCODING, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)NS_ASX.length;
        System.arraycopy(NS_ASX, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        try {
            url = URI_ABAP_XML.getBytes(UTF8_ENCODING);
            length = (byte)url.length;
            BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
            System.arraycopy(url, 0, HEADER, HEADER_OFFSET, length);
            HEADER_OFFSET += length;
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 58;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 2;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 3;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)ABAP.length;
        System.arraycopy(ABAP, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 60;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 4;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 2;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)VERSION.length;
        System.arraycopy(VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 64;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 5;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 1;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 65;
        length = (byte)ABAP_VERSION.length;
        System.arraycopy(ABAP_VERSION, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)NS_ASXHINT.length;
        System.arraycopy(NS_ASXHINT, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        try {
            url = URI_ABAP_HINT.getBytes(UTF8_ENCODING);
            length = (byte)url.length;
            BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = length;
            System.arraycopy(url, 0, HEADER, HEADER_OFFSET, length);
            HEADER_OFFSET += length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 58;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 6;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 7;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 42;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 3;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 43;
        length = (byte)VALUES.length;
        System.arraycopy(VALUES, 0, HEADER, HEADER_OFFSET, length);
        HEADER_OFFSET += length;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 60;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 8;
        BasXMLWriter.HEADER[BasXMLWriter.HEADER_OFFSET++] = 2;
    }

    public BasXMLWriter(OutputStream out) {
        this.m_out = out;
        try {
            this.m_out.write(HEADER, 0, HEADER_OFFSET);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void encode(AbstractRecord record, String name) throws IOException {
        this.openTag(name);
        if (record.recType == 4) {
            this.addTableRowCount(((DefaultTable)record).getNumRows());
        }
        this.encode(record);
        this.endTag();
    }

    public void encode(AbapClassException ace) throws IOException {
        this.referenceListForHeap = new ObjectList();
        this.references = new IntHashTable(11, 5);
        this.openTag("EXCEPTION");
        this.encodeHREFAttribute(new StringBuilder(8).append(objectReferencePrefix).append(this.nextReferenceID).toString());
        this.endTag();
        DefaultAbapObject classException = (DefaultAbapObject)ace.toAbapObject();
        Reference mainExceptionReference = new Reference(classException, this.nextReferenceID);
        this.references.put(classException.getObjectId(), mainExceptionReference);
        ++this.nextReferenceID;
        this.openTag("EXCEPTION_TEXT");
        String message = ace.getMessage();
        if (message != null && message.trim().length() > 0) {
            this.encodeText(message);
        }
        this.endTag();
        this.endTag();
        this.startHeap();
        mainExceptionReference.encode();
        while (!this.referenceListForHeap.isEmpty()) {
            this.referenceListForHeap.pop().encode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encode(AbstractRecord record) throws IOException {
        if (record.recType == 4) {
            String rowTag = ITEM;
            boolean vector = record.metaData.numFields == 1 && record.metaData.name[0].length() == 0;
            int row_save = record.row;
            try {
                if (vector) {
                    int currRow = 0;
                    while (currRow < record.numRows) {
                        record.row = currRow++;
                        this.element(record, 0, rowTag);
                    }
                } else {
                    for (int currRow = 0; currRow < record.numRows; ++currRow) {
                        record.row = currRow;
                        this.openTag(rowTag);
                        for (int i = 0; i < record.metaData.numFields; ++i) {
                            this.element(record, i, record.metaData.name[i]);
                        }
                        this.endTag();
                    }
                }
                Object var8_9 = null;
                record.row = row_save;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                record.row = row_save;
                throw throwable;
            }
        }
        for (int i = 0; i < record.metaData.numFields; ++i) {
            this.element(record, i, record.metaData.name[i]);
        }
    }

    void encode(DefaultParameterList parameterList, int index) throws IOException {
        this.element(parameterList, index, parameterList.metaData.name[index]);
    }

    private void element(AbstractRecord record, int index, String tag) throws IOException {
        byte itype = record.metaData.type[index];
        this.openTag(tag);
        switch (itype) {
            case 4: 
            case 30: {
                byte[] b = record.getByteArray(index);
                if (b == null || b.length == 0) break;
                this.m_out.write(66);
                this.m_out.write(b.length);
                this.m_out.write(b);
                break;
            }
            case 99: {
                DefaultTable table = record.getTable(index);
                if (table != null) {
                    this.addTableRowCount(table.getNumRows());
                    this.encode(table);
                    break;
                }
                this.addTableRowCount(0);
                break;
            }
            case 17: {
                DefaultStructure struct = record.getStructure(index);
                if (struct == null) break;
                this.encode(struct);
                break;
            }
            case 23: {
                byte[] converted_buffer;
                byte[] bytes = record.getByteArray(index);
                String s = DecFloat.toString(DecFloatType.DECFLOAT16_BE, bytes, 0, bytes.length);
                if (s == null || (converted_buffer = s.getBytes(this.m_encoding)).length == 0) break;
                this.m_out.write(84);
                this.m_out.write(converted_buffer.length);
                this.m_out.write(converted_buffer);
                break;
            }
            case 24: {
                byte[] converted_buffer;
                byte[] bytes = record.getByteArray(index);
                String s = DecFloat.toString(DecFloatType.DECFLOAT34_BE, bytes, 0, bytes.length);
                if (s == null || (converted_buffer = s.getBytes(this.m_encoding)).length == 0) break;
                this.m_out.write(84);
                this.m_out.write(converted_buffer.length);
                this.m_out.write(converted_buffer);
                break;
            }
            case 16: {
                DefaultAbapObject abapObject = record.getAbapObject(index);
                if (abapObject == null) break;
                int objectID = abapObject.getObjectId();
                Reference lookupReference = this.references.get(objectID);
                if (lookupReference == null) {
                    lookupReference = new Reference(abapObject, this.nextReferenceID);
                    this.references.put(objectID, lookupReference);
                    this.referenceListForHeap.add(lookupReference);
                    ++this.nextReferenceID;
                }
                this.encodeHREFAttribute(new StringBuilder(8).append(objectReferencePrefix).append(lookupReference.referenceID).toString());
                break;
            }
            default: {
                byte[] converted_buffer;
                String s = record.getString(index);
                if (s == null || (converted_buffer = s.getBytes(this.m_encoding)).length == 0) break;
                this.m_out.write(84);
                this.m_out.write(converted_buffer.length);
                this.m_out.write(converted_buffer);
            }
        }
        this.endTag();
    }

    private final void openTag(String name) throws IOException {
        int string_id = this.handleString(name);
        this.m_out.write(60);
        this.m_out.write(string_id);
        this.m_out.write(1);
    }

    private final void addTableRowCount(int numRows) throws IOException {
        if (this.lines_id == 0) {
            this.lines_id = this.handleString(LINES);
        }
        this.m_out.write(64);
        this.m_out.write(this.lines_id);
        this.m_out.write(3);
        this.m_out.write(65);
        byte[] convertedBuffer = Integer.toString(numRows).getBytes(this.m_encoding);
        this.m_out.write(convertedBuffer.length);
        this.m_out.write(convertedBuffer);
    }

    private final void encodeHREFAttribute(String href) throws IOException {
        if (this.href_id == 0) {
            this.href_id = this.handleString(HREF);
        }
        this.m_out.write(64);
        this.m_out.write(this.href_id);
        this.m_out.write(1);
        this.m_out.write(65);
        byte[] convertedHREF = href.getBytes(this.m_encoding);
        this.m_out.write(convertedHREF.length);
        this.m_out.write(convertedHREF);
    }

    private final void encodeIDAttribute(String id) throws IOException {
        if (this.id_id == 0) {
            this.id_id = this.handleString(ID);
        }
        this.m_out.write(64);
        this.m_out.write(this.id_id);
        this.m_out.write(1);
        this.m_out.write(65);
        byte[] convertedID = id.getBytes(this.m_encoding);
        this.m_out.write(convertedID.length);
        this.m_out.write(convertedID);
    }

    private void startHeap() throws IOException {
        int id_heap = this.handleString("heap");
        this.m_out.write(60);
        this.m_out.write(id_heap);
        this.m_out.write(2);
        int id_cls = this.handleString("cls");
        int id_URIGlobalClasses = this.handleNamespaceString(URI_ABAP_GLOBAL_CLASSES);
        this.m_out.write(58);
        this.m_out.write(id_cls);
        this.m_out.write(id_URIGlobalClasses);
        this.m_out.write(42);
        this.m_out.write(4);
    }

    private final void encodeText(String text) throws IOException {
        this.m_out.write(84);
        byte[] convertedText = text.getBytes(this.m_encoding);
        this.m_out.write(convertedText.length);
        this.m_out.write(convertedText);
    }

    private final int handleString(String name) throws IOException {
        int string_id;
        Integer stringID = this.m_hashed_strings.get(name);
        if (stringID == null) {
            this.m_out.write(43);
            this.m_hashed_strings.put(name, new Integer(++this.m_currentID));
            string_id = this.m_currentID;
            byte[] converted_buffer = this.escape(name).getBytes(this.m_encoding);
            this.m_out.write(converted_buffer.length);
            this.m_out.write(converted_buffer);
        } else {
            string_id = stringID;
        }
        return string_id;
    }

    private final int handleNamespaceString(String name) throws IOException {
        int string_id;
        Integer stringID = this.m_hashed_strings.get(name);
        if (stringID == null) {
            this.m_out.write(43);
            this.m_hashed_strings.put(name, new Integer(++this.m_currentID));
            string_id = this.m_currentID;
            byte[] converted_buffer = name.getBytes(this.m_encoding);
            this.m_out.write(converted_buffer.length);
            this.m_out.write(converted_buffer);
        } else {
            string_id = stringID;
        }
        return string_id;
    }

    private final String escape(String name) {
        StringBuilder buf = new StringBuilder(64);
        char ch1 = name.charAt(0);
        if (Character.isLetter(ch1) || ch1 == '_') {
            buf.append(ch1);
        } else if (ch1 == '/') {
            buf.append("_-");
        } else {
            buf.append("_--");
            buf.append(Codecs.Hex.encode((byte)ch1));
        }
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                buf.append(ch);
                continue;
            }
            if (ch == '/') {
                buf.append("_-");
                continue;
            }
            buf.append("_--");
            buf.append(Codecs.Hex.encode((byte)ch));
        }
        return buf.toString();
    }

    private final void endTag() throws IOException {
        this.m_out.write(62);
    }

    public void close() throws IOException {
        this.m_out.write(62);
        this.m_out.write(62);
        this.m_out.close();
    }

    final void encode(DefaultAbapObject instance, int referenceID) throws IOException {
        DefaultClassMetaData classMetaData = instance.getClassMetaData();
        String className = classMetaData.getName();
        int classNameID = this.handleString(className);
        this.m_out.write(60);
        this.m_out.write(classNameID);
        this.m_out.write(4);
        this.encodeIDAttribute(new StringBuilder(10).append('o').append(referenceID).toString());
        List<String> parentClasses = classMetaData.getParentClasses();
        int attributeCount = classMetaData.getFieldCount();
        int j = 0;
        for (String parentClass : parentClasses) {
            this.openTag(parentClass);
            while (j < attributeCount && classMetaData.getDeclaringClass(j).equals(parentClass)) {
                if (classMetaData.getAttributeKind(j) == JCoClassMetaData.JCoAttributeKind.INSTANCE) {
                    this.element(instance, j, classMetaData.getName(j));
                }
                ++j;
            }
            this.endTag();
        }
        this.m_out.write(60);
        this.m_out.write(classNameID);
        this.m_out.write(1);
        while (j < attributeCount) {
            if (classMetaData.getAttributeKind(j) == JCoClassMetaData.JCoAttributeKind.INSTANCE) {
                this.element(instance, j, classMetaData.getName(j));
            }
            ++j;
        }
        this.endTag();
        this.endTag();
    }

    static {
        BasXMLWriter.calculateBinaryHeader();
    }

    class Reference {
        DefaultAbapObject instance;
        int referenceID;

        Reference(DefaultAbapObject instance, int referenceID) {
            this.instance = instance;
            this.referenceID = referenceID;
        }

        void encode() throws IOException {
            BasXMLWriter.this.encode(this.instance, this.referenceID);
        }
    }
}

