/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.Trace;
import com.sap.jdsr.writer.DsrFactory;
import com.sap.jdsr.writer.DsrIMainRecord;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrIRecordSet;

public class Dsr {
    private static String dsrCompName = "SAP Java Connector";
    private static final byte INITED = 1;
    private static final byte DSR_IN_CLASSPATH = 2;
    private static final byte RFC_DSR_INITED = 4;
    private static final byte DSR_STATE_ON = 8;
    public static final int DSR_ACTION_CLIENT_EXECUTE = 0;
    public static final int DSR_ACTION_SERVER_DISPATCH = 1;
    private static final String[] action_info = new String[]{"JCoClient.execute", "JCoServer.dispatchRequest"};
    private static byte dsr_state = 0;
    private DsrIRecordSet dsrRecordSet;
    private DsrIMainRecord dsrMainRecord;
    private DsrIPassport dsrPassport;

    public static void setDsrComponentName(String dsrName) {
        if (dsrName != null && dsrName.length() > 0) {
            dsrCompName = dsrName;
        }
    }

    public static void setState(String value) {
        if (value == null) {
            return;
        }
        if ("1".equals(value)) {
            if (!Dsr.initDsr()) {
                Trace.fireTraceCritical("[JCoAPI] jDSR library not found in CLASSPATH. Please check CLASSPATH.");
                throw new JCoRuntimeException(150, "JCO_ERROR_DSR_LOAD_ERROR", "jDSR library not found in CLASSPATH. Please check CLASSPATH.");
            }
            dsr_state = (byte)(dsr_state | 0xC);
        } else if ("0".equals(value)) {
            dsr_state = (byte)(dsr_state & 0xFFFFFFF7);
        }
    }

    public static Dsr createMonitor() {
        if (dsr_state == 15) {
            return new Dsr();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initDsr() {
        block5: {
            if ((dsr_state & 1) == 0) {
                try {
                    try {
                        Class.forName("com.sap.jdsr.writer.DsrFactory");
                        dsr_state = (byte)(dsr_state | 2);
                    }
                    catch (Exception exception) {
                        Object var2_1 = null;
                        dsr_state = (byte)(dsr_state | 1);
                        break block5;
                    }
                    Object var2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    dsr_state = (byte)(dsr_state | 1);
                    throw throwable;
                }
                dsr_state = (byte)(dsr_state | 1);
            }
        }
        if ((dsr_state & 2) == 0) return false;
        return true;
    }

    public void openDsrRecord(long handle, int action_type, byte[] passport_bytes, long start_time) {
        boolean withTrace = Trace.isOn(4);
        if (withTrace) {
            Trace.fireTrace(4, new StringBuffer("[JCoAPI] openDsrRecord for connection with handle ").append(handle).append(" [enter]").toString());
        }
        if (passport_bytes != null) {
            try {
                if (this.dsrPassport == null) {
                    this.dsrPassport = DsrFactory.makeDsrPassport();
                }
                if (this.dsrRecordSet == null) {
                    if (action_type == 1) {
                        this.dsrRecordSet = DsrFactory.makeDsrRecordSet((String)dsrCompName);
                    } else {
                        this.dsrPassport.setByNetPassport(passport_bytes);
                        this.dsrRecordSet = DsrFactory.makeDsrRecordSet((String)this.dsrPassport.getCompName());
                    }
                }
                if (this.dsrRecordSet == null) {
                    Trace.fireTrace(1, "[JCoAPI] openDsrRecord(): error in jdsr library:DsrFactory.makeDsrRecordSet returns null");
                    return;
                }
                this.dsrRecordSet.getCertRecord().setByNetPassport(passport_bytes);
                this.dsrMainRecord = this.dsrRecordSet.getMainRecord();
                this.dsrMainRecord.setStartTime(start_time);
            }
            catch (Throwable th) {
                Trace.fireTrace(1, "[JCoAPI] openDsrRecord(): error in jdsr library:" + th.toString());
            }
        } else {
            Trace.fireTrace(2, "[JCoAPI] openDsrRecord(): passport isn't set");
        }
        if (withTrace) {
            Trace.fireTrace(4, new StringBuffer("[JCoAPI] openDsrRecord for connection with handle ").append(handle).append("   [leave]").toString());
        }
    }

    public void closeDsrRecord(long handle, int dsr_action, String rfm_name, long time_total, long time_middleware, long time_handle_request, long num_sent_bytes, long num_received_bytes) {
        boolean withTrace = Trace.isOn(4);
        boolean isWritten = false;
        if (withTrace) {
            Trace.fireTrace(4, new StringBuffer("[JCoAPI] closeDsrRecord for connection with handle ").append(handle).append("  [enter]").toString());
        }
        if (this.dsrMainRecord != null) {
            try {
                this.dsrMainRecord.setAction(action_info[dsr_action]);
                this.dsrMainRecord.setActionType(dsr_action);
                this.dsrMainRecord.setRespTime((int)time_total);
                this.dsrMainRecord.setCpuTime(0);
                this.dsrMainRecord.setWaitTime(dsr_action == 0 ? (int)time_middleware : (int)time_handle_request);
                StringBuffer addInfo = new StringBuffer("Calling rfc module ");
                addInfo.append(rfm_name);
                addInfo.append(" [bytes received ");
                addInfo.append(num_received_bytes);
                addInfo.append(", bytes sent ");
                addInfo.append(num_sent_bytes);
                addInfo.append("]");
                this.dsrMainRecord.setAddInfo(addInfo.toString());
                this.dsrMainRecord.setGenTime(0);
                this.dsrMainRecord.setLoadTime(0);
                this.dsrMainRecord.setMaxMem(0);
                this.dsrMainRecord.setNetTime(0);
                this.dsrMainRecord.setService(0);
                this.dsrMainRecord.setTransId(this.dsrPassport.getTransId());
                isWritten = this.dsrRecordSet.write();
                if (!isWritten) {
                    Trace.fireTrace(2, "[JCoAPI] Dsr Recordset cannot be written.");
                }
            }
            catch (Throwable th) {
                Trace.fireTrace(1, "[JCoAPI] closeDsrRecord(): error in jdsr library:" + th.toString());
            }
            if (withTrace) {
                Trace.fireTrace(4, new StringBuffer("[JCoAPI] writeDsrRecord for connection with handle ").append(handle).append(" returns ").append(isWritten).toString());
            }
            this.dsrRecordSet.clear();
            this.dsrMainRecord.clear();
            this.dsrPassport.clear();
            if (withTrace) {
                Trace.fireTrace(4, new StringBuffer("[JCoAPI] closeDsrRecord for connection with handle ").append(handle).append("  [leave]").toString());
            }
        }
    }
}

