/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionManager {
    private static LinkedList<Exception> exObjects = new LinkedList();
    private static final int ERR_ITEMS = 5;
    public static final int ERR_RESET = -1;
    public static final int ERR_UNKNOWN = 0;
    public static final int ERR_OPEN = 1;
    public static final int ERR_CLOSE = 2;
    public static final int ERR_WRITE = 3;
    public static final int ERR_VALUE = 4;
    public static final int ERR_FORMAT = 5;

    public static synchronized Exception getException() {
        if (exObjects.size() > 0) {
            return exObjects.getLast();
        }
        return null;
    }

    public static synchronized List<Exception> getExceptions() {
        if (exObjects != null) {
            return Collections.unmodifiableList(exObjects);
        }
        return Collections.emptyList();
    }

    public static synchronized void resetException() {
        exObjects.clear();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stack = new StringWriter();
        PrintWriter writer = new PrintWriter(stack);
        throwable.printStackTrace(writer);
        return ((Object)stack).toString() + Formatter.EOL;
    }

    public static void handleException(Exception exc) {
        ExceptionManager.handleException(exc, 0);
    }

    public static void handleException(Exception exc, int code) {
        ExceptionManager.saveException(exc, code);
    }

    public static void UNEXPECTED_EXCEPTION(Location location, String method, String[] args, Exception ex) {
        APILogger.logIntByAPI(200, location, method, "ASJ.log_api.000001", "Unexcepted error occured on {0}!", args);
        APILogger.catchingIntByAPI(ex);
        ExceptionManager.handleException(ex);
    }

    private static synchronized void saveException(Exception ex, int code) {
        if (exObjects.size() == 5) {
            return;
        }
        if (exObjects.contains(ex)) {
            return;
        }
        exObjects.add(ex);
    }
}

