/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.MessageBuilder;
import com.sap.tc.logging.Version;
import com.sap.tc.logging.exceptions.BufferDataException;
import com.sap.tc.logging.exceptions.DataException;
import com.sap.tc.logging.exceptions.FileOpenException;
import com.sap.tc.logging.exceptions.OpenException;
import com.sap.tc.logging.interfaces.IMessageBuilder;
import java.io.IOException;
import java.io.RandomAccessFile;

class LocalBuffer {
    private static final int INIT_VALUE = -1;
    private static final int MAX_EXTEND_COUNTER = 50;
    public static final int DEFAULT_BUFFER_SIZE = 8128;
    public static final int DEFAULT_CHUNK_SIZE = 81280;
    private byte[] buffer;
    private byte[] bufferHelper;
    private byte[] chunk;
    private byte[] emptyChunk;
    private int extendCounter = 0;
    private int buffCurrPos = -1;
    private int buffCurrSize = -1;
    private int lineSize = 0;
    private int chunkOffset = -1;
    private boolean chunkBOL;
    private boolean chunkEOL;
    private int latestDirection = -2;
    private String sourceName;
    private RandomAccessFile source;
    private int fileHeaderSize;
    private int fileFooterSize;
    private long historyLatestBOL;
    private long historyLatestEOL;
    private MessageBuilder msgBuilder;
    private int asciiZeroes;

    protected LocalBuffer(String sourceName, IMessageBuilder msgBuilder) throws OpenException {
        if (msgBuilder == null) {
            throw new IllegalArgumentException("MessageBuilder is missing!");
        }
        this.sourceName = sourceName;
        this.msgBuilder = (MessageBuilder)msgBuilder;
        this.buffer = new byte[8128];
        this.bufferHelper = new byte[8128];
        this.chunk = new byte[81280];
        this.emptyChunk = new byte[81280];
        try {
            this.source = new RandomAccessFile(sourceName, "r");
            this.setBookMark(0L);
        }
        catch (Exception ex) {
            throw new FileOpenException(sourceName, ex);
        }
    }

    public boolean isBOF() throws IOException {
        return this.isBOFInt();
    }

    public boolean isEOF() throws IOException {
        return this.isEOFInt();
    }

    boolean isLastMessage(int lastMsgLength) throws IOException {
        boolean isAtEOF = this.source.getFilePointer() == this.source.length();
        boolean isLastMsg = this.buffCurrSize - this.buffCurrPos == lastMsgLength;
        return isAtEOF && isLastMsg;
    }

    boolean isFirstMessage(int lastMsgLength, int fileHeaderSize) throws IOException {
        long pos = fileHeaderSize + lastMsgLength;
        return this.source.getFilePointer() - pos <= 0L;
    }

    public void close() throws IOException {
        this.source.close();
        this.source = null;
        this.reset();
    }

    public void moveToBOF() throws IOException {
        if (this.source == null) {
            return;
        }
        this.source.seek(this.fileHeaderSize);
        this.reInit();
    }

    public void moveToEOF() throws IOException {
        if (this.source == null) {
            return;
        }
        this.source.seek(this.source.length() - (long)this.fileFooterSize);
        this.reInit();
    }

    public IMessageBuilder readNext() throws DataException {
        try {
            if (this.latestDirection == -1) {
                this.setBookMark(this.msgBuilder.getBookMarkEOL());
            }
            this.msgBuilder.reset();
            this.asciiZeroes = 0;
            do {
                this.msgBuilder.saveNextLine(this.nextLine(), this.lineSize - this.asciiZeroes);
                if (this.msgBuilder.getBookMarkEOL() != -1L) continue;
                this.msgBuilder.setBookMarkBOL(this.historyLatestBOL);
            } while (!this.msgBuilder.isComplete(1));
        }
        catch (Exception ex) {
            throw new BufferDataException(this.sourceName, ex);
        }
        if (Version.getVersionIndex(Version.getVersionOfFirstRecord()) == 20) {
            this.nextLine();
        }
        this.msgBuilder.setBookMarkEOL(this.historyLatestEOL);
        return this.msgBuilder;
    }

    public IMessageBuilder readPrevious() throws DataException {
        try {
            if (this.latestDirection == 1) {
                this.setBookMark(this.msgBuilder.getBookMarkBOL() - 1L);
            }
            this.msgBuilder.reset();
            do {
                this.msgBuilder.savePreviousLine(this.previousLine(), this.lineSize);
                if (this.msgBuilder.getBookMarkEOL() != -1L) continue;
                this.msgBuilder.setBookMarkEOL(this.historyLatestEOL);
            } while (!this.msgBuilder.isComplete(-1));
        }
        catch (Exception ex) {
            throw new BufferDataException(this.sourceName, ex);
        }
        this.msgBuilder.setBookMarkBOL(this.historyLatestBOL);
        return this.msgBuilder;
    }

    public void setBookMark(long value) throws IOException {
        if (this.source == null) {
            return;
        }
        if (value <= 0L) {
            value = this.fileHeaderSize;
        } else if (value >= this.source.length() - (long)this.fileFooterSize) {
            value = this.source.length() - (long)this.fileFooterSize;
        }
        this.seek(value);
    }

    public void setFileHeaderSize(int value) throws IOException {
        this.fileHeaderSize = value;
        this.moveToBOF();
    }

    public void setFileFooterSize(int value) throws IOException {
        this.fileFooterSize = value;
        this.moveToBOF();
    }

    public long getBookMark() throws DataException {
        return this.historyLatestEOL;
    }

    public void seek(long pos) throws IOException {
        if (this.source == null) {
            return;
        }
        this.source.seek(pos);
        this.reInit();
    }

    private void resetLine() {
        this.chunkBOL = false;
        this.chunkEOL = false;
        this.chunkOffset = -1;
        this.lineSize = 0;
        this.asciiZeroes = 0;
    }

    private void reInit() {
        this.buffCurrPos = -1;
        this.buffCurrSize = -1;
        this.latestDirection = -2;
        this.reset();
    }

    private boolean hasNext() {
        return this.buffCurrPos >= 0 && this.buffCurrPos < this.buffCurrSize;
    }

    private boolean hasPrevious() {
        return this.buffCurrPos >= 0;
    }

    private void fillBufferForward() throws IOException, DataException {
        if (this.isEOFInt()) {
            return;
        }
        this.setLatestDirection(1);
        this.loadBuffer(this.source.read(this.bufferHelper, 0, 8128));
    }

    private void fillBufferBackward() throws IOException, DataException {
        if (this.isBOFInt()) {
            return;
        }
        int tmpBufferSize = 8128;
        long currFilePointer = this.source.getFilePointer() - (long)this.buffCurrSize;
        if (currFilePointer - (long)tmpBufferSize <= 0L) {
            tmpBufferSize = (int)currFilePointer - this.fileHeaderSize;
            currFilePointer = 0L;
            this.setFilePointer(currFilePointer);
        } else {
            this.setFilePointer(currFilePointer -= 8128L);
        }
        this.setLatestDirection(-1);
        this.loadBuffer(this.source.read(this.bufferHelper, 0, tmpBufferSize));
    }

    private void setFilePointer(long value) throws IOException {
        if (value <= 0L) {
            value = this.fileHeaderSize;
        } else if (value >= this.source.length() - (long)this.fileFooterSize) {
            value = this.source.length() - (long)this.fileFooterSize;
        }
        this.source.seek(value);
    }

    private void loadBuffer(int buffSize) throws DataException {
        if (buffSize < 0) {
            return;
        }
        try {
            if (this.lineSize > 0) {
                if (this.latestDirection == 1) {
                    int newBufferSize = this.lineSize + buffSize;
                    byte[] tempBuffer = new byte[newBufferSize];
                    System.arraycopy(this.buffer, this.buffCurrPos - this.lineSize, tempBuffer, 0, this.lineSize);
                    System.arraycopy(this.bufferHelper, 0, tempBuffer, this.lineSize, buffSize);
                    this.setCurrentSize(newBufferSize);
                    this.buffCurrPos = this.lineSize;
                    this.chunkOffset = 0;
                    this.buffer = tempBuffer;
                } else {
                    int newBufferSize = this.lineSize + buffSize;
                    byte[] tempBuffer = new byte[newBufferSize];
                    System.arraycopy(this.bufferHelper, 0, tempBuffer, 0, buffSize);
                    System.arraycopy(this.buffer, 0, tempBuffer, buffSize, this.lineSize);
                    this.setCurrentSize(buffSize);
                    this.chunkOffset = buffSize;
                    this.buffer = tempBuffer;
                }
            } else {
                if (this.buffer.length < this.bufferHelper.length) {
                    this.buffer = new byte[this.bufferHelper.length];
                }
                System.arraycopy(this.bufferHelper, 0, this.buffer, 0, buffSize);
                this.setCurrentSize(buffSize);
            }
        }
        catch (Exception ex) {
            throw new BufferDataException("LoadBuffer", ex);
        }
    }

    private boolean isChunkComplete() {
        return this.chunkBOL && this.chunkEOL;
    }

    private byte[] nextLine() throws DataException {
        try {
            this.resetLine();
            do {
                if (!this.hasNext()) {
                    if (this.lineSize > 0 && this.isChunkComplete()) {
                        return this.getChunkInt();
                    }
                    this.fillBufferForward();
                }
                while (this.hasNext()) {
                    this.next();
                    if (!this.isChunkComplete()) continue;
                    return this.getChunkInt();
                }
            } while (!this.isEOFInt());
        }
        catch (IOException ex) {
            throw new BufferDataException(this.sourceName, ex);
        }
        return this.getChunkInt();
    }

    private byte[] previousLine() throws DataException {
        try {
            this.resetLine();
            do {
                if (!this.hasPrevious()) {
                    if (this.lineSize > 0 && this.isChunkComplete()) {
                        return this.getChunkInt();
                    }
                    this.fillBufferBackward();
                }
                while (this.hasPrevious()) {
                    this.previous();
                    if (!this.isChunkComplete()) continue;
                    return this.getChunkInt();
                }
            } while (!this.isBOFInt());
        }
        catch (IOException ex) {
            throw new BufferDataException(this.sourceName, ex);
        }
        return this.getChunkInt();
    }

    private byte next() throws DataException {
        byte value = -1;
        try {
            this.latestDirection = 1;
            value = this.buffer[this.buffCurrPos];
            ++this.lineSize;
            switch (value) {
                case 10: {
                    this.chunkBOL = true;
                    this.chunkEOL = true;
                    this.msgBuilder.getDelimiter().demask();
                    break;
                }
                case 0: {
                    if (Version.getVersionIndex(Version.getVersionOfFirstRecord()) != 20) break;
                    ++this.asciiZeroes;
                    break;
                }
                default: {
                    this.msgBuilder.getDelimiter().saveNextPosition(value, this.lineSize - this.asciiZeroes);
                }
            }
            if (this.chunkOffset == -1) {
                this.chunkOffset = this.buffCurrPos;
            }
            ++this.buffCurrPos;
        }
        catch (Exception ex) {
            throw new BufferDataException(this.sourceName, ex);
        }
        return value;
    }

    private byte previous() throws DataException {
        byte value = -1;
        try {
            this.latestDirection = -1;
            value = this.buffer[this.buffCurrPos];
            ++this.lineSize;
            switch (value) {
                case 10: {
                    if (this.lineSize > 1) {
                        this.chunkBOL = true;
                        if (this.chunkOffset == -1) {
                            this.chunkOffset = this.buffCurrPos;
                        }
                        --this.lineSize;
                    } else {
                        --this.buffCurrPos;
                    }
                    this.chunkEOL = true;
                    break;
                }
                default: {
                    this.msgBuilder.getDelimiter().savePreviousPosition(value, this.lineSize);
                    this.chunkOffset = this.buffCurrPos--;
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new BufferDataException(this.sourceName, ex);
        }
        return value;
    }

    private void setLatestDirection(int direction) {
        if (direction < -1) {
            direction = -1;
        }
        if (direction > 1) {
            direction = 1;
        }
        if (direction == 0) {
            direction = 1;
        }
        this.latestDirection = direction;
    }

    private void reset() {
        this.asciiZeroes = 0;
        this.lineSize = 0;
        this.chunkOffset = -1;
        if (this.extendCounter >= 50 && this.chunk.length > 81280) {
            this.chunk = new byte[81280];
        } else {
            System.arraycopy(this.emptyChunk, 0, this.chunk, 0, 81280);
        }
    }

    private byte[] getChunkInt() throws DataException {
        if (this.lineSize == 0) {
            return this.chunk;
        }
        try {
            ++this.extendCounter;
            if (this.chunk.length < this.lineSize) {
                byte[] tmpNewChunk = new byte[this.lineSize];
                System.arraycopy(this.chunk, 0, tmpNewChunk, 0, this.chunk.length);
                this.chunk = tmpNewChunk;
                this.extendCounter = 0;
            }
            System.arraycopy(this.buffer, this.chunkOffset + this.asciiZeroes, this.chunk, 0, this.lineSize - this.asciiZeroes);
            this.historyLatestBOL = this.getBOLPointer();
            this.historyLatestEOL = this.getEOLPointer();
        }
        catch (Exception ex) {
            throw new BufferDataException(this.sourceName, ex);
        }
        return this.chunk;
    }

    private void setCurrentSize(int value) {
        this.buffCurrSize = value;
        this.chunkOffset = -1;
        this.buffCurrPos = 0;
        this.chunkEOL = false;
        this.chunkBOL = false;
        if (this.latestDirection == -1) {
            this.buffCurrPos = this.buffCurrSize > 0 ? this.buffCurrSize - 1 : -1;
        }
    }

    private long getBOLPointer() throws IOException {
        long buffSize;
        long pos = this.calculateBOLPos();
        long l = buffSize = this.buffCurrSize > 0 ? (long)this.buffCurrSize : 0L;
        if (pos < 0L) {
            pos = pos * -1L + buffSize;
        }
        return this.source.getFilePointer() - pos;
    }

    private long getEOLPointer() throws IOException {
        long pos = this.calculateEOLPos();
        return this.source.getFilePointer() - pos;
    }

    private long calculateBOLPos() {
        long buffTmpSize;
        long buffTmpPos = this.buffCurrPos;
        long l = buffTmpSize = this.buffCurrSize > 0 ? (long)this.buffCurrSize : 0L;
        if (this.latestDirection == 1) {
            buffTmpPos = buffTmpPos - (long)this.lineSize >= -1L ? buffTmpSize - buffTmpPos + (long)this.lineSize : (buffTmpPos -= (long)(this.lineSize + 1));
        } else if (this.latestDirection == -1) {
            buffTmpPos = buffTmpSize - buffTmpPos - 1L;
        }
        return buffTmpPos;
    }

    private long calculateEOLPos() {
        long buffTmpSize;
        long buffTmpPos = this.buffCurrPos;
        long l = buffTmpSize = this.buffCurrSize > 0 ? (long)this.buffCurrSize : 0L;
        buffTmpPos = this.latestDirection == 1 ? buffTmpSize - buffTmpPos : (this.latestDirection == -1 ? (buffTmpSize - buffTmpPos - (long)this.lineSize >= -1L ? buffTmpSize - (buffTmpPos + (long)this.lineSize + 1L) : buffTmpSize - buffTmpPos - (long)this.lineSize) : (this.buffCurrPos > 0 ? (long)this.buffCurrPos : 0L));
        return buffTmpPos;
    }

    private boolean isBOFInt() throws IOException {
        if (this.source == null) {
            return true;
        }
        return this.getBOLPointer() - (long)this.fileHeaderSize <= 0L;
    }

    private boolean isEOFInt() throws IOException {
        if (this.source == null) {
            return true;
        }
        return this.source.length() - (long)this.fileFooterSize <= this.getEOLPointer();
    }
}

