/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.fscc;

import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.fscc.BasicFileInformation;
import jcifs.internal.util.SMBUtil;

public class FileStandardInfo
implements BasicFileInformation {
    private long allocationSize;
    private long endOfFile;
    private int numberOfLinks;
    private boolean deletePending;
    private boolean directory;

    @Override
    public byte getFileInformationLevel() {
        return 5;
    }

    @Override
    public int getAttributes() {
        return 0;
    }

    @Override
    public long getCreateTime() {
        return 0L;
    }

    @Override
    public long getLastWriteTime() {
        return 0L;
    }

    @Override
    public long getLastAccessTime() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this.endOfFile;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        this.allocationSize = SMBUtil.readInt8(buffer, bufferIndex);
        this.endOfFile = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.numberOfLinks = SMBUtil.readInt4(buffer, bufferIndex += 8);
        bufferIndex += 4;
        this.deletePending = (buffer[bufferIndex++] & 0xFF) > 0;
        this.directory = (buffer[bufferIndex++] & 0xFF) > 0;
        return bufferIndex - start;
    }

    @Override
    public int size() {
        return 22;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt8(this.allocationSize, dst, dstIndex);
        SMBUtil.writeInt8(this.endOfFile, dst, dstIndex += 8);
        SMBUtil.writeInt4(this.numberOfLinks, dst, dstIndex += 8);
        dstIndex += 4;
        dst[dstIndex++] = (byte)(this.deletePending ? 1 : 0);
        dst[dstIndex++] = (byte)(this.directory ? 1 : 0);
        return dstIndex - start;
    }

    public String toString() {
        return new String("SmbQueryInfoStandard[allocationSize=" + this.allocationSize + ",endOfFile=" + this.endOfFile + ",numberOfLinks=" + this.numberOfLinks + ",deletePending=" + this.deletePending + ",directory=" + this.directory + "]");
    }
}

