/*
 * Decompiled with CFR 0.152.
 */
package com.opendata.api.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DatetimeUtils {
    public static final String sdfyyyy = "yyyy";
    public static final String sdfyyyyMM = "yyyy-MM";
    public static final String sdfyyyyMMdd = "yyyy-MM-dd";
    public static final String sdfyyyyMMddHH = "yyyy-MM-dd HH";
    public static final String sdfyyyyMMddHHmm = "yyyy-MM-dd HH:mm";
    public static final String sdfyyyyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    public static final String sdfMM = "MM";
    public static final String sdfdd = "dd";
    public static final String sdfHH = "HH";
    public static final String sdfmm = "mm";
    public static final String sdfss = "ss";
    public static final String sdfHHmm = "HH:mm";
    public static final String sdfHHmmss = "HH:mm:ss";

    public static boolean isSameDate(Date date1, Date date2) {
        return DatetimeUtils.toDayStart(date1).getTime() == DatetimeUtils.toDayStart(date2).getTime();
    }

    public static boolean isBefore(Date date1, Date date2) {
        return DatetimeUtils.toDayStart(date1).getTime() <= DatetimeUtils.toDayStart(date2).getTime();
    }

    public static String dateToString(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static Date stringToDate(String date, String pattern) {
        try {
            return DateUtils.parseDate((String)date, (String[])new String[]{pattern});
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date toDayStart(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(sdfyyyyMMdd);
        try {
            return sdf.parse(sdf.format(date));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date toDayEnd(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(sdfyyyyMMdd);
        Date tmp = null;
        try {
            tmp = sdf.parse(sdf.format(date));
        }
        catch (ParseException e) {
            return null;
        }
        return new Date(tmp.getTime() + 86400000L - 1L);
    }

    public static int getYear() {
        return DatetimeUtils.getYear(new Date());
    }

    public static int getYear(Date date) {
        String year = DateFormatUtils.format((Date)date, (String)sdfyyyy);
        return Integer.parseInt(year);
    }

    public static int getMonth() {
        return DatetimeUtils.getMonth(new Date());
    }

    public static int getMonth(Date date) {
        String month = DateFormatUtils.format((Date)date, (String)sdfMM);
        return Integer.parseInt(month);
    }

    public static int getDay() {
        return DatetimeUtils.getDay(new Date());
    }

    public static int getDay(Date date) {
        String day = DateFormatUtils.format((Date)date, (String)sdfdd);
        return Integer.parseInt(day);
    }

    public static int getHour() {
        return DatetimeUtils.getHour(new Date());
    }

    public static int getHour(Date date) {
        String hours = DateFormatUtils.format((Date)date, (String)sdfHH);
        return Integer.parseInt(hours);
    }

    public static int getMinute() {
        return DatetimeUtils.getMinute(new Date());
    }

    public static int getMinute(Date date) {
        String minutes = DateFormatUtils.format((Date)date, (String)sdfmm);
        return Integer.parseInt(minutes);
    }

    public static int getSecond() {
        return DatetimeUtils.getSecond(new Date());
    }

    public static int getSecond(Date date) {
        String seconds = DateFormatUtils.format((Date)date, (String)sdfss);
        return Integer.parseInt(seconds);
    }

    public static int getWeek() {
        return DatetimeUtils.getWeek(new Date());
    }

    public static int getWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7) - 1;
        return week < 0 ? 0 : week;
    }

    public static int getMonthDays(Date date) {
        if (date == null) {
            throw new RuntimeException("date is null");
        }
        int year = DatetimeUtils.getYear(date);
        int month = DatetimeUtils.getMonth(date);
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 2) {
            if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                return 29;
            }
            return 28;
        }
        return 30;
    }

    public static int getDiffYears(Date date1, Date date2) {
        int y = DatetimeUtils.getYear(date2);
        int m = DatetimeUtils.getMonth(date2);
        int d = DatetimeUtils.getDay(date2);
        int yFrom = DatetimeUtils.getYear(date1);
        int mFrom = DatetimeUtils.getMonth(date1);
        int dFrom = DatetimeUtils.getDay(date1);
        if (m > mFrom) {
            return y - yFrom;
        }
        if (m == mFrom) {
            if (d >= dFrom) {
                return y - yFrom;
            }
            return y - yFrom - 1;
        }
        if (m < mFrom) {
            return y - yFrom - 1;
        }
        return 0;
    }

    public static int getDiffMonths(Date date1, Date date2) {
        return Math.abs(DatetimeUtils.getYear(date2) * 12 + DatetimeUtils.getMonth(date2) - DatetimeUtils.getYear(date1) * 12 - DatetimeUtils.getMonth(date1));
    }

    public static int getDiffDays(Date date1, Date date2) {
        long diffTimes = Math.abs(DatetimeUtils.toDayStart(date2).getTime() - DatetimeUtils.toDayStart(date1).getTime());
        return (int)(diffTimes / 86400000L);
    }

    public static Date getFirstDayOfCurrentMonth() {
        return DatetimeUtils.getFirstDayOfCurrentMonth(new Date());
    }

    public static Date getFirstDayOfCurrentMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(sdfyyyyMM);
        try {
            return sdf.parse(sdf.format(date));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getLastDayOfCurrentMonth() {
        return DatetimeUtils.getLastDayOfCurrentMonth(new Date());
    }

    public static Date getLastDayOfCurrentMonth(Date date) {
        Date temp = DateUtils.addMonths((Date)date, (int)1);
        SimpleDateFormat sdf = new SimpleDateFormat(sdfyyyyMM);
        try {
            Long time = sdf.parse(sdf.format(temp)).getTime();
            return new Date(time - 1L);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getFirstDayOfCurrentWeek() {
        return DatetimeUtils.getFirstDayOfCurrentWeek(new Date());
    }

    public static Date getFirstDayOfCurrentWeek(Date date) {
        int week = DatetimeUtils.getWeek(date);
        if (week == 0) {
            return DateUtils.addDays((Date)date, (int)-6);
        }
        return DateUtils.addDays((Date)date, (int)(1 - week));
    }

    public static Date getLastDayOfCurrentWeek() {
        return DatetimeUtils.getLastDayOfCurrentWeek(new Date());
    }

    public static Date getLastDayOfCurrentWeek(Date date) {
        int week = DatetimeUtils.getWeek(date);
        if (week == 0) {
            return date;
        }
        return DateUtils.addDays((Date)date, (int)(7 - week));
    }

    public static int getAge(Date birthday) {
        int y = DatetimeUtils.getYear();
        int m = DatetimeUtils.getMonth();
        int d = DatetimeUtils.getDay();
        int yFrom = DatetimeUtils.getYear(birthday);
        int mFrom = DatetimeUtils.getMonth(birthday);
        int dFrom = DatetimeUtils.getDay(birthday);
        if (m > mFrom) {
            return y - yFrom;
        }
        if (m == mFrom) {
            if (d >= dFrom) {
                return y - yFrom;
            }
            return y - yFrom - 1;
        }
        if (m < mFrom) {
            return y - yFrom - 1;
        }
        return 0;
    }

    public static String millisecondToDate(long msd) {
        String timeStr = null;
        double time = (int)((double)msd * 0.001);
        timeStr = time != 0.0 ? (time > 60.0 && time < 3600.0 ? String.valueOf((int)Math.floor(time / 60.0)) + "\u5206\u949f" + (int)Math.floor(time % 60.0) + "\u79d2" : (time >= 3600.0 ? String.valueOf((int)Math.floor(time / 3600.0)) + "\u5c0f\u65f6" + (int)Math.floor(time % 3600.0) / 60 + "\u5206\u949f" + (int)Math.floor(time % 60.0) + "\u79d2" : String.valueOf(time) + "\u79d2")) : "0 \u65f6 0 \u52060 \u79d2";
        return timeStr;
    }

    public static void main(String[] args) {
        Date date = DatetimeUtils.stringToDate("2011-06-07", sdfyyyyMMdd);
        int n = DatetimeUtils.getDiffMonths(new Date(), date);
        System.out.println(n);
        int m = DatetimeUtils.getDiffYears(date, new Date());
        System.out.println(m);
    }
}

