/*
 * Decompiled with CFR 0.152.
 */
package com.opendata.api.util;

import com.opendata.api.FileItem;
import com.opendata.api.NormalRequest;
import com.opendata.api.util.HttpClientHttpsUtils;
import com.opendata.api.util.ODPLogger;
import com.opendata.api.util.ResData;
import com.opendata.api.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class WebCUtils {
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";

    public static ResData _doGetAsByte(NormalRequest req) throws IOException {
        HttpURLConnection conn = null;
        byte[] rsp = null;
        ResData res = new ResData();
        try {
            block12: {
                String ctype = "application/x-www-form-urlencoded;charset=" + req.getCharset();
                String query = WebCUtils.buildQuery(req.getTextMap(), req.getCharset());
                try {
                    conn = WebCUtils.getConnection(WebCUtils.buildGetUrl(req.getUrl(), query), METHOD_GET, ctype, req.getHeadMap(), req.getProxy());
                    if (!(conn instanceof HttpsURLConnection)) break block12;
                    try {
                        String str = HttpClientHttpsUtils.sendDataByGet(req.getUrl(), query);
                        rsp = str.getBytes();
                    }
                    catch (Exception e) {
                        ODPLogger.logCommError(e, req.getUrl(), req.getTextMap().get("Method"), req.getTextMap());
                        throw e;
                    }
                    res.setResData(rsp);
                    res.setRes_maybe_encoding(WebCUtils.getResponseCharset("utf-8"));
                    ResData resData = res;
                    return resData;
                }
                catch (IOException e) {
                    ODPLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("Method"), req.getTextMap());
                    throw e;
                }
            }
            conn.setConnectTimeout(req.getConnectTimeout());
            conn.setReadTimeout(req.getReadTimeout());
            try {
                rsp = WebCUtils.getResponseAsByte(conn);
            }
            catch (IOException e) {
                ODPLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("Method"), req.getTextMap());
                throw e;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        res.setResData(rsp);
        res.setRes_maybe_encoding(WebCUtils.getResponseCharset(conn.getContentType()));
        return res;
    }

    public static ResData _doPostAsByte(NormalRequest req) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + req.getCharset();
        String query = WebCUtils.buildQuery(req.getTextMap(), req.getCharset());
        ResData res = new ResData();
        byte[] content = null;
        content = query != null ? query.getBytes(req.getCharset()) : "".getBytes(req.getCharset());
        HttpURLConnection conn = null;
        OutputStream out = null;
        byte[] rsp = null;
        try {
            try {
                conn = WebCUtils.getConnection(new URL(req.getUrl()), METHOD_POST, ctype, req.getHeadMap(), req.getProxy());
                conn.setConnectTimeout(req.getConnectTimeout());
                conn.setReadTimeout(req.getReadTimeout());
            }
            catch (IOException e) {
                ODPLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("Method"), query);
                throw e;
            }
            try {
                out = conn.getOutputStream();
                out.write(content);
                rsp = WebCUtils.getResponseAsByte(conn);
            }
            catch (IOException e) {
                ODPLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("Method"), query);
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        res.setResData(rsp);
        res.setRes_maybe_encoding(WebCUtils.getResponseCharset(conn.getContentType()));
        return res;
    }

    private static ResData _doPostWithFileAsByte(NormalRequest req) throws IOException {
        String boundary = String.valueOf(System.nanoTime());
        HttpURLConnection conn = null;
        OutputStream out = null;
        byte[] rsp = null;
        ResData res = new ResData();
        try {
            try {
                String ctype = "multipart/form-data;charset=" + req.getCharset() + ";boundary=" + boundary;
                conn = WebCUtils.getConnection(new URL(req.getUrl()), METHOD_POST, ctype, req.getHeadMap(), req.getProxy());
                conn.setConnectTimeout(req.getConnectTimeout());
                conn.setReadTimeout(req.getReadTimeout());
            }
            catch (IOException e) {
                ODPLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("Method"), req.getTextMap());
                throw e;
            }
            StringBuilder strBody = new StringBuilder();
            try {
                out = conn.getOutputStream();
                byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(req.getCharset());
                Set<Map.Entry<String, String>> textEntrySet = req.getTextMap().entrySet();
                for (Map.Entry<String, String> textEntry : textEntrySet) {
                    strBody.append(String.valueOf(textEntry.getKey()) + "=" + textEntry.getValue() + "&");
                    byte[] textBytes = WebCUtils.getTextEntry(textEntry.getKey(), textEntry.getValue(), req.getCharset());
                    out.write(entryBoundaryBytes);
                    out.write(textBytes);
                }
                Set<Map.Entry<String, File>> fileEntrySet = req.getUploadMap().entrySet();
                for (Map.Entry<String, File> fileEntry : fileEntrySet) {
                    File f = fileEntry.getValue();
                    FileItem fileItem = new FileItem(f);
                    if (fileItem.getContent() == null) continue;
                    byte[] fileBytes = WebCUtils.getFileEntry(fileEntry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), req.getCharset());
                    out.write(entryBoundaryBytes);
                    out.write(fileBytes);
                    out.write(fileItem.getContent());
                }
                byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes(req.getCharset());
                out.write(endBoundaryBytes);
                rsp = WebCUtils.getResponseAsByte(conn);
            }
            catch (IOException e) {
                ODPLogger.logCommError((Exception)e, req.getUrl(), req.getTextMap().get("Method"), strBody.toString());
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        res.setResData(rsp);
        res.setRes_maybe_encoding(WebCUtils.getResponseCharset(conn.getContentType()));
        return res;
    }

    public static String doPost(NormalRequest req) throws IOException {
        ResData res = req.getUploadMap() == null || req.getUploadMap().isEmpty() ? WebCUtils._doPostAsByte(req) : WebCUtils._doPostWithFileAsByte(req);
        return new String(res.getResData(), res.getRes_maybe_encoding());
    }

    public static byte[] doPostAsByte(NormalRequest req) throws IOException {
        if (req.getUploadMap() == null || req.getUploadMap().isEmpty()) {
            return WebCUtils._doPostAsByte(req).getResData();
        }
        return WebCUtils._doPostWithFileAsByte(req).getResData();
    }

    public static String doGet(NormalRequest req) throws IOException {
        ResData res = WebCUtils._doGetAsByte(req);
        return new String(res.getResData(), res.getRes_maybe_encoding());
    }

    public static byte[] doGetAsByte(NormalRequest req) throws IOException {
        ResData res = WebCUtils._doGetAsByte(req);
        return res.getResData();
    }

    public static ByteArrayOutputStream unzip(InputStream in) {
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        try {
            int num;
            GZIPInputStream gzin = new GZIPInputStream(in);
            byte[] buf = new byte[1024];
            while ((num = gzin.read(buf, 0, buf.length)) != -1) {
                fout.write(buf, 0, num);
            }
            gzin.close();
            fout.close();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return fout;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap, Proxy proxy) throws IOException {
        HttpURLConnection conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection connHttps = (HttpsURLConnection)conn;
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new TrustAllTrustManager()}, new SecureRandom());
                connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            conn = connHttps;
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", ctype);
        conn.setRequestProperty("Accept", "application/json, text/javascript, */*; ");
        conn.setRequestProperty("User-Agent", "hnaesb-sdk-java");
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? String.valueOf(strUrl) + query : String.valueOf(strUrl) + "?" + query) : (strUrl.endsWith("&") ? String.valueOf(strUrl) + query : String.valueOf(strUrl) + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set entries = params.entrySet();
        boolean hasParam = false;
        try {
            for (Map.Entry entry : entries) {
                String value;
                String name = (String)entry.getKey();
                if (!StringUtils.areNotEmpty(name, value = (String)entry.getValue())) continue;
                if (hasParam) {
                    query.append("&");
                } else {
                    hasParam = true;
                }
                String text = URLEncoder.encode(value, charset);
                query.append(name).append("=").append(text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query.toString();
    }

    protected static byte[] getResponseAsByte(HttpURLConnection conn) throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            if (conn.getContentEncoding() != null && conn.getContentEncoding().toLowerCase().equals("gzip")) {
                byte[] bbb = WebCUtils.unzip(conn.getInputStream()).toByteArray();
                return bbb;
            }
            return WebCUtils._readByteFromStream(conn.getInputStream());
        }
        String charset_res = WebCUtils.getResponseCharset(conn.getContentType());
        byte[] b = WebCUtils._readByteFromStream(conn.getInputStream());
        String msg = new String(b, charset_res);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(String.valueOf(conn.getResponseCode()) + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset_res = WebCUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            if (conn.getContentEncoding() != null && conn.getContentEncoding().toLowerCase().equals("gzip")) {
                byte[] bbb = WebCUtils.unzip(conn.getInputStream()).toByteArray();
                return new String(bbb, charset_res);
            }
            return WebCUtils._readCharString(conn.getInputStream(), charset_res);
        }
        String msg = WebCUtils._readCharString(es, charset_res);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(String.valueOf(conn.getResponseCode()) + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private static byte[] _readByteFromStream(InputStream stream) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = stream.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String _readCharString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = "utf-8";
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            String[] stringArray = params = ctype.split(";");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if ((param = param.trim()).startsWith("charset")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                    charset = pair[1].trim();
                    break;
                }
                ++n2;
            }
        }
        return charset;
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = WebCUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            String[] stringArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] param = pair.split("=", 2);
                if (param != null && param.length == 2) {
                    result.put(param[0], param[1]);
                }
                ++n2;
            }
        }
        return result;
    }

    public static void main(String[] adfas) throws Exception {
        String charset = "utf-8";
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String url = "http://127.0.0.1:8081/api/user";
        String value = "\u4f60\u597d";
        String text = URLEncoder.encode(value, charset);
        String query = "systemId=" + text;
        ResData res = new ResData();
        byte[] content = null;
        content = query.getBytes(charset);
        HttpURLConnection conn = null;
        OutputStream out = null;
        byte[] rsp = null;
        try {
            conn = WebCUtils.getConnection(new URL(url), METHOD_POST, ctype, null, null);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebCUtils.getResponseAsByte(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        res.setResData(rsp);
        res.setRes_maybe_encoding(WebCUtils.getResponseCharset(conn.getContentType()));
        System.out.println(res);
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static class VerisignTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

