/*
 * Decompiled with CFR 0.152.
 */
package com.opendata.api.util;

import com.opendata.api.util.WebCUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtils {
    private static final Set<String> CONTENT_TYPES = new HashSet<String>();
    private static final Pattern REGEX_FILE_NAME = Pattern.compile("attachment;filename=\"([\\w\\-]+)\"");

    static {
        CONTENT_TYPES.add("application/octet-stream");
        CONTENT_TYPES.add("application/java-archive");
    }

    private ZipUtils() {
    }

    public static File ungzip(File gzip, File toDir) throws IOException {
        toDir.mkdirs();
        File out = new File(toDir, gzip.getName());
        GZIPInputStream gin = null;
        FileOutputStream fout = null;
        try {
            FileInputStream fin = new FileInputStream(gzip);
            gin = new GZIPInputStream(fin);
            fout = new FileOutputStream(out);
            ZipUtils.copy(gin, fout);
            gin.close();
            fout.close();
        }
        catch (Throwable throwable) {
            ZipUtils.closeQuietly(gin);
            ZipUtils.closeQuietly(fout);
            throw throwable;
        }
        ZipUtils.closeQuietly(gin);
        ZipUtils.closeQuietly(fout);
        return out;
    }

    public static List<File> unzip(File zip, File toDir) throws IOException {
        ArrayList<File> files = null;
        try (ZipFile zf = null;){
            zf = new ZipFile(zip);
            files = new ArrayList<File>();
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(toDir, entry.getName()).mkdirs();
                    continue;
                }
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    File f = new File(toDir, entry.getName());
                    input = zf.getInputStream(entry);
                    output = new FileOutputStream(f);
                    ZipUtils.copy(input, output);
                    files.add(f);
                }
                catch (Throwable throwable) {
                    ZipUtils.closeQuietly(output);
                    ZipUtils.closeQuietly(input);
                    throw throwable;
                }
                ZipUtils.closeQuietly(output);
                ZipUtils.closeQuietly(input);
            }
        }
        return files;
    }

    public static File download(String url, File toDir) throws Exception {
        toDir.mkdirs();
        HttpURLConnection conn = null;
        FileOutputStream output = null;
        File file = null;
        try {
            try {
                conn = ZipUtils.getConnection(new URL(url));
                String ctype = conn.getContentType();
                if (!CONTENT_TYPES.contains(ctype)) {
                    String rsp = WebCUtils.getResponseAsString(conn);
                    throw new Exception(rsp);
                }
                String fileName = ZipUtils.getFileName(conn);
                file = new File(toDir, fileName);
                output = new FileOutputStream(file);
                ZipUtils.copy(conn.getInputStream(), output);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            ZipUtils.closeQuietly(output);
            if (conn != null) {
                conn.disconnect();
            }
            throw throwable;
        }
        ZipUtils.closeQuietly(output);
        if (conn != null) {
            conn.disconnect();
        }
        return file;
    }

    public static File download(String url, File toDir, String fileName) throws Exception {
        toDir.mkdirs();
        HttpURLConnection conn = null;
        FileOutputStream output = null;
        File file = null;
        try {
            try {
                conn = ZipUtils.getConnection(new URL(url));
                String ctype = conn.getContentType();
                if (!CONTENT_TYPES.contains(ctype)) {
                    String rsp = WebCUtils.getResponseAsString(conn);
                    throw new Exception(rsp);
                }
                file = new File(toDir, fileName);
                output = new FileOutputStream(file);
                ZipUtils.copy(conn.getInputStream(), output);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            ZipUtils.closeQuietly(output);
            if (conn != null) {
                conn.disconnect();
            }
            throw throwable;
        }
        ZipUtils.closeQuietly(output);
        if (conn != null) {
            conn.disconnect();
        }
        return file;
    }

    public static boolean checkMd5sum(File file, String checkCode) throws IOException {
        boolean bl;
        DigestInputStream dInput = null;
        try {
            FileInputStream fInput = new FileInputStream(file);
            dInput = new DigestInputStream(fInput, ZipUtils.getMd5Instance());
            byte[] buf = new byte[8192];
            while (dInput.read(buf) > 0) {
            }
            byte[] bytes = dInput.getMessageDigest().digest();
            bl = ZipUtils.bytes2hex(bytes).equals(checkCode);
        }
        catch (Throwable throwable) {
            ZipUtils.closeQuietly(dInput);
            throw throwable;
        }
        ZipUtils.closeQuietly(dInput);
        return bl;
    }

    private static String bytes2hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sb.append("0").append(hex);
            } else {
                sb.append(hex);
            }
            ++i;
        }
        return sb.toString();
    }

    private static MessageDigest getMd5Instance() {
        try {
            return MessageDigest.getInstance("md5");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFileName(HttpURLConnection conn) {
        String fileName = conn.getHeaderField("Content-Disposition");
        Matcher matcher = REGEX_FILE_NAME.matcher(fileName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "application/zip;text/html");
        return conn;
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = ZipUtils.copyStream(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

