/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.common;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.Action;
import io.opentracing.contrib.redis.common.ThrowingAction;
import io.opentracing.contrib.redis.common.ThrowingSupplier;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tags;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TracingHelper {
    public static final String COMPONENT_NAME = "java-redis";
    public static final String DB_TYPE = "redis";
    protected final Tracer tracer;
    private final boolean traceWithActiveSpanOnly;
    private final Function<String, String> spanNameProvider;
    private final int maxKeysLength;
    private final Map<String, String> extensionTags;

    public TracingHelper(TracingConfiguration tracingConfiguration) {
        this.tracer = tracingConfiguration.getTracer();
        this.traceWithActiveSpanOnly = tracingConfiguration.isTraceWithActiveSpanOnly();
        this.spanNameProvider = tracingConfiguration.getSpanNameProvider();
        this.maxKeysLength = tracingConfiguration.getKeysMaxLength();
        this.extensionTags = tracingConfiguration.getExtensionTags();
    }

    private Tracer.SpanBuilder builder(String operationName) {
        Tracer.SpanBuilder sb = this.tracer.buildSpan(this.spanNameProvider.apply(operationName)).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.DB_TYPE.getKey(), DB_TYPE);
        this.extensionTags.forEach((arg_0, arg_1) -> ((Tracer.SpanBuilder)sb).withTag(arg_0, arg_1));
        return sb;
    }

    public Span buildSpan(String operationName, byte[][] keys) {
        if (this.traceWithActiveSpanOnly && this.tracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        return this.builder(operationName).withTag("keys", TracingHelper.toString(keys)).start();
    }

    public Span buildSpan(String operationName) {
        if (this.traceWithActiveSpanOnly && this.tracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        return this.builder(operationName).start();
    }

    public Span buildSpan(String operationName, Object key) {
        if (this.traceWithActiveSpanOnly && this.tracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        return this.builder(operationName).withTag("key", TracingHelper.nullable(key)).start();
    }

    public Span buildSpan(String operationName, byte[] key) {
        if (this.traceWithActiveSpanOnly && this.tracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        return this.builder(operationName).withTag("key", Arrays.toString(key)).start();
    }

    public Span buildSpan(String operationName, Object[] keys) {
        if (this.traceWithActiveSpanOnly && this.tracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        return this.builder(operationName).withTag("keys", Arrays.toString(this.limitKeys(keys))).start();
    }

    <T> T[] limitKeys(T[] keys) {
        if (keys != null && keys.length > this.maxKeysLength) {
            return Arrays.copyOfRange(keys, 0, this.maxKeysLength);
        }
        return keys;
    }

    public static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        if (throwable != null) {
            span.log(TracingHelper.errorLogs(throwable));
        }
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", throwable);
        return errorLogs;
    }

    public static String nullable(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static <V> String toString(Map<String, V> map) {
        ArrayList<String> list = new ArrayList<String>();
        if (map != null) {
            for (Map.Entry<String, V> entry : map.entrySet()) {
                list.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        return "{" + String.join((CharSequence)", ", list) + "}";
    }

    public static String toString(byte[][] array) {
        if (array == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] bytes : array) {
            list.add(Arrays.toString(bytes));
        }
        return "[" + String.join((CharSequence)", ", list) + "]";
    }

    private static String toStringWithDeserialization(byte[][] array) {
        if (array == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] bytes : array) {
            list.add(TracingHelper.deserialize(bytes));
        }
        return "[" + String.join((CharSequence)", ", list) + "]";
    }

    public static String collectionToString(Collection<?> collection) {
        if (collection == null) {
            return "";
        }
        return collection.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public static String toString(Collection<byte[]> collection) {
        if (collection == null) {
            return "null";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] bytes : collection) {
            list.add(Arrays.toString(bytes));
        }
        return "[" + String.join((CharSequence)", ", list) + "]";
    }

    public static String toString(List<String> list) {
        if (list == null) {
            return "null";
        }
        return String.join((CharSequence)", ", list);
    }

    public static String toStringMap(Map<byte[], byte[]> map) {
        ArrayList<String> list = new ArrayList<String>();
        if (map != null) {
            for (Map.Entry<byte[], byte[]> entry : map.entrySet()) {
                list.add(Arrays.toString(entry.getKey()) + "=" + Arrays.toString(entry.getValue()));
            }
        }
        return "{" + String.join((CharSequence)", ", list) + "}";
    }

    public static <V> String toStringMap2(Map<byte[], V> map) {
        ArrayList<String> list = new ArrayList<String>();
        if (map != null) {
            for (Map.Entry<byte[], V> entry : map.entrySet()) {
                list.add(Arrays.toString(entry.getKey()) + "=" + entry.getValue());
            }
        }
        return "{" + String.join((CharSequence)", ", list) + "}";
    }

    public static <K, V> String mapToString(Map<K, V> map) {
        if (map == null) {
            return "";
        }
        return map.entrySet().stream().map(entry -> entry.getKey() + " -> " + entry.getValue()).collect(Collectors.joining(", "));
    }

    /*
     * Exception decompiling
     */
    public <T> T decorate(Span span, Supplier<T> supplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void decorate(Span span, Action action) {
        try (Scope ignore = this.tracer.scopeManager().activate(span);){
            action.execute();
        }
        catch (Exception e) {
            TracingHelper.onError(e, span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public <T extends Exception> void decorateThrowing(Span span, ThrowingAction<T> action) throws T {
        try (Scope ignore = this.tracer.scopeManager().activate(span);){
            action.execute();
        }
        catch (Exception e) {
            TracingHelper.onError(e, span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    /*
     * Exception decompiling
     */
    public <T extends Exception, V> V decorateThrowing(Span span, ThrowingSupplier<T, V> supplier) throws T {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String deserialize(byte[] bytes) {
        return bytes == null ? "" : new String(bytes, StandardCharsets.UTF_8);
    }

    public <T> T doInScope(String command, byte[] key, Supplier<T> supplier) {
        Span span = this.buildSpan(command, TracingHelper.deserialize(key));
        return this.activateAndCloseSpan(span, supplier);
    }

    public <T> T doInScope(String command, Supplier<T> supplier) {
        Span span = this.buildSpan(command);
        return this.activateAndCloseSpan(span, supplier);
    }

    public void doInScope(String command, byte[] key, Runnable runnable) {
        Span span = this.buildSpan(command, TracingHelper.deserialize(key));
        this.activateAndCloseSpan(span, runnable);
    }

    public void doInScope(String command, Runnable runnable) {
        Span span = this.buildSpan(command);
        this.activateAndCloseSpan(span, runnable);
    }

    public <T> T doInScope(String command, byte[][] keys, Supplier<T> supplier) {
        Span span = this.buildSpan(command);
        span.setTag("keys", TracingHelper.toStringWithDeserialization((byte[][])this.limitKeys((T[])keys)));
        return this.activateAndCloseSpan(span, supplier);
    }

    /*
     * Exception decompiling
     */
    private <T> T activateAndCloseSpan(Span span, Supplier<T> supplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void activateAndCloseSpan(Span span, Runnable runnable) {
        try (Scope ignored = this.tracer.activateSpan(span);){
            runnable.run();
        }
        catch (Exception e) {
            TracingHelper.onError(e, span);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

