/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.rsocket.Payload;
import io.rsocket.frame.FrameHeaderCodec;

final class PayloadValidationUtils {
    static final String INVALID_PAYLOAD_ERROR_MESSAGE = "The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory.";

    PayloadValidationUtils() {
    }

    static boolean isValid(int mtu, Payload payload, int maxFrameLength) {
        if (mtu > 0) {
            return true;
        }
        if (payload.hasMetadata()) {
            return FrameHeaderCodec.size() + 3 + FrameHeaderCodec.size() + payload.data().readableBytes() + payload.metadata().readableBytes() <= maxFrameLength;
        }
        return FrameHeaderCodec.size() + payload.data().readableBytes() + 3 <= maxFrameLength;
    }

    static void assertValidateSetup(int maxFrameLength, int maxInboundPayloadSize, int mtu) {
        if (maxFrameLength > 0xFFFFFF) {
            throw new IllegalArgumentException("Configured maxFrameLength[" + maxFrameLength + "] exceeds maxFrameLength limit " + 0xFFFFFF);
        }
        if (maxFrameLength > maxInboundPayloadSize) {
            throw new IllegalArgumentException("Configured maxFrameLength[" + maxFrameLength + "] exceeds maxPayloadSize[" + maxInboundPayloadSize + "]");
        }
        if (mtu != 0 && mtu > maxFrameLength) {
            throw new IllegalArgumentException("Configured maximumTransmissionUnit[" + mtu + "] exceeds configured maxFrameLength[" + maxFrameLength + "]");
        }
    }
}

