/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.metadata.table.TableMetaDataFactory;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.CreateTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.DropTableStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import java.sql.SQLException;

public abstract class AbstractBackendHandler
implements BackendHandler {
    @Override
    public CommandResponsePackets execute() {
        try {
            return this.execute0();
        }
        catch (Exception ex) {
            Optional<SQLException> sqlException = this.findSQLException(ex);
            return sqlException.isPresent() ? new CommandResponsePackets(new ErrPacket(1, (SQLException)sqlException.get())) : new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_STD_UNKNOWN_EXCEPTION, ex.getMessage()));
        }
    }

    protected abstract CommandResponsePackets execute0() throws Exception;

    private Optional<SQLException> findSQLException(Exception exception) {
        if (exception instanceof SQLException) {
            return Optional.of((Object)((SQLException)exception));
        }
        if (null == exception.getCause()) {
            return Optional.absent();
        }
        if (exception.getCause() instanceof SQLException) {
            return Optional.of((Object)((SQLException)exception.getCause()));
        }
        if (null == exception.getCause().getCause()) {
            return Optional.absent();
        }
        if (exception.getCause().getCause() instanceof SQLException) {
            return Optional.of((Object)((SQLException)exception.getCause().getCause()));
        }
        return Optional.absent();
    }

    @Override
    public boolean next() throws SQLException {
        return false;
    }

    @Override
    public ResultPacket getResultValue() throws SQLException {
        return null;
    }

    protected final void refreshTableMetaData(LogicSchema logicSchema, SQLStatement sqlStatement) {
        if (sqlStatement instanceof CreateTableStatement) {
            this.refreshTableMetaData(logicSchema, (CreateTableStatement)sqlStatement);
        } else if (sqlStatement instanceof AlterTableStatement) {
            this.refreshTableMetaData(logicSchema, (AlterTableStatement)sqlStatement);
        } else if (sqlStatement instanceof DropTableStatement) {
            this.refreshTableMetaData(logicSchema, (DropTableStatement)sqlStatement);
        }
    }

    private void refreshTableMetaData(LogicSchema logicSchema, CreateTableStatement createTableStatement) {
        logicSchema.getMetaData().getTable().put(createTableStatement.getTables().getSingleTableName(), TableMetaDataFactory.newInstance((CreateTableStatement)createTableStatement));
    }

    private void refreshTableMetaData(LogicSchema logicSchema, AlterTableStatement alterTableStatement) {
        String logicTableName = alterTableStatement.getTables().getSingleTableName();
        TableMetaData newTableMetaData = TableMetaDataFactory.newInstance((AlterTableStatement)alterTableStatement, (TableMetaData)logicSchema.getMetaData().getTable().get(logicTableName));
        Optional newTableName = alterTableStatement.getNewTableName();
        if (newTableName.isPresent()) {
            logicSchema.getMetaData().getTable().put((String)newTableName.get(), newTableMetaData);
            logicSchema.getMetaData().getTable().remove(logicTableName);
        } else {
            logicSchema.getMetaData().getTable().put(logicTableName, newTableMetaData);
        }
    }

    private void refreshTableMetaData(LogicSchema logicSchema, DropTableStatement dropTableStatement) {
        for (String each : dropTableStatement.getTables().getTableNames()) {
            logicSchema.getMetaData().getTable().remove(each);
        }
    }
}

