/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.BackendHandlerFactory;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import java.beans.ConstructorProperties;
import java.sql.SQLException;

public final class UnicastSchemaBackendHandler
extends AbstractBackendHandler {
    private final int sequenceId;
    private final String sql;
    private final BackendConnection backendConnection;
    private final BackendHandlerFactory backendHandlerFactory;
    private BackendHandler delegate;

    @Override
    protected CommandResponsePackets execute0() {
        if (null == this.backendConnection.getSchemaName()) {
            this.backendConnection.setCurrentSchema(GlobalRegistry.getInstance().getSchemaNames().iterator().next());
        }
        this.delegate = this.backendHandlerFactory.newTextProtocolInstance(this.sequenceId, this.sql, this.backendConnection, DatabaseType.MySQL);
        return this.delegate.execute();
    }

    @Override
    public boolean next() throws SQLException {
        return this.delegate.next();
    }

    @Override
    public ResultPacket getResultValue() throws SQLException {
        return this.delegate.getResultValue();
    }

    @ConstructorProperties(value={"sequenceId", "sql", "backendConnection", "backendHandlerFactory"})
    public UnicastSchemaBackendHandler(int sequenceId, String sql, BackendConnection backendConnection, BackendHandlerFactory backendHandlerFactory) {
        this.sequenceId = sequenceId;
        this.sql = sql;
        this.backendConnection = backendConnection;
        this.backendHandlerFactory = backendHandlerFactory;
    }
}

