/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.connection;

import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.ConnectionStatus;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.LocalTransactionManager;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.TransactionManager;
import io.shardingsphere.transaction.api.TransactionType;
import io.shardingsphere.transaction.core.TransactionOperationType;
import io.shardingsphere.transaction.core.context.ShardingTransactionContext;
import io.shardingsphere.transaction.core.context.XATransactionContext;
import io.shardingsphere.transaction.core.loader.ShardingTransactionHandlerRegistry;
import io.shardingsphere.transaction.spi.ShardingTransactionHandler;
import java.beans.ConstructorProperties;
import java.sql.SQLException;

public final class BackendTransactionManager
implements TransactionManager {
    private final BackendConnection connection;

    @Override
    public void doInTransaction(TransactionOperationType operationType) throws SQLException {
        TransactionType transactionType = this.connection.getTransactionType();
        ShardingTransactionHandler shardingTransactionHandler = ShardingTransactionHandlerRegistry.getInstance().getHandler(transactionType);
        if (null != transactionType && transactionType != TransactionType.LOCAL) {
            Preconditions.checkNotNull((Object)shardingTransactionHandler, (Object)String.format("Cannot find transaction manager of [%s]", transactionType));
        }
        if (TransactionOperationType.BEGIN == operationType && !this.connection.getStateHandler().isInTransaction()) {
            this.connection.getStateHandler().getAndSetStatus(ConnectionStatus.TRANSACTION);
            this.connection.releaseConnections(false);
        }
        if (TransactionType.LOCAL == transactionType) {
            new LocalTransactionManager(this.connection).doInTransaction(operationType);
        } else if (TransactionType.XA == transactionType) {
            shardingTransactionHandler.doInTransaction((ShardingTransactionContext)new XATransactionContext(operationType));
            if (TransactionOperationType.BEGIN != operationType) {
                this.connection.getStateHandler().getAndSetStatus(ConnectionStatus.TERMINATED);
            }
        }
    }

    @ConstructorProperties(value={"connection"})
    public BackendTransactionManager(BackendConnection connection) {
        this.connection = connection;
    }
}

