/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.connection;

import io.shardingsphere.shardingproxy.backend.jdbc.connection.ConnectionStatus;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.ResourceSynchronizer;
import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicReference;

public class ConnectionStateHandler {
    private volatile AtomicReference<ConnectionStatus> status = new AtomicReference<ConnectionStatus>(ConnectionStatus.INIT);
    private final ResourceSynchronizer resourceSynchronizer;

    public void getAndSetStatus(ConnectionStatus update) {
        this.status.getAndSet(update);
        if (ConnectionStatus.TERMINATED == this.status.get()) {
            this.resourceSynchronizer.doNotify();
        }
    }

    public ConnectionStatus getStatus() {
        return this.status.get();
    }

    void setRunningStatusIfNecessary() {
        if (ConnectionStatus.TRANSACTION != this.status.get()) {
            this.status.getAndSet(ConnectionStatus.RUNNING);
        }
    }

    boolean isInTransaction() {
        return ConnectionStatus.TRANSACTION == this.status.get();
    }

    void doNotifyIfNecessary() {
        if (this.status.compareAndSet(ConnectionStatus.RUNNING, ConnectionStatus.RELEASE)) {
            this.resourceSynchronizer.doNotify();
        }
        if (this.status.compareAndSet(ConnectionStatus.TERMINATED, ConnectionStatus.RELEASE)) {
            this.resourceSynchronizer.doNotify();
        }
    }

    public void waitUntilConnectionReleasedIfNecessary() throws InterruptedException {
        if (ConnectionStatus.RUNNING == this.status.get() || ConnectionStatus.TERMINATED == this.status.get()) {
            while (!this.status.compareAndSet(ConnectionStatus.RELEASE, ConnectionStatus.RUNNING)) {
                this.resourceSynchronizer.doAwait();
            }
        }
    }

    @ConstructorProperties(value={"resourceSynchronizer"})
    public ConnectionStateHandler(ResourceSynchronizer resourceSynchronizer) {
        this.resourceSynchronizer = resourceSynchronizer;
    }
}

