/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.pool.ChannelPoolHandler;
import io.shardingsphere.shardingproxy.backend.netty.client.BackendNettyClientChannelInitializer;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackendNettyClientChannelPoolHandler
implements ChannelPoolHandler {
    private static final Logger log = LoggerFactory.getLogger(BackendNettyClientChannelPoolHandler.class);
    private final String dataSourceName;
    private final String schemaName;

    public void channelReleased(Channel channel) {
        log.info("channelReleased. Channel ID: {}" + channel.id().asShortText());
    }

    public void channelAcquired(Channel channel) {
        log.info("channelAcquired. Channel ID: {}" + channel.id().asShortText());
    }

    public void channelCreated(Channel channel) {
        log.info("channelCreated. Channel ID: {}" + channel.id().asShortText());
        channel.pipeline().addLast(new ChannelHandler[]{new BackendNettyClientChannelInitializer(this.dataSourceName, this.schemaName)});
    }

    @ConstructorProperties(value={"dataSourceName", "schemaName"})
    public BackendNettyClientChannelPoolHandler(String dataSourceName, String schemaName) {
        this.dataSourceName = dataSourceName;
        this.schemaName = schemaName;
    }
}

