/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.future;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.shardingsphere.shardingproxy.backend.netty.future.SynchronizedFuture;
import java.util.concurrent.TimeUnit;

public final class FutureRegistry {
    private static final FutureRegistry INSTANCE = new FutureRegistry();
    private final Cache<Integer, SynchronizedFuture> resultCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();

    public static FutureRegistry getInstance() {
        return INSTANCE;
    }

    public void put(int connectionId, SynchronizedFuture synchronizedFuture) {
        this.resultCache.put((Object)connectionId, (Object)synchronizedFuture);
    }

    public SynchronizedFuture get(int connectionId) {
        return (SynchronizedFuture)this.resultCache.getIfPresent((Object)connectionId);
    }

    public void delete(int connectionId) {
        this.resultCache.invalidate((Object)connectionId);
    }

    private FutureRegistry() {
    }
}

