/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.future;

import io.shardingsphere.core.merger.QueryResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SynchronizedFuture
implements Future<List<QueryResult>> {
    private static final Logger log = LoggerFactory.getLogger(SynchronizedFuture.class);
    private final CountDownLatch latch;
    private final List<QueryResult> responses;
    private boolean isDone;

    public SynchronizedFuture(int resultSize) {
        this.latch = new CountDownLatch(resultSize);
        this.responses = new ArrayList<QueryResult>(resultSize);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public List<QueryResult> get() throws InterruptedException {
        this.latch.await();
        return this.responses;
    }

    @Override
    public List<QueryResult> get(long timeout, TimeUnit unit) {
        try {
            this.latch.await(timeout, unit);
            this.isDone = true;
        }
        catch (InterruptedException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return this.responses;
    }

    public void setResponse(QueryResult response) {
        this.responses.add(response);
        this.latch.countDown();
    }
}

