/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend.mysql;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import io.shardingsphere.shardingproxy.frontend.common.executor.CommandExecutorSelector;
import io.shardingsphere.shardingproxy.frontend.mysql.CommandExecutor;
import io.shardingsphere.shardingproxy.runtime.ChannelRegistry;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.AuthenticationHandler;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.ConnectionIdGenerator;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.HandshakePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.HandshakeResponse41Packet;

public final class MySQLFrontendHandler
extends FrontendHandler {
    private final AuthenticationHandler authenticationHandler = new AuthenticationHandler();

    @Override
    protected void handshake(ChannelHandlerContext context) {
        int connectionId = ConnectionIdGenerator.getInstance().nextId();
        ChannelRegistry.getInstance().putConnectionId(context.channel().id().asShortText(), connectionId);
        this.getBackendConnection().setConnectionId(connectionId);
        context.writeAndFlush((Object)new HandshakePacket(connectionId, this.authenticationHandler.getAuthPluginData()));
    }

    @Override
    protected void auth(ChannelHandlerContext context, ByteBuf message) {
        try (MySQLPacketPayload payload = new MySQLPacketPayload(message);){
            HandshakeResponse41Packet response41 = new HandshakeResponse41Packet(payload);
            if (this.authenticationHandler.login(response41.getUsername(), response41.getAuthResponse())) {
                if (!Strings.isNullOrEmpty((String)response41.getDatabase()) && !GlobalRegistry.getInstance().schemaExists(response41.getDatabase())) {
                    context.writeAndFlush((Object)new ErrPacket(response41.getSequenceId() + 1, ServerErrorCode.ER_BAD_DB_ERROR, response41.getDatabase()));
                    return;
                }
                this.getBackendConnection().setCurrentSchema(response41.getDatabase());
                context.writeAndFlush((Object)new OKPacket(response41.getSequenceId() + 1));
            } else {
                context.writeAndFlush((Object)new ErrPacket(response41.getSequenceId() + 1, ServerErrorCode.ER_ACCESS_DENIED_ERROR, response41.getUsername(), "localhost", 0 == response41.getAuthResponse().length ? "NO" : "YES"));
            }
        }
    }

    @Override
    protected void executeCommand(ChannelHandlerContext context, ByteBuf message) {
        CommandExecutorSelector.getExecutor(this.getBackendConnection().getTransactionType(), context.channel().id()).execute(new CommandExecutor(context, message, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelWritabilityChanged(ChannelHandlerContext context) {
        if (context.channel().isWritable()) {
            MySQLFrontendHandler mySQLFrontendHandler = this;
            synchronized (mySQLFrontendHandler) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }
}

