/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.shardingsphere.shardingproxy.transport.common.codec.PacketCodec;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import java.util.List;

public final class MySQLPacketCodec
extends PacketCodec<MySQLPacket> {
    @Override
    protected boolean isValidHeader(int readableBytes) {
        return readableBytes > 4;
    }

    @Override
    protected void doDecode(ChannelHandlerContext context, ByteBuf in, List<Object> out, int readableBytes) {
        int payloadLength = in.markReaderIndex().readMediumLE();
        int realPacketLength = payloadLength + 3 + 1;
        if (readableBytes < realPacketLength) {
            in.resetReaderIndex();
            return;
        }
        out.add(in.readRetainedSlice(payloadLength + 1));
    }

    @Override
    protected void doEncode(ChannelHandlerContext context, MySQLPacket message, ByteBuf out) {
        try (MySQLPacketPayload payload = new MySQLPacketPayload(context.alloc().buffer());){
            message.write(payload);
            out.writeMediumLE(payload.getByteBuf().readableBytes());
            out.writeByte(message.getSequenceId());
            out.writeBytes(payload.getByteBuf());
        }
    }
}

