/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute;

import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.NullBitmap;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.BinaryProtocolValueFactory;
import java.beans.ConstructorProperties;
import java.util.List;

public final class BinaryResultSetRowPacket
implements MySQLPacket {
    private static final int PACKET_HEADER = 0;
    private static final int NULL_BITMAP_OFFSET = 2;
    private final int sequenceId;
    private final int columnsCount;
    private final List<Object> data;
    private final List<ColumnType> columnTypes;

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(0);
        this.writeNullBitmap(payload);
        this.writeValues(payload);
    }

    private void writeNullBitmap(MySQLPacketPayload payload) {
        for (int each : this.getNullBitmap().getNullBitmap()) {
            payload.writeInt1(each);
        }
    }

    private NullBitmap getNullBitmap() {
        NullBitmap result = new NullBitmap(this.columnsCount, 2);
        for (int columnIndex = 0; columnIndex < this.columnsCount; ++columnIndex) {
            if (null != this.data.get(columnIndex)) continue;
            result.setNullBit(columnIndex);
        }
        return result;
    }

    private void writeValues(MySQLPacketPayload payload) {
        for (int i = 0; i < this.columnsCount; ++i) {
            Object value = this.data.get(i);
            if (null == value) continue;
            BinaryProtocolValueFactory.getBinaryProtocolValue(this.columnTypes.get(i)).write(payload, value);
        }
    }

    @ConstructorProperties(value={"sequenceId", "columnsCount", "data", "columnTypes"})
    public BinaryResultSetRowPacket(int sequenceId, int columnsCount, List<Object> data, List<ColumnType> columnTypes) {
        this.sequenceId = sequenceId;
        this.columnsCount = columnsCount;
        this.data = data;
        this.columnTypes = columnTypes;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public List<Object> getData() {
        return this.data;
    }
}

