/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy;

import io.shardingsphere.api.config.rule.RuleConfiguration;
import io.shardingsphere.core.config.DataSourceConfiguration;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.rule.Authentication;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.opentracing.ShardingTracer;
import io.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import io.shardingsphere.shardingproxy.config.ShardingConfiguration;
import io.shardingsphere.shardingproxy.config.ShardingConfigurationLoader;
import io.shardingsphere.shardingproxy.config.yaml.YamlProxyRuleConfiguration;
import io.shardingsphere.shardingproxy.config.yaml.YamlProxyServerConfiguration;
import io.shardingsphere.shardingproxy.frontend.ShardingProxy;
import io.shardingsphere.shardingproxy.listener.ProxyListenerRegister;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.util.DataSourceConverter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class Bootstrap {
    private static final int DEFAULT_PORT = 3307;

    public static void main(String[] args) throws InterruptedException, IOException {
        ShardingConfiguration shardingConfig = new ShardingConfigurationLoader().load();
        int port = Bootstrap.getPort(args);
        new ProxyListenerRegister().register();
        if (null == shardingConfig.getServerConfiguration().getOrchestration()) {
            Bootstrap.startWithoutRegistryCenter(shardingConfig.getRuleConfigurationMap(), shardingConfig.getServerConfiguration().getAuthentication(), shardingConfig.getServerConfiguration().getConfigMap(), shardingConfig.getServerConfiguration().getProps(), port);
        } else {
            Bootstrap.startWithRegistryCenter(shardingConfig.getServerConfiguration(), shardingConfig.getRuleConfigurationMap().keySet(), shardingConfig.getRuleConfigurationMap(), port);
        }
    }

    private static int getPort(String[] args) {
        if (0 == args.length) {
            return 3307;
        }
        try {
            return Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            return 3307;
        }
    }

    private static void startWithoutRegistryCenter(Map<String, YamlProxyRuleConfiguration> ruleConfigs, Authentication authentication, Map<String, Object> configMap, Properties prop, int port) throws InterruptedException {
        GlobalRegistry.getInstance().init(Bootstrap.getDataSourceParameterMap(ruleConfigs), Bootstrap.getRuleConfiguration(ruleConfigs), authentication, configMap, prop);
        Bootstrap.initOpenTracing();
        ShardingProxy.getInstance().start(port);
    }

    private static void startWithRegistryCenter(YamlProxyServerConfiguration serverConfig, Collection<String> shardingSchemaNames, Map<String, YamlProxyRuleConfiguration> ruleConfigs, int port) throws InterruptedException {
        try (ShardingOrchestrationFacade shardingOrchestrationFacade = new ShardingOrchestrationFacade(serverConfig.getOrchestration().getOrchestrationConfiguration(), shardingSchemaNames);){
            Bootstrap.initShardingOrchestrationFacade(serverConfig, ruleConfigs, shardingOrchestrationFacade);
            GlobalRegistry.getInstance().init(Bootstrap.getSchemaDataSourceParameterMap(shardingOrchestrationFacade), Bootstrap.getSchemaRules(shardingOrchestrationFacade), shardingOrchestrationFacade.getConfigService().loadAuthentication(), shardingOrchestrationFacade.getConfigService().loadConfigMap(), shardingOrchestrationFacade.getConfigService().loadProperties(), true);
            Bootstrap.initOpenTracing();
            ShardingProxy.getInstance().start(port);
        }
    }

    private static Map<String, Map<String, DataSourceParameter>> getSchemaDataSourceParameterMap(ShardingOrchestrationFacade shardingOrchestrationFacade) {
        LinkedHashMap<String, Map<String, DataSourceParameter>> result = new LinkedHashMap<String, Map<String, DataSourceParameter>>();
        for (String each : shardingOrchestrationFacade.getConfigService().getAllShardingSchemaNames()) {
            result.put(each, DataSourceConverter.getDataSourceParameterMap(shardingOrchestrationFacade.getConfigService().loadDataSourceConfigurations(each)));
        }
        return result;
    }

    private static Map<String, RuleConfiguration> getSchemaRules(ShardingOrchestrationFacade shardingOrchestrationFacade) {
        LinkedHashMap<String, RuleConfiguration> result = new LinkedHashMap<String, RuleConfiguration>();
        for (String each : shardingOrchestrationFacade.getConfigService().getAllShardingSchemaNames()) {
            if (shardingOrchestrationFacade.getConfigService().isShardingRule(each)) {
                result.put(each, (RuleConfiguration)shardingOrchestrationFacade.getConfigService().loadShardingRuleConfiguration(each));
                continue;
            }
            result.put(each, (RuleConfiguration)shardingOrchestrationFacade.getConfigService().loadMasterSlaveRuleConfiguration(each));
        }
        return result;
    }

    private static void initShardingOrchestrationFacade(YamlProxyServerConfiguration serverConfig, Map<String, YamlProxyRuleConfiguration> ruleConfigs, ShardingOrchestrationFacade shardingOrchestrationFacade) {
        if (ruleConfigs.isEmpty()) {
            shardingOrchestrationFacade.init();
        } else {
            shardingOrchestrationFacade.init(Bootstrap.getDataSourceConfigurationMap(ruleConfigs), Bootstrap.getRuleConfiguration(ruleConfigs), serverConfig.getAuthentication(), serverConfig.getConfigMap(), serverConfig.getProps());
        }
    }

    private static void initOpenTracing() {
        if (((Boolean)GlobalRegistry.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_OPENTRACING_ENABLED)).booleanValue()) {
            ShardingTracer.init();
        }
    }

    private static Map<String, Map<String, DataSourceConfiguration>> getDataSourceConfigurationMap(Map<String, YamlProxyRuleConfiguration> ruleConfigs) {
        LinkedHashMap<String, Map<String, DataSourceConfiguration>> result = new LinkedHashMap<String, Map<String, DataSourceConfiguration>>();
        for (Map.Entry<String, YamlProxyRuleConfiguration> entry : ruleConfigs.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceConfigurationMap(entry.getValue().getDataSources()));
        }
        return result;
    }

    private static Map<String, Map<String, DataSourceParameter>> getDataSourceParameterMap(Map<String, YamlProxyRuleConfiguration> localRuleConfigs) {
        HashMap<String, Map<String, DataSourceParameter>> result = new HashMap<String, Map<String, DataSourceParameter>>(localRuleConfigs.size(), 1.0f);
        for (Map.Entry<String, YamlProxyRuleConfiguration> entry : localRuleConfigs.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getDataSources());
        }
        return result;
    }

    private static Map<String, RuleConfiguration> getRuleConfiguration(Map<String, YamlProxyRuleConfiguration> localRuleConfigs) {
        HashMap<String, RuleConfiguration> result = new HashMap<String, RuleConfiguration>();
        for (Map.Entry<String, YamlProxyRuleConfiguration> entry : localRuleConfigs.entrySet()) {
            result.put(entry.getKey(), (RuleConfiguration)(null != entry.getValue().getShardingRule() ? entry.getValue().getShardingRule().getShardingRuleConfiguration() : entry.getValue().getMasterSlaveRule().getMasterSlaveRuleConfiguration()));
        }
        return result;
    }

    private Bootstrap() {
    }
}

