/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.metadata.datasource.dialect.MySQLDataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.dialect.PostgreSQLDataSourceMetaData;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCBackendDataSourceFactory;
import javax.sql.DataSource;

public final class JDBCRawBackendDataSourceFactory
implements JDBCBackendDataSourceFactory {
    private static final JDBCRawBackendDataSourceFactory INSTANCE = new JDBCRawBackendDataSourceFactory();

    public static JDBCBackendDataSourceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public DataSource build(String dataSourceName, DataSourceParameter dataSourceParameter) {
        HikariConfig config = new HikariConfig();
        String driverClassName = this.getDriverClassName(dataSourceParameter.getUrl());
        this.validateDriverClassName(driverClassName);
        config.setDriverClassName(driverClassName);
        config.setJdbcUrl(dataSourceParameter.getUrl());
        config.setUsername(dataSourceParameter.getUsername());
        config.setPassword(dataSourceParameter.getPassword());
        config.setConnectionTimeout(dataSourceParameter.getConnectionTimeoutMilliseconds());
        config.setIdleTimeout(dataSourceParameter.getIdleTimeoutMilliseconds());
        config.setMaxLifetime(dataSourceParameter.getMaxLifetimeMilliseconds());
        config.setMaximumPoolSize(dataSourceParameter.getMaxPoolSize());
        config.setMinimumIdle(dataSourceParameter.getMinPoolSize());
        config.addDataSourceProperty("useServerPrepStmts", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        config.addDataSourceProperty("useLocalSessionState", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("rewriteBatchedStatements", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cacheResultSetMetadata", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cacheServerConfiguration", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("elideSetAutoCommits", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("maintainTimeStats", (Object)Boolean.FALSE.toString());
        config.addDataSourceProperty("netTimeoutForStreamingResults", (Object)0);
        return new HikariDataSource(config);
    }

    private String getDriverClassName(String url) {
        try {
            new MySQLDataSourceMetaData(url);
            return "com.mysql.jdbc.Driver";
        }
        catch (ShardingException shardingException) {
            try {
                new PostgreSQLDataSourceMetaData(url);
                return "org.postgresql.Driver";
            }
            catch (ShardingException shardingException2) {
                throw new UnsupportedOperationException(String.format("Cannot support url `%s`", url));
            }
        }
    }

    private void validateDriverClassName(String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new ShardingException("Cannot load JDBC driver class `%s`, make sure it in Sharding-Proxy's classpath.", new Object[]{driverClassName});
        }
    }

    private JDBCRawBackendDataSourceFactory() {
    }
}

