/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty;

import io.netty.channel.Channel;
import io.netty.channel.pool.SimpleChannelPool;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.SQLJudgeEngine;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.StatementRoutingEngine;
import io.shardingsphere.core.routing.router.masterslave.MasterSlaveRouter;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.shardingproxy.backend.AbstractBackendHandler;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.backend.netty.client.BackendNettyClientManager;
import io.shardingsphere.shardingproxy.backend.netty.client.response.mysql.MySQLQueryResult;
import io.shardingsphere.shardingproxy.backend.netty.future.FutureRegistry;
import io.shardingsphere.shardingproxy.backend.netty.future.SynchronizedFuture;
import io.shardingsphere.shardingproxy.runtime.ChannelRegistry;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import io.shardingsphere.shardingproxy.runtime.schema.MasterSlaveSchema;
import io.shardingsphere.shardingproxy.runtime.schema.ShardingSchema;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.query.ComQueryPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class NettyBackendHandler
extends AbstractBackendHandler {
    private static final GlobalRegistry GLOBAL_REGISTRY = GlobalRegistry.getInstance();
    private static final BackendNettyClientManager CLIENT_MANAGER = BackendNettyClientManager.getInstance();
    private final LogicSchema logicSchema;
    private final int connectionId;
    private final int sequenceId;
    private final String sql;
    private final DatabaseType databaseType;
    private final Map<String, List<Channel>> channelMap = new HashMap<String, List<Channel>>();
    private SynchronizedFuture synchronizedFuture;
    private int currentSequenceId;
    private int columnCount;
    private MergedResult mergedResult;

    @Override
    protected CommandResponsePackets execute0() throws InterruptedException, ExecutionException, TimeoutException {
        return this.logicSchema instanceof MasterSlaveSchema ? this.executeForMasterSlave() : this.executeForSharding();
    }

    private CommandResponsePackets executeForMasterSlave() throws InterruptedException, ExecutionException, TimeoutException {
        String dataSourceName = (String)new MasterSlaveRouter(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), ((Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(this.sql).iterator().next();
        this.synchronizedFuture = new SynchronizedFuture(1);
        FutureRegistry.getInstance().put(this.connectionId, this.synchronizedFuture);
        this.executeSQL(dataSourceName, this.sql);
        Object queryResults = this.synchronizedFuture.get((Long)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_CONNECTION_TIMEOUT_SECONDS), TimeUnit.SECONDS);
        FutureRegistry.getInstance().delete(this.connectionId);
        LinkedList<CommandResponsePackets> packets = new LinkedList<CommandResponsePackets>();
        Iterator iterator = queryResults.iterator();
        while (iterator.hasNext()) {
            QueryResult each = (QueryResult)iterator.next();
            packets.add(((MySQLQueryResult)each).getCommandResponsePackets());
        }
        return this.merge(new SQLJudgeEngine(this.sql).judge(), packets, (List<QueryResult>)queryResults);
    }

    private CommandResponsePackets executeForSharding() throws InterruptedException, ExecutionException, TimeoutException {
        StatementRoutingEngine routingEngine = new StatementRoutingEngine(((ShardingSchema)this.logicSchema).getShardingRule(), this.logicSchema.getMetaData(), this.databaseType, ((Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue());
        SQLRouteResult routeResult = routingEngine.route(this.sql);
        if (routeResult.getRouteUnits().isEmpty()) {
            return new CommandResponsePackets(new OKPacket(1));
        }
        this.synchronizedFuture = new SynchronizedFuture(routeResult.getRouteUnits().size());
        FutureRegistry.getInstance().put(this.connectionId, this.synchronizedFuture);
        for (RouteUnit each : routeResult.getRouteUnits()) {
            this.executeSQL(each.getDataSourceName(), each.getSqlUnit().getSql());
        }
        Object queryResults = this.synchronizedFuture.get((Long)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_CONNECTION_TIMEOUT_SECONDS), TimeUnit.SECONDS);
        FutureRegistry.getInstance().delete(this.connectionId);
        ArrayList<CommandResponsePackets> packets = new ArrayList<CommandResponsePackets>(queryResults.size());
        Iterator iterator = queryResults.iterator();
        while (iterator.hasNext()) {
            QueryResult each = (QueryResult)iterator.next();
            MySQLQueryResult queryResult = (MySQLQueryResult)each;
            if (0 == this.currentSequenceId) {
                this.currentSequenceId = queryResult.getCurrentSequenceId();
            }
            if (0 == this.columnCount) {
                this.columnCount = queryResult.getColumnCount();
            }
            packets.add(queryResult.getCommandResponsePackets());
        }
        SQLStatement sqlStatement = routeResult.getSqlStatement();
        CommandResponsePackets result = this.merge(sqlStatement, packets, (List<QueryResult>)queryResults);
        this.refreshTableMetaData(this.logicSchema, sqlStatement);
        return result;
    }

    private void executeSQL(String dataSourceName, String sql) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.channelMap.containsKey(dataSourceName)) {
            this.channelMap.put(dataSourceName, new ArrayList());
        }
        SimpleChannelPool pool = (SimpleChannelPool)CLIENT_MANAGER.getBackendNettyClient(this.logicSchema.getName()).getPoolMap().get((Object)dataSourceName);
        Channel channel = (Channel)pool.acquire().get(((Long)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_CONNECTION_TIMEOUT_SECONDS)).longValue(), TimeUnit.SECONDS);
        this.channelMap.get(dataSourceName).add(channel);
        ChannelRegistry.getInstance().putConnectionId(channel.id().asShortText(), this.connectionId);
        channel.writeAndFlush((Object)new ComQueryPacket(this.sequenceId, sql));
    }

    private CommandResponsePackets merge(SQLStatement sqlStatement, List<CommandResponsePackets> packets, List<QueryResult> queryResults) {
        CommandResponsePackets headPackets = new CommandResponsePackets();
        for (CommandResponsePackets commandResponsePackets : packets) {
            headPackets.getPackets().add(commandResponsePackets.getHeadPacket());
        }
        for (DatabasePacket databasePacket : headPackets.getPackets()) {
            if (!(databasePacket instanceof ErrPacket)) continue;
            return new CommandResponsePackets(databasePacket);
        }
        if (SQLType.TCL == sqlStatement.getType()) {
            this.channelRelease();
        }
        if (SQLType.DML == sqlStatement.getType()) {
            return this.mergeDML(headPackets);
        }
        if (SQLType.DQL == sqlStatement.getType() || SQLType.DAL == sqlStatement.getType()) {
            return this.mergeDQLorDAL(sqlStatement, packets, queryResults);
        }
        return packets.get(0);
    }

    private CommandResponsePackets mergeDML(CommandResponsePackets firstPackets) {
        int affectedRows = 0;
        long lastInsertId = 0L;
        for (DatabasePacket each : firstPackets.getPackets()) {
            if (!(each instanceof OKPacket)) continue;
            OKPacket okPacket = (OKPacket)each;
            affectedRows = (int)((long)affectedRows + okPacket.getAffectedRows());
            lastInsertId = okPacket.getLastInsertId();
        }
        return new CommandResponsePackets(new OKPacket(1, affectedRows, lastInsertId));
    }

    private CommandResponsePackets mergeDQLorDAL(SQLStatement sqlStatement, List<CommandResponsePackets> packets, List<QueryResult> queryResults) {
        try {
            this.mergedResult = MergeEngineFactory.newInstance((DatabaseType)DatabaseType.MySQL, (ShardingRule)((ShardingSchema)this.logicSchema).getShardingRule(), (SQLStatement)sqlStatement, (ShardingTableMetaData)this.logicSchema.getMetaData().getTable(), queryResults).merge();
        }
        catch (SQLException ex) {
            return new CommandResponsePackets(new ErrPacket(1, ex));
        }
        return packets.get(0);
    }

    @Override
    public boolean next() throws SQLException {
        if (null == this.mergedResult || !this.mergedResult.next()) {
            this.channelRelease();
            return false;
        }
        return true;
    }

    @Override
    public ResultPacket getResultValue() throws SQLException {
        ArrayList<Object> data = new ArrayList<Object>(this.columnCount);
        for (int columnIndex = 1; columnIndex <= this.columnCount; ++columnIndex) {
            data.add(this.mergedResult.getValue(columnIndex, Object.class));
        }
        return new ResultPacket(++this.currentSequenceId, data, this.columnCount, Collections.emptyList());
    }

    private void channelRelease() {
        for (Map.Entry<String, List<Channel>> entry : this.channelMap.entrySet()) {
            for (Channel each : entry.getValue()) {
                ((SimpleChannelPool)CLIENT_MANAGER.getBackendNettyClient(this.logicSchema.getName()).getPoolMap().get((Object)entry.getKey())).release(each);
            }
        }
    }

    @ConstructorProperties(value={"logicSchema", "connectionId", "sequenceId", "sql", "databaseType"})
    public NettyBackendHandler(LogicSchema logicSchema, int connectionId, int sequenceId, String sql, DatabaseType databaseType) {
        this.logicSchema = logicSchema;
        this.connectionId = connectionId;
        this.sequenceId = sequenceId;
        this.sql = sql;
        this.databaseType = databaseType;
    }

    public LogicSchema getLogicSchema() {
        return this.logicSchema;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public String getSql() {
        return this.sql;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, List<Channel>> getChannelMap() {
        return this.channelMap;
    }

    public SynchronizedFuture getSynchronizedFuture() {
        return this.synchronizedFuture;
    }

    public int getCurrentSequenceId() {
        return this.currentSequenceId;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

