/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.config.ShardingConfiguration;
import io.shardingsphere.shardingproxy.config.yaml.YamlProxyRuleConfiguration;
import io.shardingsphere.shardingproxy.config.yaml.YamlProxyServerConfiguration;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;

public final class ShardingConfigurationLoader {
    private static final String CONFIG_PATH = "/conf/";
    private static final String SERVER_CONFIG_FILE = "server.yaml";
    private static final Pattern RULE_CONFIG_FILE_PATTERN = Pattern.compile("config-.+\\.yaml");

    /*
     * WARNING - void declaration
     */
    public ShardingConfiguration load() throws IOException {
        void var7_9;
        HashSet<String> schemaNames = new HashSet<String>();
        YamlProxyServerConfiguration serverConfig = this.loadServerConfiguration(new File(ShardingConfigurationLoader.class.getResource("/conf/server.yaml").getFile()));
        File configPath = new File(ShardingConfigurationLoader.class.getResource(CONFIG_PATH).getFile());
        LinkedList<Object> ruleConfigurations = new LinkedList<Object>();
        File[] fileArray = this.findRuleConfigurationFiles(configPath);
        int n = fileArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            File each = fileArray[var7_9];
            Optional<YamlProxyRuleConfiguration> ruleConfig = this.loadRuleConfiguration(each, serverConfig);
            if (ruleConfig.isPresent()) {
                Preconditions.checkState((boolean)schemaNames.add(((YamlProxyRuleConfiguration)ruleConfig.get()).getSchemaName()), (String)"Schema name `%s` must unique at all rule configurations.", (Object[])new Object[]{((YamlProxyRuleConfiguration)ruleConfig.get()).getSchemaName()});
                ruleConfigurations.add(ruleConfig.get());
            }
            ++var7_9;
        }
        Preconditions.checkState((!ruleConfigurations.isEmpty() || null != serverConfig.getOrchestration() ? 1 : 0) != 0, (String)"Can not find any sharding rule configuration file in path `%s`.", (Object[])new Object[]{configPath.getPath()});
        HashMap<String, YamlProxyRuleConfiguration> ruleConfigurationMap = new HashMap<String, YamlProxyRuleConfiguration>(ruleConfigurations.size(), 1.0f);
        for (YamlProxyRuleConfiguration yamlProxyRuleConfiguration : ruleConfigurations) {
            ruleConfigurationMap.put(yamlProxyRuleConfiguration.getSchemaName(), yamlProxyRuleConfiguration);
        }
        return new ShardingConfiguration(serverConfig, ruleConfigurationMap);
    }

    /*
     * Exception decompiling
     */
    private YamlProxyServerConfiguration loadServerConfiguration(File yamlFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Optional<YamlProxyRuleConfiguration> loadRuleConfiguration(File yamlFile, YamlProxyServerConfiguration serverConfiguration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File[] findRuleConfigurationFiles(File path) {
        return path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return RULE_CONFIG_FILE_PATTERN.matcher(pathname.getName()).matches();
            }
        });
    }
}

