/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend.mysql;

import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacketFactory;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryCommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import io.shardingsphere.spi.root.RootInvokeHook;
import io.shardingsphere.spi.root.SPIRootInvokeHook;
import java.beans.ConstructorProperties;
import java.sql.SQLException;

public final class CommandExecutor
implements Runnable {
    private final ChannelHandlerContext context;
    private final ByteBuf message;
    private final FrontendHandler frontendHandler;
    private int currentSequenceId;
    private final RootInvokeHook rootInvokeHook = new SPIRootInvokeHook();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.rootInvokeHook.start();
        int connectionSize = 0;
        try (MySQLPacketPayload payload = new MySQLPacketPayload(this.message);
             BackendConnection backendConnection = this.frontendHandler.getBackendConnection();){
            backendConnection.getStateHandler().waitUntilConnectionReleasedIfNecessary();
            CommandPacket commandPacket = this.getCommandPacket(payload, backendConnection, this.frontendHandler);
            Optional<CommandResponsePackets> responsePackets = commandPacket.execute();
            if (!responsePackets.isPresent()) {
                return;
            }
            for (DatabasePacket each : ((CommandResponsePackets)responsePackets.get()).getPackets()) {
                this.context.write((Object)each);
            }
            if (commandPacket instanceof QueryCommandPacket && !(((CommandResponsePackets)responsePackets.get()).getHeadPacket() instanceof OKPacket) && !(((CommandResponsePackets)responsePackets.get()).getHeadPacket() instanceof ErrPacket)) {
                this.writeMoreResults((QueryCommandPacket)commandPacket, ((CommandResponsePackets)responsePackets.get()).getPackets().size());
            }
            connectionSize = backendConnection.getConnectionSize();
        }
        catch (SQLException ex) {
            this.context.write((Object)new ErrPacket(++this.currentSequenceId, ex));
        }
        catch (Exception ex) {
            this.context.write((Object)new ErrPacket(1, ServerErrorCode.ER_STD_UNKNOWN_EXCEPTION, ex.getMessage()));
        }
        finally {
            this.context.flush();
            this.rootInvokeHook.finish(connectionSize);
        }
    }

    private CommandPacket getCommandPacket(MySQLPacketPayload payload, BackendConnection backendConnection, FrontendHandler frontendHandler) throws SQLException {
        int sequenceId = payload.readInt1();
        return CommandPacketFactory.newInstance(sequenceId, payload, backendConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMoreResults(QueryCommandPacket queryCommandPacket, int headPacketsCount) throws SQLException {
        if (!this.context.channel().isActive()) {
            return;
        }
        this.currentSequenceId = headPacketsCount;
        int count = 0;
        int proxyFrontendFlushThreshold = (Integer)GlobalRegistry.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_FRONTEND_FLUSH_THRESHOLD);
        while (queryCommandPacket.next()) {
            ++count;
            while (!this.context.channel().isWritable() && this.context.channel().isActive()) {
                this.context.flush();
                FrontendHandler frontendHandler = this.frontendHandler;
                synchronized (frontendHandler) {
                    try {
                        ((Object)((Object)this.frontendHandler)).wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            DatabasePacket resultValue = queryCommandPacket.getResultValue();
            this.currentSequenceId = resultValue.getSequenceId();
            this.context.write((Object)resultValue);
            if (proxyFrontendFlushThreshold != count) continue;
            this.context.flush();
            count = 0;
        }
        this.context.write((Object)new EofPacket(++this.currentSequenceId));
    }

    @ConstructorProperties(value={"context", "message", "frontendHandler"})
    public CommandExecutor(ChannelHandlerContext context, ByteBuf message, FrontendHandler frontendHandler) {
        this.context = context;
        this.message = message;
        this.frontendHandler = frontendHandler;
    }
}

