/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.common.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PacketCodec<T extends DatabasePacket>
extends ByteToMessageCodec<T> {
    private static final Logger log = LoggerFactory.getLogger(PacketCodec.class);

    protected final void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        int readableBytes = in.readableBytes();
        if (!this.isValidHeader(readableBytes)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Read from client {} : \n {}", (Object)context.channel().id().asShortText(), (Object)ByteBufUtil.prettyHexDump((ByteBuf)in));
        }
        this.doDecode(context, in, out, readableBytes);
    }

    protected abstract boolean isValidHeader(int var1);

    protected abstract void doDecode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3, int var4);

    protected final void encode(ChannelHandlerContext context, T message, ByteBuf out) {
        this.doEncode(context, message, out);
        if (log.isDebugEnabled()) {
            log.debug("Write to client {} : \n {}", (Object)context.channel().id().asShortText(), (Object)ByteBufUtil.prettyHexDump((ByteBuf)out));
        }
    }

    protected abstract void doEncode(ChannelHandlerContext var1, T var2, ByteBuf var3);
}

