/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.admin.initdb;

import com.google.common.base.Optional;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacketType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComInitDbPacket
implements CommandPacket {
    private static final Logger log = LoggerFactory.getLogger(ComInitDbPacket.class);
    private final int sequenceId;
    private final String schema;
    private final BackendConnection backendConnection;

    public ComInitDbPacket(int sequenceId, MySQLPacketPayload payload, BackendConnection backendConnection) {
        this.sequenceId = sequenceId;
        this.schema = payload.readStringEOF();
        this.backendConnection = backendConnection;
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(CommandPacketType.COM_INIT_DB.getValue());
        payload.writeStringEOF(this.schema);
    }

    @Override
    public Optional<CommandResponsePackets> execute() {
        log.debug("Schema name received for Sharding-Proxy: {}", (Object)this.schema);
        if (GlobalRegistry.getInstance().schemaExists(this.schema)) {
            this.backendConnection.setCurrentSchema(this.schema);
            return Optional.of((Object)new CommandResponsePackets(new OKPacket(this.getSequenceId() + 1)));
        }
        return Optional.of((Object)new CommandResponsePackets(new ErrPacket(this.getSequenceId() + 1, ServerErrorCode.ER_BAD_DB_ERROR, this.schema)));
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }
}

