/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query;

import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class ColumnDefinition41Packet
implements MySQLPacket {
    private static final String CATALOG = "def";
    private static final int NEXT_LENGTH = 12;
    private final int sequenceId;
    private final int characterSet;
    private final int flags;
    private final String schema;
    private final String table;
    private final String orgTable;
    private String name;
    private final String orgName;
    private final int columnLength;
    private final ColumnType columnType;
    private final int decimals;

    public ColumnDefinition41Packet(int sequenceId, ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        this(sequenceId, resultSetMetaData.getSchemaName(columnIndex), resultSetMetaData.getTableName(columnIndex), resultSetMetaData.getTableName(columnIndex), resultSetMetaData.getColumnLabel(columnIndex), resultSetMetaData.getColumnName(columnIndex), resultSetMetaData.getColumnDisplaySize(columnIndex), ColumnType.valueOfJDBCType(resultSetMetaData.getColumnType(columnIndex)), resultSetMetaData.getScale(columnIndex));
    }

    public ColumnDefinition41Packet(int sequenceId, String schema, String table, String orgTable, String name, String orgName, int columnLength, ColumnType columnType, int decimals) {
        this.sequenceId = sequenceId;
        this.characterSet = 33;
        this.flags = 0;
        this.schema = schema;
        this.table = table;
        this.orgTable = orgTable;
        this.name = name;
        this.orgName = orgName;
        this.columnLength = columnLength;
        this.columnType = columnType;
        this.decimals = decimals;
    }

    public ColumnDefinition41Packet(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((boolean)CATALOG.equals(payload.readStringLenenc()));
        this.schema = payload.readStringLenenc();
        this.table = payload.readStringLenenc();
        this.orgTable = payload.readStringLenenc();
        this.name = payload.readStringLenenc();
        this.orgName = payload.readStringLenenc();
        Preconditions.checkArgument((12L == payload.readIntLenenc() ? 1 : 0) != 0);
        this.characterSet = payload.readInt2();
        this.columnLength = payload.readInt4();
        this.columnType = ColumnType.valueOf(payload.readInt1());
        this.flags = payload.readInt2();
        this.decimals = payload.readInt1();
        payload.skipReserved(2);
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeStringLenenc(CATALOG);
        payload.writeStringLenenc(this.schema);
        payload.writeStringLenenc(this.table);
        payload.writeStringLenenc(this.orgTable);
        payload.writeStringLenenc(this.name);
        payload.writeStringLenenc(this.orgName);
        payload.writeIntLenenc(12L);
        payload.writeInt2(this.characterSet);
        payload.writeInt4(this.columnLength);
        payload.writeInt1(this.columnType.getValue());
        payload.writeInt2(this.flags);
        payload.writeInt1(this.decimals);
        payload.writeReserved(2);
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }
}

