/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol;

import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.BinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.DateBinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.DoubleBinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.FloatBinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.Int1BinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.Int2BinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.Int4BinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.Int8BinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.StringLenencBinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.TimeBinaryProtocolValue;
import java.util.HashMap;
import java.util.Map;

public final class BinaryProtocolValueFactory {
    private static final Map<ColumnType, BinaryProtocolValue> BINARY_PROTOCOL_VALUES = new HashMap<ColumnType, BinaryProtocolValue>();

    private static void setStringLenencBinaryProtocolValue() {
        StringLenencBinaryProtocolValue binaryProtocolValue = new StringLenencBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_STRING, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_VARCHAR, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_VAR_STRING, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_ENUM, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_SET, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_LONG_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_MEDIUM_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_TINY_BLOB, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_GEOMETRY, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_BIT, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_DECIMAL, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_NEWDECIMAL, binaryProtocolValue);
    }

    private static void setInt8BinaryProtocolValue() {
        Int8BinaryProtocolValue binaryProtocolValue = new Int8BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_LONGLONG, binaryProtocolValue);
    }

    private static void setInt4BinaryProtocolValue() {
        Int4BinaryProtocolValue binaryProtocolValue = new Int4BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_LONG, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_INT24, binaryProtocolValue);
    }

    private static void setInt2BinaryProtocolValue() {
        Int2BinaryProtocolValue binaryProtocolValue = new Int2BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_SHORT, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_YEAR, binaryProtocolValue);
    }

    private static void setInt1BinaryProtocolValue() {
        Int1BinaryProtocolValue binaryProtocolValue = new Int1BinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_TINY, binaryProtocolValue);
    }

    private static void setDoubleBinaryProtocolValue() {
        DoubleBinaryProtocolValue binaryProtocolValue = new DoubleBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_DOUBLE, binaryProtocolValue);
    }

    private static void setFloatBinaryProtocolValue() {
        FloatBinaryProtocolValue binaryProtocolValue = new FloatBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_FLOAT, binaryProtocolValue);
    }

    private static void setDateBinaryProtocolValue() {
        DateBinaryProtocolValue binaryProtocolValue = new DateBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_DATE, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_DATETIME, binaryProtocolValue);
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_TIMESTAMP, binaryProtocolValue);
    }

    private static void setTimeBinaryProtocolValue() {
        TimeBinaryProtocolValue binaryProtocolValue = new TimeBinaryProtocolValue();
        BINARY_PROTOCOL_VALUES.put(ColumnType.MYSQL_TYPE_TIME, binaryProtocolValue);
    }

    public static BinaryProtocolValue getBinaryProtocolValue(ColumnType columnType) {
        Preconditions.checkArgument((boolean)BINARY_PROTOCOL_VALUES.containsKey((Object)columnType), (String)"Cannot find MySQL type '%s' in column type when process binary protocol value", (Object[])new Object[]{columnType});
        return BINARY_PROTOCOL_VALUES.get((Object)columnType);
    }

    private BinaryProtocolValueFactory() {
    }

    static {
        BinaryProtocolValueFactory.setStringLenencBinaryProtocolValue();
        BinaryProtocolValueFactory.setInt8BinaryProtocolValue();
        BinaryProtocolValueFactory.setInt4BinaryProtocolValue();
        BinaryProtocolValueFactory.setInt2BinaryProtocolValue();
        BinaryProtocolValueFactory.setInt1BinaryProtocolValue();
        BinaryProtocolValueFactory.setDoubleBinaryProtocolValue();
        BinaryProtocolValueFactory.setFloatBinaryProtocolValue();
        BinaryProtocolValueFactory.setDateBinaryProtocolValue();
        BinaryProtocolValueFactory.setTimeBinaryProtocolValue();
    }
}

