/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.prepare;

import com.google.common.base.Optional;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.SQLParsingEngine;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import io.shardingsphere.shardingproxy.runtime.schema.ShardingSchema;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.BinaryStatementRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.prepare.ComStmtPrepareOKPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComStmtPreparePacket
implements CommandPacket {
    private static final Logger log = LoggerFactory.getLogger(ComStmtPreparePacket.class);
    private static final BinaryStatementRegistry PREPARED_STATEMENT_REGISTRY = BinaryStatementRegistry.getInstance();
    private final int sequenceId;
    private final String schemaName;
    private final String sql;
    private final SQLParsingEngine sqlParsingEngine;

    public ComStmtPreparePacket(int sequenceId, BackendConnection backendConnection, MySQLPacketPayload payload) {
        this.sequenceId = sequenceId;
        this.sql = payload.readStringEOF();
        this.schemaName = backendConnection.getSchemaName();
        LogicSchema logicSchema = backendConnection.getLogicSchema();
        this.sqlParsingEngine = new SQLParsingEngine(DatabaseType.MySQL, this.sql, this.getShardingRule(logicSchema), logicSchema.getMetaData().getTable());
    }

    private ShardingRule getShardingRule(LogicSchema logicSchema) {
        return logicSchema instanceof ShardingSchema ? ((ShardingSchema)logicSchema).getShardingRule() : new ShardingRule(new ShardingRuleConfiguration(), logicSchema.getDataSources().keySet());
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeStringEOF(this.sql);
    }

    @Override
    public Optional<CommandResponsePackets> execute() {
        log.debug("COM_STMT_PREPARE received for Sharding-Proxy: {}", (Object)this.sql);
        int currentSequenceId = 0;
        SQLStatement sqlStatement = this.sqlParsingEngine.parse(true);
        int parametersIndex = sqlStatement.getParametersIndex();
        CommandResponsePackets result = new CommandResponsePackets(new ComStmtPrepareOKPacket(++currentSequenceId, PREPARED_STATEMENT_REGISTRY.register(this.sql, parametersIndex), this.getNumColumns(sqlStatement), parametersIndex, 0));
        for (int i = 0; i < parametersIndex; ++i) {
            result.getPackets().add(new ColumnDefinition41Packet(++currentSequenceId, this.schemaName, sqlStatement.getTables().isSingleTable() ? sqlStatement.getTables().getSingleTableName() : "", "", "", "", 100, ColumnType.MYSQL_TYPE_VARCHAR, 0));
        }
        if (parametersIndex > 0) {
            result.getPackets().add(new EofPacket(++currentSequenceId));
        }
        return Optional.of((Object)result);
    }

    private int getNumColumns(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            return ((SelectStatement)sqlStatement).getItems().size();
        }
        if (sqlStatement instanceof InsertStatement) {
            return ((InsertStatement)sqlStatement).getColumns().size();
        }
        return 0;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }
}

