/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.messages.codes;

import io.vertx.mqtt.messages.codes.MqttReasonCode;
import io.vertx.mqtt.messages.codes.ReasonCodeUtils;

public enum MqttPubAckReasonCode implements MqttReasonCode
{
    SUCCESS(0),
    NO_MATCHING_SUBSCRIBERS(16),
    UNSPECIFIED_ERROR(-128),
    IMPLEMENTATION_SPECIFIC_ERROR(-125),
    NOT_AUTHORIZED(-121),
    TOPIC_NAME_INVALID(-112),
    PACKET_IDENTIFIER_IN_USE(-111),
    QUOTA_EXCEEDED(-105),
    PAYLOAD_FORMAT_INVALID(-103);

    private final byte byteValue;
    private static final MqttPubAckReasonCode[] VALUES;

    private MqttPubAckReasonCode(byte byteValue) {
        this.byteValue = byteValue;
    }

    public static MqttPubAckReasonCode valueOf(byte b) {
        return ReasonCodeUtils.codeLookup(VALUES, b, "PUBACK");
    }

    @Override
    public byte value() {
        return this.byteValue;
    }

    @Override
    public boolean isError() {
        return (this.byteValue & 0x80) != 0;
    }

    static {
        VALUES = new MqttPubAckReasonCode[154];
        ReasonCodeUtils.fillValuesByCode((MqttReasonCode[])VALUES, (MqttReasonCode[])MqttPubAckReasonCode.values());
    }
}

