/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthFeishuRequest
extends AuthDefaultRequest {
    public AuthFeishuRequest(AuthConfig config) {
        super(config, AuthDefaultSource.FEISHU);
    }

    public AuthFeishuRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.FEISHU, authStateCache);
    }

    private String getAppAccessToken() {
        String cacheKey = this.source.getName().concat(":app_access_token:").concat(this.config.getClientId());
        String cacheAppAccessToken = this.authStateCache.get(cacheKey);
        if (StringUtils.isNotEmpty(cacheAppAccessToken)) {
            return cacheAppAccessToken;
        }
        String url = "https://open.feishu.cn/open-apis/auth/v3/app_access_token/internal/";
        JSONObject requestObject = new JSONObject();
        requestObject.put("app_id", (Object)this.config.getClientId());
        requestObject.put("app_secret", (Object)this.config.getClientSecret());
        String response = new HttpUtils(this.config.getHttpConfig()).post(url, requestObject.toJSONString(), new HttpHeader().add("Content-Type", "application/json")).getBody();
        JSONObject jsonObject = JSON.parseObject((String)response);
        this.checkResponse(jsonObject);
        String appAccessToken = jsonObject.getString("app_access_token");
        this.authStateCache.cache(cacheKey, appAccessToken, jsonObject.getLongValue("expire") * 1000L);
        return appAccessToken;
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("app_access_token", (Object)this.getAppAccessToken());
        requestObject.put("grant_type", (Object)"authorization_code");
        requestObject.put("code", (Object)authCallback.getCode());
        return this.getToken(requestObject, this.source.accessToken());
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.source.userInfo(), null, new HttpHeader().add("Content-Type", "application/json").add("Authorization", "Bearer " + accessToken), false).getBody();
        JSONObject object = JSON.parseObject((String)response);
        this.checkResponse(object);
        JSONObject data = object.getJSONObject("data");
        return AuthUser.builder().rawUserInfo(object).uuid(data.getString("union_id")).username(data.getString("name")).nickname(data.getString("name")).avatar(data.getString("avatar_url")).email(data.getString("email")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse<AuthToken> refresh(AuthToken authToken) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("app_access_token", (Object)this.getAppAccessToken());
        requestObject.put("grant_type", (Object)"refresh_token");
        requestObject.put("refresh_token", (Object)authToken.getRefreshToken());
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(requestObject, this.source.refresh())).build();
    }

    private AuthToken getToken(JSONObject param, String url) {
        String response = new HttpUtils(this.config.getHttpConfig()).post(url, param.toJSONString(), new HttpHeader().add("Content-Type", "application/json")).getBody();
        JSONObject jsonObject = JSON.parseObject((String)response);
        this.checkResponse(jsonObject);
        JSONObject data = jsonObject.getJSONObject("data");
        return AuthToken.builder().accessToken(data.getString("access_token")).refreshToken(data.getString("refresh_token")).expireIn(data.getIntValue("expires_in")).tokenType(data.getString("token_type")).openId(data.getString("open_id")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("app_id", this.config.getClientId()).queryParam("redirect_uri", GlobalAuthUtils.urlEncode(this.config.getRedirectUri())).queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject jsonObject) {
        if (jsonObject.getIntValue("code") != 0) {
            throw new AuthException(jsonObject.getString("message"));
        }
    }
}

