/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.xkcoding.http.support.HttpHeader;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthLinkedinScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthLinkedinRequest
extends AuthDefaultRequest {
    public AuthLinkedinRequest(AuthConfig config) {
        super(config, AuthDefaultSource.LINKEDIN);
    }

    public AuthLinkedinRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.LINKEDIN, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "api.linkedin.com");
        httpHeader.add("Connection", "Keep-Alive");
        httpHeader.add("Authorization", "Bearer " + accessToken);
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.userInfoUrl(authToken), null, httpHeader, false).getBody();
        JSONObject userInfoObject = JSONObject.parseObject((String)response);
        this.checkResponse(userInfoObject);
        String userName = this.getUserName(userInfoObject);
        String avatar = this.getAvatar(userInfoObject);
        String email = this.getUserEmail(accessToken);
        return AuthUser.builder().rawUserInfo(userInfoObject).uuid(userInfoObject.getString("id")).username(userName).nickname(userName).avatar(avatar).email(email).token(authToken).gender(AuthUserGender.UNKNOWN).source(this.source.toString()).build();
    }

    private String getUserName(JSONObject userInfoObject) {
        String firstName = userInfoObject.containsKey((Object)"localizedFirstName") ? userInfoObject.getString("localizedFirstName") : this.getUserName(userInfoObject, "firstName");
        String lastName = userInfoObject.containsKey((Object)"localizedLastName") ? userInfoObject.getString("localizedLastName") : this.getUserName(userInfoObject, "lastName");
        return firstName + " " + lastName;
    }

    private String getAvatar(JSONObject userInfoObject) {
        JSONObject profilePictureObject = userInfoObject.getJSONObject("profilePicture");
        if (null == profilePictureObject || !profilePictureObject.containsKey((Object)"displayImage~")) {
            return null;
        }
        JSONObject displayImageObject = profilePictureObject.getJSONObject("displayImage~");
        if (null == displayImageObject || !displayImageObject.containsKey((Object)"elements")) {
            return null;
        }
        JSONArray displayImageElements = displayImageObject.getJSONArray("elements");
        if (null == displayImageElements || displayImageElements.isEmpty()) {
            return null;
        }
        JSONObject largestImageObj = displayImageElements.getJSONObject(displayImageElements.size() - 1);
        if (null == largestImageObj || !largestImageObj.containsKey((Object)"identifiers")) {
            return null;
        }
        JSONArray identifiers = largestImageObj.getJSONArray("identifiers");
        if (null == identifiers || identifiers.isEmpty()) {
            return null;
        }
        return identifiers.getJSONObject(0).getString("identifier");
    }

    private String getUserEmail(String accessToken) {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "api.linkedin.com");
        httpHeader.add("Connection", "Keep-Alive");
        httpHeader.add("Authorization", "Bearer " + accessToken);
        String emailResponse = new HttpUtils(this.config.getHttpConfig()).get("https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))", null, httpHeader, false).getBody();
        JSONObject emailObj = JSONObject.parseObject((String)emailResponse);
        this.checkResponse(emailObj);
        Object obj = JSONPath.eval((Object)emailObj, (String)"$['elements'][0]['handle~']['emailAddress']");
        return null == obj ? null : (String)obj;
    }

    private String getUserName(JSONObject userInfoObject, String nameKey) {
        JSONObject firstNameObj = userInfoObject.getJSONObject(nameKey);
        JSONObject localizedObj = firstNameObj.getJSONObject("localized");
        JSONObject preferredLocaleObj = firstNameObj.getJSONObject("preferredLocale");
        String firstName = localizedObj.getString(preferredLocaleObj.getString("language") + "_" + preferredLocaleObj.getString("country"));
        return firstName;
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"), this.source);
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "www.linkedin.com");
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
        String response = new HttpUtils(this.config.getHttpConfig()).post(accessTokenUrl, null, httpHeader).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("scope", this.getScopes(" ", false, AuthScopeUtils.getDefaultScopes(AuthLinkedinScope.values()))).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("projection", "(id,firstName,lastName,profilePicture(displayImage~:playableStreams))").build();
    }
}

