/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.config;

import cn.hutool.core.util.StrUtil;

public enum DbType {
    MySQL("com.mysql.cj.jdbc.Driver"),
    Oracle("oracle.jdbc.driver.OracleDriver"),
    PostgreSQL("org.postgresql.Driver"),
    SQLServer("com.microsoft.sqlserver.jdbc.SQLServerDriver"),
    DM("dm.jdbc.driver.DmDriver"),
    Clickhouse("com.clickhouse.jdbc.ClickHouseDriver"),
    KingBase("com.kingbase8.Driver");

    private final String driverClass;

    private DbType(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public static DbType getValue(String dbType) {
        if (StrUtil.equalsAny((CharSequence)dbType, (CharSequence[])new CharSequence[]{"MySQL"})) {
            return MySQL;
        }
        if (StrUtil.equalsAny((CharSequence)dbType, (CharSequence[])new CharSequence[]{"Oracle"})) {
            return Oracle;
        }
        if (StrUtil.equalsAny((CharSequence)dbType, (CharSequence[])new CharSequence[]{"PostgreSQL"})) {
            return PostgreSQL;
        }
        if (StrUtil.equalsAny((CharSequence)dbType, (CharSequence[])new CharSequence[]{"SQLServer", "Microsoft SQL Server"})) {
            return SQLServer;
        }
        if (StrUtil.equalsAny((CharSequence)dbType, (CharSequence[])new CharSequence[]{"DM", "DM DBMS"})) {
            return DM;
        }
        if (StrUtil.equalsAny((CharSequence)dbType, (CharSequence[])new CharSequence[]{"Clickhouse"})) {
            return Clickhouse;
        }
        if (StrUtil.equalsAny((CharSequence)dbType, (CharSequence[])new CharSequence[]{"KingBase"})) {
            return KingBase;
        }
        return null;
    }
}

