/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.biz.impl;

import java.util.ArrayList;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.basic.bean.RoleBean;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.dao.IRoleDao;
import net.mingsoft.basic.entity.RoleEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="roleBiz")
@Transactional
public class RoleBizImpl
extends BaseBizImpl<IRoleDao, RoleEntity>
implements IRoleBiz {
    @Autowired
    private IRoleDao roleDao;
    @Autowired
    private IRoleModelBiz roleModelBiz;
    @Autowired
    private IModelBiz modelBiz;

    public IBaseDao getDao() {
        return this.roleDao;
    }

    @Override
    public boolean saveOrUpdateRole(RoleBean role) {
        RoleBean oldRole = new RoleBean();
        oldRole.setRoleName(role.getRoleName());
        oldRole = (RoleBean)((Object)this.roleDao.getByEntity(oldRole));
        if (StringUtils.isNotEmpty((CharSequence)role.getId())) {
            if (oldRole != null && !oldRole.getId().equals(role.getId())) {
                return false;
            }
            this.roleDao.updateEntity(role);
        } else {
            if (oldRole != null) {
                return false;
            }
            this.save((Object)role);
            this.roleDao.updateCache();
        }
        ArrayList<RoleModelEntity> roleModelList = new ArrayList<RoleModelEntity>();
        if (!StringUtils.isEmpty((CharSequence)role.getIds())) {
            for (String id : role.getIds().split(",")) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setRoleId(Integer.parseInt(role.getId()));
                roleModel.setModelId(Integer.parseInt(id));
                roleModelList.add(roleModel);
            }
            this.roleModelBiz.deleteEntity(Integer.parseInt(role.getId()));
            this.modelBiz.updateCache();
            this.roleModelBiz.saveBatch(roleModelList, roleModelList.size());
        } else {
            this.roleModelBiz.deleteEntity(Integer.parseInt(role.getId()));
        }
        return true;
    }
}

