/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;

public class ActiveMQXAConnectionFactoryTest
extends CombinationTestSupport {
    public void testCopy() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?");
        ActiveMQConnectionFactory copy = cf.copy();
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an ActiveMQXAConnectionFactory", (boolean)(copy instanceof ActiveMQXAConnectionFactory));
    }

    public void testUseURIToSetOptionsOnConnectionFactory() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?jms.useAsyncSend=true");
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQXAConnectionFactory("vm://localhost?jms.useAsyncSend=false");
        ActiveMQXAConnectionFactoryTest.assertFalse((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm://localhost", (String)cf.getBrokerURL());
        cf = new ActiveMQXAConnectionFactory("vm:(broker:()/localhost)?jms.useAsyncSend=true");
        ActiveMQXAConnectionFactoryTest.assertTrue((boolean)cf.isUseAsyncSend());
        ActiveMQXAConnectionFactoryTest.assertEquals((String)"vm:(broker:()/localhost)", (String)cf.getBrokerURL());
    }

    public void testCreateVMConnectionWithEmbdeddBroker() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQXAConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        Connection connection = cf.createConnection();
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
        connection.close();
        ActiveMQXAConnectionFactoryTest.assertNull((Object)BrokerRegistry.getInstance().lookup("localhost"));
    }

    public void testGetBrokerName() throws URISyntaxException, JMSException {
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory("vm://localhost?broker.persistent=false");
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        String brokerName = connection.getBrokerName();
        log.info("Got broker name: " + brokerName);
        ActiveMQXAConnectionFactoryTest.assertNotNull((String)"No broker name available!", (Object)brokerName);
        connection.close();
    }

    public void testCreateTcpConnectionUsingAllocatedPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true");
    }

    public void testCreateTcpConnectionUsingKnownPort() throws Exception {
        this.assertCreateConnection("tcp://localhost:61610?wireFormat.tcpNoDelayEnabled=true");
    }

    protected void assertCreateConnection(String uri) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        TransportConnector connector = broker.addConnector(uri);
        broker.start();
        URI temp = new URI(uri);
        URI currentURI = connector.getServer().getConnectURI();
        URI connectURI = new URI(temp.getScheme(), temp.getUserInfo(), temp.getHost(), currentURI.getPort(), temp.getPath(), temp.getQuery(), temp.getFragment());
        log.info("connection URI is: " + connectURI);
        ActiveMQXAConnectionFactory cf = new ActiveMQXAConnectionFactory(connectURI);
        Connection connection = cf.createConnection();
        this.assertXAConnection(connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        connection.close();
        connection = cf.createXAConnection();
        this.assertXAConnection(connection);
        ActiveMQXAConnectionFactoryTest.assertNotNull((Object)connection);
        connection.close();
        broker.stop();
    }

    private void assertXAConnection(Connection connection) {
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XAConnection", (boolean)(connection instanceof XAConnection));
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XATopicConnection", (boolean)(connection instanceof XATopicConnection));
        ActiveMQXAConnectionFactoryTest.assertTrue((String)"Should be an XAQueueConnection", (boolean)(connection instanceof XAQueueConnection));
    }
}

