/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Assert;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSConsumerTest
extends JmsTestSupport {
    private static final Log log = LogFactory.getLog(JMSConsumerTest.class);
    public ActiveMQDestination destination;
    public int deliveryMode;
    public int prefetch;
    public int ackMode;
    public byte destinationType;
    public boolean durableConsumer;

    public static Test suite() {
        return JMSConsumerTest.suite(JMSConsumerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JMSConsumerTest.suite());
    }

    public void initCombosForTestMessageListenerWithConsumerCanBeStopped() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testMessageListenerWithConsumerCanBeStopped() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done1 = new CountDownLatch(1);
        final CountDownLatch done2 = new CountDownLatch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer(this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 1) {
                    done1.countDown();
                }
                if (counter.get() == 2) {
                    done2.countDown();
                }
            }
        });
        this.sendMessages(session, (Destination)this.destination, 1);
        JMSConsumerTest.assertTrue((boolean)done1.await(1L, TimeUnit.SECONDS));
        JMSConsumerTest.assertEquals((int)1, (int)counter.get());
        consumer.stop();
        this.sendMessages(session, (Destination)this.destination, 1);
        JMSConsumerTest.assertFalse((boolean)done2.await(1L, TimeUnit.SECONDS));
        JMSConsumerTest.assertEquals((int)1, (int)counter.get());
        consumer.start();
        JMSConsumerTest.assertTrue((boolean)done2.await(1L, TimeUnit.SECONDS));
        JMSConsumerTest.assertEquals((int)2, (int)counter.get());
    }

    public void initCombosForTestMutiReceiveWithPrefetch1() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("ackMode", new Object[]{new Integer(1), new Integer(3), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testMutiReceiveWithPrefetch1() throws Exception {
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(false, this.ackMode);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        this.sendMessages(session, (Destination)this.destination, 4);
        Message message = null;
        for (int i = 0; i < 4; ++i) {
            message = consumer.receive(1000L);
            JMSConsumerTest.assertNotNull((Object)message);
        }
        JMSConsumerTest.assertNull((Object)consumer.receiveNoWait());
        message.acknowledge();
    }

    public void initCombosForTestDurableConsumerSelectorChange() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(2)});
    }

    public void testDurableConsumerSelectorChange() throws Exception {
        this.connection.setClientID("test");
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageProducer producer = session.createProducer(this.destination);
        producer.setDeliveryMode(this.deliveryMode);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)((Object)this.destination), "test", "color='red'", false);
        TextMessage message = session.createTextMessage("1st");
        message.setStringProperty("color", "red");
        producer.send(message);
        Message m = consumer.receive(1000L);
        JMSConsumerTest.assertNotNull((Object)m);
        JMSConsumerTest.assertEquals((String)"1st", (String)((TextMessage)m).getText());
        consumer.close();
        consumer = session.createDurableSubscriber((Topic)((Object)this.destination), "test", "color='blue'", false);
        message = session.createTextMessage("2nd");
        message.setStringProperty("color", "red");
        producer.send(message);
        message = session.createTextMessage("3rd");
        message.setStringProperty("color", "blue");
        producer.send(message);
        m = consumer.receive(1000L);
        JMSConsumerTest.assertNotNull((Object)m);
        JMSConsumerTest.assertEquals((String)"3rd", (String)((TextMessage)m).getText());
        JMSConsumerTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void initCombosForTestSendReceiveBytesMessage() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testSendReceiveBytesMessage() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        MessageProducer producer = session.createProducer(this.destination);
        BytesMessage message = session.createBytesMessage();
        message.writeBoolean(true);
        message.writeBoolean(false);
        producer.send(message);
        BytesMessage m = (BytesMessage)consumer.receive(1000L);
        JMSConsumerTest.assertNotNull((Object)m);
        JMSConsumerTest.assertTrue((boolean)m.readBoolean());
        JMSConsumerTest.assertFalse((boolean)m.readBoolean());
        JMSConsumerTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void initCombosForTestSetMessageListenerAfterStart() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testSetMessageListenerAfterStart() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done = new CountDownLatch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        this.sendMessages(session, (Destination)this.destination, 4);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 4) {
                    done.countDown();
                }
            }
        });
        JMSConsumerTest.assertTrue((boolean)done.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumerTest.assertEquals((int)4, (int)counter.get());
    }

    public void initCombosForTestMessageListenerUnackedWithPrefetch1StayInQueue() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("ackMode", new Object[]{new Integer(1), new Integer(3), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1)});
    }

    public void testMessageListenerUnackedWithPrefetch1StayInQueue() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch sendDone = new CountDownLatch(1);
        final CountDownLatch got2Done = new CountDownLatch(1);
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.setOptimizedMessageDispatch(false);
        this.connection.start();
        Session session = this.connection.createSession(false, this.ackMode);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                try {
                    TextMessage tm = (TextMessage)m;
                    log.info("Got in first listener: " + tm.getText());
                    Assert.assertEquals((String)("" + counter.get()), (String)tm.getText());
                    counter.incrementAndGet();
                    m.acknowledge();
                    if (counter.get() == 2) {
                        sendDone.await();
                        JMSConsumerTest.this.connection.close();
                        got2Done.countDown();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        this.sendMessages(session, (Destination)this.destination, 4);
        sendDone.countDown();
        JMSConsumerTest.assertTrue((boolean)got2Done.await(100000L, TimeUnit.MILLISECONDS));
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connections.add(this.connection);
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        final CountDownLatch done2 = new CountDownLatch(1);
        session = this.connection.createSession(false, this.ackMode);
        consumer = session.createConsumer(this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                try {
                    TextMessage tm = (TextMessage)m;
                    log.info("Got in second listener: " + tm.getText());
                    Assert.assertEquals((String)("" + counter.get()), (String)tm.getText());
                    counter.incrementAndGet();
                    if (counter.get() == 4) {
                        done2.countDown();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        JMSConsumerTest.assertTrue((boolean)done2.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumerTest.assertEquals((int)4, (int)counter.get());
    }

    public void initCombosForTestMessageListenerWithConsumerWithPrefetch1() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testMessageListenerWithConsumerWithPrefetch1() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done = new CountDownLatch(1);
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 4) {
                    done.countDown();
                }
            }
        });
        this.sendMessages(session, (Destination)this.destination, 4);
        JMSConsumerTest.assertTrue((boolean)done.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumerTest.assertEquals((int)4, (int)counter.get());
    }

    public void initCombosForTestMessageListenerWithConsumer() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testMessageListenerWithConsumer() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch done = new CountDownLatch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                counter.incrementAndGet();
                if (counter.get() == 4) {
                    done.countDown();
                }
            }
        });
        this.sendMessages(session, (Destination)this.destination, 4);
        JMSConsumerTest.assertTrue((boolean)done.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        JMSConsumerTest.assertEquals((int)4, (int)counter.get());
    }

    public void initCombosForTestUnackedWithPrefetch1StayInQueue() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("ackMode", new Object[]{new Integer(1), new Integer(3), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1)});
    }

    public void testUnackedWithPrefetch1StayInQueue() throws Exception {
        int i;
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(false, this.ackMode);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        this.sendMessages(session, (Destination)this.destination, 4);
        Message message = null;
        for (i = 0; i < 2; ++i) {
            message = consumer.receive(1000L);
            JMSConsumerTest.assertNotNull((Object)message);
        }
        message.acknowledge();
        this.connection.close();
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connections.add(this.connection);
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        session = this.connection.createSession(false, this.ackMode);
        consumer = session.createConsumer(this.destination);
        for (i = 0; i < 2; ++i) {
            message = consumer.receive(1000L);
            JMSConsumerTest.assertNotNull((Object)message);
        }
        message.acknowledge();
        JMSConsumerTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void initCombosForTestPrefetch1MessageNotDispatched() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
    }

    public void testPrefetch1MessageNotDispatched() throws Exception {
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        this.destination = new ActiveMQQueue("TEST");
        MessageConsumer consumer = session.createConsumer(this.destination);
        this.sendMessages(session, (Destination)this.destination, 2);
        session.commit();
        Message message1 = consumer.receive(1000L);
        JMSConsumerTest.assertNotNull((Object)message1);
        ActiveMQConnection connection2 = (ActiveMQConnection)this.factory.createConnection();
        this.connections.add(connection2);
        Session session2 = connection2.createSession(true, 0);
        MessageConsumer consumer2 = session2.createConsumer(this.destination);
        Message message2 = consumer.receive(1000L);
        JMSConsumerTest.assertNotNull((Object)message2);
        session.commit();
        session2.commit();
        JMSConsumerTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void initCombosForTestDontStart() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2)});
    }

    public void testDontStart() throws Exception {
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        this.sendMessages(session, (Destination)this.destination, 1);
        JMSConsumerTest.assertNull((Object)consumer.receive(1000L));
    }

    public void initCombosForTestStartAfterSend() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2)});
    }

    public void testStartAfterSend() throws Exception {
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        this.sendMessages(session, (Destination)this.destination, 1);
        this.connection.start();
        JMSConsumerTest.assertNotNull((Object)consumer.receive(1000L));
        JMSConsumerTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void initCombosForTestReceiveMessageWithConsumer() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testReceiveMessageWithConsumer() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer(this.destination);
        this.sendMessages(session, (Destination)this.destination, 1);
        Message m = consumer.receive(1000L);
        JMSConsumerTest.assertNotNull((Object)m);
        JMSConsumerTest.assertEquals((String)"0", (String)((TextMessage)m).getText());
        JMSConsumerTest.assertNull((Object)consumer.receiveNoWait());
    }
}

