/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;

public class JMSUsecaseTest
extends JmsTestSupport {
    public ActiveMQDestination destination;
    public int deliveryMode;
    public int prefetch;
    public byte destinationType;
    public boolean durableConsumer;

    public static Test suite() {
        return JMSUsecaseTest.suite(JMSUsecaseTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JMSUsecaseTest.suite());
    }

    public void initCombosForTestQueueBrowser() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(5)});
    }

    public void testQueueBrowser() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 0);
        this.destination = this.createDestination(session, this.destinationType);
        this.sendMessages(session, (Destination)this.destination, 5);
        QueueBrowser browser = session.createBrowser((Queue)((Object)this.destination));
        Enumeration enumeration = browser.getEnumeration();
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(100L);
            JMSUsecaseTest.assertTrue((boolean)enumeration.hasMoreElements());
            Message m = (Message)enumeration.nextElement();
            JMSUsecaseTest.assertNotNull((Object)m);
            JMSUsecaseTest.assertEquals((String)("" + i), (String)((TextMessage)m).getText());
        }
        JMSUsecaseTest.assertFalse((boolean)enumeration.hasMoreElements());
    }

    public void initCombosForTestSendReceive() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testSendReceive() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageProducer producer = session.createProducer(this.destination);
        MessageConsumer consumer = session.createConsumer(this.destination);
        ActiveMQMessage message = new ActiveMQMessage();
        producer.send(message);
        JMSUsecaseTest.assertNotNull((Object)consumer.receive(1000L));
        JMSUsecaseTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void initCombosForTestSendReceiveTransacted() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2), new Byte(5), new Byte(6)});
    }

    public void testSendReceiveTransacted() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        this.destination = this.createDestination(session, this.destinationType);
        MessageProducer producer = session.createProducer(this.destination);
        MessageConsumer consumer = session.createConsumer(this.destination);
        producer.send(session.createTextMessage("test"));
        JMSUsecaseTest.assertNull((Object)consumer.receiveNoWait());
        session.commit();
        Message message = consumer.receive(1000L);
        JMSUsecaseTest.assertNotNull((Object)message);
        JMSUsecaseTest.assertFalse((boolean)message.getJMSRedelivered());
        JMSUsecaseTest.assertNull((Object)consumer.receiveNoWait());
        session.rollback();
        message = consumer.receive(2000L);
        JMSUsecaseTest.assertNotNull((Object)message);
        JMSUsecaseTest.assertTrue((boolean)message.getJMSRedelivered());
        JMSUsecaseTest.assertNull((Object)consumer.receiveNoWait());
        session.commit();
        JMSUsecaseTest.assertNull((Object)consumer.receiveNoWait());
    }
}

