/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsConnectionStartStopTest
extends TestSupport {
    private static final Log log = LogFactory.getLog(JmsConnectionStartStopTest.class);
    private Connection startedConnection;
    private Connection stoppedConnection;

    protected void setUp() throws Exception {
        log.info(((Object)((Object)this)).getClass().getClassLoader().getResource("log4j.properties"));
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.startedConnection = factory.createConnection();
        this.startedConnection.start();
        this.stoppedConnection = factory.createConnection();
    }

    protected void tearDown() throws Exception {
        this.stoppedConnection.close();
        this.startedConnection.close();
    }

    public void testStoppedConsumerHoldsMessagesTillStarted() throws JMSException {
        Session startedSession = this.startedConnection.createSession(false, 1);
        Session stoppedSession = this.stoppedConnection.createSession(false, 1);
        Topic topic = startedSession.createTopic("test");
        MessageConsumer startedConsumer = startedSession.createConsumer(topic);
        MessageConsumer stoppedConsumer = stoppedSession.createConsumer(topic);
        MessageProducer producer = startedSession.createProducer(topic);
        TextMessage message = startedSession.createTextMessage("Hello");
        producer.send(message);
        Message m = startedConsumer.receive(1000L);
        JmsConnectionStartStopTest.assertNotNull((Object)m);
        m = stoppedConsumer.receive(1000L);
        JmsConnectionStartStopTest.assertNull((Object)m);
        this.stoppedConnection.start();
        m = stoppedConsumer.receive(5000L);
        JmsConnectionStartStopTest.assertNotNull((Object)m);
        startedSession.close();
        stoppedSession.close();
    }

    public void testMultipleConnectionStops() throws Exception {
        this.testStoppedConsumerHoldsMessagesTillStarted();
        this.stoppedConnection.stop();
        this.testStoppedConsumerHoldsMessagesTillStarted();
        this.stoppedConnection.stop();
        this.testStoppedConsumerHoldsMessagesTillStarted();
    }
}

