/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.TestSupport;
import org.apache.activemq.command.ActiveMQMessage;

public class JmsCreateConsumerInOnMessageTest
extends TestSupport
implements MessageListener {
    private Connection connection;
    private Session publisherSession;
    private Session consumerSession;
    private MessageConsumer consumer;
    private MessageConsumer testConsumer;
    private MessageProducer producer;
    private Topic topic;
    private Object lock = new Object();

    protected void setUp() throws Exception {
        super.setUp();
        ((TestSupport)this).topic = true;
        this.connection = this.createConnection();
        this.connection.setClientID("connection:" + this.getSubject());
        this.publisherSession = this.connection.createSession(false, 1);
        this.consumerSession = this.connection.createSession(false, 1);
        this.topic = (Topic)super.createDestination("Test.Topic");
        this.consumer = this.consumerSession.createConsumer(this.topic);
        this.consumer.setMessageListener(this);
        this.producer = this.publisherSession.createProducer(this.topic);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateConsumer() throws Exception {
        ActiveMQMessage msg = super.createMessage();
        this.producer.send(msg);
        if (this.testConsumer == null) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(3000L);
            }
        }
        JmsCreateConsumerInOnMessageTest.assertTrue((this.testConsumer != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            this.testConsumer = this.consumerSession.createConsumer(this.topic);
            MessageProducer anotherProducer = this.consumerSession.createProducer(this.topic);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JmsCreateConsumerInOnMessageTest.assertTrue((boolean)false);
        }
    }
}

