/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.Queue;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsQueueSendReceiveTwoConnectionsTest;
import org.apache.activemq.broker.BrokerService;

public class JmsQueueSendReceiveTwoConnectionsStartBeforeBrokerTest
extends JmsQueueSendReceiveTwoConnectionsTest {
    private Queue errors = new ConcurrentLinkedQueue();
    private int delayBeforeStartingBroker = 1000;
    private BrokerService broker;

    public void startBroker() {
        log.info("Lets wait: " + this.delayBeforeStartingBroker + " millis  before creating the broker");
        try {
            Thread.sleep(this.delayBeforeStartingBroker);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("Now starting the broker");
        try {
            this.broker = new BrokerService();
            this.broker.setPersistent(false);
            this.broker.addConnector("tcp://localhost:61616");
            this.broker.start();
        }
        catch (Exception e) {
            log.info("Caught: " + e);
            this.errors.add(e);
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("failover:(tcp://localhost:61616)?maxReconnectAttempts=10&useExponentialBackOff=false&initialReconnectDelay=200");
    }

    protected void setUp() throws Exception {
        Thread thread = new Thread(){

            public void run() {
                JmsQueueSendReceiveTwoConnectionsStartBeforeBrokerTest.this.startBroker();
            }
        };
        thread.start();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
        if (!this.errors.isEmpty()) {
            Exception e = (Exception)this.errors.remove();
            throw e;
        }
    }
}

